#!/bin/sh

SRCDIR=/mnt/sdcard/source
DESTDIR=/usr/local

echo --- preparing ---
mkdir -p $DESTDIR/{mysql,postgres,gogs,spark,apache}
mkdir /var/log/git

echo --- adding users and their respective groups ---
groupadd mysql
groupadd git
groupadd postgres
groupadd spark

useradd -r -g mysql -s /bin/false -d $DESTDIR/mysql mysql
useradd -r -g postgres -s /bin/bash -d $DESTDIR/postgres postgres
useradd -r -g git -s /bin/bash -d $DESTDIR/gogs git
useradd -r -g spark -s /bin/bash -d $DESTDIR/spark spark

echo --- installing Go ---
cd $DESTDIR
curl -Lk http://dave.cheney.net/paste/go-linux-arm-bootstrap-c788a8e.tbz | tar xj
curl -Lk https://storage.googleapis.com/golang/go1.5.src.tar.gz | tar xz
cd $DESTDIR/go/src
env GOROOT_BOOTSTRAP=$DESTDIR/go-linux-arm-bootstrap ./make.bash
export PATH=$PATH:$DESTDIR/go/bin
rm -rf $DESTDIR/go-linux-arm-bootstrap

echo --- installing Gogs
wget https://github.com/gogits/gogs/releases/download/v0.8.10/linux_arm.zip -O $DESTDIR/
unzip $DESTDIR/linux_arm.zip
rm $DESTDIR/linux_arm.zip

if [ ! -d "$SRCDIR" ]; then
	echo --- downloading required packages ---
	mkdir $SRCDIR
	cd $SRCDIR
	curl -Lk https://github.com/git/git/archive/v2.6.4.tar.gz | tar xz
	curl -Lk http://apache.javapipe.com/httpd/httpd-2.4.18.tar.gz | tar xz
	curl -Lk https://ftp.postgresql.org/pub/source/v9.4.5/postgresql-9.4.5.tar.gz | tar xz
	curl -Lk https://dev.mysql.com/get/Downloads/MySQL-5.7/mysql-5.7.10.tar.gz | tar xz
	curl -Lk http://uk1.php.net/get/php-7.0.0.tar.gz/from/this/mirror | tar xz
	curl -Lk https://download.samba.org/pub/samba/stable/samba-4.3.3.tar.gz | tar xz
	cd $SRCDIR/httpd-2.4.18/srclib/
	curl -Lk http://apache.javapipe.com/apr/apr-1.5.2.tar.gz | tar xz
	curl -Lk http://apache.javapipe.com/apr/apr-util-1.5.4.tar.gz | tar xz
	mv apr-1.5.2 apr
	mv apr-util-1.5.4 apr-util
fi

if [ -d "$SRCDIR/git-2.6.4" ]; then
	echo --- installing Git ---
	cd $SRCDIR/git-2.6.4/
	make configure
	./configure --prefix=$DESTDIR
	make all
	make install
fi

if [ -d "$SRCDIR/httpd-2.4.18" ]; then
	echo --- installing Apache httpd ---

	echo ---- building and installing apr ----
	cd $SRCDIR/httpd-2.4.18/srclib/apr/
	./configure --prefix=$DESTDIR
	make
	make install

	echo ---- building and installing apr-util ----
	cd $SRCDIR/httpd-2.4.18/srclib/apr-util/
	./configure --prefix=$DESTDIR --with-apr=$DESTDIR
	make
	make install

	echo ---- building and installing httpd ----
	mkdir -p $DESTDIR/apache/
	cd $SRCDIR/httpd-2.4.18/
	./configure --prefix=$DESTDIR/apache --with-apr=$DESTDIR --with-apr-util=$DESTDIR --with-pcre=/usr --enable-so --enable-cgi
	make
	make install
	mkdir $DESTDIR/apache/conf/sites-available
	mkdir $DESTDIR/apache/conf/sites-enabled
	mkdir $DESTDIR/hosts
	ln -s $DESTDIR/apache/bin/apachectl $DESTDIR/etc/init.d/httpd
fi

if [ -d "$SRCDIR/postgresql-9.4.5" ]; then
	echo --- installing PostgreSQL ---

	echo ---- building and installing PostgreSQL ----
	cd $SRCDIR/postgresql-9.4.5/
	./configure --prefix=$DESTDIR/postgres
	make
	make install

	echo ---- configuring PostgreSQL ----
	mkdir $DESTDIR/postgres/data
	chown -R postgres:postgres $DESTDIR/postgres/data
	su - postgres -c "$DESTDIR/postgres/bin/initdb -D $DESTDIR/postgres/data"
	cp $SRCDIR/postgresql-9.4.5/contrib/start-scripts/linux $DESTDIR/etc/init.d/postgres
fi

if [ -d "$SRCDIR/mysql-5.7.10" ]; then
	echo --- installing MySQL ---
	mkdir $SRCDIR/mysql-5.7.10/build
	cd $SRCDIR/mysql-5.7.10/build
	cmake $SRCDIR/mysql-5.7.10/ -DCMAKE_INSTALL_PREFIX=$DESTDIR/mysql -DWITH_BOOST=/usr/lib/boost -DDOWNLOAD_BOOST=1
	make
	make install

	echo ---- configuring MySQL ----
	chown -R mysql:mysql $DESTDIR/mysql
	$DESTDIR/mysql/bin/mysqld --initialize --user=mysql
	$DESTDIR/mysql/bin/mysql_ssl_rsa_setup
	cp $DESTDIR/support-files/mysql.server $DESTDIR/etc/init.d/mysqld
	ln -s $DESTDIR/mysql/lib/libmysqlclient.so $DESTDIR/mysql/lib/libmysqlclient_r.so
fi

if [ -d "$SRCDIR/php-7.0.0" ]; then
	echo --- installing PHP 7 ---
	cd $SRCDIR/php-7.0.0/
	./configure --with-apxs2=$DESTDIR/apache/bin/apxs --with-mysqli=$DESTDIR/mysql/bin/mysql_config --enable-mbstring --with-pgsql=$DESTDIR/postgres --enable-opcache=no --prefix=$DESTDIR
	make
	make install

	cp php.ini-development $DESTDIR/lib/php.ini
fi

if [ -d "$SRCDIR/samba-4.3.3" ]; then
	echo --- installing Samba ---
	cd $SRCDIR/samba-4.3.3/
	./configure --prefix=$DESTDIR --disable-cups --without-ads --enable-fhs --disable-iprint --without-ldap
	make
	make install
fi

echo --- setting permissions ---
chown -R mysql:mysql $DESTDIR/mysql/
chown -R postgres:postgres $DESTDIR/postgres
chown -R git:git $DESTDIR/gogs
chown -R spark:spark $DESTDIR/spark
chown -R git:git /var/log/git

echo --- syncing and rebooting the device ---
sync
reboot