#!/bin/sh

if [ -d "/mnt/sdcard/packages/" ]; then
	echo --- installing packages ---
	rpm -Uvh /mnt/sdcard/packages/*.rpm --nodeps --force --quiet

	echo --- creating missing links and library cleanup ---
	ln -s /usr/lib/liblua.so /usr/lib/liblua-5.1.so
	ln -s /bin/mkdir /usr/bin/mkdir
	ln -s /bin/rm /usr/bin/rm
	ln -s /bin/cat /usr/bin/cat
	ln -s /bin/mktemp /usr/bin/mktemp
	ln -s /usr/bin/perl /bin/perl
	ln -s /usr/bin/m4 /bin/m4
	ln -s /usr/bin/find /bin/find
	ln -s /usr/bin/gzip /bin/gzip
	ln -s /usr/bin/sort /bin/sort
	ln -s /usr/bin/sed /bin/sed
	rm /lib/libnss_nis-2.13.so
	rm /lib/libBrokenLocale-2.13.so
	rm /lib/libnsl-2.13.so
	rm /lib/libc-2.13.so
	rm /lib/libm-2.13.so
	rm /lib/libnss_compat-2.13.so
	rm /lib/librt-2.13.so
	rm /lib/libcrypt-2.13.so
	rm /lib/libnss_nisplus-2.13.so
	rm /lib/libresolv-2.13.so
	rm /usr/lib/libtic.so.5.7
	rm /usr/lib/libmenu.so.5.7
	rm /usr/lib/libncurses.so.5.7
fi

echo --- creating and enabling swap ---
dd if=/dev/zero of=/opt/usr/swapfile bs=1024 count=1024000
chown root:root /opt/usr/swapfile
chmod 0600 /opt/usr/swapfile
mkswap /opt/usr/swapfile
swapon /opt/usr/swapfile
echo '/opt/usr/swapfile	swap	swap	defaults	0	0' >> /etc/fstab

echo --- removing unneeded files and directories ---
rm -rf /sdcard
rm -rf /csa
rm -rf /media
rm -rf /srv
rm -rf /opt/apps
rm -rf /opt/driver
rm -rf /opt/storage
rm -rf /opt/ug
rm -rf /opt/usr/apps
rm -rf /opt/usr/ug
rm -rf /mnt/mntlib
rm -rf /mnt/moviefs
rm -rf /mnt/nfs
rm -rf /mnt/mmc
rm -rf /mnt/ums
rm -rf /opt/data/browser-provider
rm -rf /opt/data/download-provider
rm -rf /opt/data/setting
rm -rf /opt/share/applications
rm -rf /opt/share/bt-ftp
rm -rf /opt/share/icons
rm -rf /opt/share/secure-storage
rm -rf /opt/share/settings
rm -rf /opt/share/widget
rm -rf /opt/usr/devel
rm -rf /opt/usr/live
rm -rf /opt/usr/media
rm -rf /opt/usr/share
rm /usr/lib/systemd/system/ac.service
rm /usr/lib/systemd/system/bluetooth.target
rm /usr/lib/systemd/system/ghost.service
rm /usr/lib/systemd/system/launchpad-preload.service
rm /usr/lib/systemd/system/printer.target
rm /usr/lib/systemd/system/resourced.service
rm -rf /usr/lib/systemd/system/security-server*.*
rm /usr/lib/systemd/system/sound.target
rm /usr/lib/systemd/system/tmp.mount
rm /usr/lib/systemd/system/wm_ready.service
rm -rf /usr/apps
rm -rf /usr/games
rm -rf /usr/local
rm -rf /usr/ug
rm -rf /usr/src
rm -rf /usr/etc/bluetooth
rm -rf /usr/etc/enlightenment
rm -rf /usr/etc/wifi-direct
rm -rf /usr/etc/wrt*
rm -rf /usr/etc/mmfw*.ini
rm -rf /usr/opt
rm -rf /opt/usr/data
rm -rf /opt/system
rm /etc/systemd/system/csa.mount

echo --- creating directory structure ---
mkdir /var/webmin
mkdir /var/spool/cron
mkdir /var/log/network
mkdir -p /opt/usr/data
mkdir /var/log/apache
mv /opt/var /opt/usr/var
rm -rf /opt/var
ln -s /opt/usr/var /opt/var
rm -rf /var
ln -s /opt/usr/var /var
ln -s /mnt/sdcard/src /usr/src
ln -s /var/log/network /opt/usr/data/network
mv /opt/home /opt/usr/
ln -s /opt/usr/home /opt/home
ln -s /opt/usr/home /home
cp -R /lib/modules /lib/_modules
umount /lib/modules
cp -R /lib/_modules/* /lib/modules/
rm -rf /lib/_modules
ln -s /mnt/sdcard /usr/local

echo --- syncing passwords with shadow tools ---
pwconv

echo --- syncing and rebooting the device ---
sync
reboot