#!/bin/sh

echo --- This script is created to transform your Tizen RD-PQ device ---
echo --- into a personal development server ---
echo ---

echo --- switching CPU to performance mode ---
echo '#!/bin/sh
echo performance > /sys/devices/system/cpu/cpu0/cpufreq/scaling_governor' > /usr/bin/cpu-governor.sh

echo --- mounting SD card ---
mkdir /mnt/sdcard
mount /dev/mmcblk1p1 /mnt/sdcard
echo '/dev/mmcblk1p1	/mnt/sdcard	ext3	data=ordered,user_xattr,relatime,nodelalloc,barrier=1,acl	0	0' >> /etc/fstab

echo --- installing WLAN support and SSH server ---
mkdir -p /tmp/tizend-dev-it
wget https://download.tizen.org/releases/2.2.1/latest/repos/tizen-main/armv7l/packages/armv7l/usleep-1-5.2.armv7l.rpm -O /tmp/tizend-dev-it/usleep-1-5-2.armv7l.rpm 
# usleep-1-6.7.armv7l.rpm
wget https://download.tizen.org/releases/2.2/latest/repos/tizen-main/armv7l/packages/armv7l/wlandrv-plugin-tizen2.1-bcm43xx-1.0.4-1.armv7l.rpm -O /tmp/tizend-dev-it/wlandrv-plugin-tizen2.1-bcm43xx-1.0.4-1.armv7l.rpm
wget https://download.tizen.org/releases/2.2.1/latest/repos/tizen-main/armv7l/packages/armv7l/lsb-3.2-4.2.armv7l.rpm -O /tmp/tizend-dev-it/lsb-3.2-4.2.armv7l.rpm
# lsb-3.2-6.2.armv7l.rpm
wget https://download.tizen.org/releases/2.3/2.3-mobile/tizen-2.3-mobile_20150206.1/repos/target/packages/armv7l/openssh-client-5.3p1-1.2.armv7l.rpm -O /tmp/tizend-dev-it/openssh-client-5.3p1-1.2.armv7l.rpm
wget https://download.tizen.org/releases/2.3/2.3-mobile/tizen-2.3-mobile_20150206.1/repos/target/packages/armv7l/openssh-server-5.3p1-1.2.armv7l.rpm -O /tmp/tizend-dev-it/openssh-server-5.3p1-1.2.armv7l.rpm
rpm -ivh /tmp/tizend-dev-it/usleep-*.armv7l.rpm --quiet
rpm -ivh /tmp/tizend-dev-it/wlandrv-plugin-tizen2.1-bcm43xx-*.armv7l.rpm --quiet
rpm -ivh /tmp/tizend-dev-it/lsb-*.armv7l.rpm --quiet
rpm -ivh /tmp/tizend-dev-it/openssh-client-*.armv7l.rpm --quiet
rpm -ivh /tmp/tizend-dev-it/openssh-server-*.armv7l.rpm --quiet
rm -rf /tmp/tizend-dev-it

echo --- creating missing links ---
ln -s /usr/sbin/rmmod /sbin/rmmod
ln -s /usr/sbin/modprobe /sbin/modprobe
mkdir /var/run/sshd
chmod 0600 /var/run/sshd

echo --- enabling wlan, wifi and sshd autostart ---
systemctl enable wlan-1
systemctl enable wlan-2
systemctl enable connman
systemctl enable sshd

echo --- syncing and rebooting the device ---
sync
reboot