# About

Tizen Development Kit is a collection of scripts created to transform your Samsung RD-PQ development device into a personal home development server. Since the device should be running Tizen 2.3.1, you have a powerfull Linux kernel available so the scripts just remove the unneeded cruft from the packages while installing others that you will need.

The scripts are tested with RD-PQ and Tizen 2.3.1.

## Installation

As a prerequisite, your RD-PQ device should be running Tizen 2.3.1. If it does not, search for more information on how to install it.

Also, you need the latest Tizen mobile snapshot extra packages added to a directory on the SD card, called `packages` (`/mnt/sdcard` directory). Those rpm packages are based on the [Tizen mobile snapshots](https://download.tizen.org/snapshots/tizen/mobile/latest/repos/arm-wayland/) found on the official Tizen website.

The installation is divided into four steps with four different scripts.

### stage1.sh

The first script will switch the CPU into performance mode, mount the SD card, install and activate the Wlan driver, enable the wpa_supplicant, install the SSH server and client components and reboot the device.

### stage2.sh

Before running the second script, make sure you use the Tizen UI to connect to a wireless network and perform any other customizations. For example, you might want to disable bluetooth, nfc, gps, set date/time, set timezone, etc. The second script will remove a bunch of unneeded packages, including X server, e17, all Tizen server components, agents and services.

### stage-3.sh

The third script will install all the packages from the /mnt/sdcard/packages directory, create some missing links inside the Tizen OS, create a swap file and enable it.

### stage-4.sh

The fourth script will activate swap, build and install some server components from latest source. The components are:

- Golang (1.5)
- Git (2.6.4)
- Apache httpd (2.4.18)
- PostgreSQL (9.4.5)
- MySQL (5.7.10)
- PHP (7.0.0)
- Samba (4.3.3)

If you need different versions, make sure you edit the `stage4.sh` script accordingly.

## Usage

Start by uploading the two files in the `bin` directory that are missing from the tizen-coreutils package, push the four shell script files via sdb, push the four .service files and run the script files one by one. The scripts will automatically reboot your phone, so you know when to continue with the others.

```shell
# sdb root on
# sdb push bin/* /usr/bin/
# sdb push stage*.sh /usr/bin/
# sdb push service/*.service /etc/systemd/system/
# sdb shell
# /usr/bin/stage1.sh ... etc ...
```

After the scripts are done with their processing, you will be presented with a personal development server powered by the RD-PQ's quad core Exynos ARMv7 CPU, quite a powerful machine that will be significantly faster than a Raspberry Pi.

You can login into your device via SSH, the root user has no default password. Make sure you create a password for it by using the `passwd` command.

## License

Tizen Development Kit is written by __sizeof(cat)__ and released under __GPLv3__.

```txt
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation, either version 3 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program. If not, see <https://www.gnu.org/licenses/>.
```
