unit Unit1;

{$mode objfpc}{$H+}

interface

uses
	 Classes, SysUtils, Forms, Controls, Graphics, Dialogs, StdCtrls, ComCtrls,
	 ExtCtrls, StrUtils, regexpr, opensslsockets, lclintf, fphttpclient, fpjson,
     jsonparser;

type

	{ TfrmMain }

	TfrmMain = class(TForm)
		btnGetCACertData: TButton;
		btnGetProviderData: TButton;
	    btnGetCapData: TButton;
	    btnGetCertData: TButton;
	    btnGenerate: TButton;
	    btnDownload: TButton;
		btnLoadProfile: TButton;
		btnRenewCert: TButton;
		btnSaveProfile: TButton;
		cmbGateway: TComboBox;
		cmbPort: TComboBox;
		cmbProto: TComboBox;
		cmbOS: TComboBox;
		Image1: TImage;
		Label10: TLabel;
		Label11: TLabel;
		Label12: TLabel;
		Label13: TLabel;
		Label14: TLabel;
        Memo1: TMemo;
		renewMemo: TMemo;
		dlgOpen: TOpenDialog;
		Panel1: TPanel;
		pdURL: TEdit;
		caURL: TEdit;
		capURL: TEdit;
		certURL: TEdit;
		Label6: TLabel;
		caMemo: TMemo;
		pdMemo: TMemo;
		capMemo: TMemo;
		certMemo: TMemo;
		profileMemo: TMemo;
		pageMain: TPageControl;
		pnlProfile: TPanel;
		dlgSave: TSaveDialog;
		TabSheet1: TTabSheet;
		TabSheet2: TTabSheet;
		TabSheet3: TTabSheet;
		TabSheet4: TTabSheet;
		TabSheet5: TTabSheet;
		TabSheet6: TTabSheet;
		TabSheet7: TTabSheet;
		procedure btnGetCACertDataClick(Sender: TObject);
		procedure btnGetProviderDataClick(Sender: TObject);
		procedure btnGetCapDataClick(Sender: TObject);
		procedure btnGetCertDataClick(Sender: TObject);
		procedure btnGenerateClick(Sender: TObject);
		procedure btnDownloadClick(Sender: TObject);
		procedure btnLoadProfileClick(Sender: TObject);
		procedure btnRenewCertClick(Sender: TObject);
		procedure btnSaveProfileClick(Sender: TObject);
		procedure cmbGatewayChange(Sender: TObject);
		procedure cmbPortChange(Sender: TObject);
		procedure cmbProtoChange(Sender: TObject);
		procedure cmbOSChange(Sender: TObject);
        procedure Image1Click(Sender: TObject);
		procedure Label11Click(Sender: TObject);
		procedure Label12Click(Sender: TObject);
		procedure Label13Click(Sender: TObject);
		procedure Label14Click(Sender: TObject);
                procedure Label5Click(Sender: TObject);
        procedure Label7Click(Sender: TObject);
		procedure Label9Click(Sender: TObject);
	private
		DatetimeCreated: TDateTime;
        DatetimeExpires: TDateTime;
	    CAcertData: ansistring;
		ProviderData: TJSONData;
		ConfigData: TJSONData;
		KeypairData: ansistring;
		TempAPIUri: string;
		TempAPIVersion: string;
		TempCACertUri: string;
		TempDev: string;
		TempCipher: string;
		TempTLSCipher: string;
		TempTLSVersionMin: string;
		TempAuth: string;
		TempKeepAlive: string;
		TempVerb: string;
		TempHost: string;
		TempPort: string;
		TempProto: string;
	    TempOS: string;
		TempLoadedProfileFilename: string;
	public

	end;

var
	frmMain: TfrmMain;

const
	UserAgent = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36';
	OpenVPNDefaultData =
		'# =========================================================================' + #13#10 +
        '# This OpenVPN profile was generated from the Riseup VPN servers using' + #13#10 +
        '# sizeof(cat)`s RiseupVPN to OpenVPN application.' + #13#10 +
        '#' + #13#10 +
        '# Created: REPLACE_CDATE' + #13#10 +
        '# Expires: REPLACE_EDATE' + #13#10 +
		'#' + #13#10 +
        '# Version: 1.0' + #13#10 +
        '# License: GPLv3' + #13#10 +
        '# Author: sizeof(cat)' + #13#10 +
		'# Project page: http://sizeof.cat/project/riseupvpn-to-openvpn-application' + #13#10 +
        '# =========================================================================' + #13#10 + #13#10 +
        'client' + #13#10 +
        'tls-client' + #13#10 +
		'dev REPLACE_DEV' + #13#10 +
        'proto REPLACE_PROTO' + #13#10 +
		'remote REPLACE_IP REPLACE_PORT' + #13#10 +
        'auth REPLACE_AUTH' + #13#10 +
        'cipher REPLACE_CIPHER' + #13#10 +
        'keepalive REPLACE_KEEP_ALIVE' + #13#10 +
        'tls-cipher REPLACE_TLS_CIPHER' + #13#10 +
        'float' + #13#10 +
        'resolv-retry infinite' + #13#10 +
        'nobind' + #13#10 +
		'verb REPLACE_VERB' + #13#10 +
        'persist-key' + #13#10 +
        'persist-tun' + #13#10 +
        'reneg-sec 0' + #13#10 +
        'pull' + #13#10 +
        'auth-nocache' + #13#10 +
        'script-security 2' + #13#10 +
        'tls-version-min REPLACE_TLS_VERSION_MIN' + #13#10 +
        'redirect-gateway ipv6' + #13#10 +
        'remote-cert-tls server' + #13#10 +
        'remote-cert-eku "TLS Web Server Authentication"' + #13#10 +
		'verify-x509-name REPLACE_HOST name' + #13#10 +
        '<ca>' + #13#10 +
		'REPLACE_CA_CERT' + #13#10 +
        '</ca>' + #13#10 +
        '<cert>' + #13#10 +
		'REPLACE_CLIENT_CERT' + #13#10 +
        '</cert>' + #13#10 +
        '<key>' + #13#10 +
        'REPLACE_CLIENT_KEY' + #13#10 +
        '</key>';
	 OpenVPNDefaultDataEx =
         'up /etc/openvpn/update-resolv-conf' + #13#10 +
         'down /etc/openvpn/update-resolv-conf';

implementation

{$R *.lfm}

{ TfrmMain }

procedure TfrmMain.btnGetCACertDataClick(Sender: TObject);
var
	Http: TFPHttpClient;
begin
	Http := TFPHttpClient.Create(nil);
	try
		Http.AddHeader('User-Agent', UserAgent);
		CACertData := Http.Get(TempCACertUri);

		caMemo.Text := CACertData;

		btnGetCapData.Enabled := True;
		btnGetCACertData.Enabled := False;
		pageMain.ActivePage := TabSheet1;
	finally
		Http.Free;
	end;
end;

procedure TfrmMain.btnGetProviderDataClick(Sender: TObject);
var
	Http: TFPHttpClient;
	Content: string;
	Json: TJSONData;
	JsonObject: TJSONObject;
begin
	Http := TFPHttpClient.Create(nil);
	try
		Http.AddHeader('User-Agent', UserAgent);
		Content := Http.Get('https://riseup.net/provider.json');
		Json := GetJSON(Content);
		JsonObject := TJSONObject(Json);
		ProviderData := Json;

		TempAPIUri := JsonObject.Strings['api_uri'];
		TempAPIVersion := JsonObject.Strings['api_version'];
		TempCACertUri := JsonObject.Strings['ca_cert_uri'];

		pdMemo.Text := Json.FormatJSON;
		capURL.Text := TempAPIUri + '/' + TempAPIVersion + '/config/eip-service.json';
		certURL.Text := TempAPIUri + '/' + TempAPIVersion + '/cert';
		caURL.Text := TempCACertUri;

		btnGetCACertData.Enabled := True;
		btnGetProviderData.Enabled := False;
		pageMain.ActivePage := TabSheet2;
	finally
		Http.Free;
	end;
end;

procedure TfrmMain.btnGetCapDataClick(Sender: TObject);
var
	Http: TFPHttpClient;
	Content: string;
	Json: TJSONData;
	JsonObject, Gateway: TJSONObject;
	JsonOpenVPNConfigObject: TJSONObject;
	JsonOpenVPNGateways: TJSONArray;
	i: byte;
begin
	Http := TFPHttpClient.Create(nil);
	try
		Http.AddHeader('User-Agent', UserAgent);
		Content := Http.Get(TempAPIUri + '/' + TempAPIVersion + '/config/eip-service.json');
		Json := GetJSON(Content);
		ConfigData := Json;
		JsonObject := TJSONObject(Json);

		JsonOpenVPNConfigObject := JsonObject.Objects['openvpn_configuration'];
		TempDev := JsonOpenVPNConfigObject.Strings['dev'];
		TempCipher := JsonOpenVPNConfigObject.Strings['cipher'];
		TempTLSCipher := JsonOpenVPNConfigObject.Strings['tls-cipher'];
		TempTLSVersionMin := JsonOpenVPNConfigObject.Strings['tls-version-min'];
		TempAuth := JsonOpenVPNConfigObject.Strings['auth'];
		TempKeepAlive := JsonOpenVPNConfigObject.Strings['keepalive'];
		TempVerb := JsonOpenVPNConfigObject.Strings['verb'];

		JsonOpenVPNGateways := JsonObject.Arrays['gateways'];
        cmbGateway.Items.Clear;
		for i := 0 to JsonOpenVPNGateways.Count - 1 do
		begin
			Gateway := JsonOpenVPNGateways.Objects[i];
			cmbGateway.Items.Add(Gateway.Strings['host']);
		end;

        cmbPort.Items.Clear;
        cmbPort.Items.Add('53');
        cmbPort.Items.Add('80');
        cmbPort.Items.Add('1194');

        cmbProto.Items.Clear;
        cmbProto.Items.Add('TCP');
        cmbProto.Items.Add('UDP');

        cmbOS.Items.Clear;
        cmbOS.Items.Add('Windows');
        cmbOS.Items.Add('Linux');
        cmbOS.Items.Add('macOS');

		cmbGateway.ItemIndex := 0;
		TempHost := cmbGateway.Text;
		cmbPort.ItemIndex := 2;
		TempPort := cmbPort.Text;
		cmbProto.ItemIndex := 0;
		TempProto := cmbProto.Text;
		cmbOS.ItemIndex := 0;
		TempOS := cmbOS.Text;

		capMemo.Text := Json.FormatJSON;

		btnGetCertData.Enabled := True;
		btnGetCapData.Enabled := False;
		pageMain.ActivePage := TabSheet3;
	finally
		Http.Free;
	end;
end;

procedure TfrmMain.btnGetCertDataClick(Sender: TObject);
var
	Http: TFPHttpClient;
begin
	Http := TFPHttpClient.Create(nil);
	try
		Http.AddHeader('User-Agent', UserAgent);
		KeypairData := Http.Get(TempAPIUri + '/' + TempAPIVersion + '/cert');
		certMemo.Text := KeypairData;
        DatetimeCreated := Now;
	    DatetimeExpires := Now + (4 * 7 * 3);

		cmbGateway.Enabled := True;
		cmbPort.Enabled := True;
		cmbProto.Enabled := True;
		cmbOS.Enabled := True;
		btnGenerate.Enabled := True;
		btnGetCertData.Enabled := False;
		pageMain.ActivePage := TabSheet4;
	finally
        Http.Free;
	end;
end;

procedure TfrmMain.btnGenerateClick(Sender: TObject);
var
	OpenVPNData: ansistring;
	re: tregexpr;
    VPNHost: string;
begin
	if (CACertData <> '') and (ProviderData <> nil) and (ConfigData <> nil) and
		(KeypairData <> '') then
	begin
	    OpenVPNData := OpenVPNDefaultData;
		OpenVPNData := ReplaceStr(OpenVPNData, 'REPLACE_CA_CERT', CACertData);
		OpenVPNData := ReplaceStr(OpenVPNData, 'REPLACE_DEV', TempDev);
		OpenVPNData := ReplaceStr(OpenVPNData, 'REPLACE_CIPHER', TempCipher);
		OpenVPNData := ReplaceStr(OpenVPNData, 'REPLACE_TLS_CIPHER', TempTLSCipher);
		OpenVPNData := ReplaceStr(OpenVPNData, 'REPLACE_KEEP_ALIVE', TempKeepAlive);
		OpenVPNData := ReplaceStr(OpenVPNData, 'REPLACE_TLS_VERSION_MIN', TempTLSVersionMin);
		OpenVPNData := ReplaceStr(OpenVPNData, 'REPLACE_VERB', TempVerb);
		OpenVPNData := ReplaceStr(OpenVPNData, 'REPLACE_AUTH', TempAuth);

		re := tregexpr.Create('-----BEGIN CERTIFICATE-----(?s)(.*)-----END CERTIFICATE-----');
		re.Exec(KeypairData);
		OpenVPNData := ReplaceStr(OpenVPNData, 'REPLACE_CLIENT_CERT', '-----BEGIN CERTIFICATE-----' + re.match[1] + '-----END CERTIFICATE-----');
		re.Free;

		re := tregexpr.Create('-----BEGIN RSA PRIVATE KEY-----(?s)(.*)-----END RSA PRIVATE KEY-----');
		re.Exec(KeypairData);
		OpenVPNData := ReplaceStr(OpenVPNData, 'REPLACE_CLIENT_KEY', '-----BEGIN RSA PRIVATE KEY-----' + re.match[1] + '-----END RSA PRIVATE KEY-----');
		re.Free;

        VPNHost := Copy(TempHost, 1, Pos('.', TempHost) - 1);

		OpenVPNData := ReplaceStr(OpenVPNData, 'REPLACE_HOST', VPNHost);
		OpenVPNData := ReplaceStr(OpenVPNData, 'REPLACE_IP', TempHost);
		OpenVPNData := ReplaceStr(OpenVPNData, 'REPLACE_PORT', TempPort);
        OpenVPNData := ReplaceStr(OpenVPNData, 'REPLACE_PROTO', TempProto);
        OpenVPNData := ReplaceStr(OpenVPNData, 'REPLACE_CDATE', DateTimeToStr(DatetimeCreated));
        OpenVPNData := ReplaceStr(OpenVPNData, 'REPLACE_EDATE', DateTimeToStr(DatetimeExpires));

		profileMemo.Text := OpenVPNData;
		if TempOS = 'Linux' then
		begin
			profileMemo.Lines.Add(OpenVPNDefaultDataEx);
		end;

		pageMain.ActivePage := TabSheet5;
		btnDownload.Enabled := True;
	end;
end;

procedure TfrmMain.btnDownloadClick(Sender: TObject);
begin
	dlgSave.FileName := TempHost + '.ovpn';
	if dlgSave.Execute then
		profileMemo.Lines.SaveToFile(dlgSave.FileName);
end;

procedure TfrmMain.btnLoadProfileClick(Sender: TObject);
begin
	if dlgOpen.Execute then
	begin
		TempLoadedProfileFilename := dlgOpen.Filename;
		renewMemo.Lines.Clear;
		renewMemo.Lines.LoadFromFile(dlgOpen.Filename);
		btnRenewCert.Enabled := True;
		btnSaveProfile.Enabled := True;
	end;
end;

procedure TfrmMain.btnRenewCertClick(Sender: TObject);
var
	Http: TFPHttpClient;
	RenewKeypairData: ansistring;
	re: tregexpr;
	RenewKeypairDataCert: ansistring;
	RenewKeypairDataKey: ansistring;
	TempStr: ansistring;
begin
	 Http := TFPHttpClient.Create(nil);
	 try
		Http.AddHeader('User-Agent', UserAgent);
		RenewKeypairData := Http.Get('https://api.black.riseup.net:443/3/cert');

		re := tregexpr.Create('-----BEGIN CERTIFICATE-----(?s)(.*)-----END CERTIFICATE-----');
		re.Exec(RenewKeypairData);
		RenewKeypairDataCert := re.match[1];
		re.Free;

		re := tregexpr.Create('-----BEGIN RSA PRIVATE KEY-----(?s)(.*)-----END RSA PRIVATE KEY-----');
		re.Exec(RenewKeypairData);
		RenewKeypairDataKey := re.match[1];
		re.Free;

		TempStr := renewMemo.Text;
		TempStr := ReplaceRegExpr('<cert>(?s)(.*)</cert>',
			TempStr, '<cert>' + #13#10 + '-----BEGIN CERTIFICATE-----' +
			RenewKeypairDataCert + '-----END CERTIFICATE-----' + #13#10 + '</cert>',
			True);

		TempStr := ReplaceRegExpr('<key>(?s)(.*)</key>',
			TempStr, '<key>' + #13#10 + '-----BEGIN RSA PRIVATE KEY-----' +
			RenewKeypairDataKey + '-----END RSA PRIVATE KEY-----' + #13#10 +
			'</key>', True);
		renewMemo.Text := TempStr;

		btnSaveProfile.Enabled := True;
	finally
		Http.Free;
	end;
end;

procedure TfrmMain.btnSaveProfileClick(Sender: TObject);
begin
	dlgSave.FileName := TempLoadedProfileFilename;
	if dlgSave.Execute then
		renewMemo.Lines.SaveToFile(dlgSave.FileName);
end;

procedure TfrmMain.cmbGatewayChange(Sender: TObject);
begin
	TempHost := cmbGateway.Text;
	btnGenerate.Click;
end;

procedure TfrmMain.cmbPortChange(Sender: TObject);
begin
	TempPort := cmbPort.Text;
	btnGenerate.Click;
end;

procedure TfrmMain.cmbProtoChange(Sender: TObject);
begin
	TempProto := cmbProto.Text;
	btnGenerate.Click;
end;

procedure TfrmMain.cmbOSChange(Sender: TObject);
begin
	TempOS := cmbOS.Text;
	btnGenerate.Click;
end;

procedure TfrmMain.Image1Click(Sender: TObject);
begin
	TabSheet7.TabVisible := True;
end;

procedure TfrmMain.Label11Click(Sender: TObject);
begin
	OpenURL('https://riseup.net/vpn');
end;

procedure TfrmMain.Label12Click(Sender: TObject);
begin
	OpenURL('https://sizeof.cat/project/riseupvpn-to-openvpn-application/');
end;

procedure TfrmMain.Label13Click(Sender: TObject);
begin
	OpenURL('https://openvpn.net/community-downloads/');
end;

procedure TfrmMain.Label14Click(Sender: TObject);
begin
	OpenURL('https://tunnelblick.net');
end;

procedure TfrmMain.Label5Click(Sender: TObject);
begin

end;

procedure TfrmMain.Label7Click(Sender: TObject);
begin

end;

procedure TfrmMain.Label9Click(Sender: TObject);
begin
	OpenURL('http://sizeof.cat');
end;

end.
