/*
 * PasteDialog.java
 *

 * Created on 14 June 2000, 22:00
 */
 
import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;

/** 
 *
 * @author  aak97
 * @version 
 */
public class PasteDialog extends javax.swing.JDialog {

  private boolean buttonPressed = false;
  private int     theButtonPressed = -1;
  private Frame parent;

  /** Creates new form PasteDialog */
  public PasteDialog(java.awt.Frame theParent,boolean modal) {
    super (theParent, modal);
    parent = theParent;
    initComponents ();
    pack ();
    
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents () {//GEN-BEGIN:initComponents
    jPanel2 = new javax.swing.JPanel ();
    cancelButon = new javax.swing.JButton ();
    clearButton = new javax.swing.JButton ();
    okayButton = new javax.swing.JButton ();
    jPanel1 = new javax.swing.JPanel ();
    jScrollPane1 = new javax.swing.JScrollPane ();
    pasteDnaText = new javax.swing.JTextArea ();
    setTitle ("Paste DNA Sequence");
    setResizable (false);
    addWindowListener (new java.awt.event.WindowAdapter () {
      public void windowClosing (java.awt.event.WindowEvent evt) {
        closeDialog (evt);
      }
    }
    );


      cancelButon.setText ("Cancel");
      cancelButon.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          cancelButtonPerformed (evt);
        }
      }
      );
  
      jPanel2.add (cancelButon);
  
      clearButton.setText ("Clear");
      clearButton.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          clearButtonPerformed (evt);
        }
      }
      );
  
      jPanel2.add (clearButton);
  
      okayButton.setText ("Okay");
      okayButton.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          okayButtonPerformed (evt);
        }
      }
      );
  
      jPanel2.add (okayButton);
  

    getContentPane ().add (jPanel2, java.awt.BorderLayout.SOUTH);

    jPanel1.setBorder (new javax.swing.border.TitledBorder("Please paste your DNA sequence here"));

      jScrollPane1.setPreferredSize (new java.awt.Dimension(300, 150));
  
        pasteDnaText.setWrapStyleWord (true);
    
        jScrollPane1.setViewportView (pasteDnaText);
    
      jPanel1.add (jScrollPane1);
  

    getContentPane ().add (jPanel1, java.awt.BorderLayout.NORTH);

  }//GEN-END:initComponents

  private void okayButtonPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okayButtonPerformed
// Add your handling code here:
    theButtonPressed = 1;
    buttonPressed = true;
    setVisible(false);
  }//GEN-LAST:event_okayButtonPerformed

  private void clearButtonPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearButtonPerformed
// Add your handling code here:
	this.setTextField("");
  }//GEN-LAST:event_clearButtonPerformed


  private void cancelButtonPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonPerformed
// Add your handling code here:
    theButtonPressed = 0;
    buttonPressed = true;
    setVisible(false);
  }//GEN-LAST:event_cancelButtonPerformed

  /** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
    setVisible (false);
    dispose ();
  }//GEN-LAST:event_closeDialog

  public void clearTextField()
  {
      this.setTextField("");
  }
  
  public void setTextField(String theString)
  {
    pasteDnaText.setText(theString);
  }
  public String getTextField()
  {
    return pasteDnaText.getText();
  }
  public int showDnaPasteDialog()
  {
	centre();
      setVisible(true);
      return theButtonPressed;
  }
 
  /**
  * @param args the command line arguments
  */
  public static void main (String args[]) {
    new PasteDialog (new javax.swing.JFrame (), true).setVisible(true);
  }


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel jPanel2;
  private javax.swing.JButton cancelButon;
  private javax.swing.JButton clearButton;
  private javax.swing.JButton okayButton;
  private javax.swing.JPanel jPanel1;
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JTextArea pasteDnaText;
  // End of variables declaration//GEN-END:variables
	void centre() 
	{
          	pack();

          	Point p = parent.getLocation();
          	Dimension d = parent.getSize();
          	Dimension s = getSize();

          	p.translate((d.width - s.width) / 2,
                      (d.height - s.height) / 2);
          	setLocation(p);
      	}

}