/*
 * MusicalNote.java
 *
 * Created on 15 May 2000, 19:58
 */

/** 
 *
 * @author  aak97
 * @version 
 */
public class MusicalNote extends Object 
{
  private String  stringRepresentation  = "";
  private int     integerRepresentation = 0;
  /** Creates new MusicalNote */
  public MusicalNote(String theStringRepresentation) 
  {
      stringRepresentation = String.valueOf(stringRepresentation.toUpperCase());
      integerRepresentation = this.convertFromString(theStringRepresentation.toUpperCase());
      //byteRepresentation = (integerRepresentation&&255);
  }
  
  public MusicalNote(int theIntegerRepresentation) 
  {
      integerRepresentation = theIntegerRepresentation;
      stringRepresentation =  this.convertFromInteger(theIntegerRepresentation);
  }
  
  public int getIntegerRepresentation()
  {
      return integerRepresentation;
  }
  
  public String getStringRepresentation()
  {
      return stringRepresentation;
  }
  public String convertFromInteger(int theIntegerRepresentation)
  {
      String  returnString       =   "";
      int     basicNote          =   0;
      int     ocataveMultiplier  =   0;
      
      ocataveMultiplier = (int) theIntegerRepresentation/12;
      basicNote         = (int) theIntegerRepresentation%12;
      
      /* string representation according to the basic node   */
      
      switch(basicNote)
      {
          case  0 : returnString = returnString + "C" ; break;
          case  2 : returnString = returnString + "D" ; break;
          case  4 : returnString = returnString + "E" ; break;
          case  5 : returnString = returnString + "F" ; break;
          case  7 : returnString = returnString + "G" ; break;
          case  9 : returnString = returnString + "A" ; break;
          case 11 : returnString = returnString + "B" ; break;
          default : returnString = returnString + this.getClass().getName() + " : could not convert into String!"  ; break;
      }

      /* convert int into String for getting the octave     */
      Integer dummyInteger = Integer.valueOf(ocataveMultiplier);
      returnString = returnString + dummyInteger.toString();
      return returnString;

    }
  public int convertFromString(String theStringRepresentation)
  {
      /* get the first character of the string representaion */
      /* for converting into muscical note.                  */
      /* For example A3, first charater A                    */
    
      char dummyChar = theStringRepresentation.charAt(0); 
      
      /* convert into an integer                             */
    
      int  basicNote          =   0;
      int  ocataveMultiplier  =   0;
      
      switch(dummyChar)
      {
          case 'C' : basicNote =  0 ; break;
          case 'D' : basicNote =  2 ; break;
          case 'E' : basicNote =  4 ; break;
          case 'F' : basicNote =  5 ; break;
          case 'G' : basicNote =  7 ; break;
          case 'A' : basicNote =  9 ; break;
          case 'B' : basicNote = 11 ; break;
          default : basicNote = -1  ; break;
      }
     
      /* get the octave number (starts by zero)             */
      
      Integer dummyInteger = Integer.valueOf(theStringRepresentation.substring(1));
      
      /* construct Integer from String                      */
      
      ocataveMultiplier = dummyInteger.intValue();
      
      /* return integer reprentation of the note            */
      
      return (ocataveMultiplier*12)+basicNote;
  }
  
  public static void main(String[] args)
  {
      String S = new String("A5");
     // int[] intArray = new int[128];
      MusicalNote[] MA = new MusicalNote[128];
      for(int i=0;i<=128;i++)
      {
                MA[i] = new MusicalNote(i);
                System.out.println("String representation of "+i+" is : "+ MA[i].getStringRepresentation());
      }
      MusicalNote M = new MusicalNote(S);
      System.out.println("String representation of "+S+" is : "+ M.getIntegerRepresentation());
      
      
  }

  
}
