/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class ProteinMusicIO {
    BufferedReader inDnaReader = null;

    public String getSequenceFromFile(String string) {
        String string2 = "";
        try {
            this.inDnaReader = new BufferedReader(new FileReader(string));
            string2 = this.getAsciiFile();
        }
        catch (Exception exception) {
            System.out.println(this.getClass() + "\n" + exception);
        }
        return this.getSequenceFromString(string2);
    }

    public String getSequenceFromString(String string) {
        String string2 = "";
        if (this.testForFasta(string)) {
            string2 = this.convertSequenceFromFastaString(string);
        }
        if (this.testForEmbl(string)) {
            string2 = this.convertSequenceFromEmblString(string);
        }
        if (this.testForNcbi(string)) {
            string2 = this.convertSequenceFromNcbiString(string);
        }
        return string2;
    }

    private String getAsciiFile() throws IOException {
        Object object = "";
        String string = "";
        String string2 = "";
        boolean bl = false;
        do {
            if ((string = this.inDnaReader.readLine()) == null) {
                bl = true;
                continue;
            }
            object = (String)object + string + "\n";
        } while (!bl);
        return object;
    }

    private boolean testForFasta(String string) {
        return string != null && string.length() > 0 && string.charAt(0) == '>';
    }

    public String convertSequenceFromFastaString(String string) {
        Object object = "";
        String string2 = "";
        String string3 = "";
        try {
            string3 = string.substring(string.indexOf("\n"), string.length());
        }
        catch (Exception exception) {
            System.out.println("ProteinMusicIO:\t Problems with FASTA sequence");
            return null;
        }
        for (int i = 0; i < string3.length(); ++i) {
            string2 = string3.substring(i, i + 1);
            if (!string2.equalsIgnoreCase("a") && !string2.equalsIgnoreCase("t") && !string2.equalsIgnoreCase("g") && !string2.equalsIgnoreCase("c")) continue;
            object = (String)object + string2;
        }
        return object;
    }

    private boolean testForEmbl(String string) {
        return string != null && string.length() > 0 && string.indexOf("SQ   Sequence") > 0 && string.indexOf("//") > 0;
    }

    private boolean testForNcbi(String string) {
        return string != null && string.length() > 0 && string.indexOf("BASE COUNT") > 0 && string.indexOf("//") > 0;
    }

    public String convertSequenceFromEmblString(String string) {
        Object object = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        try {
            string3 = string.substring(string.indexOf("SQ   Sequence"), string.indexOf("//") - 1);
            string4 = string3.substring(string3.indexOf("\n"), string3.length());
        }
        catch (Exception exception) {
            System.out.println("ProteinMusicIO:\t Problems with FASTA sequence");
            return null;
        }
        for (int i = 0; i < string4.length(); ++i) {
            string2 = string4.substring(i, i + 1);
            if (!string2.equalsIgnoreCase("a") && !string2.equalsIgnoreCase("t") && !string2.equalsIgnoreCase("g") && !string2.equalsIgnoreCase("c")) continue;
            object = (String)object + string2;
        }
        return object;
    }

    public String convertSequenceFromNcbiString(String string) {
        Object object = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        try {
            string3 = string.substring(string.indexOf("ORIGIN"), string.lastIndexOf("//") - 1);
            string4 = string3.substring(string3.indexOf("\n"), string3.length());
        }
        catch (Exception exception) {
            System.out.println("ProteinMusicIO:\t Problems with FASTA sequence");
            return null;
        }
        for (int i = 0; i < string4.length(); ++i) {
            string2 = string4.substring(i, i + 1);
            if (!string2.equalsIgnoreCase("a") && !string2.equalsIgnoreCase("t") && !string2.equalsIgnoreCase("g") && !string2.equalsIgnoreCase("c")) continue;
            object = (String)object + string2;
        }
        return object;
    }

    public static void main(String[] stringArray) {
        ProteinMusicIO proteinMusicIO = new ProteinMusicIO();
        System.out.println(proteinMusicIO.getSequenceFromFile("GENE.AA"));
    }
}

