/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import javax.sound.midi.Instrument;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class ProteinMusic
extends JFrame
implements InstrumentTableUserInterface,
MetaEventListener {
    private Sequence theSequence;
    private Sequencer theSequencer;
    private Synthesizer theSynthesizer;
    private ConversionCore theConversionCore;
    private ProteinMusicIO theProteinMusicIO;
    private String theSequenceString = "";
    private Instrument[] theInstruments;
    private String[] instrumentNames = new String[]{"Piano", "Chromatic Perc.", "Organ", "Guitar", "Bass", "Strings", "Ensemble", "Brass", "Reed", "Pipe", "Synth Lead", "Synth Pad", "Synth Effects", "Ethnic", "Percussive", "Sound Effects"};
    private int instrumentTableRows = 8;
    private int instrumentTableCols = this.instrumentNames.length;
    private AboutDialog aboutDialog = new AboutDialog((Frame)this, true);
    private PasteDialog pasteDialog = new PasteDialog((Frame)this, true);
    public String pastedString;
    private JFileChooser fileChooser;
    private File currentDirectory = null;
    private File currentFile = null;
    private File currentMidiFile = null;
    private boolean fileLoaded = false;
    private boolean playing = false;
    private InstrumentTable instrumentTable = null;
    private TitledBorder tb;
    private int scrollPaneXPosition = 0;
    private int scrollPaneYPosition = 0;
    private int scrollPaneCounter = 0;
    private JTextArea sequenceTextArea;
    private int scrollStep = 10;
    private Point scrollPosition;
    private JViewport scrollJViewport;
    private boolean instrumentChanged = false;
    private int instrumentChangedCount = 0;
    private long positionChangeInTicks = 0L;
    private boolean positionChange = false;
    private double actualAAPosition = 0.0;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem openDnaFileMI;
    private JMenuItem closeDnaFileMI;
    private JSeparator jSeparator1;
    private JMenuItem saveMidiFileMI;
    private JMenuItem saveMidiFileAsMI;
    private JSeparator jSeparator2;
    private JMenuItem exitMI;
    private JMenu sequenceMenu;
    private JMenuItem pasteMenuItem;
    private JSeparator jSeparator3;
    private JMenuItem primaryMappingMenuItem;
    private JMenuItem secondaryMappingItem;
    private JMenu helpMenu;
    private JMenuItem aboutMenuItem;
    private JPanel jPanel3;
    private JComboBox jComboBox1;
    private JScrollPane jScrollPane4;
    private JTable jTable1;
    private JPanel jPanel1;
    private JButton rewindB;
    private JButton playB;
    private JButton pauseB;
    private JButton stopB;
    private JButton forwardB;
    private JPanel jPanel4;
    private JSlider tempoSlider;
    private JScrollPane sequenceScrollPane;

    public ProteinMusic() {
        this.theConversionCore = new ConversionCore();
        this.theConversionCore.init();
        this.fileChooser = new JFileChooser();
        this.theProteinMusicIO = new ProteinMusicIO();
        this.initComponents();
        this.pack();
        try {
            this.theSynthesizer = MidiSystem.getSynthesizer();
        }
        catch (Exception exception) {
            System.out.println(this.getClass() + "\tSynthesizer Device not supported (" + exception + ")");
            System.exit(1);
        }
        try {
            this.theSynthesizer.open();
        }
        catch (Exception exception) {
            System.out.println(this.getClass() + "\tCannot open Synthesizer Device (" + exception + ")");
            System.exit(1);
        }
        try {
            this.theSequencer = MidiSystem.getSequencer();
        }
        catch (Exception exception) {
            System.out.println(this.getClass() + "\tSequencer Device not supported" + exception + ")");
            System.exit(1);
        }
        try {
            this.theSequencer.open();
        }
        catch (Exception exception) {
            System.out.println(this.getClass() + "Cannot open Sequencer Device");
            System.exit(1);
        }
        if (!this.theSequencer.addMetaEventListener(this)) {
            System.out.println(this.getClass() + "\tCould not register MetaEventListener - there will be problems with scrolling! ");
        }
        if (this.theSynthesizer.getDefaultSoundbank() != null) {
            this.theInstruments = this.theSynthesizer.getDefaultSoundbank().getInstruments();
        } else {
            System.out.println(this.getClass() + "\tCould not find default soundbank - no instruments will be  visable/available!");
        }
        this.sequenceTextArea = this.createSequenceTextArea();
        this.sequenceScrollPane.setViewportView(this.sequenceTextArea);
        this.centre();
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openDnaFileMI = new JMenuItem();
        this.closeDnaFileMI = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.saveMidiFileMI = new JMenuItem();
        this.saveMidiFileAsMI = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.exitMI = new JMenuItem();
        this.sequenceMenu = new JMenu();
        this.pasteMenuItem = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.primaryMappingMenuItem = new JMenuItem();
        this.secondaryMappingItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.jPanel3 = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.jScrollPane4 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel1 = new JPanel();
        this.rewindB = new JButton();
        this.playB = new JButton();
        this.pauseB = new JButton();
        this.stopB = new JButton();
        this.forwardB = new JButton();
        this.jPanel4 = new JPanel();
        this.tempoSlider = new JSlider();
        this.sequenceScrollPane = new JScrollPane();
        this.fileMenu.setText("File");
        this.openDnaFileMI.setToolTipText("Open a FASTA, GenBank, or EMBL DNA File ");
        this.openDnaFileMI.setText("Open Project");
        this.openDnaFileMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProteinMusic.this.openDnaFileHandler(actionEvent);
            }
        });
        this.fileMenu.add(this.openDnaFileMI);
        this.closeDnaFileMI.setToolTipText("Close current project");
        this.closeDnaFileMI.setText("Close Project");
        this.closeDnaFileMI.setEnabled(false);
        this.closeDnaFileMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProteinMusic.this.closeDnaFileHandler(actionEvent);
            }
        });
        this.fileMenu.add(this.closeDnaFileMI);
        this.fileMenu.add(this.jSeparator1);
        this.saveMidiFileMI.setToolTipText("Save the generated MIDI file in current directory and under the same name");
        this.saveMidiFileMI.setText("Save MIDI File");
        this.saveMidiFileMI.setEnabled(false);
        this.saveMidiFileMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProteinMusic.this.saveMidiFileHandler(actionEvent);
                ProteinMusic.this.saveMidiFileHandler(actionEvent);
            }
        });
        this.fileMenu.add(this.saveMidiFileMI);
        this.saveMidiFileAsMI.setToolTipText("Save generated MIDI file under any name in any directory");
        this.saveMidiFileAsMI.setText("Save MIDI File As");
        this.saveMidiFileAsMI.setEnabled(false);
        this.saveMidiFileAsMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProteinMusic.this.saveAsMidiFileHandler(actionEvent);
            }
        });
        this.fileMenu.add(this.saveMidiFileAsMI);
        this.fileMenu.add(this.jSeparator2);
        this.exitMI.setToolTipText("Exit the program");
        this.exitMI.setActionCommand("exit");
        this.exitMI.setText("Exit");
        this.exitMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProteinMusic.this.exitActionHandler(actionEvent);
            }
        });
        this.fileMenu.add(this.exitMI);
        this.menuBar.add(this.fileMenu);
        this.sequenceMenu.setName("Sequence and Mapping");
        this.sequenceMenu.setText("Edit");
        this.pasteMenuItem.setToolTipText("Paste a DNA sequence into a text window for generating a MIDI sequence");
        this.pasteMenuItem.setText("Paste Sequence");
        this.pasteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProteinMusic.this.pasteMenuHandler(actionEvent);
            }
        });
        this.sequenceMenu.add(this.pasteMenuItem);
        this.sequenceMenu.add(this.jSeparator3);
        this.primaryMappingMenuItem.setToolTipText("Adjust primary musical mapping for the conversion");
        this.primaryMappingMenuItem.setText("Set Primary Mapping");
        this.primaryMappingMenuItem.setEnabled(false);
        this.sequenceMenu.add(this.primaryMappingMenuItem);
        this.secondaryMappingItem.setToolTipText("Adjust the order of amino acid characteristic for the conversion");
        this.secondaryMappingItem.setText("Set Secondary Mapping");
        this.secondaryMappingItem.setEnabled(false);
        this.sequenceMenu.add(this.secondaryMappingItem);
        this.menuBar.add(this.sequenceMenu);
        this.helpMenu.setText("Help");
        this.helpMenu.setEnabled(true);
        this.aboutMenuItem.setToolTipText("About this program");
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProteinMusic.this.aboutMenuHandler(actionEvent);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ProteinMusic.this.exitForm(windowEvent);
            }
        });
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.setBorder(new TitledBorder("Instrument Selection"));
        this.jComboBox1.setMaximumRowCount(2);
        this.jComboBox1.setMaximumSize(new Dimension(130, 25));
        this.jComboBox1.addItem(new String("Top Line"));
        this.jComboBox1.addItem(new String("Bass Line"));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProteinMusic.this.lineActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add((Component)this.jComboBox1, "North");
        this.jScrollPane4.setMinimumSize(new Dimension(120, 180));
        this.jScrollPane4.setMaximumSize(new Dimension(2000, 180));
        this.jTable1.setDoubleBuffered(true);
        this.jTable1.setCellEditor(this.jTable1.getCellEditor());
        this.jTable1.setCellSelectionEnabled(true);
        this.jTable1.setModel(new AbstractTableModel(){

            @Override
            public Object getValueAt(int n, int n2) {
                if (ProteinMusic.this.theInstruments != null) {
                    return ProteinMusic.this.theInstruments[n2 * ProteinMusic.this.instrumentTableRows + n].getName();
                }
                return Integer.toString(n2 * ProteinMusic.this.instrumentTableRows + n);
            }

            @Override
            public int getColumnCount() {
                return ProteinMusic.this.instrumentTableCols;
            }

            @Override
            public int getRowCount() {
                return ProteinMusic.this.instrumentTableRows;
            }

            @Override
            public String getColumnName(int n) {
                return ProteinMusic.this.instrumentNames[n];
            }

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
            }
        });
        this.jTable1.setPreferredScrollableViewportSize(new Dimension(450, 150));
        for (int i = 0; i < this.instrumentNames.length; ++i) {
            TableColumn tableColumn = this.jTable1.getColumn(this.instrumentNames[i]);
            tableColumn.setPreferredWidth(110);
        }
        this.jTable1.setAutoResizeMode(0);
        this.jTable1.setSelectionMode(0);
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ProteinMusic.this.TableMouseReleasedHandler(mouseEvent);
            }
        });
        this.jScrollPane4.setViewportView(this.jTable1);
        this.jPanel3.add((Component)this.jScrollPane4, "Center");
        this.getContentPane().add((Component)this.jPanel3, "North");
        this.jPanel1.setLayout(new FlowLayout(1, 10, 10));
        this.rewindB.setIcon(new ImageIcon("reverse.gif"));
        this.rewindB.setActionCommand("stop");
        this.rewindB.setText("Rewind");
        this.rewindB.setEnabled(false);
        this.rewindB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProteinMusic.this.rewindActionHandler(actionEvent);
            }
        });
        this.jPanel1.add(this.rewindB);
        this.playB.setIcon(new ImageIcon("play.gif"));
        this.playB.setActionCommand("play");
        this.playB.setText("Play");
        this.playB.setEnabled(false);
        this.playB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProteinMusic.this.playActionHandler(actionEvent);
            }
        });
        this.jPanel1.add(this.playB);
        this.pauseB.setIcon(new ImageIcon("pause.gif"));
        this.pauseB.setActionCommand("stop");
        this.pauseB.setText("Pause");
        this.pauseB.setEnabled(false);
        this.pauseB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProteinMusic.this.pauseActionHandler(actionEvent);
            }
        });
        this.jPanel1.add(this.pauseB);
        this.stopB.setIcon(new ImageIcon("stop.gif"));
        this.stopB.setActionCommand("stop");
        this.stopB.setText("Stop");
        this.stopB.setEnabled(false);
        this.stopB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProteinMusic.this.stopActionHandler(actionEvent);
            }
        });
        this.jPanel1.add(this.stopB);
        this.forwardB.setIcon(new ImageIcon("forward.gif"));
        this.forwardB.setActionCommand("stop");
        this.forwardB.setText("Forward");
        this.forwardB.setEnabled(false);
        this.forwardB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProteinMusic.this.forwardActionHandler(actionEvent);
            }
        });
        this.jPanel1.add(this.forwardB);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel4.setPreferredSize(new Dimension(512, 110));
        this.jPanel4.setMinimumSize(new Dimension(512, 110));
        this.tempoSlider.setPreferredSize(new Dimension(128, 50));
        this.tempoSlider.setBorder(new TitledBorder(""));
        this.tempoSlider.setMinimumSize(new Dimension(128, 50));
        this.tempoSlider.setMaximum(225);
        this.tempoSlider.setValue(128);
        this.tb = (TitledBorder)this.tempoSlider.getBorder();
        this.tb.setTitle("Tempo (BPM) = " + (int)this.theConversionCore.getTempoInBPM());
        this.tempoSlider.setValue((int)this.theConversionCore.getTempoInBPM());
        this.tempoSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ProteinMusic.this.tempoStateChangeHandler(changeEvent);
            }
        });
        this.jPanel4.add((Component)this.tempoSlider, "North");
        this.jPanel4.add((Component)this.sequenceScrollPane, "Center");
        this.getContentPane().add((Component)this.jPanel4, "Center");
        this.setJMenuBar(this.menuBar);
    }

    private void closeDnaFileHandler(ActionEvent actionEvent) {
        this.theConversionCore.setNucSequence("                                                                     ");
        this.theSequence = null;
        this.currentFile = null;
        super.setTitle("ProteinMusic");
        this.setButtonsNone();
        this.closeDnaFileMI.setEnabled(false);
        this.saveMidiFileMI.setEnabled(false);
        this.saveMidiFileAsMI.setEnabled(false);
        this.fileLoaded = false;
        this.setSequenceScroll();
        this.repaint();
    }

    private void forwardActionHandler(ActionEvent actionEvent) {
        if (!this.positionChange) {
            this.forwardB.setEnabled(false);
            this.rewindB.setEnabled(false);
            this.changeSequencePosition(9);
        }
    }

    private void pauseActionHandler(ActionEvent actionEvent) {
        if (this.theSequencer != null && this.theSequence != null) {
            this.setButtonsTogglePause();
            if (this.playing) {
                this.tempoSlider.setEnabled(true);
                this.theSequencer.setTempoInBPM(this.theConversionCore.getTempoInBPM());
                this.playing = false;
                this.theSequencer.stop();
            } else {
                this.theSequencer.setTempoInBPM(this.theConversionCore.getTempoInBPM());
                this.playing = true;
                this.theConversionCore.setTempoInBPM(this.tempoSlider.getValue());
                this.theSequencer.setTempoInBPM(this.theConversionCore.getTempoInBPM());
                this.theSequencer.start();
            }
        }
    }

    private void rewindActionHandler(ActionEvent actionEvent) {
        if (!this.positionChange) {
            this.forwardB.setEnabled(false);
            this.rewindB.setEnabled(false);
            this.changeSequencePosition(-9);
        }
    }

    private void pasteMenuHandler(ActionEvent actionEvent) {
        if (this.pasteDialog.showDnaPasteDialog() == 1) {
            this.pastedString = this.theProteinMusicIO.getSequenceFromString(this.pasteDialog.getTextField());
            try {
                this.theConversionCore.setNucSequence(this.pastedString);
                this.repaint();
                this.theSequence = this.theConversionCore.convertNucSequence(this);
                this.theSequencer.setSequence(this.theSequence);
                this.actualAAPosition = 0.0;
            }
            catch (Exception exception) {
                System.out.println(this.getClass() + "\tCannot set sequence to sequencer (" + exception + ")");
                this.repaint();
                return;
            }
            this.currentFile = new File("noname.mid");
            super.setTitle(this.currentFile.getName());
            this.setButtonsStartPlay();
            this.closeDnaFileMI.setEnabled(true);
            this.saveMidiFileMI.setEnabled(true);
            this.saveMidiFileAsMI.setEnabled(true);
            this.fileLoaded = true;
            this.setSequenceScroll();
            this.repaint();
        }
    }

    private void aboutMenuHandler(ActionEvent actionEvent) {
        this.aboutDialog.showAboutDialog();
    }

    private void tempoStateChangeHandler(ChangeEvent changeEvent) {
        long l = 0L;
        if (!this.playing) {
            TitledBorder titledBorder = (TitledBorder)this.tempoSlider.getBorder();
            titledBorder.setTitle("Tempo (BPM) = " + this.tempoSlider.getValue());
            this.theConversionCore.setTempoInBPM(this.tempoSlider.getValue());
            this.theSequencer.setTempoInBPM(this.theConversionCore.getTempoInBPM());
        }
    }

    private void lineActionPerformed(ActionEvent actionEvent) {
        switch (this.jComboBox1.getSelectedIndex()) {
            case 0: {
                this.tb.setTitle("Volume = " + this.theConversionCore.getTopLineVolume());
                break;
            }
            case 1: {
                this.tb.setTitle("Volume = " + this.theConversionCore.getBassLineVolume());
            }
        }
        this.tb = (TitledBorder)this.tempoSlider.getBorder();
        this.tb.setTitle("Tempo in BPM = " + (int)this.theConversionCore.getTempoInBPM());
        this.tempoSlider.setValue((int)this.theConversionCore.getTempoInBPM());
    }

    private void saveAsMidiFileHandler(ActionEvent actionEvent) {
        this.repaint();
        this.theSequence = this.theConversionCore.convertNucSequence(this);
        if (this.currentDirectory != null) {
            this.fileChooser.setCurrentDirectory(this.currentDirectory);
        }
        this.fileChooser.setSelectedFile(new File(this.currentFile.getName().substring(0, this.currentFile.getName().indexOf(46)) + ".mid"));
        if (this.fileChooser.showSaveDialog(this) == 0) {
            this.currentMidiFile = this.fileChooser.getSelectedFile();
            try {
                MidiSystem.write(this.theSequence, 1, this.currentMidiFile);
            }
            catch (Exception exception) {
                System.out.println(this.getClass() + "\tCould not write MIDI file (" + exception + ")");
            }
        }
        this.repaint();
    }

    private void saveMidiFileHandler(ActionEvent actionEvent) {
        this.repaint();
        this.theSequence = this.theConversionCore.convertNucSequence(this);
        this.currentMidiFile = new File(this.currentDirectory.getPath() + System.getProperty("file.separator") + this.currentFile.getName().substring(0, this.currentFile.getName().indexOf(46)) + ".mid");
        try {
            MidiSystem.write(this.theSequence, 1, this.currentMidiFile);
        }
        catch (Exception exception) {
            System.out.println(this.getClass() + "\tCould not write MIDI file (" + exception + ")");
        }
    }

    private void volumeStateChanged(ChangeEvent changeEvent) {
        long l = 0L;
        if (this.playing) {
            this.theSequencer.stop();
            l = this.theSequencer.getTickPosition();
        }
        switch (this.jComboBox1.getSelectedIndex()) {
            case 0: {
                this.tb.setTitle("Volume = " + this.theConversionCore.getTopLineVolume());
                break;
            }
            case 1: {
                this.tb.setTitle("Volume = " + this.theConversionCore.getBassLineVolume());
            }
        }
        if (this.fileLoaded) {
            this.theConversionCore.updateInstrumentSettings();
            try {
                this.theSequencer.setSequence(this.theSequence);
            }
            catch (Exception exception) {
                System.out.println(this.getClass() + "\n" + exception);
                System.out.println(this.getClass() + "\tCannot set sequence to sequencer (" + exception + ")");
                return;
            }
        }
        if (this.playing) {
            this.theConversionCore.setTempoInBPM(this.tempoSlider.getValue());
            this.theSequencer.setTempoInBPM(this.theConversionCore.getTempoInBPM());
            this.theSequencer.setTickPosition(l);
            this.theSequencer.start();
        }
    }

    private void TableMouseReleasedHandler(MouseEvent mouseEvent) {
        long l = 0L;
        boolean bl = this.theSequencer.isRunning();
        l = this.theSequencer.getTickPosition();
        if (bl) {
            this.instrumentChanged = true;
            this.theSequencer.close();
            try {
                this.theSequencer.open();
            }
            catch (Exception exception) {
                System.out.println(this.getClass() + "\tCannot open Sequencer Device (" + exception + ")");
                System.exit(1);
            }
        }
        switch (this.jComboBox1.getSelectedIndex()) {
            case 0: {
                this.theConversionCore.setTopLineInstrumentNumber(this.jTable1.getSelectedRow() + this.jTable1.getSelectedColumn() * 8);
                break;
            }
            case 1: {
                this.theConversionCore.setBassLineInstrumentNumber(this.jTable1.getSelectedRow() + this.jTable1.getSelectedColumn() * 8);
            }
        }
        if (this.fileLoaded) {
            this.theConversionCore.updateInstrumentSettings();
            try {
                this.theSequencer.setSequence(this.theSequence);
                this.theSequencer.setTickPosition(l);
                this.theSequencer.setTempoInBPM(this.theConversionCore.getTempoInBPM());
            }
            catch (Exception exception) {
                System.out.println(this.getClass() + "\tCannot set sequence to sequencer (" + exception + ")");
                return;
            }
        }
        if (bl) {
            this.theConversionCore.setTempoInBPM(this.tempoSlider.getValue());
            this.theSequencer.start();
            this.theSequencer.setTickPosition(l);
            this.theSequencer.setTempoInBPM(this.theConversionCore.getTempoInBPM());
        } else {
            this.theConversionCore.setTempoInBPM(this.tempoSlider.getValue());
            this.theSequencer.start();
            this.theSequencer.setTickPosition(l);
            this.theSequencer.setTempoInBPM(this.theConversionCore.getTempoInBPM());
            this.theSequencer.stop();
        }
    }

    private void JTable1MouseReleasedHandler(MouseEvent mouseEvent) {
    }

    private void Jtable1ProperyChangeHandler(PropertyChangeEvent propertyChangeEvent) {
    }

    private void stopActionHandler(ActionEvent actionEvent) {
        if (this.theSequencer != null && this.theSequence != null) {
            this.setButtonsStartPlay();
            this.theSequencer.setTempoInBPM(this.theConversionCore.getTempoInBPM());
            this.playing = false;
            this.theSequencer.stop();
        }
    }

    private void playActionHandler(ActionEvent actionEvent) {
        if (this.theSequencer != null && this.theSequence != null) {
            this.theSequencer.stop();
            this.theConversionCore.setTempoInBPM(this.tempoSlider.getValue());
            this.setButtonsPlaying();
            this.playing = true;
            this.theSequencer.start();
            this.theSequencer.setTempoInBPM(this.theConversionCore.getTempoInBPM());
        }
    }

    private void openDnaFileHandler(ActionEvent actionEvent) {
        int n = -1;
        if (this.currentDirectory == null) {
            this.currentDirectory = new File(System.getProperty("user.dir"));
        }
        this.fileChooser.setCurrentDirectory(this.currentDirectory);
        if (this.fileChooser.showOpenDialog(this) == 0) {
            this.currentDirectory = this.fileChooser.getCurrentDirectory();
            File file = this.fileChooser.getSelectedFile();
            this.repaint();
            this.theConversionCore.setNucSequence(this.theProteinMusicIO.getSequenceFromFile(file.getPath()));
            this.theConversionCore.setTempoInBPM(this.tempoSlider.getValue());
            this.theSequencer.setTempoInBPM(this.theConversionCore.getTempoInBPM());
            this.theSequence = this.theConversionCore.convertNucSequence(this);
            this.actualAAPosition = 0.0;
            try {
                this.theSequencer.setSequence(this.theSequence);
            }
            catch (Exception exception) {
                System.out.println(this.getClass() + "\tCannot set sequence to sequencer (" + exception + ")");
                return;
            }
            this.currentFile = this.fileChooser.getSelectedFile();
            super.setTitle(file.getName());
            this.playB.setEnabled(true);
            this.closeDnaFileMI.setEnabled(true);
            this.saveMidiFileMI.setEnabled(true);
            this.saveMidiFileAsMI.setEnabled(true);
            this.fileLoaded = true;
            this.setSequenceScroll();
        }
    }

    private void exitActionHandler(ActionEvent actionEvent) {
        this.theSequencer.close();
        System.exit(1);
    }

    private void exitForm(WindowEvent windowEvent) {
        this.theSequencer.close();
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        new ProteinMusic().setVisible(true);
    }

    @Override
    public void instrumentChange(int n) {
    }

    public JTextArea createSequenceTextArea() {
        Font font = null;
        String string = this.theConversionCore.getAminoAcidSequence();
        String string2 = this.theConversionCore.getNucSequence();
        Object object = "";
        for (int i = 0; i < string.length(); ++i) {
            object = (String)object + string.substring(i, i + 1) + "  ";
        }
        JTextArea jTextArea = new JTextArea(string2 + "\n" + (String)object + "\n");
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        for (int i = 0; i < fontArray.length; ++i) {
            String string3 = fontArray[i].getFontName().toUpperCase();
            if (string3.indexOf("MONOSPACED") <= -1 && !fontArray[i].getFontName().equalsIgnoreCase("BitstreamVeraSansMono-Bold")) continue;
            font = fontArray[i];
            break;
        }
        if (font != null) {
            jTextArea.setFont(font.deriveFont(14.0f));
            jTextArea.revalidate();
        } else {
            System.out.println(this.getClass() + "\tCould not find monospaced font.");
        }
        jTextArea.setEditable(false);
        return jTextArea;
    }

    public void setSequenceScroll() {
        this.sequenceTextArea = this.createSequenceTextArea();
        this.scrollStep = (int)this.sequenceTextArea.getPreferredSize().getWidth() / (this.theConversionCore.getNucSequence().length() * 2);
        this.sequenceScrollPane.setViewportView(this.sequenceTextArea);
        this.sequenceScrollPane.setVerticalScrollBarPolicy(21);
        this.sequenceScrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollJViewport = this.sequenceScrollPane.getViewport();
        this.scrollPosition = this.scrollJViewport.getViewPosition();
        this.scrollPosition.setLocation(0, 0);
        this.scrollJViewport.setViewPosition(this.scrollPosition);
        this.pack();
        this.sequenceScrollPane.repaint();
        this.repaint();
        this.scrollJViewport = this.sequenceScrollPane.getViewport();
        Action[] actionArray = this.sequenceTextArea.getActions();
    }

    private void changeSequencePosition(int n) {
        float f = 0.0f;
        long l = 0L;
        boolean bl = false;
        long l2 = 0L;
        int n2 = 0;
        long l3 = 0L;
        if (this.playing) {
            this.theSequencer.stop();
        }
        l = (long)(this.actualAAPosition * (double)this.theConversionCore.getNucTime() + (double)(this.theConversionCore.getNucTime() * 3));
        double d = this.actualAAPosition + (double)n;
        n2 = this.theConversionCore.getNucSequence().length();
        if (d <= (double)n2 && d > 0.0) {
            this.actualAAPosition += (double)n;
            this.positionChangeInTicks = l + (long)(n * this.theConversionCore.getNucTime());
            this.positionChange = true;
            this.scrollPosition.setLocation((double)((int)(d * (double)(this.scrollStep * 2))), this.scrollPosition.getY());
            this.scrollJViewport.setViewPosition(this.scrollPosition);
            this.sequenceScrollPane.repaint();
        } else {
            this.actualAAPosition = 0.0;
            this.positionChangeInTicks = 0L;
            this.positionChange = true;
            d = 0.0;
            this.scrollPosition.setLocation((double)((int)(d * (double)(this.scrollStep * 2))), this.scrollPosition.getY());
            this.scrollJViewport.setViewPosition(this.scrollPosition);
            this.sequenceScrollPane.repaint();
        }
        if (this.playing) {
            this.theConversionCore.setTempoInBPM(this.tempoSlider.getValue());
            this.theSequencer.start();
            this.theSequencer.setTempoInBPM(this.theConversionCore.getTempoInBPM());
        }
    }

    @Override
    public void meta(MetaMessage metaMessage) {
        this.actualAAPosition += 0.5;
        if (this.positionChange) {
            this.theSequencer.setTickPosition(this.positionChangeInTicks);
            this.theSequencer.setTempoInBPM(this.theConversionCore.getTempoInBPM());
            this.forwardB.setEnabled(true);
            this.rewindB.setEnabled(true);
        }
        this.scrollPosition.setLocation(this.scrollPosition.getX() + (double)this.scrollStep, (double)((int)this.scrollPosition.getY()));
        this.scrollJViewport.setViewPosition(this.scrollPosition);
        if (metaMessage.getType() == 2 && !this.instrumentChanged) {
            this.actualAAPosition = 0.0;
            this.theConversionCore.setTempoInBPM(this.tempoSlider.getValue());
            this.theSequencer.setTempoInBPM(this.theConversionCore.getTempoInBPM());
            this.playing = false;
            this.setSequenceScroll();
            this.setButtonsStartPlay();
        }
        this.sequenceScrollPane.repaint();
        this.instrumentChanged = false;
        this.positionChange = false;
        this.positionChangeInTicks = 0L;
    }

    private void setButtonsStartPlay() {
        this.playB.setEnabled(true);
        this.stopB.setEnabled(false);
        this.pauseB.setEnabled(false);
        this.rewindB.setEnabled(false);
        this.forwardB.setEnabled(false);
        this.tempoSlider.setValue((int)this.theConversionCore.getTempoInBPM());
        this.tempoSlider.setEnabled(true);
    }

    private void setButtonsPlaying() {
        this.playB.setEnabled(false);
        this.stopB.setEnabled(true);
        this.pauseB.setEnabled(true);
        this.rewindB.setEnabled(true);
        this.forwardB.setEnabled(true);
        this.tempoSlider.setEnabled(false);
    }

    private void setButtonsNone() {
        this.playB.setEnabled(false);
        this.stopB.setEnabled(false);
        this.pauseB.setEnabled(false);
        this.rewindB.setEnabled(false);
        this.forwardB.setEnabled(false);
        this.tempoSlider.setEnabled(true);
    }

    private void setButtonsTogglePause() {
        if (this.playing) {
            this.playB.setEnabled(false);
            this.stopB.setEnabled(false);
            this.pauseB.setEnabled(true);
            this.rewindB.setEnabled(false);
            this.forwardB.setEnabled(false);
            this.tempoSlider.setEnabled(true);
        } else {
            this.playB.setEnabled(false);
            this.stopB.setEnabled(true);
            this.pauseB.setEnabled(true);
            this.rewindB.setEnabled(true);
            this.forwardB.setEnabled(true);
            this.tempoSlider.setEnabled(false);
        }
    }

    public void centre() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)(dimension.getWidth() - this.getSize().getWidth()) / 2, (int)(dimension.getHeight() - this.getSize().getHeight()) / 2);
    }
}

