/*
 * Decompiled with CFR 0.152.
 */
public class Mapping
implements CodonConstants {
    private MusicalNote nucA;
    private MusicalNote nucT;
    private MusicalNote nucG;
    private MusicalNote nucC;
    private MusicalNote polar;
    private MusicalNote hydrophobic;
    private MusicalNote charged;
    private MusicalNote positive;
    private MusicalNote aliphatic;
    private MusicalNote aromatic;
    private OctaveChange tiny;
    private OctaveChange small;
    private OctaveChange large;
    private int generalCodonTime = 3000;
    public Codon[] codons;

    public void Mapping() {
    }

    public void init() {
        String[] stringArray = new String[6];
        long[] lArray = new long[6];
        int n = this.generalCodonTime / 6;
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        nArray[0] = this.generalCodonTime / 3;
        nArray[1] = nArray[0] / 2;
        nArray2[0] = 70;
        nArray2[1] = 100;
        lArray[0] = 0L;
        for (int i = 1; i < lArray.length; ++i) {
            lArray[i] = lArray[i - 1] + (long)n;
        }
        this.nucA = new MusicalNote("A5");
        this.nucT = new MusicalNote("E5");
        this.nucG = new MusicalNote("C5");
        this.nucC = new MusicalNote("G5");
        this.polar = new MusicalNote("A3");
        this.hydrophobic = new MusicalNote("C3");
        this.charged = new MusicalNote("F3");
        this.positive = new MusicalNote("E3");
        this.aliphatic = new MusicalNote("G3");
        this.aromatic = new MusicalNote("D3");
        this.tiny = new OctaveChange(2);
        this.small = new OctaveChange(1);
        this.large = new OctaveChange(1);
        this.codons = new Codon[21];
        stringArray[0] = "TTT";
        stringArray[1] = "TTC";
        stringArray[2] = "";
        stringArray[3] = "";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[0] = new Codon(stringArray, "f");
        this.codons[0].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.aromatic), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[0].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.hydrophobic), lArray[4], nArray[0], nArray2[1], nArray2[0]));
        this.codons[0].setSize(2);
        stringArray[0] = "TTA";
        stringArray[1] = "TTG";
        stringArray[2] = "CTT";
        stringArray[3] = "CTC";
        stringArray[4] = "CTA";
        stringArray[5] = "CTG";
        this.codons[1] = new Codon(stringArray, "l");
        this.codons[1].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.aliphatic), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[1].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.hydrophobic), lArray[4], nArray[0], nArray2[1], nArray2[0]));
        this.codons[1].setSize(2);
        stringArray[0] = "ATT";
        stringArray[1] = "ATC";
        stringArray[2] = "ATA";
        stringArray[3] = "";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[2] = new Codon(stringArray, "i");
        this.codons[2].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.hydrophobic), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[2].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.aliphatic), lArray[4], nArray[0], nArray2[1], nArray2[0]));
        this.codons[2].setSize(2);
        stringArray[0] = "ATG";
        stringArray[1] = "";
        stringArray[2] = "";
        stringArray[3] = "";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[3] = new Codon(stringArray, "m");
        this.codons[3].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.hydrophobic), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[3].setSize(2);
        stringArray[0] = "GTT";
        stringArray[1] = "GTC";
        stringArray[2] = "GTA";
        stringArray[3] = "GTG";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[4] = new Codon(stringArray, "v");
        this.codons[4].addAminoAcidTiming(new AminoAcidTimeAttributes(this.small.convertNote(this.hydrophobic), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[4].addAminoAcidTiming(new AminoAcidTimeAttributes(this.small.convertNote(this.aliphatic), lArray[4], nArray[0], nArray2[1], nArray2[0]));
        this.codons[4].setSize(1);
        stringArray[0] = "TCT";
        stringArray[1] = "TCC";
        stringArray[2] = "TCA";
        stringArray[3] = "TCG";
        stringArray[4] = "AGT";
        stringArray[5] = "AGC";
        this.codons[5] = new Codon(stringArray, "s");
        this.codons[5].addAminoAcidTiming(new AminoAcidTimeAttributes(this.tiny.convertNote(this.polar), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[5].setSize(0);
        stringArray[0] = "CCT";
        stringArray[1] = "CCC";
        stringArray[2] = "CCA";
        stringArray[3] = "CCG";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[6] = new Codon(stringArray, "p");
        this.codons[6].setSize(1);
        stringArray[0] = "ACT";
        stringArray[1] = "ACC";
        stringArray[2] = "ACA";
        stringArray[3] = "ACG";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[7] = new Codon(stringArray, "t");
        this.codons[7].addAminoAcidTiming(new AminoAcidTimeAttributes(this.small.convertNote(this.polar), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[7].addAminoAcidTiming(new AminoAcidTimeAttributes(this.small.convertNote(this.hydrophobic), lArray[4], nArray[0], nArray2[1], nArray2[0]));
        this.codons[7].setSize(1);
        stringArray[0] = "GCT";
        stringArray[1] = "GCC";
        stringArray[2] = "GCA";
        stringArray[3] = "GCG";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[8] = new Codon(stringArray, "a");
        this.codons[8].addAminoAcidTiming(new AminoAcidTimeAttributes(this.tiny.convertNote(this.hydrophobic), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[8].setSize(0);
        stringArray[0] = "TAT";
        stringArray[1] = "TAC";
        stringArray[2] = "";
        stringArray[3] = "";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[9] = new Codon(stringArray, "y");
        this.codons[9].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.aromatic), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[9].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.hydrophobic), lArray[2], nArray[0], nArray2[1], nArray2[0]));
        this.codons[9].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.polar), lArray[4], nArray[0], nArray2[1], nArray2[0]));
        this.codons[9].setSize(2);
        stringArray[0] = "TAA";
        stringArray[1] = "TAG";
        stringArray[2] = "TGA";
        stringArray[3] = "";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[10] = new Codon(stringArray, "z");
        this.codons[10].setSize(1);
        stringArray[0] = "CAT";
        stringArray[1] = "CAC";
        stringArray[2] = "";
        stringArray[3] = "";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[11] = new Codon(stringArray, "h");
        this.codons[11].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.positive), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[11].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.polar), lArray[2], nArray[1], nArray2[1], nArray2[0]));
        this.codons[11].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.hydrophobic), lArray[3], nArray[1], nArray2[1], nArray2[0]));
        this.codons[11].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.aromatic), lArray[4], nArray[1], nArray2[1], nArray2[0]));
        this.codons[11].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.charged), lArray[5], nArray[1], nArray2[1], nArray2[0]));
        this.codons[11].setSize(2);
        stringArray[0] = "CAA";
        stringArray[1] = "CAG";
        stringArray[2] = "";
        stringArray[3] = "";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[12] = new Codon(stringArray, "q");
        this.codons[12].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.polar), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[12].setSize(2);
        stringArray[0] = "AAT";
        stringArray[1] = "AAC";
        stringArray[2] = "";
        stringArray[3] = "";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[13] = new Codon(stringArray, "n");
        this.codons[13].addAminoAcidTiming(new AminoAcidTimeAttributes(this.small.convertNote(this.polar), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[13].setSize(1);
        stringArray[0] = "AAA";
        stringArray[1] = "AAG";
        stringArray[2] = "";
        stringArray[3] = "";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[14] = new Codon(stringArray, "k");
        this.codons[14].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.polar), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[14].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.hydrophobic), lArray[2], nArray[0], nArray2[1], nArray2[0]));
        this.codons[14].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.charged), lArray[3], nArray[1], nArray2[1], nArray2[0]));
        this.codons[14].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.positive), lArray[4], nArray[1], nArray2[1], nArray2[0]));
        this.codons[14].setSize(2);
        stringArray[0] = "GAT";
        stringArray[1] = "GAC";
        stringArray[2] = "";
        stringArray[3] = "";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[15] = new Codon(stringArray, "d");
        this.codons[15].addAminoAcidTiming(new AminoAcidTimeAttributes(this.small.convertNote(this.polar), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[15].addAminoAcidTiming(new AminoAcidTimeAttributes(this.small.convertNote(this.charged), lArray[4], nArray[0], nArray2[1], nArray2[0]));
        this.codons[15].setSize(1);
        stringArray[0] = "GAA";
        stringArray[1] = "GAG";
        stringArray[2] = "";
        stringArray[3] = "";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[16] = new Codon(stringArray, "e");
        this.codons[16].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.polar), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[16].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.charged), lArray[4], nArray[0], nArray2[1], nArray2[0]));
        this.codons[16].setSize(2);
        stringArray[0] = "TGT";
        stringArray[1] = "TGC";
        stringArray[2] = "";
        stringArray[3] = "";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[17] = new Codon(stringArray, "c");
        this.codons[17].addAminoAcidTiming(new AminoAcidTimeAttributes(this.small.convertNote(this.hydrophobic), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[17].setSize(1);
        stringArray[0] = "TGG";
        stringArray[1] = "";
        stringArray[2] = "";
        stringArray[3] = "";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[18] = new Codon(stringArray, "w");
        this.codons[18].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.aromatic), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[18].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.hydrophobic), lArray[2], nArray[0], nArray2[1], nArray2[0]));
        this.codons[18].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.polar), lArray[4], nArray[0], nArray2[1], nArray2[0]));
        this.codons[18].setSize(2);
        stringArray[0] = "CGT";
        stringArray[1] = "CGC";
        stringArray[2] = "CGA";
        stringArray[3] = "CGG";
        stringArray[4] = "AGA";
        stringArray[5] = "AGG";
        this.codons[19] = new Codon(stringArray, "r");
        this.codons[19].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.polar), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[19].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.positive), lArray[2], nArray[0], nArray2[1], nArray2[0]));
        this.codons[19].addAminoAcidTiming(new AminoAcidTimeAttributes(this.large.convertNote(this.charged), lArray[4], nArray[0], nArray2[1], nArray2[0]));
        this.codons[19].setSize(2);
        stringArray[0] = "GGT";
        stringArray[1] = "GGC";
        stringArray[2] = "GGA";
        stringArray[3] = "GGG";
        stringArray[4] = "";
        stringArray[5] = "";
        this.codons[20] = new Codon(stringArray, "g");
        this.codons[20].addAminoAcidTiming(new AminoAcidTimeAttributes(this.tiny.convertNote(this.hydrophobic), lArray[0], nArray[0], nArray2[0], nArray2[0]));
        this.codons[20].setSize(0);
    }

    public void setNucMapping(String string, MusicalNote musicalNote) {
        if (string.equalsIgnoreCase("a")) {
            this.nucA = musicalNote;
        } else if (string.equalsIgnoreCase("t")) {
            this.nucT = musicalNote;
        } else if (string.equalsIgnoreCase("g")) {
            this.nucG = musicalNote;
        } else if (string.equalsIgnoreCase("c")) {
            this.nucC = musicalNote;
        }
    }

    public MusicalNote getNucMapping(String string) {
        MusicalNote musicalNote = null;
        if (string.equalsIgnoreCase("a")) {
            musicalNote = this.nucA;
        } else if (string.equalsIgnoreCase("t")) {
            musicalNote = this.nucT;
        } else if (string.equalsIgnoreCase("g")) {
            musicalNote = this.nucG;
        } else if (string.equalsIgnoreCase("c")) {
            musicalNote = this.nucC;
        } else {
            System.out.println("The Nucleotide does not exist : " + string);
        }
        return musicalNote;
    }

    public MusicalNote getNucMapping(String string, String string2) {
        MusicalNote musicalNote = this.getNucMapping(string);
        MusicalNote musicalNote2 = null;
        if (this.getCodonMappingFor(string2).getSize() == 0) {
            musicalNote2 = this.tiny.convertNote(musicalNote);
        } else if (this.getCodonMappingFor(string2).getSize() == 1) {
            musicalNote2 = this.small.convertNote(musicalNote);
        } else if (this.getCodonMappingFor(string2).getSize() == 2) {
            musicalNote2 = this.large.convertNote(musicalNote);
        }
        return musicalNote2;
    }

    public Codon getCodonMappingFor(String string) {
        Codon codon = null;
        for (int i = 0; i < 21; ++i) {
            if (!this.codons[i].isCoding(string)) continue;
            codon = this.codons[i];
            i = 22;
        }
        return codon;
    }

    public int getGeneralCodonTime() {
        return this.generalCodonTime;
    }

    public void setGeneralCodonTime(int n) {
        this.generalCodonTime = n;
    }
}

