/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.io.Serializable;
import javax.sound.midi.Instrument;
import javax.sound.midi.Synthesizer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class InstrumentTable
extends JPanel
implements Serializable {
    private Synthesizer synthesizer;
    private Instrument[] instruments;
    private Instrument instrument;
    private JTable table;
    private int row;
    private int col = 0;
    private String[] names = new String[]{"Piano", "Chromatic Perc.", "Organ", "Guitar", "Bass", "Strings", "Ensemble", "Brass", "Reed", "Pipe", "Synth Lead", "Synth Pad", "Synth Effects", "Ethnic", "Percussive", "Sound Effects"};
    private int nRows = 8;
    private int nCols = this.names.length;
    private int instrumentNumber;

    public InstrumentTable() {
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return InstrumentTable.this.nCols;
            }

            @Override
            public int getRowCount() {
                return InstrumentTable.this.nRows;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (InstrumentTable.this.instruments != null) {
                    return InstrumentTable.this.instruments[n2 * InstrumentTable.this.nRows + n].getName();
                }
                return Integer.toString(n2 * InstrumentTable.this.nRows + n);
            }

            @Override
            public String getColumnName(int n) {
                return InstrumentTable.this.names[n];
            }

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
            }
        };
        this.table = new JTable(abstractTableModel);
        this.table.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    InstrumentTable.this.row = listSelectionModel.getMinSelectionIndex();
                }
                InstrumentTable.this.programChange(InstrumentTable.this.col * InstrumentTable.this.nRows + InstrumentTable.this.row);
            }
        });
        listSelectionModel = this.table.getColumnModel().getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    InstrumentTable.this.col = listSelectionModel.getMinSelectionIndex();
                }
                InstrumentTable.this.programChange(InstrumentTable.this.col * InstrumentTable.this.nRows + InstrumentTable.this.row);
            }
        });
        this.table.setPreferredScrollableViewportSize(new Dimension(this.nCols * 550, 200));
        this.table.setCellSelectionEnabled(true);
        this.table.setColumnSelectionAllowed(true);
        for (int i = 0; i < this.names.length; ++i) {
            TableColumn tableColumn = this.table.getColumn(this.names[i]);
            tableColumn.setPreferredWidth(110);
        }
        this.table.setAutoResizeMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        this.add(jScrollPane);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.names.length * 110, 170);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(32000, 180);
    }

    private void programChange(int n) {
        if (this.instruments != null) {
            this.instrument = this.instruments[n];
        }
        System.out.println(n);
    }

    public int getInstrumentNumber() {
        return this.instrumentNumber;
    }

    public void setInstrumentNumber(int n) {
        this.instrumentNumber = n;
    }

    public void setSynthesizer(Synthesizer synthesizer) {
        if (this.synthesizer != null) {
            this.synthesizer = synthesizer;
            this.instruments = this.synthesizer.getDefaultSoundbank().getInstruments();
            this.repaint();
        }
    }
}

