/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class ConversionCore {
    private String inComingSequence = "DNA";
    private String aminoAcidSequence = "A";
    private Mapping mapping;
    public Codon[] codonSequence;
    private int nucSeqLength = 0;
    private static float defaultTempoInBPM = 120.0f;
    private static int defaultTempoInPPQ = 1500;
    private static float defaultFactorPPQToBPM = 12.5f;
    private float tempoInBPM = defaultTempoInBPM;
    private int tempoInPPQ = defaultTempoInPPQ;
    private Track topLineTrack;
    private Track bassLineTrack;
    private Track[] allTracks;
    private MidiEvent topLineInstrumentMidi;
    private MidiEvent bassLineInstrumentMidi;
    private MidiEvent topLineReverbMidi;
    private MidiEvent bassLineReverbMidi;
    private MidiEvent topLinePitchMidi;
    private MidiEvent bassLinePitchMidi;
    private MidiEvent topLinePressureMidi;
    private MidiEvent bassLinePressureMidi;
    private MidiEvent topLineVolumeMidi;
    private MidiEvent bassLineVolumeMidi;
    private Sequence theSequence;
    private int topLineInstrumentNumber = 0;
    private int bassLineInstrumentNumber = 0;
    private int topLineReverb = 64;
    private int bassLineReverb = 64;
    private int topLinePitch = 64;
    private int bassLinePitch = 64;
    private int topLinePressure = 64;
    private int bassLinePressure = 64;
    private int topLineVolume = 128;
    private int bassLineVolume = 255;

    public void ConversionCore() {
    }

    public void init() {
        this.mapping = new Mapping();
        this.mapping.init();
    }

    public void setNucSequence(String string) {
        this.nucSeqLength = string.length();
        this.inComingSequence = new String(string.substring(0, this.nucSeqLength / 3 * 3));
        this.codonSequence = new Codon[this.inComingSequence.length() / 3];
        this.aminoAcidSequence = new String();
    }

    public String getNucSequence() {
        return this.inComingSequence;
    }

    public String getAminoAcidSequence() {
        return this.aminoAcidSequence;
    }

    public int getNucSequenceLength() {
        return this.nucSeqLength;
    }

    public void setTopLineInstrumentNumber(int n) {
        this.topLineInstrumentNumber = n;
    }

    public int getTopLineInstrumentNumber() {
        return this.topLineInstrumentNumber;
    }

    public void setBassLineInstrumentNumber(int n) {
        this.bassLineInstrumentNumber = n;
    }

    public int getBassLineInstrumentNumber() {
        return this.bassLineInstrumentNumber;
    }

    public void setTopLinePressure(int n) {
        this.topLinePressure = n;
    }

    public int getTopLinePressure() {
        return this.topLinePressure;
    }

    public void setTopLinePitch(int n) {
        this.topLinePitch = n;
    }

    public int getTopLinePitch() {
        return this.topLinePitch;
    }

    public void setTopLineReverb(int n) {
        this.topLineReverb = n;
    }

    public int getTopLineReverb() {
        return this.topLineReverb;
    }

    public void setTopLineVolume(int n) {
        this.topLineVolume = n;
    }

    public int getTopLineVolume() {
        return this.topLineVolume;
    }

    public void setBassLinePressure(int n) {
        this.bassLinePressure = n;
    }

    public int getBassLinePressure() {
        return this.bassLinePressure;
    }

    public void setBassLinePitch(int n) {
        this.bassLinePitch = n;
    }

    public int getBassLinePitch() {
        return this.bassLinePitch;
    }

    public void setBassLineReverb(int n) {
        this.bassLineReverb = n;
    }

    public int getBassLineReverb() {
        return this.bassLineReverb;
    }

    public void setBassLineVolume(int n) {
        this.bassLineVolume = n;
    }

    public int getBassLineVolume() {
        return this.bassLineVolume;
    }

    public MidiEvent createShortMidiEvent(int n, int n2, int n3, int n4, long l) {
        MidiEvent midiEvent;
        int n5 = 255;
        int n6 = n3 + n4;
        int n7 = n6 & n5;
        int n8 = (n6 - n7) / (n5 + 1);
        n8 = n3 / (n5 + 1);
        n7 = n4;
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(n, n2, n3, n4);
            midiEvent = new MidiEvent(shortMessage, l);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
        return midiEvent;
    }

    public MidiEvent createShortMidiEvent(int n, int n2, int n3, long l) {
        MidiEvent midiEvent;
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(n, n2, n3);
            midiEvent = new MidiEvent(shortMessage, l);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
        return midiEvent;
    }

    public MidiEvent createMetaMidiEvent(int n, String string, long l) {
        MidiEvent midiEvent;
        try {
            MetaMessage metaMessage = new MetaMessage();
            metaMessage.setMessage(n, string.getBytes(), string.length());
            midiEvent = new MidiEvent(metaMessage, l);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
        return midiEvent;
    }

    public int getTempoInPPQ() {
        return this.tempoInPPQ;
    }

    public void setTempoInPPQ(int n) {
        this.tempoInPPQ = n;
        this.tempoInBPM = (float)this.tempoInPPQ / defaultFactorPPQToBPM;
    }

    public float getTempoInBPM() {
        return this.tempoInBPM;
    }

    public void setDefaultTempo() {
        this.tempoInBPM = defaultTempoInBPM;
        this.tempoInPPQ = defaultTempoInPPQ;
    }

    public void setTempoInBPM(float f) {
        this.tempoInBPM = f;
        this.tempoInPPQ = (int)(this.tempoInBPM * defaultFactorPPQToBPM);
    }

    public void changeInstruments() {
        Track[] trackArray = this.theSequence.getTracks();
        Track track = trackArray[2];
        track.remove(this.topLineInstrumentMidi);
        track.remove(this.bassLineInstrumentMidi);
        this.topLineInstrumentMidi = this.createShortMidiEvent(194, 2, this.getTopLineInstrumentNumber(), 0, 1000L);
        track.add(this.topLineInstrumentMidi);
        this.bassLineInstrumentMidi = this.createShortMidiEvent(193, 1, this.getBassLineInstrumentNumber(), 0, 1000L);
        track.add(this.bassLineInstrumentMidi);
    }

    public void updateInstrumentSettings() {
        Track[] trackArray = this.theSequence.getTracks();
        Track track = trackArray[2];
        track.remove(this.topLineInstrumentMidi);
        track.remove(this.bassLineInstrumentMidi);
        this.topLineInstrumentMidi = this.createShortMidiEvent(194, 2, this.getTopLineInstrumentNumber(), 0, 1000L);
        track.add(this.topLineInstrumentMidi);
        this.topLinePressureMidi = this.createShortMidiEvent(208, 2, this.getTopLinePressure(), 0, 1000L);
        track.add(this.topLinePressureMidi);
        this.topLinePitchMidi = this.createShortMidiEvent(224, 2, this.getTopLinePitch(), 0, 1000L);
        track.add(this.topLinePitchMidi);
        this.bassLineInstrumentMidi = this.createShortMidiEvent(193, 1, this.getBassLineInstrumentNumber(), 0, 1000L);
        track.add(this.bassLineInstrumentMidi);
        this.bassLinePressureMidi = this.createShortMidiEvent(208, 2, this.getBassLinePressure(), 0, 1000L);
        track.add(this.bassLinePressureMidi);
        this.bassLinePitchMidi = this.createShortMidiEvent(224, 2, this.getBassLinePitch(), 0, 1000L);
        track.add(this.bassLinePitchMidi);
    }

    public int getCodonTime() {
        return this.mapping.getGeneralCodonTime();
    }

    public int getNucTime() {
        return this.mapping.getGeneralCodonTime() / 3;
    }

    public Sequence convertNucSequence(Frame frame) {
        long l;
        Sequence sequence = null;
        Object var14_3 = null;
        Object var15_4 = null;
        Object var16_5 = null;
        int n = 0;
        String string = "";
        String string2 = "";
        int n2 = this.mapping.getGeneralCodonTime();
        long l2 = l = (long)n2;
        int n3 = n2 / 3;
        int n4 = Double.valueOf((double)n3 * 0.9).intValue();
        if (!this.inComingSequence.equals("")) {
            try {
                this.theSequence = sequence = new Sequence(0.0f, defaultTempoInPPQ);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                System.out.println("O o " + invalidMidiDataException);
            }
            sequence.createTrack();
            sequence.createTrack();
            sequence.createTrack();
            this.allTracks = sequence.getTracks();
            Track track = this.allTracks[0];
            Track track2 = this.allTracks[1];
            Track track3 = this.allTracks[2];
            this.aminoAcidSequence = "";
            n = this.inComingSequence.length();
            if (n % 3 != 0) {
                System.out.println("The Sequence length is " + n + " and divided by three is " + n / 3);
            } else {
                this.updateInstrumentSettings();
                for (int i = 0; i < this.inComingSequence.length() / 3; ++i) {
                    string = this.inComingSequence.substring(i * 3, (i + 1) * 3);
                    this.codonSequence[i] = this.mapping.getCodonMappingFor(string);
                    MusicalNote musicalNote = this.mapping.getNucMapping(this.inComingSequence.substring(i * 3, i * 3 + 1), string);
                    MusicalNote musicalNote2 = this.mapping.getNucMapping(this.inComingSequence.substring(i * 3 + 1, i * 3 + 2), string);
                    MusicalNote musicalNote3 = this.mapping.getNucMapping(this.inComingSequence.substring(i * 3 + 2, i * 3 + 3), string);
                    track.add(this.createShortMidiEvent(144, 2, musicalNote.getIntegerRepresentation(), 100, l2 + (long)(n3 * 0)));
                    track.add(this.createShortMidiEvent(144, 2, musicalNote2.getIntegerRepresentation(), 70, l2 + (long)(n3 * 1)));
                    track.add(this.createShortMidiEvent(144, 2, musicalNote3.getIntegerRepresentation(), 70, l2 + (long)(n3 * 2)));
                    track.add(this.createShortMidiEvent(128, 2, musicalNote.getIntegerRepresentation(), 100, l2 + (long)(n3 * 0 + n4)));
                    track.add(this.createShortMidiEvent(128, 2, musicalNote2.getIntegerRepresentation(), 100, l2 + (long)(n3 * 1) + (long)n4));
                    track.add(this.createShortMidiEvent(128, 2, musicalNote3.getIntegerRepresentation(), 100, l2 + (long)(n3 * 2) + (long)n4));
                    track.add(this.createMetaMidiEvent(1, "", l2 + (long)(n3 * 0)));
                    track.add(this.createMetaMidiEvent(1, "", l2 + (long)(n3 * 1)));
                    track.add(this.createMetaMidiEvent(1, "", l2 + (long)(n3 * 2)));
                    track.add(this.createMetaMidiEvent(1, "", l2 + (long)(n3 / 2 * 1)));
                    track.add(this.createMetaMidiEvent(1, "", l2 + (long)(n3 / 2 * 3)));
                    track.add(this.createMetaMidiEvent(1, "", l2 + (long)(n3 / 2 * 5)));
                    for (int j = 0; j < this.codonSequence[i].getNumberOfAminoAcidTimings(); ++j) {
                        AminoAcidTimeAttributes aminoAcidTimeAttributes = this.codonSequence[i].getAminoAcidTiming(j);
                        track2.add(this.createShortMidiEvent(144, 1, aminoAcidTimeAttributes.getAttribute().getIntegerRepresentation(), aminoAcidTimeAttributes.getVelocityOnTime(), l2 + aminoAcidTimeAttributes.getPlayTime()));
                        track2.add(this.createShortMidiEvent(128, 1, aminoAcidTimeAttributes.getAttribute().getIntegerRepresentation(), aminoAcidTimeAttributes.getVelocityOffTime(), l2 + aminoAcidTimeAttributes.getPlayTime() + (long)aminoAcidTimeAttributes.getDurationTime()));
                    }
                    l2 += (long)n2;
                    this.aminoAcidSequence = this.aminoAcidSequence + this.codonSequence[i].getAminoAcid();
                }
                track.add(this.createMetaMidiEvent(1, "next", l2));
            }
            track.add(this.createMetaMidiEvent(2, "end", l2));
        }
        return sequence;
    }

    public static void main(String[] stringArray) throws Exception {
    }
}

