/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Codon
implements CodonConstants {
    public String[] codingCodons = new String[6];
    public String aminoAcid = "";
    private int size = -1;
    private Vector aminoAcidTimings;

    public Codon() {
        this.aminoAcidTimings = new Vector();
    }

    public Codon(String[] stringArray, String string) {
        this.setCodons(stringArray);
        this.setAminoAcid(string);
        this.aminoAcidTimings = new Vector();
    }

    public void setCodons(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.codingCodons[i] = new String(stringArray[i]);
        }
    }

    public String[] getCodons() {
        return this.codingCodons;
    }

    public void setAminoAcid(String string) {
        this.aminoAcid = new String(string);
    }

    public String getAminoAcid() {
        return this.aminoAcid;
    }

    public void addAminoAcidTiming(AminoAcidTimeAttributes aminoAcidTimeAttributes) {
        this.aminoAcidTimings.add(aminoAcidTimeAttributes);
    }

    public AminoAcidTimeAttributes getAminoAcidTiming(int n) {
        AminoAcidTimeAttributes aminoAcidTimeAttributes;
        try {
            aminoAcidTimeAttributes = (AminoAcidTimeAttributes)this.aminoAcidTimings.get(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            aminoAcidTimeAttributes = null;
        }
        return aminoAcidTimeAttributes;
    }

    public int getNumberOfAminoAcidTimings() {
        return this.aminoAcidTimings.size();
    }

    public void setSize(int n) {
        if (n >= 0 || n <= 2) {
            this.size = n;
        }
    }

    public int getSize() {
        return this.size;
    }

    public boolean isCoding(String string) {
        for (int i = 0; i < this.codingCodons.length; ++i) {
            if (!this.codingCodons[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        Object object = "";
        object = (String)object + this.getAminoAcid() + "\t";
        for (int i = 0; i < this.codingCodons.length; ++i) {
            if (this.codingCodons[i].equals("")) continue;
            object = (String)object + this.codingCodons + "\t";
        }
        object = (String)object + "\n";
        return object;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"TTT", "GGG"};
        Codon codon = new Codon(stringArray2, "p");
        System.out.println(codon.getAminoAcid());
    }
}

