/*
 * ProteinMusic.java
 *
 * Created on 16 May 2000, 18:44
 */

import javax.sound.midi.*;

import java.awt.event.*;
import java.awt.*;
        
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.text.*;
import javax.swing.table.*;

import java.io.*;

/** 
 *
 * @author  aak97
 * @version 
 */
public class ProteinMusic extends javax.swing.JFrame implements InstrumentTableUserInterface, MetaEventListener {

  private Sequence          theSequence;
  private Sequencer         theSequencer;
  private Synthesizer       theSynthesizer;
  private ConversionCore    theConversionCore;
  private ProteinMusicIO    theProteinMusicIO;

  private String            theSequenceString = "";

  private Instrument[]      theInstruments;
  private String            instrumentNames[] =
  {
    "Piano", "Chromatic Perc.", "Organ", "Guitar",
    "Bass", "Strings", "Ensemble", "Brass",
    "Reed", "Pipe", "Synth Lead", "Synth Pad",
    "Synth Effects", "Ethnic", "Percussive", "Sound Effects"
  };
  private int               instrumentTableRows = 8;
  private int               instrumentTableCols = instrumentNames.length;

  private AboutDialog  aboutDialog = new AboutDialog(this,true);
  private PasteDialog  pasteDialog = new PasteDialog(this,true);
  public  String       pastedString;
  
  
  private JFileChooser      fileChooser;
  private File              currentDirectory = null;
  private File              currentFile      = null;
  private File              currentMidiFile  = null;

  private boolean           fileLoaded       = false;
  private boolean           playing          = false;
  
  private InstrumentTable   instrumentTable  = null;

  private TitledBorder tb;
  
  private int               scrollPaneXPosition = 0;
  private int               scrollPaneYPosition = 0;
  private int               scrollPaneCounter   = 0;
  private JTextArea         sequenceTextArea;  
  private int               scrollStep          = 10;
  private Point             scrollPosition;
  private JViewport         scrollJViewport;
  
  private boolean           instrumentChanged     = false;
  private int               instrumentChangedCount= 0;
  private long              positionChangeInTicks = 0;
  private boolean           positionChange        = false;
  private double 	    actualAAPosition     =  0.0;


  /** Creates new form ProteinMusic */
  public ProteinMusic() 
  {
    theConversionCore = new ConversionCore();
    theConversionCore.init();
    fileChooser = new JFileChooser();
    theProteinMusicIO = new ProteinMusicIO();
    initComponents ();
    pack ();

    try
    {
      theSynthesizer = MidiSystem.getSynthesizer();
    }
    catch(Exception e)
    {
      System.out.println(this.getClass()+"\tSynthesizer Device not supported ("+e+")");
      System.exit(1);
    }
    try
    {
      theSynthesizer.open();
    }
    catch(Exception e)
    {
      System.out.println(this.getClass()+"\tCannot open Synthesizer Device ("+e+")");
      System.exit(1);
    }
  //  instrumentTable1.setSynthesizer(theSynthesizer);
    try
    {
      theSequencer = MidiSystem.getSequencer();
    }
    catch(Exception e)
    {
      System.out.println(this.getClass()+"\tSequencer Device not supported"+e+")");
      System.exit(1);
    }
    try
    {
      theSequencer.open();
    }
    catch(Exception e)
    {
      System.out.println(this.getClass()+"Cannot open Sequencer Device");
      System.exit(1);
    }
    if(!theSequencer.addMetaEventListener(this))
    {
        System.out.println(this.getClass()+"\tCould not register MetaEventListener - there will be problems with scrolling! ");
    }
    if(theSynthesizer.getDefaultSoundbank()!=null)
    {
        theInstruments = theSynthesizer.getDefaultSoundbank().getInstruments();
    }
    else
    {
        System.out.println(this.getClass()+"\tCould not find default soundbank - no instruments will be  visable/available!");
    }

    sequenceTextArea = this.createSequenceTextArea();
    sequenceScrollPane.setViewportView(sequenceTextArea);
	
	centre();

  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents () {//GEN-BEGIN:initComponents
    menuBar = new javax.swing.JMenuBar ();
    fileMenu = new javax.swing.JMenu ();
    openDnaFileMI = new javax.swing.JMenuItem ();
    closeDnaFileMI = new javax.swing.JMenuItem ();
    jSeparator1 = new javax.swing.JSeparator ();
    saveMidiFileMI = new javax.swing.JMenuItem ();
    saveMidiFileAsMI = new javax.swing.JMenuItem ();
    jSeparator2 = new javax.swing.JSeparator ();
    exitMI = new javax.swing.JMenuItem ();
    sequenceMenu = new javax.swing.JMenu ();
    pasteMenuItem = new javax.swing.JMenuItem ();
    jSeparator3 = new javax.swing.JSeparator ();
    primaryMappingMenuItem = new javax.swing.JMenuItem ();
    secondaryMappingItem = new javax.swing.JMenuItem ();
    helpMenu = new javax.swing.JMenu ();
    aboutMenuItem = new javax.swing.JMenuItem ();
    jPanel3 = new javax.swing.JPanel ();
    jComboBox1 = new javax.swing.JComboBox ();
    jScrollPane4 = new javax.swing.JScrollPane ();
    jTable1 = new javax.swing.JTable ();
    jPanel1 = new javax.swing.JPanel ();
    rewindB = new javax.swing.JButton ();
    playB = new javax.swing.JButton ();
    pauseB = new javax.swing.JButton ();
    stopB = new javax.swing.JButton ();
    forwardB = new javax.swing.JButton ();
    jPanel4 = new javax.swing.JPanel ();
    tempoSlider = new javax.swing.JSlider ();
    sequenceScrollPane = new javax.swing.JScrollPane ();

      fileMenu.setText ("File");
  
        openDnaFileMI.setToolTipText ("Open a FASTA, GenBank, or EMBL DNA File ");
        openDnaFileMI.setText ("Open Project");
        openDnaFileMI.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
            openDnaFileHandler (evt);
          }
        }
        );
    
        fileMenu.add (openDnaFileMI);
        closeDnaFileMI.setToolTipText ("Close current project");
        closeDnaFileMI.setText ("Close Project");
        closeDnaFileMI.setEnabled (false);
        closeDnaFileMI.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
            closeDnaFileHandler (evt);
          }
        }
        );
    
        fileMenu.add (closeDnaFileMI);
    
        fileMenu.add (jSeparator1);
        saveMidiFileMI.setToolTipText ("Save the generated MIDI file in current directory and under the same name");
        saveMidiFileMI.setText ("Save MIDI File");
        saveMidiFileMI.setEnabled (false);
        saveMidiFileMI.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
            saveMidiFileHandler (evt);
            saveMidiFileHandler (evt);
          }
        }
        );
    
        fileMenu.add (saveMidiFileMI);
        saveMidiFileAsMI.setToolTipText ("Save generated MIDI file under any name in any directory");
        saveMidiFileAsMI.setText ("Save MIDI File As");
        saveMidiFileAsMI.setEnabled (false);
        saveMidiFileAsMI.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
            saveAsMidiFileHandler (evt);
          }
        }
        );
    
        fileMenu.add (saveMidiFileAsMI);
    
        fileMenu.add (jSeparator2);
        exitMI.setToolTipText ("Exit the program");
        exitMI.setActionCommand ("exit");
        exitMI.setText ("Exit");
        exitMI.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
            exitActionHandler (evt);
          }
        }
        );
    
        fileMenu.add (exitMI);
      menuBar.add (fileMenu);
      sequenceMenu.setName ("Sequence and Mapping");
      sequenceMenu.setText ("Edit");
  
        pasteMenuItem.setToolTipText ("Paste a DNA sequence into a text window for generating a MIDI sequence");
        pasteMenuItem.setText ("Paste Sequence");
        pasteMenuItem.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
            pasteMenuHandler (evt);
          }
        }
        );
    
        sequenceMenu.add (pasteMenuItem);
    
        sequenceMenu.add (jSeparator3);
        primaryMappingMenuItem.setToolTipText ("Adjust primary musical mapping for the conversion");
        primaryMappingMenuItem.setText ("Set Primary Mapping");
        primaryMappingMenuItem.setEnabled (false);
    
        sequenceMenu.add (primaryMappingMenuItem);
        secondaryMappingItem.setToolTipText ("Adjust the order of amino acid characteristic for the conversion");
        secondaryMappingItem.setText ("Set Secondary Mapping");
        secondaryMappingItem.setEnabled (false);
    
        sequenceMenu.add (secondaryMappingItem);
      menuBar.add (sequenceMenu);
      helpMenu.setText ("Help");
      helpMenu.setEnabled (true);
  
        aboutMenuItem.setToolTipText ("About this program");
        aboutMenuItem.setText ("About");
        aboutMenuItem.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
            aboutMenuHandler (evt);
          }
        }
        );
    
        helpMenu.add (aboutMenuItem);
      menuBar.add (helpMenu);
    addWindowListener (new java.awt.event.WindowAdapter () {
      public void windowClosing (java.awt.event.WindowEvent evt) {
        exitForm (evt);
      }
    }
    );

    jPanel3.setLayout (new java.awt.BorderLayout ());
    jPanel3.setBorder (new javax.swing.border.TitledBorder("Instrument Selection"));

      jComboBox1.setMaximumRowCount (2);
      jComboBox1.setMaximumSize (new java.awt.Dimension(130, 25));
      jComboBox1.addItem((Object) new String("Top Line"));
      jComboBox1.addItem((Object) new String("Bass Line"));
  
      jComboBox1.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          lineActionPerformed (evt);
        }
      }
      );
  
      jPanel3.add (jComboBox1, java.awt.BorderLayout.NORTH);
  
      jScrollPane4.setMinimumSize (new java.awt.Dimension(120, 180));
      jScrollPane4.setMaximumSize (new java.awt.Dimension(2000, 180));
  
        jTable1.setDoubleBuffered (true);
        jTable1.setCellEditor (jTable1.getCellEditor ());
        jTable1.setCellSelectionEnabled (true);
        jTable1.setModel (new AbstractTableModel()
        {
          public Object getValueAt(int r, int c)
          {
            if(theInstruments != null)
            {
              return theInstruments[c*instrumentTableRows+r].getName();
            }
            else
            {
              return Integer.toString(c*instrumentTableRows+r);
            }
          }
          public int getColumnCount()
          {
            return instrumentTableCols;
          }
          public int getRowCount()
          {
            return instrumentTableRows;
          }
          public String getColumnName(int c)
          {
            return instrumentNames[c];
          }
          public Class getColumnClass(int c)
          {
            return getValueAt(0, c).getClass();
          }
          public boolean isCellEditable(int r, int c)
          {
            return false;
          }
          public void setValueAt(Object obj, int r, int c)
          {
          }
        });
        jTable1.setPreferredScrollableViewportSize (new java.awt.Dimension(450, 150));
        for (int i = 0; i < instrumentNames.length; i++)
        {
          TableColumn column = jTable1.getColumn(instrumentNames[i]);
          column.setPreferredWidth(110);
        }
        jTable1.setAutoResizeMode(jTable1.AUTO_RESIZE_OFF);
        jTable1.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        jTable1.addMouseListener (new java.awt.event.MouseAdapter () {
          public void mouseReleased (java.awt.event.MouseEvent evt) {
            TableMouseReleasedHandler (evt);
          }
        }
        );
    
        jScrollPane4.setViewportView (jTable1);
    
      jPanel3.add (jScrollPane4, java.awt.BorderLayout.CENTER);
  

    getContentPane ().add (jPanel3, java.awt.BorderLayout.NORTH);

    jPanel1.setLayout (new java.awt.FlowLayout (1, 10, 10));

      rewindB.setIcon (new javax.swing.ImageIcon ("reverse.gif"));
      rewindB.setActionCommand ("stop");
      rewindB.setText ("Rewind");
      rewindB.setEnabled (false);
      rewindB.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          rewindActionHandler (evt);
        }
      }
      );
  
      jPanel1.add (rewindB);
  
      playB.setIcon (new javax.swing.ImageIcon ("play.gif"));
      playB.setActionCommand ("play");
      playB.setText ("Play");
      playB.setEnabled (false);
      playB.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          playActionHandler (evt);
        }
      }
      );
  
      jPanel1.add (playB);
  
      pauseB.setIcon (new javax.swing.ImageIcon ("pause.gif"));
      pauseB.setActionCommand ("stop");
      pauseB.setText ("Pause");
      pauseB.setEnabled (false);
      pauseB.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          pauseActionHandler (evt);
        }
      }
      );

      jPanel1.add (pauseB);
  
      stopB.setIcon (new javax.swing.ImageIcon ("stop.gif"));
      stopB.setActionCommand ("stop");
      stopB.setText ("Stop");
      stopB.setEnabled (false);
      stopB.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          stopActionHandler (evt);
        }
      }
      );
  
      jPanel1.add (stopB);
  
      forwardB.setIcon (new javax.swing.ImageIcon ("forward.gif"));
      forwardB.setActionCommand ("stop");
      forwardB.setText ("Forward");
      forwardB.setEnabled (false);
      forwardB.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          forwardActionHandler (evt);
        }
      }
      );
  
      jPanel1.add (forwardB);
  

    getContentPane ().add (jPanel1, java.awt.BorderLayout.SOUTH);

    jPanel4.setLayout (new java.awt.BorderLayout ());
    jPanel4.setPreferredSize (new java.awt.Dimension(512, 110));
    jPanel4.setMinimumSize (new java.awt.Dimension(512, 110));

      tempoSlider.setPreferredSize (new java.awt.Dimension(128, 50));
      tempoSlider.setBorder (new javax.swing.border.TitledBorder(""));
      tempoSlider.setMinimumSize (new java.awt.Dimension(128, 50));
      tempoSlider.setMaximum (225);
      tempoSlider.setValue (128);
      tb = (TitledBorder) tempoSlider.getBorder();
      tb.setTitle("Tempo (BPM) = "+ (int) theConversionCore.getTempoInBPM());
      tempoSlider.setValue( (int) theConversionCore.getTempoInBPM());
  
      tempoSlider.addChangeListener (new javax.swing.event.ChangeListener () {
        public void stateChanged (javax.swing.event.ChangeEvent evt) {
          tempoStateChangeHandler (evt);
        }
      }
      );
  
      jPanel4.add (tempoSlider, java.awt.BorderLayout.NORTH);
  
  
      jPanel4.add (sequenceScrollPane, java.awt.BorderLayout.CENTER);
  

    getContentPane ().add (jPanel4, java.awt.BorderLayout.CENTER);

    setJMenuBar (menuBar);

  }//GEN-END:initComponents

  private void closeDnaFileHandler (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeDnaFileHandler
// Add your handling code here:
        theConversionCore.setNucSequence("                                                                     ");
        theSequence = null;
        currentFile = null;
        super.setTitle("ProteinMusic");
	this.setButtonsNone();
        closeDnaFileMI.setEnabled(false);
        saveMidiFileMI.setEnabled(false);
        saveMidiFileAsMI.setEnabled(false);

        this.fileLoaded = false;
        this.setSequenceScroll();
        this.repaint();
  }//GEN-LAST:event_closeDnaFileHandler

  private void forwardActionHandler (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_forwardActionHandler
// Add your handling code here:
	if(!positionChange)
	{
		forwardB.setEnabled(false);
		rewindB.setEnabled(false);
    		this.changeSequencePosition(9);
	}
    
  }//GEN-LAST:event_forwardActionHandler

  private void pauseActionHandler (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pauseActionHandler
// Add your handling code here:
    if((theSequencer!=null)&&(theSequence!=null))
    {
	this.setButtonsTogglePause();
        if(playing)
        {
          tempoSlider.setEnabled(true);
          theSequencer.setTempoInBPM(theConversionCore.getTempoInBPM());
          playing = false;
          theSequencer.stop();
        }
        else
        {
          theSequencer.setTempoInBPM(theConversionCore.getTempoInBPM());
          playing = true;
          theConversionCore.setTempoInBPM((float)tempoSlider.getValue());
          theSequencer.setTempoInBPM(theConversionCore.getTempoInBPM());
          theSequencer.start();
        }
    }
  }//GEN-LAST:event_pauseActionHandler

  private void rewindActionHandler (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rewindActionHandler
// Add your handling code here:
	if(!positionChange)
	{
		forwardB.setEnabled(false);
		rewindB.setEnabled(false);
    		this.changeSequencePosition(-9);
	}
  }//GEN-LAST:event_rewindActionHandler

  private void pasteMenuHandler (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pasteMenuHandler
// Add your handling code here:
    if(pasteDialog.showDnaPasteDialog()==1)
    {
        pastedString = theProteinMusicIO.getSequenceFromString(pasteDialog.getTextField());
        try
        {
          theConversionCore.setNucSequence(pastedString);
          this.repaint();
          theSequence = theConversionCore.convertNucSequence(this);
          theSequencer.setSequence(theSequence);
	  actualAAPosition = 0;
        }
        catch(Exception e)
        {
            System.out.println(this.getClass()+"\tCannot set sequence to sequencer ("+e+")");
            repaint();
            return;
        }
        currentFile = new File("noname.mid");
        super.setTitle(currentFile.getName());
	this.setButtonsStartPlay();

        closeDnaFileMI.setEnabled(true);
        saveMidiFileMI.setEnabled(true);
        saveMidiFileAsMI.setEnabled(true);
        this.fileLoaded = true;
        
        this.setSequenceScroll();

        this.repaint();
    }

    
  }//GEN-LAST:event_pasteMenuHandler

  private void aboutMenuHandler (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_aboutMenuHandler
// Add your handling code here:
    aboutDialog.showAboutDialog();
  }//GEN-LAST:event_aboutMenuHandler

  private void tempoStateChangeHandler (javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_tempoStateChangeHandler
// Add your handling code here:
      long position = 0;

      if(!playing)
      {
          TitledBorder tb = (TitledBorder) tempoSlider.getBorder();
          tb.setTitle("Tempo (BPM) = "+tempoSlider.getValue());
          theConversionCore.setTempoInBPM((float)tempoSlider.getValue());
          theSequencer.setTempoInBPM(theConversionCore.getTempoInBPM());
      }
  }//GEN-LAST:event_tempoStateChangeHandler

  private void lineActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lineActionPerformed
// Add your handling code here:
      switch (jComboBox1.getSelectedIndex())
      {
          case 0 :
            tb.setTitle("Volume = "+theConversionCore.getTopLineVolume());
            break;
          case 1 :
            tb.setTitle("Volume = "+theConversionCore.getBassLineVolume());
            break;
      }   
      tb = (TitledBorder) tempoSlider.getBorder();
      tb.setTitle("Tempo in BPM = "+(int) theConversionCore.getTempoInBPM());
      tempoSlider.setValue( (int) theConversionCore.getTempoInBPM());
  }//GEN-LAST:event_lineActionPerformed

  private void saveAsMidiFileHandler (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveAsMidiFileHandler
// Add your handling code here:    int fileChooserReturn = -1;
    this.repaint();
    theSequence = theConversionCore.convertNucSequence(this);
    if(currentDirectory != null)
    {
      fileChooser.setCurrentDirectory(currentDirectory);
    }
    
    fileChooser.setSelectedFile(new File (currentFile.getName().substring(0,currentFile.getName().indexOf('.'))+".mid"));
    if(fileChooser.showSaveDialog(this) == JFileChooser.APPROVE_OPTION)
    {
      currentMidiFile =  fileChooser.getSelectedFile();
//      System.out.println(currentMidiFile.getName());
        try
        {
          MidiSystem.write(theSequence,1,currentMidiFile);
        }
        catch(Exception e)
        {
          System.out.println(this.getClass()+"\tCould not write MIDI file ("+e+")");
        }    
    }
    else /* cancelled */
    {
    };
    this.repaint();
    
    //mapping.setNucSequence()
    
  }//GEN-LAST:event_saveAsMidiFileHandler

  private void saveMidiFileHandler (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveMidiFileHandler
// Add your handling code here:
    this.repaint();
    theSequence = theConversionCore.convertNucSequence(this);
//    System.out.println(currentDirectory.getPath()+System.getProperty("file.separator")+currentFile.getName().substring(0,currentFile.getName().indexOf('.'))+".mid");
    currentMidiFile = new File(currentDirectory.getPath()+System.getProperty("file.separator")+currentFile.getName().substring(0,currentFile.getName().indexOf('.'))+".mid");
    try
    {
        MidiSystem.write(theSequence,1,currentMidiFile);
    }
    catch(Exception e)
    {
        System.out.println(this.getClass()+"\tCould not write MIDI file ("+e+")");
    }    
  }//GEN-LAST:event_saveMidiFileHandler

  private void volumeStateChanged (javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_volumeStateChanged
// Add your handling code here:
      long position = 0;
    
      if(playing)
      {
        theSequencer.stop();
        position = theSequencer.getTickPosition();
      }
 //     TitledBorder tb = (TitledBorder) volumeSlider.getBorder();
      switch (jComboBox1.getSelectedIndex())
      {
          case 0 :
//            theConversionCore.setTopLineVolume(volumeSlider.getValue());
            tb.setTitle("Volume = "+theConversionCore.getTopLineVolume());
            break;
          case 1 :
//            theConversionCore.setBassLineVolume(volumeSlider.getValue());
            tb.setTitle("Volume = "+theConversionCore.getBassLineVolume());
            break;
      }   
      if(this.fileLoaded)
      {
        theConversionCore.updateInstrumentSettings();
        try
        {
          theSequencer.setSequence(theSequence);
        }
        catch(Exception e)
        {
            System.out.println(""+this.getClass()+"\n"+e);
            System.out.println(this.getClass()+"\tCannot set sequence to sequencer ("+e+")");
            return;
        }
      }
      if(playing)
      {
        theConversionCore.setTempoInBPM((float)tempoSlider.getValue());
        theSequencer.setTempoInBPM(theConversionCore.getTempoInBPM());
        theSequencer.setTickPosition(position);
        theSequencer.start();
      }

  }//GEN-LAST:event_volumeStateChanged

  private void TableMouseReleasedHandler (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_TableMouseReleasedHandler
// Add your handling code here:
        
      long position = 0;
      boolean wasPlaying = theSequencer.isRunning();
    
      position = theSequencer.getTickPosition();
      if(wasPlaying)
      {
        instrumentChanged = true;
        theSequencer.close();
        try
        {
          theSequencer.open();
        }
        catch(Exception e)
        {
          System.out.println(this.getClass()+"\tCannot open Sequencer Device ("+e+")");
          System.exit(1);
        }
     }
     switch (jComboBox1.getSelectedIndex())
     {
          case 0 :
            theConversionCore.setTopLineInstrumentNumber(jTable1.getSelectedRow()+(jTable1.getSelectedColumn()*8));
            break;
          case 1 :
            theConversionCore.setBassLineInstrumentNumber(jTable1.getSelectedRow()+(jTable1.getSelectedColumn()*8));
            break;
     }
     if(this.fileLoaded)
     {
        theConversionCore.updateInstrumentSettings();
        try
        {
          theSequencer.setSequence(theSequence);
          theSequencer.setTickPosition(position);
          theSequencer.setTempoInBPM(theConversionCore.getTempoInBPM());

        }
        catch(Exception e)
        {
            System.out.println(this.getClass()+"\tCannot set sequence to sequencer ("+e+")");
            return;
        }
     }
     if(wasPlaying)
     {
        theConversionCore.setTempoInBPM((float)tempoSlider.getValue());
        theSequencer.start();
        theSequencer.setTickPosition(position);
        theSequencer.setTempoInBPM(theConversionCore.getTempoInBPM());
     }
     else
     {
        theConversionCore.setTempoInBPM((float)tempoSlider.getValue());
        theSequencer.start();
        theSequencer.setTickPosition(position);
        theSequencer.setTempoInBPM(theConversionCore.getTempoInBPM());
	theSequencer.stop();
     }      
  }//GEN-LAST:event_TableMouseReleasedHandler

  private void JTable1MouseReleasedHandler (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_JTable1MouseReleasedHandler
// Add your handling code here:
  }//GEN-LAST:event_JTable1MouseReleasedHandler

  private void Jtable1ProperyChangeHandler (java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_Jtable1ProperyChangeHandler
// Add your handling code here:
  }//GEN-LAST:event_Jtable1ProperyChangeHandler

  private void stopActionHandler (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_stopActionHandler
// Add your handling code here:
    if((theSequencer!=null)&&(theSequence!=null))
    {
	this.setButtonsStartPlay();
        theSequencer.setTempoInBPM(theConversionCore.getTempoInBPM());
        playing = false;
        theSequencer.stop();
    }
  }//GEN-LAST:event_stopActionHandler

  private void playActionHandler (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_playActionHandler
// Add your handling code here:
    if((theSequencer!=null)&&(theSequence!=null))
    {
        theSequencer.stop();
        theConversionCore.setTempoInBPM((float)tempoSlider.getValue());
	this.setButtonsPlaying();
        playing = true;
        theSequencer.start();
        theSequencer.setTempoInBPM(theConversionCore.getTempoInBPM());
    }
    
  }//GEN-LAST:event_playActionHandler

  private void openDnaFileHandler (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openDnaFileHandler
// Add your handling code here:
    
    int fileChooserReturn = -1;
    if(currentDirectory == null)
    {
      currentDirectory = new File(System.getProperty("user.dir"));
    }
    fileChooser.setCurrentDirectory(currentDirectory);
    
    if(fileChooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION)
    {
        currentDirectory = fileChooser.getCurrentDirectory();
        File dummyFile = fileChooser.getSelectedFile();
        this.repaint();
        theConversionCore.setNucSequence(theProteinMusicIO.getSequenceFromFile(dummyFile.getPath()));
        theConversionCore.setTempoInBPM((float)tempoSlider.getValue());
        theSequencer.setTempoInBPM(theConversionCore.getTempoInBPM());
        theSequence = theConversionCore.convertNucSequence(this);
	actualAAPosition = 0;
        try
        {
          theSequencer.setSequence(theSequence);
        }
        catch(Exception e)
        {
            System.out.println(this.getClass()+"\tCannot set sequence to sequencer ("+e+")");
            return;
        }
        currentFile = fileChooser.getSelectedFile();
        super.setTitle(dummyFile.getName());
        playB.setEnabled(true);
//        stopB.setEnabled(true);
        closeDnaFileMI.setEnabled(true);
        saveMidiFileMI.setEnabled(true);
        saveMidiFileAsMI.setEnabled(true);

        this.fileLoaded = true;
        this.setSequenceScroll();
    }
    else /* cancelled */
    {
    };
    
    //mapping.setNucSequence()
    
  }//GEN-LAST:event_openDnaFileHandler

  private void exitActionHandler (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitActionHandler
// Add your handling code here:
    theSequencer.close();
    System.exit(1);
    
  }//GEN-LAST:event_exitActionHandler

  /** Exit the Application */
  private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
    theSequencer.close();
    System.exit (0);
  }//GEN-LAST:event_exitForm

  
  /**
  * @param args the command line arguments
  */
  public static void main (String args[]) {
    new ProteinMusic ().show ();
  }


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JMenuBar menuBar;
  private javax.swing.JMenu fileMenu;
  private javax.swing.JMenuItem openDnaFileMI;
  private javax.swing.JMenuItem closeDnaFileMI;
  private javax.swing.JSeparator jSeparator1;
  private javax.swing.JMenuItem saveMidiFileMI;
  private javax.swing.JMenuItem saveMidiFileAsMI;
  private javax.swing.JSeparator jSeparator2;
  private javax.swing.JMenuItem exitMI;
  private javax.swing.JMenu sequenceMenu;
  private javax.swing.JMenuItem pasteMenuItem;
  private javax.swing.JSeparator jSeparator3;
  private javax.swing.JMenuItem primaryMappingMenuItem;
  private javax.swing.JMenuItem secondaryMappingItem;
  private javax.swing.JMenu helpMenu;
  private javax.swing.JMenuItem aboutMenuItem;
  private javax.swing.JPanel jPanel3;
  private javax.swing.JComboBox jComboBox1;
  private javax.swing.JScrollPane jScrollPane4;
  private javax.swing.JTable jTable1;
  private javax.swing.JPanel jPanel1;
  private javax.swing.JButton rewindB;
  private javax.swing.JButton playB;
  private javax.swing.JButton pauseB;
  private javax.swing.JButton stopB;
  private javax.swing.JButton forwardB;
  private javax.swing.JPanel jPanel4;
  private javax.swing.JSlider tempoSlider;
  private javax.swing.JScrollPane sequenceScrollPane;
  // End of variables declaration//GEN-END:variables

  public void instrumentChange(int instrumentNumber) {
  }
  
  public JTextArea createSequenceTextArea()
  {

      GraphicsEnvironment theGraphicsEnvironment;
      Font[]              theFonts;
      Font                theMonoSpacedFont = null;
    
      /*     get the sequences and insert two spaces between each of the amino acids */
    
      String aminoAcidSequenceDummy   = theConversionCore.getAminoAcidSequence();
      String nucleotideSequence       = theConversionCore.getNucSequence();
      String aminoAcidSequence        = "";

      for(int i =0;i<aminoAcidSequenceDummy.length();i++)
      {
          aminoAcidSequence = aminoAcidSequence + aminoAcidSequenceDummy.substring(i,i+1)+ "  "; 
      }
//      aminoAcidSequence = aminoAcidSequence +

      /* create the JTextArea object */
      
      JTextArea sequenceArea = new JTextArea(nucleotideSequence+"\n" + aminoAcidSequence+"\n");
//      JTextArea sequenceArea = new JTextArea(nucleotideSequence+"\n" + "This should be an aa sequence");
      /* get the right font */

      theGraphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
      theFonts = theGraphicsEnvironment.getAllFonts();

      for(int i = 0;i<theFonts.length;i++)
      {
	  String fontName = theFonts[i].getFontName().toUpperCase();
	  //System.out.println("Num: "+i+"\tName "+fontName);
	  //System.out.println(fontName.indexOf("MONO"));
	  
	  if((fontName.indexOf("MONOSPACED") > -1 )|| (theFonts[i].getFontName().equalsIgnoreCase("BitstreamVeraSansMono-Bold")  ))
	  {
              theMonoSpacedFont = theFonts[i];
	      //System.out.println("The font chosen is: "+theMonoSpacedFont.getFontName());
	      break;
          }
      }
      
      if(theMonoSpacedFont != null)
      {
          sequenceArea.setFont(theMonoSpacedFont.deriveFont(14.0f));
          sequenceArea.revalidate();
      }
      else
      { 
          System.out.println(this.getClass()+"\tCould not find monospaced font.");
      }
      
      sequenceArea.setEditable(false);
      return sequenceArea;


  }

  public void setSequenceScroll()
  {
        sequenceTextArea = this.createSequenceTextArea();
        scrollStep = (int) sequenceTextArea.getPreferredSize().getWidth()/(theConversionCore.getNucSequence().length()*2);
//        System.out.println("scrollstep = "+scrollStep);
        sequenceScrollPane.setViewportView(sequenceTextArea);
        sequenceScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
        sequenceScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        scrollJViewport = sequenceScrollPane.getViewport();
        scrollPosition  = scrollJViewport.getViewPosition();

        scrollPosition.setLocation(0,0);
        scrollJViewport.setViewPosition(scrollPosition);
        pack();
        sequenceScrollPane.repaint();
        this.repaint();
        scrollJViewport = sequenceScrollPane.getViewport();
        Action[] theActions = sequenceTextArea.getActions();
  }

   private void changeSequencePosition(int theChange)
   {
      float   lengthOfPosInTicks    = 0;
      long    actualPositionInTicks = 0;
      int     actualPositionInAscii = 0;
      long    sequenceLengthInTicks = 0;
      int     sequenceLengthInAscii = 0;
      double  newPosInAscii;
      long    changePosInTicks      = 0;

      if(playing)
      {
        theSequencer.stop();
      }


	actualPositionInTicks = (long) ((actualAAPosition*theConversionCore.getNucTime())+(theConversionCore.getNucTime()*3));
//	newPosInAscii = (scrollPosition.getX()/8) + theChange;
	sequenceLengthInAscii = theConversionCore.getNucSequence().length();
      	newPosInAscii = actualAAPosition + theChange;

//System.out.println("s1\t"+theSequencer.getTickPosition()+"\t"+actualAAPosition+"\t"+actualPositionInTicks);
//System.out.println("s1\t"+newPosInAscii+"\t"+(actualAAPosition + theChange));
//System.out.println("s1\t"+sequenceLengthInAscii+"\n++++++++++");

	if((newPosInAscii <= sequenceLengthInAscii)&&(newPosInAscii > 0))
      	{
		actualAAPosition = (actualAAPosition + theChange);
        	positionChangeInTicks = actualPositionInTicks +( (long) (theChange*theConversionCore.getNucTime()));
         	positionChange = true;
         	scrollPosition.setLocation((int)(newPosInAscii*(scrollStep*2)),scrollPosition.getY());
         	scrollJViewport.setViewPosition(scrollPosition);
         	sequenceScrollPane.repaint();
//System.out.println("s2\t"+actualPositionInTicks+"\t"+positionChangeInTicks+"\n-------------");
	}
	else
	{
		actualAAPosition = 0;
		positionChangeInTicks = 0;		
         	positionChange = true;
		newPosInAscii  = 0;
         	scrollPosition.setLocation((int)(newPosInAscii*(scrollStep*2)),scrollPosition.getY());
         	scrollJViewport.setViewPosition(scrollPosition);
         	sequenceScrollPane.repaint();
	}

      if(playing)
      {
        theConversionCore.setTempoInBPM((float)tempoSlider.getValue());
//        theSequencer.setTempoInBPM(theConversionCore.getTempoInBPM());
        theSequencer.start();
        theSequencer.setTempoInBPM(theConversionCore.getTempoInBPM());
      }
    }

  public void meta(MetaMessage p1)
  {
	actualAAPosition = actualAAPosition+ 0.5;
//	int expectedPos =  (int)((actualAAPosition*theConversionCore.getNucTime())+(theConversionCore.getNucTime()*3));
//	System.out.println(theSequencer.getTickPosition()+"\t"+actualAAPosition+"\t"+expectedPos+"\t"+theSequencer.getSequence().getTickLength() );

       if(positionChange)
        {
          theSequencer.setTickPosition(positionChangeInTicks);
          theSequencer.setTempoInBPM(theConversionCore.getTempoInBPM());
	  forwardB.setEnabled(true);
	  rewindB.setEnabled(true);
        }

        scrollPosition.setLocation(scrollPosition.getX()+scrollStep,(int) scrollPosition.getY());
        scrollJViewport.setViewPosition(scrollPosition);


        if(p1.getType() == 2&&(!instrumentChanged))
        {
		actualAAPosition = 0;
       		theConversionCore.setTempoInBPM((float)tempoSlider.getValue());
        	theSequencer.setTempoInBPM(theConversionCore.getTempoInBPM());

              	playing = false;
              	this.setSequenceScroll();
		this.setButtonsStartPlay();
         }
        sequenceScrollPane.repaint();
        instrumentChanged = false;
        positionChange = false;
        positionChangeInTicks = 0;
  }


	private void setButtonsStartPlay()
	{
        	playB.setEnabled(true);
              	stopB.setEnabled(false);
              	pauseB.setEnabled(false);
              	rewindB.setEnabled(false);
              	forwardB.setEnabled(false);
		tempoSlider.setValue((int) theConversionCore.getTempoInBPM());
        	tempoSlider.setEnabled(true);
	}
	private void setButtonsPlaying()
	{
        	playB.setEnabled(false);
              	stopB.setEnabled(true);
              	pauseB.setEnabled(true);
              	rewindB.setEnabled(true);
              	forwardB.setEnabled(true);
        	tempoSlider.setEnabled(false);
	}
	private void setButtonsNone()
	{
        	playB.setEnabled(false);
              	stopB.setEnabled(false);
              	pauseB.setEnabled(false);
              	rewindB.setEnabled(false);
              	forwardB.setEnabled(false);
        	tempoSlider.setEnabled(true);
	}

	private void setButtonsTogglePause()
	{
		if(playing)
		{
        		playB.setEnabled(false);
              		stopB.setEnabled(false);
              		pauseB.setEnabled(true);
              		rewindB.setEnabled(false);
              		forwardB.setEnabled(false);
        		tempoSlider.setEnabled(true);
		}
		else
		{
        		playB.setEnabled(false);
              		stopB.setEnabled(true);
              		pauseB.setEnabled(true);
              		rewindB.setEnabled(true);
              		forwardB.setEnabled(true);
        		tempoSlider.setEnabled(false);
		}
	}	
		

	public void centre()
	{

		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
      		this.setLocation((int)( screen.getWidth() - this.getSize().getWidth() ) / 2,(int) ( screen.getHeight() - this.getSize().getHeight() ) / 2 );
	}


}
