/*
 * Mapping.java
 *
 * Created on 12 May 2000, 21:08
 */


/** 
 *
 * @author  aak97
 * @version 
 */
public class Mapping extends Object implements CodonConstants
{
  
  /* default mapping from paper */
  
  private MusicalNote  nucA; 
  private MusicalNote  nucT; 
  private MusicalNote  nucG; 
  private MusicalNote  nucC; 
  
  private MusicalNote  polar; 
  private MusicalNote  hydrophobic; 
  private MusicalNote  charged;
  private MusicalNote  positive;
  private MusicalNote  aliphatic; 
  private MusicalNote  aromatic;
  private OctaveChange tiny;
  private OctaveChange small;
  private OctaveChange large;

  private int          generalCodonTime = 3000;
  
  public Codon[]  codons;
  
  /** Creates new Mapping */
  
  public void Mapping() 
  {
      
  }
  
  public void init()
  {
    String[] dummyStrings = new String[6];

    long[]  playTime     = new long[6];
    int     gap          = generalCodonTime/6;
    int[]   durationTime = new int[2];
    int[]   velocityTime = new int[2];

    durationTime[0] = generalCodonTime/3;
    durationTime[1] = durationTime[0]/2;
    velocityTime[0] = 70;
    velocityTime[1] = 100;
      
    playTime[0] = 0;
    for(int i = 1;i<playTime.length;i++)
    {
        playTime[i] = playTime[i-1]+gap;
    }
     
    
    nucA        = new MusicalNote("A5"); /*  A4  */
    nucT        = new MusicalNote("E5"); /*  E3  */
    nucG        = new MusicalNote("C5"); /*  C3  */
    nucC        = new MusicalNote("G5"); /*  G3  */
  
    polar       = new MusicalNote("A3"); /*  A2  */
    hydrophobic = new MusicalNote("C3"); /*  C1  */
    charged     = new MusicalNote("F3"); /*  F1  */
    positive    = new MusicalNote("E3"); /*  E1  */
    aliphatic   = new MusicalNote("G3"); /*  G1  */
    aromatic    = new MusicalNote("D3"); /*  D1  */
    tiny        = new OctaveChange(2); /*  All plus one ocatve  */
    small       = new OctaveChange(1); /*  All plus one ocatve  */
    large       = new OctaveChange(1); /*  All plus one ocatve  */

    codons = new Codon[CodonConstants.NUMBEROFAMINOACIDS];
    
    dummyStrings[0] = "TTT";
    dummyStrings[1] = "TTC";
    dummyStrings[2] = "";
    dummyStrings[3] = "";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[0] = new Codon(dummyStrings,"f");
    codons[0].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(aromatic),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[0].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(hydrophobic),playTime[4],durationTime[0],velocityTime[1],velocityTime[0]));
    codons[0].setSize(CodonConstants.LARGE);
        
    dummyStrings[0] = "TTA";
    dummyStrings[1] = "TTG";
    dummyStrings[2] = "CTT";
    dummyStrings[3] = "CTC";
    dummyStrings[4] = "CTA";
    dummyStrings[5] = "CTG";
    codons[1] = new Codon(dummyStrings,"l");
    codons[1].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(aliphatic),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[1].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(hydrophobic),playTime[4],durationTime[0],velocityTime[1],velocityTime[0]));
    codons[1].setSize(CodonConstants.LARGE);
    
    dummyStrings[0] = "ATT";
    dummyStrings[1] = "ATC";
    dummyStrings[2] = "ATA";
    dummyStrings[3] = "";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[2] = new Codon(dummyStrings,"i");
    codons[2].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(hydrophobic),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[2].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(aliphatic),playTime[4],durationTime[0],velocityTime[1],velocityTime[0]));
    codons[2].setSize(CodonConstants.LARGE);
    
    dummyStrings[0] = "ATG";
    dummyStrings[1] = "";
    dummyStrings[2] = "";
    dummyStrings[3] = "";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[3] = new Codon(dummyStrings,"m");
    codons[3].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(hydrophobic),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[3].setSize(CodonConstants.LARGE);
    
    dummyStrings[0] = "GTT";
    dummyStrings[1] = "GTC";
    dummyStrings[2] = "GTA";
    dummyStrings[3] = "GTG";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[4] = new Codon(dummyStrings,"v");
    codons[4].addAminoAcidTiming(new AminoAcidTimeAttributes(small.convertNote(hydrophobic),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[4].addAminoAcidTiming(new AminoAcidTimeAttributes(small.convertNote(aliphatic),playTime[4],durationTime[0],velocityTime[1],velocityTime[0]));
    codons[4].setSize(CodonConstants.SMALL);
    
    dummyStrings[0] = "TCT";
    dummyStrings[1] = "TCC";
    dummyStrings[2] = "TCA";
    dummyStrings[3] = "TCG";
    dummyStrings[4] = "AGT";
    dummyStrings[5] = "AGC";
    codons[5] = new Codon(dummyStrings,"s");
    codons[5].addAminoAcidTiming(new AminoAcidTimeAttributes(tiny.convertNote(polar),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[5].setSize(CodonConstants.TINY);
    
    dummyStrings[0] = "CCT";
    dummyStrings[1] = "CCC";
    dummyStrings[2] = "CCA";
    dummyStrings[3] = "CCG";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[6] = new Codon(dummyStrings,"p");
    codons[6].setSize(CodonConstants.SMALL);
    
    dummyStrings[0] = "ACT";
    dummyStrings[1] = "ACC";
    dummyStrings[2] = "ACA";
    dummyStrings[3] = "ACG";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[7] = new Codon(dummyStrings,"t");
    codons[7].addAminoAcidTiming(new AminoAcidTimeAttributes(small.convertNote(polar),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[7].addAminoAcidTiming(new AminoAcidTimeAttributes(small.convertNote(hydrophobic),playTime[4],durationTime[0],velocityTime[1],velocityTime[0]));
    codons[7].setSize(CodonConstants.SMALL);
    
    dummyStrings[0] = "GCT";
    dummyStrings[1] = "GCC";
    dummyStrings[2] = "GCA";
    dummyStrings[3] = "GCG";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[8] = new Codon(dummyStrings,"a");
    codons[8].addAminoAcidTiming(new AminoAcidTimeAttributes(tiny.convertNote(hydrophobic),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[8].setSize(CodonConstants.TINY);
    
    dummyStrings[0] = "TAT";
    dummyStrings[1] = "TAC";
    dummyStrings[2] = "";
    dummyStrings[3] = "";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[9] = new Codon(dummyStrings,"y");
    codons[9].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(aromatic),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[9].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(hydrophobic),playTime[2],durationTime[0],velocityTime[1],velocityTime[0]));
    codons[9].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(polar),playTime[4],durationTime[0],velocityTime[1],velocityTime[0]));
    codons[9].setSize(CodonConstants.LARGE);

    dummyStrings[0] = "TAA";
    dummyStrings[1] = "TAG";
    dummyStrings[2] = "TGA";
    dummyStrings[3] = "";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[10] = new Codon(dummyStrings,"z"); /*not an amino acid -> stop signal*/ 
                                              /*has to be inluded for incomplete sequences!*/
    codons[10].setSize(CodonConstants.SMALL);
    
    dummyStrings[0] = "CAT";
    dummyStrings[1] = "CAC";
    dummyStrings[2] = "";
    dummyStrings[3] = "";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[11] = new Codon(dummyStrings,"h");
    codons[11].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(positive),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[11].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(polar),playTime[2],durationTime[1],velocityTime[1],velocityTime[0]));
    codons[11].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(hydrophobic),playTime[3],durationTime[1],velocityTime[1],velocityTime[0]));
    codons[11].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(aromatic),playTime[4],durationTime[1],velocityTime[1],velocityTime[0]));
    codons[11].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(charged),playTime[5],durationTime[1],velocityTime[1],velocityTime[0]));
    codons[11].setSize(CodonConstants.LARGE);
    
    dummyStrings[0] = "CAA";
    dummyStrings[1] = "CAG";
    dummyStrings[2] = "";
    dummyStrings[3] = "";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[12] = new Codon(dummyStrings,"q");
    codons[12].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(polar),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[12].setSize(CodonConstants.LARGE);
    
    dummyStrings[0] = "AAT";
    dummyStrings[1] = "AAC";
    dummyStrings[2] = "";
    dummyStrings[3] = "";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[13] = new Codon(dummyStrings,"n");
    codons[13].addAminoAcidTiming(new AminoAcidTimeAttributes(small.convertNote(polar),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[13].setSize(CodonConstants.SMALL);
    
    dummyStrings[0] = "AAA";
    dummyStrings[1] = "AAG";
    dummyStrings[2] = "";
    dummyStrings[3] = "";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[14] = new Codon(dummyStrings,"k");
    codons[14].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(polar),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[14].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(hydrophobic),playTime[2],durationTime[0],velocityTime[1],velocityTime[0]));
    codons[14].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(charged),playTime[3],durationTime[1],velocityTime[1],velocityTime[0]));
    codons[14].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(positive),playTime[4],durationTime[1],velocityTime[1],velocityTime[0]));
    codons[14].setSize(CodonConstants.LARGE);
    
    dummyStrings[0] = "GAT";
    dummyStrings[1] = "GAC";
    dummyStrings[2] = "";
    dummyStrings[3] = "";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[15] = new Codon(dummyStrings,"d");
    codons[15].addAminoAcidTiming(new AminoAcidTimeAttributes(small.convertNote(polar),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[15].addAminoAcidTiming(new AminoAcidTimeAttributes(small.convertNote(charged),playTime[4],durationTime[0],velocityTime[1],velocityTime[0]));
    codons[15].setSize(CodonConstants.SMALL);
    
    dummyStrings[0] = "GAA";
    dummyStrings[1] = "GAG";
    dummyStrings[2] = "";
    dummyStrings[3] = "";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[16] = new Codon(dummyStrings,"e");
    codons[16].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(polar),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[16].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(charged),playTime[4],durationTime[0],velocityTime[1],velocityTime[0]));
    codons[16].setSize(CodonConstants.LARGE);
    
    dummyStrings[0] = "TGT";
    dummyStrings[1] = "TGC";
    dummyStrings[2] = "";
    dummyStrings[3] = "";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[17] = new Codon(dummyStrings,"c");
    codons[17].addAminoAcidTiming(new AminoAcidTimeAttributes(small.convertNote(hydrophobic),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[17].setSize(CodonConstants.SMALL);
    
    dummyStrings[0] = "TGG";
    dummyStrings[1] = "";
    dummyStrings[2] = "";
    dummyStrings[3] = "";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[18] = new Codon(dummyStrings,"w");
    codons[18].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(aromatic),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[18].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(hydrophobic),playTime[2],durationTime[0],velocityTime[1],velocityTime[0]));
    codons[18].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(polar),playTime[4],durationTime[0],velocityTime[1],velocityTime[0]));
    codons[18].setSize(CodonConstants.LARGE);
    
    dummyStrings[0] = "CGT";
    dummyStrings[1] = "CGC";
    dummyStrings[2] = "CGA";
    dummyStrings[3] = "CGG";
    dummyStrings[4] = "AGA";
    dummyStrings[5] = "AGG";
    codons[19] = new Codon(dummyStrings,"r");
    codons[19].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(polar),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[19].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(positive),playTime[2],durationTime[0],velocityTime[1],velocityTime[0]));
    codons[19].addAminoAcidTiming(new AminoAcidTimeAttributes(large.convertNote(charged),playTime[4],durationTime[0],velocityTime[1],velocityTime[0]));
    codons[19].setSize(CodonConstants.LARGE);
    
    dummyStrings[0] = "GGT";
    dummyStrings[1] = "GGC";
    dummyStrings[2] = "GGA";
    dummyStrings[3] = "GGG";
    dummyStrings[4] = "";
    dummyStrings[5] = "";
    codons[20] = new Codon(dummyStrings,"g");
    codons[20].addAminoAcidTiming(new AminoAcidTimeAttributes(tiny.convertNote(hydrophobic),playTime[0],durationTime[0],velocityTime[0],velocityTime[0]));
    codons[20].setSize(CodonConstants.TINY);
    
  }
  
  public void setNucMapping(String theNucleotide, MusicalNote theMappingNote)
  {
    if(theNucleotide.equalsIgnoreCase("a"))
    {
      nucA = theMappingNote;
    }
    else if(theNucleotide.equalsIgnoreCase("t"))
    {
      nucT = theMappingNote;
    }
    else if(theNucleotide.equalsIgnoreCase("g"))
    {
      nucG = theMappingNote;
    }
    else if(theNucleotide.equalsIgnoreCase("c"))
    {
      nucC = theMappingNote;
    }
  }  
  public MusicalNote getNucMapping(String theNucleotide)
  {
    MusicalNote returnMusicalNote = null;
    if(theNucleotide.equalsIgnoreCase("a"))
    {
      returnMusicalNote = nucA;
    }
    else if(theNucleotide.equalsIgnoreCase("t"))
    {
      returnMusicalNote = nucT;
    }
    else if(theNucleotide.equalsIgnoreCase("g"))
    {
      returnMusicalNote = nucG;
    }
    else if(theNucleotide.equalsIgnoreCase("c"))
    {
      returnMusicalNote = nucC;
    }
    else
    {
        System.out.println("The Nucleotide does not exist : "+theNucleotide);
    }
    return returnMusicalNote;
  }  
  public MusicalNote getNucMapping(String theNucleotide, String theCodingCodon)
  {
    MusicalNote dummyMusicalNote = this.getNucMapping(theNucleotide);
    MusicalNote returnMusicalNote = null;
    if(this.getCodonMappingFor(theCodingCodon).getSize()==CodonConstants.TINY)
    {
            returnMusicalNote = tiny.convertNote(dummyMusicalNote);
    }
    else if(this.getCodonMappingFor(theCodingCodon).getSize()==CodonConstants.SMALL)
    {
            returnMusicalNote = small.convertNote(dummyMusicalNote);
    }
    else if(this.getCodonMappingFor(theCodingCodon).getSize()==CodonConstants.LARGE)
    {
            returnMusicalNote = large.convertNote(dummyMusicalNote);
    }
    return returnMusicalNote;
  }  

  public Codon getCodonMappingFor(String theCodongString)
  {
    Codon returnCodon = null;
    
    for(int j = 0;j<CodonConstants.NUMBEROFAMINOACIDS;j++)
    {
      if(codons[j].isCoding(theCodongString))
      {
        returnCodon = codons[j];
        j = CodonConstants.NUMBEROFAMINOACIDS+1; /* found the right amin acid for this codon */
      }
    }
    return returnCodon;
  }
    
  public int getGeneralCodonTime()
  {
      return generalCodonTime;
  }
  public void setGeneralCodonTime(int theGeneralCodonTime)
  {
      generalCodonTime = theGeneralCodonTime;
  }
  
  
}
  