unit GPSUnit;

{$mode objfpc}{$H+}

interface

uses
	Classes, SysUtils, Forms, Controls, Graphics, Dialogs, StdCtrls, ComCtrls,
	Buttons, ExtCtrls, SdpoSerial, GPSparser;

type

	{ TMainForm }

 TMainForm = class(TForm)
		btnStart: TButton;
		btnStop: TButton;
		btnGetModemCapabilities: TSpeedButton;
		getModemInfo: TSpeedButton;
		ImageList1: TImageList;
		btnExport: TSpeedButton;
		dlgSave: TSaveDialog;
		btnClear: TSpeedButton;
		ToolBar1: TToolBar;
		txtLat: TEdit;
		txtLong: TEdit;
		txtAlt: TEdit;
		edSuplServer: TEdit;
		edApn: TEdit;
		gbSettings: TGroupBox;
		GroupBox1: TGroupBox;
		Label1: TLabel;
		Label2: TLabel;
		Label4: TLabel;
		Label5: TLabel;
		Label6: TLabel;
		srControl: TSdpoSerial;
		srData: TSdpoSerial;
		txtDebug: TMemo;
		txtData: TMemo;
		rbStandalone: TRadioButton;
		rbAssisted: TRadioButton;
		procedure btnClearClick(Sender: TObject);
  		procedure btnExportClick(Sender: TObject);
  		procedure btnGetModemCapabilitiesClick(Sender: TObject);
		procedure btnStartClick(Sender: TObject);
		procedure btnStopClick(Sender: TObject);
		procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
		procedure FormShow(Sender: TObject);
		procedure getModemInfoClick(Sender: TObject);
		procedure rbAssistedChange(Sender: TObject);
		procedure rbStandaloneChange(Sender: TObject);
		procedure srControlRxData(Sender: TObject);
		procedure srDataRxData(Sender: TObject);
	private
        procedure sendCommandAndLog(Command: String);
	public
	end;

var
	MainForm: TMainForm;
	started: Boolean;
    hasFix: Boolean;

implementation

{$R *.lfm}

procedure TMainForm.sendCommandAndLog(Command: String);
begin
    txtDebug.Lines.Add('> ' + Command);
    srControl.WriteData(Command + Chr(13) + Chr(10));
    //Sleep(100);
end;

procedure TMainForm.btnStartClick(Sender: TObject);
var
	Apn: String;
	SuplServer: String;
    sDateTime: TDateTime;
begin
    if started <> True then
    begin
		Apn := edApn.Text;
		SuplServer := edSuplServer.Text;
    	srControl.Open;
    	srData.Open;
        if rbStandalone.Checked = True then
		begin
            txtDebug.Lines.Add('Modem control and data ports opened.');
            txtDebug.Lines.Add('Switching to Standalone GPS (S-GPS) mode.');
            sendCommandAndLog('AT_OGPSP=7,1');
            started := True;
		end
		else
        begin
			if (rbAssisted.Checked = True) and (Apn <> '') and (SuplServer <> '') then
 			begin
                sDateTime := Now;
                txtDebug.Lines.Add('Modem control and data ports opened.');
                txtDebug.Lines.Add('Switching to Assisted GPS (A-GPS) mode.');
                sendCommandAndLog('AT+CCLK="' + FormatDateTime('yy/MM/dd,hh:mm:ss', sDateTime) + '"');
                sendCommandAndLog('AT_OGPSP=7,2');
                sendCommandAndLog('AT_OGPSCONT=1,"IP", "' + Apn + '"');
                sendCommandAndLog('AT_OGPSLS=1,"' + SuplServer + '"');
                started := True;
			end;
		end;
        if started = True then
		begin
            sendCommandAndLog('AT_OGPS=1');
			btnStart.Enabled := False;
			btnStop.Enabled := True;
		end;
	end;
end;

procedure TMainForm.btnGetModemCapabilitiesClick(Sender: TObject);
begin
    srControl.Open;
	txtDebug.Lines.Add('Modem control port opened.');
	sendCommandAndLog('AT_OIFACE?');
	srControl.Close;
	txtDebug.Lines.Add('Modem control port closed.');
end;

procedure TMainForm.btnExportClick(Sender: TObject);
begin
	dlgSave.FileName := 'export.nmea';
	if dlgSave.Execute then
    begin
		txtData.Lines.SaveToFile(dlgSave.FileName);
	end;
end;

procedure TMainForm.btnClearClick(Sender: TObject);
begin
    txtDebug.Lines.Clear;
end;

procedure TMainForm.btnStopClick(Sender: TObject);
begin
    if started = True then
	begin
        sendCommandAndLog('AT_OGPS=0');
    	srControl.Close;
		srData.Close;
        btnStart.Enabled := True;
		btnStop.Enabled := False;
		started := False;
        txtDebug.Lines.Add('Modem control and data ports closed.');
	end;
end;

procedure TMainForm.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
	srControl.Close;
	srData.Close;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
	started := False;
	hasFix := False;
end;

procedure TMainForm.getModemInfoClick(Sender: TObject);
begin
	srControl.Open;
	txtDebug.Lines.Add('Modem control port opened.');
	sendCommandAndLog('ATI');
	srControl.Close;
	txtDebug.Lines.Add('Modem control port closed.');
end;

procedure TMainForm.rbAssistedChange(Sender: TObject);
begin
	if rbAssisted.Checked = True then
    begin
		gbSettings.Enabled := True;
	end
	else
    begin
		gbSettings.Enabled := False;
	end;
end;

procedure TMainForm.rbStandaloneChange(Sender: TObject);
begin
	if rbStandalone.Checked = True then
    begin
		gbSettings.Enabled := False;
	end
	else
    begin
		gbSettings.Enabled := True;
	end;
end;

procedure TMainForm.srControlRxData(Sender: TObject);
begin
	txtDebug.Lines.Add(Trim(srControl.ReadData));
end;

procedure TMainForm.srDataRxData(Sender: TObject);
var
	Info: TGPSInfo;
    Line: String;
begin
    Line := Trim(srData.ReadData);
    txtData.Lines.Add(Line);
    hasFix := GPSParse(Line, Info);
    if hasFix = True then
    begin
    	txtLat.Text := Info.Latitude;
		txtLong.Text := Info.Longitude;
    	txtAlt.Text := Info.Altitude;
        btnStop.Click;
	end;
end;

end.

