/*!
 * jQuery Noti plugin
 * 
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <https://www.gnu.org/licenses/>.
 * 
 * author: sizeof(cat) <sizeofcat AT riseup DOT net> https://sizeof.cat
 * url: https://sizeof.cat/project/software/jquery-noti/
 * copyright: 2016-2022
 * version: 1.1.0
 * license: GPLv3 https://sizeof.cat/LICENSE.txt
 */
(function($) {
	$.noti = function(settings) {
		let image;
		let right;
		let left;
		let inner;
		let html_title = '';
		let html_content = '';
		settings = $.extend({
			title: undefined,
			content: undefined,
			timeout: 0,
			icon: undefined,
			time: true,
			click: undefined
		}, settings);
		let container = $('#notis');
		if (!container.length) {
			container = $('<div>', {
				id: 'notis'
			}).appendTo(document.body);
		}
		let notification = $('<div>');
		notification.addClass('noti noti-pop');
		let hide = $('<div>', {
			click: function() {
				$(this).parent().removeClass('noti-pop').addClass('noti-remove').delay(300).queue(function() {
					$(this).clearQueue();
					$(this).remove();
				});
			},
			touchstart: function() {
				$(this).parent().removeClass('noti-pop').addClass('noti-remove').delay(300).queue(function() {
					$(this).clearQueue();
					$(this).remove();
				});
			}
		});
		hide.addClass('hide');
		hide.html('hide');
		if (settings.icon !== undefined) {
			image = $('<div>', {
				style: 'background: url(' + settings.icon + ')'
			});
			image.addClass('icon');
			left = $('<div class="left">');
			right = $('<div class="right">');
			if (settings.title !== undefined) {
				html_title = '<h2>' + settings.title + '</h2>';
			}
			if (settings.content !== undefined) {
				html_content = settings.content;
			}
			inner = $('<div>', {
				html: html_title + html_content
			});
			inner.addClass('inner');
			inner.appendTo(right);
			image.appendTo(left);
			left.appendTo(notification);
			right.appendTo(notification);
		} else {
			if (settings.title !== undefined) {
				html_title = '<h2>' + settings.title + '</h2>';
			}
			if (settings.content !== undefined) {
				html_content = settings.content;
			}
			inner = html_title + html_content;
			notification.html(inner);
		}
		hide.appendTo(notification);
		function time_since(time) {
			var time_formats = [
				[2, "One second", "1 second from now"], 
				[60, "seconds", 1], 
				[120, "One minute", "1 minute from now"], 
				[3600, "minutes", 60], 
				[7200, "One hour", "1 hour from now"], 
				[86400, "hours", 3600], 
				[172800, "One day", "tomorrow"], 
				[604800, "days", 86400], 
				[1209600, "One week", "next week"], 
				[2419200, "weeks", 604800], 
				[4838400, "One month", "next month"], 
				[29030400, "months", 2419200], 
				[58060800, "One year", "next year"], 
				[2903040000, "years", 29030400], 
				[5806080000, "One century", "next century"], 
				[58060800000, "centuries", 2903040000]
			];
			let seconds = (new Date - time) / 1000;
			let token = 'ago', list_choice = 1;
			if (seconds < 0) {
				seconds = Math.abs(seconds);
				token = 'from now';
				list_choice = 1;
			}
			let i = 0, format;
			while (format = time_formats[i++]) {
				if (seconds < format[0]) {
					if (typeof format[2] === 'string') {
						return format[list_choice];
					} else {
						return Math.floor(seconds / format[2]) + " " + format[1];
					}
				}
			}
			return time;
		}
		if (settings.time !== false) {
			let timestamp = Number(new Date());
			let time_html = $('<div>', {
				html: '<strong>' + time_since(timestamp) + '</strong> ago'
			});
			time_html.addClass('time').attr('title', timestamp);
			if (settings.icon !== undefined) {
				time_html.appendTo(right);
			} else {
				time_html.appendTo(notification);
			}
			setInterval(function() {
				$('.time').each(function() {
					let timing = $(this).attr('title');
					$(this).html('<strong>' + time_since(timing) + '</strong> ago');
				});
			}, 4000);
		}
		notification.hover(function() {
			hide.show();
		}, function() {
			hide.hide();
		});
		notification.prependTo(container);
		notification.show();
		if (settings.timeout) {
			setTimeout(function() {
				notification.removeClass('noti-pop').addClass('noti-remove').delay(300).queue(function() {
					$(this).clearQueue();
					$(this).remove();
				});
			}, settings.timeout);
		}
		if (settings.click !== undefined) {
			notification.addClass('click');
			notification.click(function(event) {
				let target = $(event.target);
				if (!target.is('.hide')) {
					settings.click.call(this);
				}
			});
		}
		return this;
	};
})(jQuery);
