/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import apple.awt.CGraphicsEnvironment;
import apple.awt.ComponentModel;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.image.ColorModel;
import sun.awt.DisplayChangedListener;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.VolatileSurfaceManager;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLGraphicsConfig;
import sun.java2d.opengl.CGLSurfaceData;

public class CGLVolatileSurfaceManager
extends VolatileSurfaceManager
implements DisplayChangedListener {
    private boolean accelerationEnabled;

    public CGLVolatileSurfaceManager(SunVolatileImage sunVolatileImage, Object object) {
        super(sunVolatileImage, object);
        this.accelerationEnabled = sunVolatileImage.getTransparency() == 1;
        CGraphicsEnvironment cGraphicsEnvironment = (CGraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
        cGraphicsEnvironment.addDisplayChangedListener(this);
    }

    protected boolean isAccelerationEnabled() {
        return this.accelerationEnabled;
    }

    protected SurfaceData initAcceleratedSurface() {
        CGLSurfaceData.CGLOffScreenSurfaceData cGLOffScreenSurfaceData;
        Component component = this.vImg.getComponent();
        ComponentModel componentModel = component != null ? (ComponentModel)component.getPeer() : null;
        try {
            boolean bl = false;
            if (this.context instanceof Boolean) {
                bl = (Boolean)this.context;
            }
            if (bl) {
                cGLOffScreenSurfaceData = CGLSurfaceData.createData(componentModel, true);
            } else {
                CGLGraphicsConfig cGLGraphicsConfig = (CGLGraphicsConfig)this.vImg.getGraphicsConfig();
                ColorModel colorModel = cGLGraphicsConfig.getColorModel();
                cGLOffScreenSurfaceData = CGLSurfaceData.createData(cGLGraphicsConfig, this.vImg.getWidth(), this.vImg.getHeight(), colorModel, this.vImg, 3);
            }
        }
        catch (NullPointerException nullPointerException) {
            cGLOffScreenSurfaceData = null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            cGLOffScreenSurfaceData = null;
        }
        return cGLOffScreenSurfaceData;
    }

    protected boolean isConfigValid(GraphicsConfiguration graphicsConfiguration) {
        return graphicsConfiguration == null || graphicsConfiguration == this.vImg.getGraphicsConfig();
    }

    public void flush() {
        this.lostSurface = true;
        CGLSurfaceData cGLSurfaceData = (CGLSurfaceData)this.sdAccel;
        this.sdAccel = null;
        if (cGLSurfaceData != null) {
            cGLSurfaceData.flush();
        }
    }

    public void displayChanged() {
        if (!this.isAccelerationEnabled()) {
            return;
        }
        this.lostSurface = true;
        if (this.sdAccel != null) {
            this.sdBackup = null;
            this.sdCurrent = this.getBackupSurface();
            SurfaceData surfaceData = this.sdAccel;
            this.sdAccel = null;
            surfaceData.invalidate();
        }
        this.vImg.updateGraphicsConfig();
    }

    public void paletteChanged() {
        this.lostSurface = true;
    }

    public ImageCapabilities getCapabilities() {
        if (this.isAccelerationEnabled() && !(this.imageCaps instanceof CGLImageCaps)) {
            this.imageCaps = new CGLImageCaps();
        }
        return super.getCapabilities();
    }

    private class CGLImageCaps
    extends VolatileSurfaceManager.DefaultImageCapabilities {
        private CGLImageCaps() {
            super((VolatileSurfaceManager)CGLVolatileSurfaceManager.this);
        }

        public boolean isTrueVolatile() {
            return this.isAccelerated();
        }
    }
}

