/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.ComponentModel;
import apple.awt.OSXSurfaceData;
import apple.awt.StrategyBufferImage;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.peer.ContainerPeer;
import java.util.Vector;
import sun.awt.SunGraphicsCallback;
import sun.java2d.SurfaceData;

public abstract class ContainerModel
extends ComponentModel
implements ContainerPeer {
    private int isValidating = 0;
    Insets fInsets = new Insets(0, 0, 0, 0);
    StrategyBufferImage fStrategyBufferImage = null;

    ContainerModel(Component component) {
        super(component);
    }

    protected void initPeer() {
        super.initPeer();
    }

    void initContainer() {
        this.fNSView = -1L;
    }

    protected void disposeImpl() {
        super.disposeImpl();
    }

    public Rectangle getBounds() {
        return this.fTarget.getBounds();
    }

    public void print(Graphics graphics) {
        if (this.fTarget instanceof Container) {
            super.print(graphics);
            SunGraphicsCallback.PrintHeavyweightComponentsCallback.getInstance().runComponents(((Container)this.fTarget).getComponents(), graphics, 3);
        } else {
            this.fTarget.print(graphics);
        }
    }

    public ContainerModel(Container container) {
        super(container);
    }

    protected Rectangle getSurfaceBounds() {
        Rectangle rectangle = this.getBounds();
        return new Rectangle(this.getInsets().left, this.getInsets().top, rectangle.width - this.getInsets().left, rectangle.height - this.getInsets().top);
    }

    public Insets getInsets() {
        return this.fInsets;
    }

    public void beginValidate() {
        if (this.isValidating == 0) {
            this._beginValidate(this.fModelPtr);
        }
        ++this.isValidating;
    }

    private native void _beginValidate(long var1);

    public void endValidate() {
        --this.isValidating;
        if (this.isValidating == 0) {
            this._endValidate(this.fModelPtr);
        }
    }

    private native void _endValidate(long var1);

    public void cancelPendingPaint(int n, int n2, int n3, int n4) {
    }

    public boolean isRestackSupported() {
        return true;
    }

    public void restack() {
        Vector vector = new Vector();
        Container container = (Container)this.fTarget;
        this.restack(container, vector);
        if (vector.size() > 0) {
            this._restack(this.fModelPtr, vector.toArray());
        }
    }

    private void restack(Container container, Vector vector) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (!component.isLightweight() && component.getPeer() != null) {
                vector.add(component.getPeer());
            }
            if (!component.isLightweight() || !(component instanceof Container)) continue;
            this.restack((Container)component, vector);
        }
    }

    private native void _restack(long var1, Object[] var3);

    public Insets insets() {
        return this.getInsets();
    }

    public void setVisible(boolean bl) {
        SurfaceData surfaceData;
        if (!bl && (surfaceData = this.getSurface()) instanceof OSXSurfaceData) {
            ((OSXSurfaceData)this.getSurface()).clearLazyDrawing();
        }
        super.setVisible(bl);
    }

    public synchronized void createBuffers(int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (n < 1) {
            throw new IllegalStateException("Can not create less than 1 buffer");
        }
        if (n > 1) {
            this.destroyBuffers();
            this.fStrategyBufferImage = new StrategyBufferImage(this);
        }
    }

    public synchronized void destroyBuffers() {
        this.fStrategyBufferImage = null;
    }

    public Image getFrontBuffer() {
        if (this.fStrategyBufferImage == null) {
            try {
                this.createBuffers(2, null);
            }
            catch (AWTException aWTException) {
                System.err.println(aWTException);
                Thread.dumpStack();
            }
        }
        return this.fStrategyBufferImage;
    }

    public Image getBackBuffer() {
        return this.getFrontBuffer();
    }

    public synchronized void flip(BufferCapabilities.FlipContents flipContents) {
        this.fStrategyBufferImage.show();
    }
}

