/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.OSXOffScreenSurfaceData;
import java.awt.Canvas;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import sun.security.action.LoadLibraryAction;

public class CImage
extends BufferedImage {
    long fNSImage = 0L;

    public CImage(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public static CImage createImage(long l) {
        return CImage.createImage(l, CImage.width(l), CImage.height(l));
    }

    public static CImage createImage(long l, int n, int n2) {
        CImage cImage = new CImage(n, n2, 3);
        cImage.setNSImage(l);
        if (!GraphicsEnvironment.isHeadless()) {
            OSXOffScreenSurfaceData oSXOffScreenSurfaceData = (OSXOffScreenSurfaceData)OSXOffScreenSurfaceData.createData(cImage);
            oSXOffScreenSurfaceData.copyNSImagePixels(l);
        }
        return cImage;
    }

    public CImage(long l) {
        super(CImage.width(l), CImage.height(l), 3);
        this.setNSImage(l);
        OSXOffScreenSurfaceData oSXOffScreenSurfaceData = (OSXOffScreenSurfaceData)OSXOffScreenSurfaceData.createData(this);
        if (!GraphicsEnvironment.isHeadless()) {
            oSXOffScreenSurfaceData.copyNSImagePixels(l);
        }
    }

    private static native long icon(String var0);

    public static CImage createImage(String string) {
        return CImage.createImage(CImage.icon(string));
    }

    public static CImage createImage(String string, int n, int n2) {
        return CImage.createImage(CImage.icon(string), n, n2);
    }

    private static native long imageFromIconSelector(int var0);

    public static CImage createImage(int n) {
        return CImage.createImage(CImage.imageFromIconSelector(n));
    }

    public static CImage createImage(int n, int n2, int n3) {
        return CImage.createImage(CImage.imageFromIconSelector(n), n2, n3);
    }

    public static CImage createImage(Image image) {
        CImage cImage = null;
        if (image != null) {
            Canvas canvas = new Canvas();
            if (!(image instanceof BufferedImage)) {
                MediaTracker mediaTracker = new MediaTracker(canvas);
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("ImageTracker interrupted.");
                    Thread.dumpStack();
                    return cImage;
                }
            }
            int n = Math.max(image.getWidth(canvas), 1);
            int n2 = Math.max(image.getHeight(canvas), 1);
            cImage = new CImage(n, n2, 3);
            Graphics2D graphics2D = cImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, n, n2, null);
            graphics2D.dispose();
            cImage.setNSImage();
        }
        return cImage;
    }

    private static native int width(long var0);

    private static native int height(long var0);

    private synchronized void setNSImage(long l) {
        if (this.fNSImage != 0L) {
            this._release(this.fNSImage);
        }
        this.fNSImage = l;
    }

    private void setNSImage() {
        long l = this.makeNSImage(this);
        this.setNSImage(l);
    }

    private long makeNSImage(BufferedImage bufferedImage) {
        return OSXOffScreenSurfaceData.makeNSImage(bufferedImage);
    }

    public long getNSImage() {
        return this.fNSImage;
    }

    private native void _release(long var1);

    public synchronized void dispose() {
        if (this.fNSImage != 0L) {
            this._release(this.fNSImage);
            this.fNSImage = 0L;
        }
    }

    protected void finalize() {
        this.dispose();
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
    }
}

