/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CFontConfiguration;
import apple.awt.CGraphicsDevice;
import apple.awt.CPrinterJob;
import apple.awt.RuntimeOptions;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.awt.DisplayChangedListener;
import sun.awt.FontConfiguration;
import sun.awt.SunDisplayChanger;
import sun.awt.image.BufImgSurfaceData;
import sun.font.AppleNativeFont;
import sun.font.Font2D;
import sun.font.FontFamily;
import sun.font.FontManager;
import sun.java2d.SunGraphics2D;
import sun.java2d.SunGraphicsEnvironment;
import sun.java2d.SurfaceData;
import sun.security.action.LoadLibraryAction;

public class CGraphicsEnvironment
extends SunGraphicsEnvironment
implements DisplayChangedListener {
    SunDisplayChanger displayChanger = new SunDisplayChanger();
    Font sDefaultFont;
    static final int Renderer = RuntimeOptions.getCurrentOptions().Renderer;
    private SunDisplayChanger topLevels = new SunDisplayChanger();
    private Font[] allFontsWithLogical;
    static String[] sLogicalFonts;
    private boolean loadedFonts = false;
    Object waitForFontsToBeLoaded = new Object();

    protected native int getNumScreens();

    public synchronized GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[0];
    }

    public String getDefaultFontFaceName() {
        return "Lucida Grande";
    }

    public void displayChanged() {
        GraphicsDevice[] graphicsDeviceArray = this.resetDisplays();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            if (!(graphicsDeviceArray[i] instanceof CGraphicsDevice)) continue;
            ((CGraphicsDevice)graphicsDeviceArray[i]).displayChanged();
        }
        this.displayChanger.notifyListeners();
    }

    public void paletteChanged() {
        this.displayChanger.notifyPaletteChanged();
    }

    public synchronized GraphicsDevice[] resetDisplays() {
        GraphicsDevice[] graphicsDeviceArray = this.screens;
        return graphicsDeviceArray;
    }

    public void addDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.displayChanger.add(displayChangedListener);
    }

    public void removeDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.displayChanger.remove(displayChangedListener);
    }

    protected void registerFontsInDir(String string, boolean bl, int n, boolean bl2, boolean bl3) {
        this.loadNativeDirFonts(string);
        super.registerFontsInDir(string, bl, n, bl2, bl3);
    }

    private native void loadNativeDirFonts(String var1);

    private native void loadNativeFonts();

    void registerFont(String string, String string2, int n) {
        AppleNativeFont appleNativeFont = new AppleNativeFont(string, string2, n);
        FontManager.registerGenericFont((Font2D)appleNativeFont);
        if ((appleNativeFont.getStyle() & 2) == 0) {
            FontManager.registerGenericFont((Font2D)appleNativeFont.createItalicVariant(), (boolean)true);
        }
    }

    public Font[] getAllFonts() {
        if (this.allFontsWithLogical == null) {
            Font[] fontArray = super.getAllFonts();
            int n = sLogicalFonts.length;
            int n2 = fontArray.length;
            Font[] fontArray2 = new Font[n2 + n];
            System.arraycopy(fontArray, 0, fontArray2, n, n2);
            for (int i = 0; i < n; ++i) {
                Font font;
                fontArray2[i] = font = new Font(sLogicalFonts[i], 0, 1);
            }
            this.allFontsWithLogical = fontArray2;
        }
        return this.allFontsWithLogical;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFonts() {
        Object object = this.waitForFontsToBeLoaded;
        synchronized (object) {
            super.loadFonts();
            this.loadedFonts = true;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CGraphicsEnvironment.this.loadNativeFonts();
                    return null;
                }
            });
            String string = "Lucida Grande";
            String string2 = "Lucida Sans";
            this.setupLogicalFonts("Dialog", string, string2);
            this.setupLogicalFonts("Serif", "Times", "Lucida Bright");
            this.setupLogicalFonts("SansSerif", string, string2);
            this.setupLogicalFonts("Monospaced", "Courier", "Lucida Sans Typewriter");
            this.setupLogicalFonts("DialogInput", string, string2);
        }
    }

    protected void setupLogicalFonts(String string, String string2, String string3) {
        FontFamily fontFamily = this.getFontFamilyWithExtraTry(string, string2, string3);
        this.cloneStyledFont(fontFamily, string, 0);
        this.cloneStyledFont(fontFamily, string, 1);
        this.cloneStyledFont(fontFamily, string, 2);
        this.cloneStyledFont(fontFamily, string, 3);
    }

    protected FontFamily getFontFamilyWithExtraTry(String string, String string2, String string3) {
        FontFamily fontFamily = this.getFontFamily(string2, string3);
        if (fontFamily != null) {
            return fontFamily;
        }
        super.loadFonts();
        fontFamily = this.getFontFamily(string2, string3);
        if (fontFamily != null) {
            return fontFamily;
        }
        System.err.println("Warning: the fonts \"" + string2 + "\" and \"" + string3 + "\" are not available for the Java logical font \"" + string + "\", which may have unexpected appearance or behavior. Re-enable the \"" + string2 + "\" font to remove this warning.");
        return null;
    }

    protected FontFamily getFontFamily(String string, String string2) {
        FontFamily fontFamily = FontFamily.getFamily(string);
        if (fontFamily != null) {
            return fontFamily;
        }
        fontFamily = FontFamily.getFamily(string2);
        if (fontFamily != null) {
            System.err.println("Warning: the font \"" + string + "\" is not available, so \"" + string2 + "\" has been substituted, but may have unexpected appearance or behavor. Re-enable the \"" + string + "\" font to remove this warning.");
            return fontFamily;
        }
        return null;
    }

    protected boolean cloneStyledFont(FontFamily fontFamily, String string, int n) {
        boolean bl = false;
        if (fontFamily == null) {
            return bl;
        }
        Font2D font2D = fontFamily.getFontWithExactStyleMatch(n);
        if (font2D != null && font2D instanceof AppleNativeFont) {
            AppleNativeFont appleNativeFont = (AppleNativeFont)font2D;
            AppleNativeFont appleNativeFont2 = new AppleNativeFont(appleNativeFont.getPostscriptName(), string, appleNativeFont.getIndex(), n);
            Font2D font2D2 = FontManager.registerGenericFont((Font2D)appleNativeFont2, (boolean)true);
            bl = true;
        }
        return bl;
    }

    protected GraphicsDevice makeScreenDevice(int n) {
        return new CGraphicsDevice(n);
    }

    public PrinterJob getPrinterJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new CPrinterJob();
    }

    protected FontConfiguration createFontConfiguration() {
        if (Renderer == 1) {
            return new CFontConfiguration.Quartz(this);
        }
        return new CFontConfiguration.Other(this);
    }

    public FontConfiguration createFontConfiguration(boolean bl, boolean bl2) {
        if (Renderer == 1) {
            return new CFontConfiguration.Quartz(this, bl, bl2);
        }
        return new CFontConfiguration.Other(this, bl, bl2);
    }

    public Graphics2D createGraphics(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new NullPointerException("BufferedImage cannot be null");
        }
        SurfaceData surfaceData = BufImgSurfaceData.createData(bufferedImage);
        if (this.sDefaultFont == null) {
            this.sDefaultFont = new Font("Lucida Grande", 0, 13);
        }
        return new SunGraphics2D(surfaceData, Color.white, Color.black, this.sDefaultFont);
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        sLogicalFonts = new String[]{"Serif", "SansSerif", "Monospaced", "Dialog", "DialogInput"};
    }
}

