/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TooManyListenersException;

class SerialComm
implements SerialPortEventListener,
Runnable {
    public static final String PORT_OWER = "MonitorApp";
    private boolean isOpen;
    private boolean isStart;
    private boolean isSave;
    private boolean isPrint;
    private Thread readThread;
    private String portName;
    private String portAddress;
    private CommPortIdentifier portId;
    private SerialPort serialPort;
    private InputStream inputStream;
    private OutputStream outputStream;
    private SimpleDateFormat formatter;
    private String dataProtocol;

    public SerialComm() {
        ProcessBuilder pro = new ProcessBuilder("");
        this.isOpen = false;
        this.isStart = false;
        this.isSave = true;
        this.isPrint = false;
        this.formatter = new SimpleDateFormat("[yyyy-MM-dd hh:mm:ss,SSS]");
        this.portName = "COM1";
        this.portAddress = "LOCAL";
        this.dataProtocol = "Gooseli";
    }

    public void init(String port, String protocol) throws Exception {
        this.portAddress = this.portName = port;
        this.dataProtocol = protocol;
        this.init();
    }

    public void init(String port, String address, String protocol) throws Exception {
        this.portName = port;
        this.portAddress = address;
        this.dataProtocol = protocol;
        this.init();
    }

    public void init() throws IOException, Exception {
        if (this.isOpen) {
            this.close();
        }
        try {
            this.portId = CommPortIdentifier.getPortIdentifier(this.portName);
            this.serialPort = (SerialPort)this.portId.open(PORT_OWER, 2000);
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
            this.isOpen = true;
        }
        catch (NoSuchPortException ex) {
            throw new Exception(ex.toString());
        }
        catch (PortInUseException ex) {
            throw new Exception(ex.toString());
        }
    }

    public void start() throws Exception {
        if (!this.isOpen) {
            throw new Exception(String.valueOf(this.portName) + " has not been opened.");
        }
        try {
            this.readThread = new Thread(this);
            this.readThread.start();
            this.serialPort.notifyOnDataAvailable(true);
            this.serialPort.addEventListener(this);
            this.isStart = true;
        }
        catch (TooManyListenersException ex) {
            throw new Exception(ex.toString());
        }
    }

    public void run() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            System.out.println(ex.toString());
        }
        String strTemp = "AT+CGMM\r" + (char)Integer.parseInt("1a", 16) + "z";
        this.writeComm(strTemp);
        this.isPrint = true;
    }

    public void stop() {
        if (this.isStart) {
            this.serialPort.notifyOnDataAvailable(false);
            this.serialPort.removeEventListener();
            this.isStart = false;
        }
    }

    public void close() {
        this.stop();
        if (this.isOpen) {
            try {
                this.inputStream.close();
                this.outputStream.close();
                this.serialPort.close();
                this.isOpen = false;
            }
            catch (IOException ex) {
                System.out.println(ex.toString());
            }
        }
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                this.readComm();
                break;
            }
        }
    }

    public void readComm() {
        StringBuffer readBuffer = new StringBuffer();
        String scannedInput = "";
        Date currentTime = null;
        String TimeStamp = "";
        try {
            int c;
            while ((c = this.inputStream.read()) != 10) {
                readBuffer.append((char)c);
            }
            scannedInput = readBuffer.toString().trim();
            currentTime = new Date();
            if (this.isPrint) {
                TimeStamp = this.formatter.format(currentTime);
                System.out.println(String.valueOf(TimeStamp) + " - " + scannedInput);
            }
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void writeComm(String outString) {
        try {
            this.outputStream.write(outString.getBytes());
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
        }
    }

    public static void main(String[] args) {
        SerialComm serialcomm = new SerialComm();
        try {
            serialcomm.init("COM4", "Air");
            serialcomm.start();
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }
}

