/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import sun.font.AppleNativeFont;
import sun.font.Font2D;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.NativeStrikeDisposer;
import sun.font.StrikeCache;
import sun.font.StrikeMetrics;

public class AppleNativeStrike
extends FontStrike {
    private AppleNativeFont nativeFont;
    private AffineTransform invDevTx;
    private GlyphInfoCache glyphInfoCache;
    private GlyphAdvanceCache glyphAdvanceCache;

    AppleNativeStrike(AppleNativeFont appleNativeFont, FontStrikeDesc fontStrikeDesc) {
        this.nativeFont = appleNativeFont;
        this.desc = fontStrikeDesc;
        this.glyphInfoCache = new GlyphInfoCache(appleNativeFont, this.desc);
        this.glyphAdvanceCache = new GlyphAdvanceCache();
        this.disposer = this.glyphInfoCache;
        if (fontStrikeDesc.devTx != null && !fontStrikeDesc.devTx.isIdentity()) {
            try {
                this.invDevTx = fontStrikeDesc.devTx.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
    }

    public int getNumGlyphs() {
        return this.nativeFont.getNumGlyphs();
    }

    StrikeMetrics getFontMetrics() {
        if (this.strikeMetrics == null) {
            this.strikeMetrics = this.nativeFont.getFontMetrics();
            if (this.invDevTx != null) {
                this.strikeMetrics.convertToUserSpace(this.invDevTx);
            }
            this.strikeMetrics.convertToUserSpace(this.desc.glyphTx);
        }
        return this.strikeMetrics;
    }

    float getGlyphAdvance(int n) {
        return this.getScaledAdvanceForAdvance(this.getCachedNativeGlyphAdvance(n));
    }

    float getCodePointAdvance(int n) {
        float f = this.getCachedNativeGlyphAdvance(this.nativeFont.getMapper().charToGlyph(n));
        double d = this.desc.glyphTx.getScaleX();
        double d2 = this.desc.devTx.getScaleX();
        if (d2 == 0.0) {
            d = Math.sqrt(this.desc.glyphTx.getDeterminant());
            d2 = Math.sqrt(this.desc.devTx.getDeterminant());
        }
        if (d2 == 0.0) {
            d2 = Double.NaN;
        }
        f = (float)((double)f * d / d2);
        return this.desc.fmHint != 0 ? f : (float)Math.round(f);
    }

    private float getScaledAdvanceForAdvance(float f) {
        if (this.invDevTx != null) {
            f = (float)((double)f * this.invDevTx.getScaleX());
        }
        f = (float)((double)f * this.desc.glyphTx.getScaleX());
        return this.desc.fmHint != 0 ? f : (float)Math.round(f);
    }

    Point2D.Float getCharMetrics(char c) {
        return this.getScaledPointForAdvance(this.getCachedNativeGlyphAdvance(this.nativeFont.getMapper().charToGlyph(c)));
    }

    Point2D.Float getGlyphMetrics(int n) {
        return this.getScaledPointForAdvance(this.getCachedNativeGlyphAdvance(n));
    }

    private Point2D.Float getScaledPointForAdvance(float f) {
        Point2D.Float float_ = new Point2D.Float(f, 0.0f);
        if (!this.desc.glyphTx.isIdentity()) {
            return this.scalePoint(float_);
        }
        if (this.desc.fmHint == 0) {
            float_.x = Math.round(float_.x);
        }
        return float_;
    }

    private Point2D.Float scalePoint(Point2D.Float float_) {
        if (this.invDevTx != null) {
            this.invDevTx.transform(float_, float_);
        }
        this.desc.glyphTx.transform(float_, float_);
        if (this.desc.fmHint == 0) {
            float_.x = Math.round(float_.x);
            float_.y = Math.round(float_.y);
        }
        return float_;
    }

    Rectangle2D.Float getGlyphOutlineBounds(int n) {
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        this.getGlyphImageBounds(n, float_);
        return float_;
    }

    void getGlyphImageBounds(int n, Point2D.Float float_, Rectangle rectangle) {
        Rectangle2D.Float float_2 = new Rectangle2D.Float();
        this.getGlyphImageBounds(n, float_2);
        if (float_2.width == 0.0f && float_2.height == 0.0f) {
            rectangle.setRect(0.0, 0.0, -1.0, -1.0);
            return;
        }
        rectangle.setRect(float_2.x + float_.x, float_2.y + float_.y, float_2.width, float_2.height);
    }

    private void getGlyphImageBounds(int n, Rectangle2D.Float float_) {
        AffineTransform affineTransform = this.desc.glyphTx;
        this.getNativeGlyphImageBounds(this.nativeFont, n, float_, (float)affineTransform.getScaleX(), (float)affineTransform.getScaleY(), (float)affineTransform.getShearX(), (float)affineTransform.getShearY(), (float)affineTransform.getTranslateX(), (float)affineTransform.getTranslateY());
    }

    GeneralPath getGlyphOutline(int n, float f, float f2) {
        AffineTransform affineTransform = this.desc.glyphTx;
        return this.getNativeGlyphOutline(this.nativeFont, n, (float)affineTransform.getScaleX(), (float)affineTransform.getScaleY(), (float)affineTransform.getShearX(), (float)affineTransform.getShearY(), (float)affineTransform.getTranslateX(), (float)affineTransform.getTranslateY(), f, f2);
    }

    GeneralPath getGlyphVectorOutline(int[] nArray, float f, float f2) {
        throw new Error("not implemented yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getGlyphImagePtr(int n) {
        GlyphInfoCache glyphInfoCache = this.glyphInfoCache;
        synchronized (glyphInfoCache) {
            long l = this.glyphInfoCache.get(n);
            if (l != 0L) {
                return l;
            }
            long[] lArray = new long[1];
            int[] nArray = new int[]{n};
            this.getGlyphImagePtrs(nArray, lArray, 1);
            l = lArray[0];
            this.glyphInfoCache.put(n, l);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getGlyphImagePtrs(int[] nArray, long[] lArray, int n) {
        GlyphInfoCache glyphInfoCache = this.glyphInfoCache;
        synchronized (glyphInfoCache) {
            int n2;
            int n3;
            int n4 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                int n5 = nArray[i];
                long l = this.glyphInfoCache.get(n5);
                if (l != 0L) {
                    lArray[i] = l;
                    continue;
                }
                lArray[i] = 0L;
                ++n4;
            }
            if (n4 == 0) {
                return;
            }
            int[] nArray2 = new int[n4];
            int[] nArray3 = new int[n4];
            int n6 = 0;
            int n7 = 0;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (lArray[n3] != 0L) continue;
                int n8 = nArray[n3];
                if (this.glyphInfoCache.get(n8) == -1L) {
                    nArray3[n6] = -1;
                    ++n7;
                    ++n6;
                    continue;
                }
                n2 = n6 - n7;
                nArray2[n2] = n8;
                this.glyphInfoCache.put(n8, -1L);
                nArray3[n6] = n2;
                ++n6;
            }
            n3 = n6 - n7;
            long[] lArray2 = new long[n3];
            this.getFilteredGlyphImagePtrs(lArray2, nArray2, n3);
            n6 = 0;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (lArray[n2] != 0L && lArray[n2] != -1L) continue;
                int n9 = nArray3[n6];
                int n10 = nArray[n2];
                if ((long)n9 == -1L) {
                    lArray[n2] = this.glyphInfoCache.get(n10);
                } else {
                    long l;
                    lArray[n2] = l = lArray2[n9];
                    this.glyphInfoCache.put(n10, l);
                }
                ++n6;
            }
        }
    }

    private float[] getGlyphTx() {
        return new float[]{(float)this.desc.glyphTx.getScaleX(), (float)this.desc.glyphTx.getScaleY(), (float)this.desc.glyphTx.getShearX(), (float)this.desc.glyphTx.getShearY(), (float)this.desc.glyphTx.getTranslateX(), (float)this.desc.glyphTx.getTranslateY()};
    }

    private void getFilteredGlyphImagePtrs(long[] lArray, int[] nArray, int n) {
        this.getGlyphImagePtrsNative(this.nativeFont, this.getGlyphTx(), this.desc.aaHint != 0, this.desc.fmHint != 0, lArray, nArray, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getCachedNativeGlyphAdvance(int n) {
        GlyphAdvanceCache glyphAdvanceCache = this.glyphAdvanceCache;
        synchronized (glyphAdvanceCache) {
            float f = this.glyphAdvanceCache.get(n);
            if (f != 0.0f) {
                return f;
            }
            f = this.getNativeGlyphAdvance(this.nativeFont, n);
            this.glyphAdvanceCache.put(n, f);
            return f;
        }
    }

    private native void getGlyphImagePtrsNative(AppleNativeFont var1, float[] var2, boolean var3, boolean var4, long[] var5, int[] var6, int var7);

    private native float getNativeGlyphAdvance(AppleNativeFont var1, int var2);

    private native float getNativeCTCodePointAdvance(AppleNativeFont var1, int var2);

    private native GeneralPath getNativeGlyphOutline(AppleNativeFont var1, int var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10);

    private native void getNativeGlyphImageBounds(AppleNativeFont var1, int var2, Rectangle2D.Float var3, float var4, float var5, float var6, float var7, float var8, float var9);

    private static class GlyphAdvanceCache {
        private static final int FIRST_LAYER_SIZE = 256;
        private static final int SECOND_LAYER_SIZE = 16384;
        private final float[] firstLayerCache = new float[256];
        private SparseBitShiftingTwoLayerArray secondLayerCache;
        private HashMap<Integer, Float> generalCache;

        private GlyphAdvanceCache() {
        }

        public synchronized float get(int n) {
            if (n < 0) {
                if (-n < 16384) {
                    if (this.secondLayerCache == null) {
                        return 0.0f;
                    }
                    return this.secondLayerCache.get(-n);
                }
            } else if (n < 256) {
                return this.firstLayerCache[n];
            }
            if (this.generalCache == null) {
                return 0.0f;
            }
            Float f = this.generalCache.get(new Integer(n));
            if (f == null) {
                return 0.0f;
            }
            return f.floatValue();
        }

        public synchronized void put(int n, float f) {
            if (n < 0) {
                if (-n < 16384) {
                    if (this.secondLayerCache == null) {
                        this.secondLayerCache = new SparseBitShiftingTwoLayerArray(16384, 7);
                    }
                    this.secondLayerCache.put(-n, f);
                    return;
                }
            } else if (n < 256) {
                this.firstLayerCache[n] = f;
                return;
            }
            if (this.generalCache == null) {
                this.generalCache = new HashMap();
            }
            this.generalCache.put(new Integer(n), new Float(f));
        }

        private static class SparseBitShiftingTwoLayerArray {
            final float[][] cache;
            final int shift;
            final int secondLayerLength;

            public SparseBitShiftingTwoLayerArray(int n, int n2) {
                this.shift = n2;
                this.cache = new float[1 << n2][];
                this.secondLayerLength = n >> n2;
            }

            public float get(int n) {
                int n2 = n >> this.shift;
                float[] fArray = this.cache[n2];
                if (fArray == null) {
                    return 0.0f;
                }
                return fArray[n - n2 * (1 << this.shift)];
            }

            public void put(int n, float f) {
                int n2 = n >> this.shift;
                float[] fArray = this.cache[n2];
                if (fArray == null) {
                    fArray = new float[this.secondLayerLength];
                    this.cache[n2] = fArray;
                }
                fArray[n - n2 * (1 << this.shift)] = f;
            }
        }
    }

    private static class GlyphInfoCache
    extends NativeStrikeDisposer {
        private static final int FIRST_LAYER_SIZE = 256;
        private static final int SECOND_LAYER_SIZE = 16384;
        private final long[] firstLayerCache = new long[256];
        private SparseBitShiftingTwoLayerArray secondLayerCache;
        private HashMap<Integer, Long> generalCache;

        public GlyphInfoCache(Font2D font2D, FontStrikeDesc fontStrikeDesc) {
            super(font2D, fontStrikeDesc);
        }

        public synchronized long get(int n) {
            if (n < 0) {
                if (-n < 16384) {
                    if (this.secondLayerCache == null) {
                        return 0L;
                    }
                    return this.secondLayerCache.get(-n);
                }
            } else if (n < 256) {
                return this.firstLayerCache[n];
            }
            if (this.generalCache == null) {
                return 0L;
            }
            Long l = this.generalCache.get(new Integer(n));
            if (l == null) {
                return 0L;
            }
            return l;
        }

        public synchronized void put(int n, long l) {
            if (n < 0) {
                if (-n < 16384) {
                    if (this.secondLayerCache == null) {
                        this.secondLayerCache = new SparseBitShiftingTwoLayerArray(16384, 7);
                    }
                    this.secondLayerCache.put(-n, l);
                    return;
                }
            } else if (n < 256) {
                this.firstLayerCache[n] = l;
                return;
            }
            if (this.generalCache == null) {
                this.generalCache = new HashMap();
            }
            this.generalCache.put(new Integer(n), new Long(l));
        }

        public synchronized void dispose() {
            Object object;
            super.dispose();
            GlyphInfoCache.disposeLongArray(this.firstLayerCache);
            if (this.secondLayerCache != null) {
                object = this.secondLayerCache.cache;
                for (int i = 0; i < ((long[][])object).length; ++i) {
                    Object object2 = object[i];
                    if (object2 == null) continue;
                    GlyphInfoCache.disposeLongArray((long[])object2);
                }
            }
            if (this.generalCache != null) {
                object = this.generalCache.values().iterator();
                while (object.hasNext()) {
                    StrikeCache.freeLongPointer((Long)object.next());
                }
            }
        }

        private static void disposeLongArray(long[] lArray) {
            for (int i = 0; i < lArray.length; ++i) {
                long l = lArray[i];
                if (l == 0L) continue;
                StrikeCache.freeLongPointer(l);
            }
        }

        private static class SparseBitShiftingTwoLayerArray {
            final long[][] cache;
            final int shift;
            final int secondLayerLength;

            public SparseBitShiftingTwoLayerArray(int n, int n2) {
                this.shift = n2;
                this.cache = new long[1 << n2][];
                this.secondLayerLength = n >> n2;
            }

            public long get(int n) {
                int n2 = n >> this.shift;
                long[] lArray = this.cache[n2];
                if (lArray == null) {
                    return 0L;
                }
                return lArray[n - n2 * (1 << this.shift)];
            }

            public void put(int n, long l) {
                int n2 = n >> this.shift;
                long[] lArray = this.cache[n2];
                if (lArray == null) {
                    lArray = new long[this.secondLayerLength];
                    this.cache[n2] = lArray;
                }
                lArray[n - n2 * (1 << this.shift)] = l;
            }
        }
    }
}

