/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.util.HashMap;
import sun.font.AppleNativeFont;
import sun.font.CharToGlyphMapper;

public class AppleNativeCharToGlyphMapper
extends CharToGlyphMapper {
    private Cache cache = new Cache();
    AppleNativeFont fFont;
    int numGlyphs = -1;

    public AppleNativeCharToGlyphMapper(AppleNativeFont appleNativeFont) {
        this.fFont = appleNativeFont;
        this.missingGlyph = 0;
    }

    public int getNumGlyphs() {
        if (this.numGlyphs == -1) {
            this.numGlyphs = this.fFont.getNumGlyphs();
        }
        return this.numGlyphs;
    }

    public boolean canDisplay(char c) {
        int n = this.charToGlyph(c);
        return n != this.missingGlyph;
    }

    public boolean canDisplay(int n) {
        int n2 = this.charToGlyph(n);
        return n2 != this.missingGlyph;
    }

    public synchronized boolean charsToGlyphsNS(int n, char[] cArray, int[] nArray) {
        this.charsToGlyphs(n, cArray, nArray);
        return false;
    }

    public synchronized int charToGlyph(char c) {
        int n = this.cache.get(c);
        if (n != 0) {
            return n;
        }
        char[] cArray = new char[]{c};
        int[] nArray = new int[1];
        this.nativeCharsToGlyphs(this.fFont, 1, cArray, nArray);
        this.cache.put(c, nArray[0]);
        return nArray[0];
    }

    public synchronized int charToGlyph(int n) {
        return this.charToGlyph((char)n);
    }

    public synchronized void charsToGlyphs(int n, char[] cArray, int[] nArray) {
        this.cache.get(n, cArray, nArray);
    }

    public synchronized void charsToGlyphs(int n, int[] nArray, int[] nArray2) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)nArray[i];
        }
        this.cache.get(n, cArray, nArray2);
    }

    native void nativeCharsToGlyphs(AppleNativeFont var1, int var2, int[] var3, int[] var4);

    native void nativeCharsToGlyphs(AppleNativeFont var1, int var2, char[] var3, int[] var4);

    private class Cache {
        private static final int FIRST_LAYER_SIZE = 256;
        private static final int SECOND_LAYER_SIZE = 16384;
        private final int[] firstLayerCache = new int[256];
        private SparseBitShiftingTwoLayerArray secondLayerCache;
        private HashMap<Integer, Integer> generalCache;

        private Cache() {
        }

        public int get(char c) {
            if (c < '\u0100') {
                return this.firstLayerCache[c];
            }
            if (c < '\u4000') {
                if (this.secondLayerCache == null) {
                    return 0;
                }
                return this.secondLayerCache.get(c);
            }
            if (this.generalCache == null) {
                return 0;
            }
            Integer n = this.generalCache.get(new Integer(c));
            if (n == null) {
                return 0;
            }
            return n;
        }

        public void put(char c, int n) {
            if (c < '\u0100') {
                this.firstLayerCache[c] = n;
                return;
            }
            if (c < '\u4000') {
                if (this.secondLayerCache == null) {
                    this.secondLayerCache = new SparseBitShiftingTwoLayerArray(16384, 7);
                }
                this.secondLayerCache.put(c, n);
                return;
            }
            if (this.generalCache == null) {
                this.generalCache = new HashMap();
            }
            this.generalCache.put(new Integer(c), new Integer(n));
        }

        public void get(int n, char[] cArray, int[] nArray) {
            int n2;
            int n3;
            int n4;
            int n5 = 0;
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                n4 = this.get(c);
                if (n4 != 0) {
                    nArray[i] = n4;
                    continue;
                }
                nArray[i] = 0;
                ++n5;
            }
            if (n5 == 0) {
                return;
            }
            char[] cArray2 = new char[n5];
            int[] nArray2 = new int[n5];
            n4 = 0;
            int n6 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                if ((long)nArray[n3] != 0L) continue;
                char c = cArray[n3];
                if (this.get(c) == -1) {
                    nArray2[n4] = -1;
                    ++n6;
                    ++n4;
                    continue;
                }
                n2 = n4 - n6;
                cArray2[n2] = c;
                this.put(c, -1);
                nArray2[n4] = n2;
                ++n4;
            }
            n3 = n4 - n6;
            int[] nArray3 = new int[n3];
            AppleNativeCharToGlyphMapper.this.nativeCharsToGlyphs(AppleNativeCharToGlyphMapper.this.fFont, n3, cArray2, nArray3);
            n4 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                if ((long)nArray[n2] != 0L && (long)nArray[n2] != -1L) continue;
                int n7 = nArray2[n4];
                char c = cArray[n2];
                if ((long)n7 == -1L) {
                    nArray[n2] = this.get(c);
                } else {
                    int n8;
                    nArray[n2] = n8 = nArray3[n7];
                    this.put(c, n8);
                }
                ++n4;
            }
        }

        private class SparseBitShiftingTwoLayerArray {
            final int[][] cache;
            final int shift;
            final int secondLayerLength;

            public SparseBitShiftingTwoLayerArray(int n, int n2) {
                this.shift = n2;
                this.cache = new int[1 << n2][];
                this.secondLayerLength = n >> n2;
            }

            public int get(char c) {
                int n = c >> this.shift;
                int[] nArray = this.cache[n];
                if (nArray == null) {
                    return 0;
                }
                return nArray[c - n * (1 << this.shift)];
            }

            public void put(char c, int n) {
                int n2 = c >> this.shift;
                int[] nArray = this.cache[n2];
                if (nArray == null) {
                    nArray = new int[this.secondLayerLength];
                    this.cache[n2] = nArray;
                }
                nArray[c - n2 * (1 << this.shift)] = n;
            }
        }
    }
}

