/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.tiff;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.SurfaceData;

public class TIFFImageReader
extends ImageReader {
    static final boolean DEBUG = false;
    long nativeChunk;
    long decoder;
    static final int fChunkSize = 16384;
    static final int kPixelsWide = 0;
    static final int kPixelsHigh = 1;
    static final int kAlphaInfo = 2;
    static final int kBitsPerComponent = 3;
    static final int kBitsPerPixel = 4;
    static final int kBytesPerRow = 5;
    static final int kLastFrameInfoIndex = 6;
    BufferedImage[] frames;
    ByteBuffer[] framesInfo;
    int nrOfFrames;

    public TIFFImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
        this.reset();
    }

    public int getNumImages(boolean bl) throws IOException {
        if (this.nrOfFrames == 0) {
            this.initDecoder();
            this.nrOfFrames = this.getNumberOfFrames(this.decoder);
        }
        return this.nrOfFrames;
    }

    public int getWidth(int n) throws IOException {
        this.initImageInfo(n);
        IntBuffer intBuffer = this.framesInfo[n].asIntBuffer();
        return intBuffer.get(0);
    }

    public int getHeight(int n) throws IOException {
        this.initImageInfo(n);
        IntBuffer intBuffer = this.framesInfo[n].asIntBuffer();
        return intBuffer.get(1);
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.initImageInfo(n);
        IntBuffer intBuffer = this.framesInfo[n].asIntBuffer();
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(3));
        return arrayList.iterator();
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        return null;
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.initImageInfo(n);
        if (this.frames == null) {
            this.frames = new BufferedImage[this.nrOfFrames];
        }
        if (this.frames[n] == null) {
            IntBuffer intBuffer = this.framesInfo[n].asIntBuffer();
            this.frames[n] = TIFFImageReader.getDestination(this.getDefaultReadParam(), this.getImageTypes(n), intBuffer.get(0), intBuffer.get(1));
            Graphics2D graphics2D = this.frames[n].createGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, intBuffer.get(0), intBuffer.get(1));
            graphics2D.dispose();
            this.decodeFrameBytes(this.decoder, n, BufImgSurfaceData.createData(this.frames[n]));
        }
        return this.frames[n];
    }

    void initDecoder() throws IOException {
        if (this.input == null) {
            throw new IllegalStateException("input not set");
        }
        if (this.decoder == 0L) {
            try {
                ImageInputStream imageInputStream = (ImageInputStream)this.input;
                imageInputStream.mark();
                byte[] byArray = new byte[16384];
                boolean bl = false;
                while (!bl) {
                    try {
                        imageInputStream.readFully(byArray);
                    }
                    catch (EOFException eOFException) {
                        bl = true;
                    }
                    this.nativeChunk = this.addChunk(this.nativeChunk, byArray);
                }
                imageInputStream.reset();
            }
            catch (IOException iOException) {
                throw new IIOException(iOException.getMessage());
            }
            this.decoder = this.createNativeDecoder(this.nativeChunk);
        }
    }

    void initImageInfo(int n) throws IOException {
        if (this.nrOfFrames == 0) {
            this.getNumImages(true);
        }
        if (n < 0 || n >= this.nrOfFrames) {
            throw new IndexOutOfBoundsException("index out of range");
        }
        if (this.framesInfo == null) {
            this.framesInfo = new ByteBuffer[this.nrOfFrames];
        }
        if (this.framesInfo[n] == null) {
            this.framesInfo[n] = TIFFImageReader.getBufferOfSize(24);
            this.getFrameInfo(this.decoder, n, this.framesInfo[n]);
        }
    }

    public void dispose() {
        this.reset();
    }

    public synchronized void reset() {
        int n;
        super.reset();
        if (this.decoder != 0L) {
            this.decoder = this.releaseNativeDecoder(this.nativeChunk, this.decoder);
        }
        if (this.frames != null) {
            for (n = 0; n < this.frames.length; ++n) {
                this.frames[n] = null;
            }
        }
        if (this.framesInfo != null) {
            for (n = 0; n < this.framesInfo.length; ++n) {
                this.framesInfo[n] = null;
            }
        }
        this.nativeChunk = 0L;
        this.decoder = 0L;
        this.frames = null;
        this.framesInfo = null;
        this.nrOfFrames = 0;
    }

    static ByteBuffer getBufferOfSize(int n) {
        return TIFFImageReader.getBufferOfSize(n, ByteOrder.nativeOrder());
    }

    static ByteBuffer getBufferOfSize(int n, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.order(byteOrder);
        return byteBuffer;
    }

    private native long addChunk(long var1, byte[] var3);

    private native long createNativeDecoder(long var1);

    private native long releaseNativeDecoder(long var1, long var3);

    private native int getNumberOfFrames(long var1);

    private native void getFrameInfo(long var1, int var3, ByteBuffer var4);

    private native void decodeFrameBytes(long var1, int var3, SurfaceData var4);
}

