/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CToolkit;
import apple.awt.OSXSurfaceData;
import apple.awt.RuntimeOptions;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.nio.CharBuffer;
import sun.awt.SunHints;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.pipe.TextPipe;

public class CTextPipe
implements TextPipe {
    static final boolean sRenderString;
    static final boolean sRenderGlyphs;
    static final boolean sRenderUnicodes;

    static native void init(boolean var0);

    void drawGlyphVectorAsShape(SunGraphics2D sunGraphics2D, GlyphVector glyphVector, float f, float f2) {
        assert (CToolkit.stdio("CTextPipe.drawGlyphVectorAsShape"));
        FontRenderContext fontRenderContext = sunGraphics2D.getFontRenderContext();
        Font font = sunGraphics2D.getFont();
        int n = glyphVector.getNumGlyphs();
        for (int i = 0; i < n; ++i) {
            Shape shape = glyphVector.getGlyphOutline(i, f, f2);
            sunGraphics2D.fill(shape);
        }
    }

    void drawTextAsShape(SunGraphics2D sunGraphics2D, String string, double d, double d2) {
        assert (CToolkit.stdio("CTextPipe.drawTextAsShape"));
        Object object = sunGraphics2D.getRenderingHint(SunHints.KEY_ANTIALIASING);
        FontRenderContext fontRenderContext = sunGraphics2D.getFontRenderContext();
        sunGraphics2D.setRenderingHint(SunHints.KEY_ANTIALIASING, fontRenderContext.isAntiAliased() ? SunHints.VALUE_ANTIALIAS_ON : SunHints.VALUE_ANTIALIAS_OFF);
        Font font = sunGraphics2D.getFont();
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
        int n = glyphVector.getNumGlyphs();
        for (int i = 0; i < n; ++i) {
            Shape shape = glyphVector.getGlyphOutline(i, (float)d, (float)d2);
            sunGraphics2D.fill(shape);
        }
        sunGraphics2D.setRenderingHint(SunHints.KEY_ANTIALIASING, object);
    }

    native void doDrawString(SurfaceData var1, String var2, double var3, double var5);

    public void drawBytes(SunGraphics2D sunGraphics2D, byte[] byArray, int n, int n2, int n3, int n4) {
        this.drawString(sunGraphics2D, new String(byArray, n, n2), n3, n4);
    }

    public void drawString(SunGraphics2D sunGraphics2D, String string, double d, double d2) {
        assert (CToolkit.stdio("CTextPipe.drawString:" + sunGraphics2D.getFont()));
        if (!sRenderString) {
            return;
        }
        OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
        if (OSXSurfaceData.IsSimpleColor(sunGraphics2D.paint)) {
            oSXSurfaceData.drawString(this, sunGraphics2D, string, d, d2);
        } else {
            this.drawTextAsShape(sunGraphics2D, string, d, d2);
        }
    }

    native void doDrawGlyphs(SurfaceData var1, GlyphVector var2, float var3, float var4);

    public void drawGlyphVector(SunGraphics2D sunGraphics2D, GlyphVector glyphVector, float f, float f2) {
        assert (CToolkit.stdio("CTextPipe.drawGlyphVector:" + sunGraphics2D.getFont()));
        if (!sRenderGlyphs) {
            return;
        }
        OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
        if (OSXSurfaceData.IsSimpleColor(sunGraphics2D.paint)) {
            oSXSurfaceData.drawGlyphs(this, sunGraphics2D, glyphVector, f, f2);
        } else {
            this.drawGlyphVectorAsShape(sunGraphics2D, glyphVector, f, f2);
        }
    }

    native void doUnicodes(SurfaceData var1, char[] var2, int var3, int var4, float var5, float var6);

    native void doOneUnicode(SurfaceData var1, char var2, float var3, float var4);

    public void drawChars(SunGraphics2D sunGraphics2D, char[] cArray, int n, int n2, int n3, int n4) {
        assert (CToolkit.stdio("CTextPipe.drawChars:" + sunGraphics2D.getFont()));
        if (!sRenderUnicodes) {
            return;
        }
        if (n2 <= 0 || cArray == null) {
            return;
        }
        OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
        if (OSXSurfaceData.IsSimpleColor(sunGraphics2D.paint)) {
            oSXSurfaceData.drawUnicodes(this, sunGraphics2D, cArray, n, n2, n3, n4);
        } else {
            this.drawTextAsShape(sunGraphics2D, new String(cArray, n, n2), n3, n4);
        }
    }

    native void doDrawDirectByteBuffer(SurfaceData var1, CharBuffer var2, int var3, float var4, float var5);

    public CTextPipe traceWrap() {
        return new Tracer();
    }

    static {
        RuntimeOptions runtimeOptions = RuntimeOptions.getCurrentOptions();
        sRenderString = runtimeOptions.RenderString;
        sRenderGlyphs = runtimeOptions.RenderGlyphs;
        sRenderUnicodes = runtimeOptions.RenderUnicodes;
        CTextPipe.init(runtimeOptions.AlwaysUseCoreText);
    }

    public static class Tracer
    extends CTextPipe {
        void doDrawString(SurfaceData surfaceData, String string, float f, float f2) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawString");
            super.doDrawString(surfaceData, string, f, f2);
        }

        void doDrawGlyphs(SurfaceData surfaceData, GlyphVector glyphVector, float f, float f2) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawGlyphs");
            super.doDrawGlyphs(surfaceData, glyphVector, f, f2);
        }

        void doUnicodes(SurfaceData surfaceData, char[] cArray, int n, int n2, float f, float f2) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawUnicodes");
            super.doUnicodes(surfaceData, cArray, n, n2, f, f2);
        }

        void doOneUnicode(SurfaceData surfaceData, char c, float f, float f2) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawUnicode");
            super.doOneUnicode(surfaceData, c, f, f2);
        }

        void doDrawDirectByteBuffer(SurfaceData surfaceData, CharBuffer charBuffer, int n, float f, float f2) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawBytes");
            super.doDrawDirectByteBuffer(surfaceData, charBuffer, n, f, f2);
        }
    }
}

