/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import sun.awt.SunToolkit;

public final class CGlobalCursorManager {
    private static CGlobalCursorManager manager;
    private final NativeUpdater nativeUpdater = new NativeUpdater();
    private long lastUpdateMillis;
    private final Object lastUpdateLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCursorImmediately() {
        NativeUpdater nativeUpdater = this.nativeUpdater;
        synchronized (nativeUpdater) {
            this.nativeUpdater.pending = false;
        }
        this._updateCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCursorImmediately(InputEvent inputEvent) {
        boolean bl;
        Object object = this.lastUpdateLock;
        synchronized (object) {
            bl = inputEvent.getWhen() >= this.lastUpdateMillis;
        }
        if (bl) {
            this._updateCursor();
        }
    }

    public void updateCursorLater(Component component) {
        this.nativeUpdater.postIfNotPending(component, new InvocationEvent((Object)Toolkit.getDefaultToolkit(), this.nativeUpdater));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateCursor() {
        Object object = this.lastUpdateLock;
        synchronized (object) {
            this.lastUpdateMillis = System.currentTimeMillis();
        }
        object = null;
        Point point = null;
        try {
            Component component = this.findHeavyweightUnderCursor();
            if (component == null) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            if (component instanceof Window) {
                point = component.getLocation();
            } else if (component instanceof Container && component.isVisible()) {
                point = this.getLocationOnScreen(component);
            }
            if (point != null) {
                object = new Point();
                this.getCursorPos((Point)object);
                Component component2 = this.findComponentAt((Container)component, ((Point)object).x - point.x, ((Point)object).y - point.y);
                if (component2 != null) {
                    component = component2;
                }
            }
            this.setCursor(component.getCursor());
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    public static CGlobalCursorManager getCursorManager() {
        if (manager == null) {
            manager = new CGlobalCursorManager();
        }
        return manager;
    }

    public static void nativeUpdateCursor(Component component) {
        if (component != null) {
            CGlobalCursorManager.getCursorManager().updateCursorLater(component);
        }
    }

    protected native void setCursor(Cursor var1);

    protected native void getCursorPos(Point var1);

    protected native Component findComponentAt(Container var1, int var2, int var3);

    protected native Component findHeavyweightUnderCursor();

    protected native Point getLocationOnScreen(Component var1);

    class NativeUpdater
    implements Runnable {
        boolean pending = false;

        NativeUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = false;
            NativeUpdater nativeUpdater = this;
            synchronized (nativeUpdater) {
                if (this.pending) {
                    this.pending = false;
                    bl = true;
                }
            }
            if (bl) {
                CGlobalCursorManager.this._updateCursor();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postIfNotPending(Component component, InvocationEvent invocationEvent) {
            boolean bl = false;
            NativeUpdater nativeUpdater = this;
            synchronized (nativeUpdater) {
                if (!this.pending) {
                    bl = true;
                    this.pending = true;
                }
            }
            if (bl) {
                SunToolkit.postEvent(SunToolkit.targetToAppContext(component), invocationEvent);
            }
        }
    }
}

