/*
 * Decompiled with CFR 0.152.
 */
package net.contentobjects.jnotify;

import net.contentobjects.jnotify.IJNotify;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;

public class JNotify {
    public static final int FILE_CREATED = 1;
    public static final int FILE_DELETED = 2;
    public static final int FILE_MODIFIED = 4;
    public static final int FILE_RENAMED = 8;
    public static final int FILE_ANY = 15;
    private static IJNotify _instance;

    public static int addWatch(String path, int mask, boolean watchSubtree, JNotifyListener listener) throws JNotifyException {
        return _instance.addWatch(path, mask, watchSubtree, listener);
    }

    public static boolean removeWatch(int watchId) throws JNotifyException {
        return _instance.removeWatch(watchId);
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.equals("linux")) {
            try {
                _instance = (IJNotify)Class.forName("net.contentobjects.jnotify.linux.JNotifyAdapterLinux").newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (osName.startsWith("windows")) {
            try {
                _instance = (IJNotify)Class.forName("net.contentobjects.jnotify.win32.JNotifyAdapterWin32").newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("Unsupported OS : " + osName);
        }
    }
}

