/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.onlineupdate.ui;

import com.huawei.mobilePartner.business.apn.InitializationAPN;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.config.bean.CustomizeBean;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.gui.ui.APNPasswordDocumentListener;
import com.huawei.mobilePartner.gui.ui.APNPasswordField;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.gui.ui.GetButtonBackground;
import com.huawei.mobilePartner.onlineupdate.logic.HttpTest;
import com.huawei.mobilePartner.onlineupdate.logic.TextUtil;
import com.huawei.mobilePartner.onlineupdate.logic.XMLTool;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class UpdateConfigPanel
extends JPanel {
    private static final String UPDATE_CONFIG_PATH = String.valueOf(System.getProperty("user.dir")) + "/config/onlineupdate/UpdateConfig.xml";
    private static final String[] updateCheckPeriods = new String[]{"1", "7", "14", "30"};
    private static final long serialVersionUID = 1L;
    private static final String COMMAND_USE_NO_PROXY = "useNoProxy";
    private static final String COMMAND_USE_IE_PROXY = "useIEProxy";
    private static final String COMMAND_USE_SELF_DEFINED_PROXY = "useSelfDefinedProxy";
    private static final String COMMAND_DISABLE_AUTO_CHECK = "disableAutoUpdate";
    private static final String COMMAND_ENABLE_AUTO_CHECK = "enableAutoUpdate";
    private static final String AUTO_UPDATE_CONFIG_NODE_PATH = "UpdateConfig/AutoRun/AutoCheck";
    private static final String AUTO_UPDATE_PERIOD_NODE_PATH = "UpdateConfig/AutoRun/Cycle";
    private static final String PROXY_USE_PROXY_NODE_PATH = "UpdateConfig/ProxyInfo/UseProxy";
    private static final String PROXY_ANONYMITY_FLAG_NODE_PATH = "UpdateConfig/ProxyInfo/AnonymityFlag";
    private static final String PROXY_IP_ADDRESS_NODE_PATH = "UpdateConfig/ProxyInfo/IPAddress";
    private static final String PROXY_PORT_NODE_PATH = "UpdateConfig/ProxyInfo/Port";
    private static final String PROXY_USER_NAME_NODE_PATH = "UpdateConfig/ProxyInfo/UserName";
    private static final String PROXY_PASSWORD_NODE_PATH = "UpdateConfig/ProxyInfo/Password";
    private static final int CONFIG_USE_NO_PROXY = 0;
    private static final int CONFIG_USE_SELF_DEFINED_PROXY = 1;
    private static final int CONFIG_USE_IE_PROXY = 2;
    private static final int CONFIG_DISABLE_AUTO_CHECK = 0;
    private static final int CONFIG_ENABLE_AUTO_CHECK = 1;
    private static final int CONFIG_ANONYMITY = 1;
    private static final int CONFIG_NONE_ANONYMITY = 0;
    private static final int MAX_PASSWORD_LENGTH = 48;
    private String path = "";
    private XMLTool xmltool = null;
    private CustomizeBean cb = CustomizeInit.getCustomizeBean();
    private LanguageBean lb = CustomizeInit.getLanguageBean();
    private AppFrame appFrame = AppFrame.getAppFrameInit();
    private String testNoteStatus = "";
    public LogConfig log = null;
    private JPanel MainPanel;
    private JButton btnCancel;
    private JButton btnOK;
    private JButton btnTest;
    private JCheckBox cbProxySetting;
    private JComboBox cmbAutoCheckDays;
    private JPanel jPanel;
    private JLabel lblAddress;
    private JLabel lblDays;
    private JLabel lblPassword;
    private JLabel lblPort;
    private JLabel lblTestNote;
    private JLabel lblUserName;
    private JPanel panelAutoUpdate;
    private JPanel panelConnectConfig;
    private JPanel panelPicture;
    private JPanel panelButton;
    private JRadioButton rbDisableAutoUpdate;
    private JRadioButton rbEnableAutoUpdate;
    private ButtonGroup rbGroupAutoUpdate;
    private ButtonGroup rbGroupProxy;
    private JRadioButton rbNoProxy;
    private JRadioButton rbSelfDefinedProxy;
    private JTextField tfAddress;
    private APNPasswordField tfPassword;
    private JTextField tfPort;
    private JTextField tfUserName;
    private JDialog jDialog;

    public UpdateConfigPanel(JDialog dialog) {
        this.jDialog = dialog;
        this.log = Log.getLog(InitializationAPN.class);
        try {
            XMLTool.setImportExport(true);
            this.xmltool = new XMLTool(UPDATE_CONFIG_PATH);
        }
        catch (Exception ex) {
            this.log.error("read UpdateConfig.xml fail : [" + ex.toString() + "]");
        }
        this.setFont(Tools.setFont());
        this.initComponents();
        this.initDefaultValues();
    }

    private void initComponents() {
        this.rbGroupProxy = new ButtonGroup();
        this.rbGroupAutoUpdate = new ButtonGroup();
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        this.panelAutoUpdate = new JPanel();
        this.rbDisableAutoUpdate = new JRadioButton();
        this.rbEnableAutoUpdate = new JRadioButton();
        this.cmbAutoCheckDays = new JComboBox();
        this.lblDays = new JLabel();
        this.panelConnectConfig = new JPanel();
        this.rbNoProxy = new JRadioButton();
        this.rbSelfDefinedProxy = new JRadioButton();
        this.lblAddress = new JLabel();
        this.tfAddress = new JTextField();
        this.lblPort = new JLabel();
        this.tfPort = new JTextField();
        this.cbProxySetting = new JCheckBox();
        this.tfUserName = new JTextField();
        this.lblUserName = new JLabel();
        this.tfPassword = new APNPasswordField(48);
        this.lblPassword = new JLabel();
        this.btnTest = new JButton();
        this.lblTestNote = new JLabel();
        this.path = String.valueOf(XMLTool.getClassPath()) + "/config/images/";
        this.path = TextUtil.replaceStr1(this.path, "\\/", "/");
        this.path = TextUtil.replaceStr1(this.path, "\\", "/");
        this.setLayout(null);
        this.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.rbGroupProxy.add(this.rbNoProxy);
        this.rbGroupProxy.add(this.rbSelfDefinedProxy);
        private class RbActionListener
        implements ActionListener {
            RbActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                String choice = e.getActionCommand();
                if (UpdateConfigPanel.COMMAND_USE_NO_PROXY.equals(choice)) {
                    UpdateConfigPanel.this.tfAddress.setEnabled(false);
                    UpdateConfigPanel.this.tfPort.setEnabled(false);
                    UpdateConfigPanel.this.tfUserName.setEnabled(false);
                    UpdateConfigPanel.this.tfPassword.setEnabled(false);
                    UpdateConfigPanel.this.cbProxySetting.setEnabled(false);
                } else if (UpdateConfigPanel.COMMAND_USE_IE_PROXY.equals(choice)) {
                    UpdateConfigPanel.this.tfAddress.setEnabled(false);
                    UpdateConfigPanel.this.tfPort.setEnabled(false);
                    UpdateConfigPanel.this.cbProxySetting.setEnabled(true);
                    if (UpdateConfigPanel.this.cbProxySetting.isSelected()) {
                        UpdateConfigPanel.this.tfUserName.setEnabled(true);
                        UpdateConfigPanel.this.tfPassword.setEnabled(true);
                    } else {
                        UpdateConfigPanel.this.tfUserName.setEnabled(false);
                        UpdateConfigPanel.this.tfPassword.setEnabled(false);
                    }
                } else if (UpdateConfigPanel.COMMAND_USE_SELF_DEFINED_PROXY.equals(choice)) {
                    UpdateConfigPanel.this.tfAddress.setEnabled(true);
                    UpdateConfigPanel.this.tfPort.setEnabled(true);
                    UpdateConfigPanel.this.cbProxySetting.setEnabled(true);
                    if (UpdateConfigPanel.this.cbProxySetting.isSelected()) {
                        UpdateConfigPanel.this.tfUserName.setEnabled(true);
                        UpdateConfigPanel.this.tfPassword.setEnabled(true);
                    } else {
                        UpdateConfigPanel.this.tfUserName.setEnabled(false);
                        UpdateConfigPanel.this.tfPassword.setEnabled(false);
                    }
                } else if (UpdateConfigPanel.COMMAND_DISABLE_AUTO_CHECK.equals(choice)) {
                    UpdateConfigPanel.this.cmbAutoCheckDays.setEnabled(false);
                } else if (UpdateConfigPanel.COMMAND_ENABLE_AUTO_CHECK.equals(choice)) {
                    UpdateConfigPanel.this.cmbAutoCheckDays.setEnabled(true);
                } else {
                    return;
                }
            }
        }
        RbActionListener rbListener = new RbActionListener();
        this.rbNoProxy.addActionListener(rbListener);
        this.rbSelfDefinedProxy.addActionListener(rbListener);
        this.rbGroupAutoUpdate.add(this.rbDisableAutoUpdate);
        this.rbGroupAutoUpdate.add(this.rbEnableAutoUpdate);
        this.rbDisableAutoUpdate.addActionListener(rbListener);
        this.rbEnableAutoUpdate.addActionListener(rbListener);
        this.btnOK.setText(this.lb.getUpdate_OK_Button());
        this.btnOK.setName("btnOK");
        this.btnOK.setPreferredSize(new Dimension(80, 23));
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String strUserName;
                if (UpdateConfigPanel.COMMAND_USE_NO_PROXY.equals(UpdateConfigPanel.this.rbGroupProxy.getSelection().getActionCommand())) {
                    UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.PROXY_USE_PROXY_NODE_PATH, String.valueOf(0));
                    strUserName = UpdateConfigPanel.this.tfUserName.getText();
                    String strPassword = String.valueOf(UpdateConfigPanel.this.tfPassword.getPassword());
                    String strIPAddress = UpdateConfigPanel.this.tfAddress.getText();
                    String strPort = UpdateConfigPanel.this.tfPort.getText();
                    String EncryptedPwd = "";
                    try {
                        EncryptedPwd = Tools.enCrypto(strPassword, "HUAWEITERMINAL");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    System.err.println("Encrypted password: " + EncryptedPwd);
                    UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.PROXY_USER_NAME_NODE_PATH, strUserName);
                    UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.PROXY_PASSWORD_NODE_PATH, EncryptedPwd);
                    UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.PROXY_IP_ADDRESS_NODE_PATH, strIPAddress);
                    UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.PROXY_PORT_NODE_PATH, strPort);
                } else if (UpdateConfigPanel.COMMAND_USE_IE_PROXY.equals(UpdateConfigPanel.this.rbGroupProxy.getSelection().getActionCommand())) {
                    UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.PROXY_USE_PROXY_NODE_PATH, String.valueOf(2));
                    if (UpdateConfigPanel.this.cbProxySetting.isSelected()) {
                        UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.PROXY_ANONYMITY_FLAG_NODE_PATH, String.valueOf(0));
                    } else {
                        UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.PROXY_ANONYMITY_FLAG_NODE_PATH, String.valueOf(1));
                    }
                    strUserName = UpdateConfigPanel.this.tfUserName.getText();
                    String strPassword = String.valueOf(UpdateConfigPanel.this.tfPassword.getPassword());
                    String EncryptedPwd = "";
                    try {
                        EncryptedPwd = Tools.enCrypto(strPassword, "HUAWEITERMINAL");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    System.err.println("Encrypted password: " + EncryptedPwd);
                    UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.PROXY_USER_NAME_NODE_PATH, strUserName);
                    UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.PROXY_PASSWORD_NODE_PATH, EncryptedPwd);
                } else {
                    UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.PROXY_USE_PROXY_NODE_PATH, String.valueOf(1));
                    if (UpdateConfigPanel.this.cbProxySetting.isSelected()) {
                        UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.PROXY_ANONYMITY_FLAG_NODE_PATH, String.valueOf(0));
                    } else {
                        UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.PROXY_ANONYMITY_FLAG_NODE_PATH, String.valueOf(1));
                    }
                    strUserName = UpdateConfigPanel.this.tfUserName.getText();
                    String strPassword = String.valueOf(UpdateConfigPanel.this.tfPassword.getPassword());
                    String strIPAddress = UpdateConfigPanel.this.tfAddress.getText();
                    String strPort = UpdateConfigPanel.this.tfPort.getText();
                    String EncryptedPwd = "";
                    try {
                        EncryptedPwd = Tools.enCrypto(strPassword, "HUAWEITERMINAL");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    System.err.println("Encrypted password: " + EncryptedPwd);
                    UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.PROXY_USER_NAME_NODE_PATH, strUserName);
                    UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.PROXY_PASSWORD_NODE_PATH, EncryptedPwd);
                    UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.PROXY_IP_ADDRESS_NODE_PATH, strIPAddress);
                    UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.PROXY_PORT_NODE_PATH, strPort);
                }
                if (UpdateConfigPanel.COMMAND_DISABLE_AUTO_CHECK.equals(UpdateConfigPanel.this.rbGroupAutoUpdate.getSelection().getActionCommand())) {
                    UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.AUTO_UPDATE_CONFIG_NODE_PATH, String.valueOf(0));
                } else {
                    UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.AUTO_UPDATE_CONFIG_NODE_PATH, String.valueOf(1));
                    String strAutoCheckPeriod = UpdateConfigPanel.this.cmbAutoCheckDays.getSelectedItem().toString();
                    UpdateConfigPanel.this.xmltool.setNodeValue(UpdateConfigPanel.AUTO_UPDATE_PERIOD_NODE_PATH, strAutoCheckPeriod);
                }
                UpdateConfigPanel.this.jDialog.setVisible(false);
                UpdateConfigPanel.this.jDialog.dispose();
            }
        });
        this.add(this.btnOK);
        this.btnOK.setBounds(325, 350, 125, 23);
        this.btnCancel.setText(this.lb.getUpdate_Cancel_Button());
        this.btnCancel.setName("btnCancel");
        this.btnCancel.setPreferredSize(new Dimension(80, 23));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpdateConfigPanel.this.jDialog.setVisible(false);
                UpdateConfigPanel.this.jDialog.dispose();
            }
        });
        this.add(this.btnCancel);
        this.btnCancel.setBounds(465, 350, 125, 23);
        this.panelPicture = new JPanel(){
            private ImageIcon image;
            {
                this.image = new ImageIcon(String.valueOf(UpdateConfigPanel.this.path) + UpdateConfigPanel.this.cb.getImages_update_left());
            }

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.clearRect(0, 0, this.getSize().width, this.getSize().height);
                g.drawImage(this.image.getImage(), 0, 0, this.getSize().width, this.getSize().height, null);
            }
        };
        this.panelPicture.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.panelPicture.setName("panelPicture");
        this.panelPicture.setLayout(null);
        this.add(this.panelPicture);
        this.panelPicture.setBounds(10, 10, 98, 363);
        this.panelAutoUpdate.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.panelAutoUpdate.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.panelAutoUpdate.setName("panelAutoUpdate");
        this.panelAutoUpdate.setLayout(null);
        this.rbDisableAutoUpdate.setSelected(true);
        this.rbDisableAutoUpdate.setText(this.lb.getUpdate_Disable_Auto());
        this.rbDisableAutoUpdate.setActionCommand(COMMAND_DISABLE_AUTO_CHECK);
        this.rbDisableAutoUpdate.setContentAreaFilled(false);
        this.rbDisableAutoUpdate.setName("rbDisableAutoUpdate");
        this.panelAutoUpdate.add(this.rbDisableAutoUpdate);
        this.rbDisableAutoUpdate.setBounds(10, 11, this.getNativeStringWidth(this.rbDisableAutoUpdate, this.lb.getUpdate_Disable_Auto()) + 130, 23);
        this.rbEnableAutoUpdate.setText(this.lb.getUpdate_Enable_Auto());
        this.rbEnableAutoUpdate.setActionCommand(COMMAND_ENABLE_AUTO_CHECK);
        this.rbEnableAutoUpdate.setContentAreaFilled(false);
        this.rbEnableAutoUpdate.setName("rbEnableAutoUpdate");
        this.panelAutoUpdate.add(this.rbEnableAutoUpdate);
        int iRBEnableAutoUpdateWidth = this.getNativeStringWidth(this.rbEnableAutoUpdate, this.lb.getUpdate_Enable_Auto()) + 30;
        this.rbEnableAutoUpdate.setBounds(10, 44, iRBEnableAutoUpdateWidth, 23);
        this.cmbAutoCheckDays.setModel(new DefaultComboBoxModel<String>(updateCheckPeriods));
        this.cmbAutoCheckDays.setSelectedIndex(1);
        this.cmbAutoCheckDays.setEnabled(false);
        this.cmbAutoCheckDays.setName("cmbAutoCheckDays");
        this.panelAutoUpdate.add(this.cmbAutoCheckDays);
        this.cmbAutoCheckDays.setBounds(30 + iRBEnableAutoUpdateWidth, 44, 80, 23);
        this.lblDays.setText(this.lb.getUpdate_Enable_Auto_Days());
        this.lblDays.setName("lblDays");
        this.panelAutoUpdate.add(this.lblDays);
        int iLBLDaysWidth = this.getNativeStringWidth(this.lblDays, this.lb.getUpdate_Enable_Auto_Days());
        this.lblDays.setBounds(30 + iRBEnableAutoUpdateWidth + 80 + 10, 44, iLBLDaysWidth + 70, 23);
        this.add(this.panelAutoUpdate);
        this.panelAutoUpdate.setBounds(120, 245, 470, 78);
        this.panelConnectConfig.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.panelConnectConfig.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.panelConnectConfig.setName("panelConnectConfig");
        this.panelConnectConfig.setLayout(null);
        this.rbNoProxy.setSelected(true);
        this.rbNoProxy.setText(this.lb.getUpdate_No_Proxy());
        this.rbNoProxy.setActionCommand(COMMAND_USE_NO_PROXY);
        this.rbNoProxy.setContentAreaFilled(false);
        this.rbNoProxy.setName("rbNoProxy");
        this.panelConnectConfig.add(this.rbNoProxy);
        int iRBNoProxyWidth = this.getNativeStringWidth(this.rbNoProxy, this.lb.getUpdate_No_Proxy()) + 30;
        this.rbNoProxy.setBounds(10, 5, iRBNoProxyWidth + 50, 23);
        this.rbSelfDefinedProxy.setText(this.lb.getUpdate_Self_Defined_Proxy());
        this.rbSelfDefinedProxy.setActionCommand(COMMAND_USE_SELF_DEFINED_PROXY);
        this.rbSelfDefinedProxy.setContentAreaFilled(false);
        this.rbSelfDefinedProxy.setName("rbSelfDefinedProxy");
        this.panelConnectConfig.add(this.rbSelfDefinedProxy);
        int iRBSelfDefinedProxyWidth = this.getNativeStringWidth(this.rbSelfDefinedProxy, this.lb.getUpdate_Self_Defined_Proxy()) + 30;
        this.rbSelfDefinedProxy.setBounds(10, 35, iRBSelfDefinedProxyWidth + 50, 23);
        this.lblAddress.setText(this.lb.getUpdate_Proxy_Address());
        this.lblAddress.setName("lblAddress");
        this.lblAddress.setHorizontalAlignment(2);
        this.panelConnectConfig.add(this.lblAddress);
        this.lblAddress.setBounds(20, 66, 100, 15);
        this.tfAddress.setText("");
        this.tfAddress.setEnabled(false);
        this.tfAddress.setName("tfAddress");
        this.panelConnectConfig.add(this.tfAddress);
        this.tfAddress.setBounds(160, 65, 130, 21);
        this.lblPort.setText(this.lb.getUpdate_Proxy_Port());
        this.lblPort.setName("lblPort");
        this.lblPort.setHorizontalAlignment(0);
        this.panelConnectConfig.add(this.lblPort);
        this.lblPort.setBounds(295, 66, 60, 15);
        this.tfPort.setText("80");
        this.tfPort.setColumns(5);
        this.tfPort.setDocument(new PlainDocument(){

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                String temp = String.valueOf(UpdateConfigPanel.this.tfPort.getText()) + str;
                if (temp.getBytes().length > UpdateConfigPanel.this.tfPort.getColumns()) {
                    return;
                }
                super.insertString(offs, str, a);
            }
        });
        this.tfPort.setEnabled(false);
        this.tfPort.setName("tfPort");
        this.panelConnectConfig.add(this.tfPort);
        this.tfPort.setBounds(370, 65, 80, 21);
        this.cbProxySetting.setSelected(true);
        this.cbProxySetting.setText(this.lb.getUpdate_Security_Settings());
        this.cbProxySetting.setContentAreaFilled(false);
        this.cbProxySetting.setEnabled(false);
        this.cbProxySetting.setName("cbProxySetting");
        this.panelConnectConfig.add(this.cbProxySetting);
        int iCBProxySettingWidth = this.getNativeStringWidth(this.cbProxySetting, this.lb.getUpdate_Security_Settings()) + 30;
        this.cbProxySetting.setBounds(10, 95, iCBProxySettingWidth + 50, 15);
        this.cbProxySetting.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JCheckBox cb = (JCheckBox)e.getSource();
                if (cb.isEnabled() && cb.isSelected()) {
                    UpdateConfigPanel.this.tfUserName.setEnabled(true);
                    UpdateConfigPanel.this.tfPassword.setEnabled(true);
                } else {
                    UpdateConfigPanel.this.tfUserName.setEnabled(false);
                    UpdateConfigPanel.this.tfPassword.setEnabled(false);
                }
            }
        });
        this.tfUserName.setText("");
        this.tfUserName.setEnabled(false);
        this.tfUserName.setName("tfUserName");
        this.panelConnectConfig.add(this.tfUserName);
        this.tfUserName.setBounds(160, 120, 240, 23);
        this.lblUserName.setText(this.lb.getUpdate_User_Name());
        this.lblUserName.setName("lblUserName");
        this.lblUserName.setHorizontalAlignment(2);
        this.panelConnectConfig.add(this.lblUserName);
        this.lblUserName.setBounds(20, 120, 130, 15);
        this.tfPassword.setText("");
        this.tfPassword.setEnabled(false);
        this.tfPassword.setName("tfPassword");
        this.tfPassword.getDocument().addDocumentListener(new APNPasswordDocumentListener(this.tfPassword));
        this.panelConnectConfig.add(this.tfPassword);
        this.tfPassword.setBounds(160, 150, 240, 23);
        this.lblPassword.setText(this.lb.getUpdate_Password());
        this.lblPassword.setName("lblPassword");
        this.lblPassword.setHorizontalAlignment(2);
        this.panelConnectConfig.add(this.lblPassword);
        this.lblPassword.setBounds(20, 150, 130, 15);
        this.btnTest.setText(this.lb.getUpdate_Test_Button());
        this.btnTest.setName("btnTest");
        this.panelConnectConfig.add(this.btnTest);
        this.btnTest.setBounds(20, 180, 105, 23);
        this.btnTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Test connection...");
                UpdateConfigPanel.this.btnTest.setEnabled(false);
                UpdateConfigPanel.this.lblTestNote.setText(UpdateConfigPanel.this.lb.getUpdate_Label_Detect_Connection());
                UpdateConfigPanel.this.testNoteStatus = "Detecting";
                Thread thr = new Thread(new Runnable(){

                    public void run() {
                        boolean bRet = false;
                        try {
                            bRet = UpdateConfigPanel.COMMAND_USE_NO_PROXY.equals(UpdateConfigPanel.this.rbGroupProxy.getSelection().getActionCommand()) ? new HttpTest().testConnection("", "", "", "") : (UpdateConfigPanel.this.cbProxySetting.isSelected() ? new HttpTest().testConnection(UpdateConfigPanel.this.tfAddress.getText(), UpdateConfigPanel.this.tfPort.getText(), UpdateConfigPanel.this.tfUserName.getText(), String.valueOf(UpdateConfigPanel.this.tfPassword.getPassword())) : new HttpTest().testConnection(UpdateConfigPanel.this.tfAddress.getText(), UpdateConfigPanel.this.tfPort.getText(), "", ""));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            UpdateConfigPanel.this.lblTestNote.setText(UpdateConfigPanel.this.lb.getUpdate_Label_Connection_Fail());
                            UpdateConfigPanel.this.testNoteStatus = "Fail";
                        }
                        if (bRet) {
                            UpdateConfigPanel.this.lblTestNote.setText(UpdateConfigPanel.this.lb.getUpdate_Label_Connection_Success());
                            UpdateConfigPanel.this.testNoteStatus = "Success";
                            UpdateConfigPanel.this.btnTest.setEnabled(true);
                        } else {
                            UpdateConfigPanel.this.lblTestNote.setText(UpdateConfigPanel.this.lb.getUpdate_Label_Connection_Fail());
                            UpdateConfigPanel.this.testNoteStatus = "Fail";
                            UpdateConfigPanel.this.btnTest.setEnabled(true);
                        }
                    }
                });
                thr.start();
            }
        });
        String strNote = this.lb.getUpdate_Test_Label();
        this.lblTestNote.setName("lblTestNote");
        this.panelConnectConfig.add(this.lblTestNote);
        int iLBLTestNoteWidth = this.getNativeStringWidth(this.lblTestNote, strNote);
        if (iLBLTestNoteWidth > 280) {
            strNote = "<html>" + strNote + "</html>";
        }
        this.lblTestNote.setText(strNote);
        this.lblTestNote.setBounds(160, 178, 310, 35);
        this.add(this.panelConnectConfig);
        this.panelConnectConfig.setBounds(120, 10, 470, 220);
        GetButtonBackground.setButtonBackground(this.btnOK);
        GetButtonBackground.setButtonBackground(this.btnCancel);
        GetButtonBackground.setButtonBackground(this.btnTest);
    }

    private void initDefaultValues() {
        int iAnonymityConfig = Integer.parseInt(this.xmltool.getNodeValue(PROXY_ANONYMITY_FLAG_NODE_PATH));
        if (iAnonymityConfig == 0) {
            this.cbProxySetting.setSelected(true);
        } else {
            this.cbProxySetting.setSelected(false);
        }
        String strUserName = this.xmltool.getNodeValue(PROXY_USER_NAME_NODE_PATH);
        String strPassword = this.xmltool.getNodeValue(PROXY_PASSWORD_NODE_PATH);
        String decryptedPwd = "";
        try {
            decryptedPwd = Tools.deCrypto(strPassword, "HUAWEITERMINAL");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            decryptedPwd = "";
        }
        System.err.println("Decrypted password: " + decryptedPwd);
        this.tfUserName.setText(strUserName);
        this.tfPassword.setText(decryptedPwd);
        String strIPAddress = this.xmltool.getNodeValue(PROXY_IP_ADDRESS_NODE_PATH);
        this.tfAddress.setText(strIPAddress);
        String strPort = this.xmltool.getNodeValue(PROXY_PORT_NODE_PATH);
        this.tfPort.setText(strPort);
        int iProxyConfig = Integer.parseInt(this.xmltool.getNodeValue(PROXY_USE_PROXY_NODE_PATH));
        if (iProxyConfig == 0) {
            this.rbNoProxy.setSelected(true);
            this.tfAddress.setEnabled(false);
            this.tfPort.setEnabled(false);
            this.tfUserName.setEnabled(false);
            this.tfPassword.setEnabled(false);
            this.cbProxySetting.setEnabled(false);
        } else if (1 == iProxyConfig) {
            this.rbSelfDefinedProxy.setSelected(true);
            this.tfAddress.setEnabled(true);
            this.tfPort.setEnabled(true);
            this.cbProxySetting.setEnabled(true);
            if (this.cbProxySetting.isSelected()) {
                this.tfUserName.setEnabled(true);
                this.tfPassword.setEnabled(true);
            } else {
                this.tfUserName.setEnabled(false);
                this.tfPassword.setEnabled(false);
            }
        } else {
            this.rbNoProxy.setSelected(true);
            this.tfAddress.setEnabled(false);
            this.tfPort.setEnabled(false);
            this.tfUserName.setEnabled(false);
            this.tfPassword.setEnabled(false);
            this.cbProxySetting.setEnabled(false);
        }
        String strCheckPeriod = this.xmltool.getNodeValue(AUTO_UPDATE_PERIOD_NODE_PATH);
        this.cmbAutoCheckDays.setSelectedItem(strCheckPeriod);
        int iAutoCheckConfig = Integer.parseInt(this.xmltool.getNodeValue(AUTO_UPDATE_CONFIG_NODE_PATH));
        if (iAutoCheckConfig == 0) {
            this.rbDisableAutoUpdate.setSelected(true);
            this.cmbAutoCheckDays.setEnabled(false);
        } else {
            this.rbEnableAutoUpdate.setSelected(true);
            this.cmbAutoCheckDays.setEnabled(true);
        }
    }

    private int getNativeStringWidth(JComponent c, String str) {
        Font font = c.getFont();
        FontMetrics fm = c.getFontMetrics(font);
        return fm.stringWidth(str);
    }

    public void changelanguage() {
        this.btnOK.setText(this.lb.getUpdate_OK_Button());
        this.btnCancel.setText(this.lb.getUpdate_Cancel_Button());
        this.rbDisableAutoUpdate.setText(this.lb.getUpdate_Disable_Auto());
        this.rbEnableAutoUpdate.setText(this.lb.getUpdate_Enable_Auto());
        this.lblDays.setText(this.lb.getUpdate_Enable_Auto_Days());
        this.rbNoProxy.setText(this.lb.getUpdate_No_Proxy());
        this.rbSelfDefinedProxy.setText(this.lb.getUpdate_Self_Defined_Proxy());
        this.lblAddress.setText(this.lb.getUpdate_Proxy_Address());
        this.lblPort.setText(this.lb.getUpdate_Proxy_Port());
        this.cbProxySetting.setText(this.lb.getUpdate_Security_Settings());
        this.lblUserName.setText(this.lb.getUpdate_User_Name());
        this.lblPassword.setText(this.lb.getUpdate_Password());
        this.btnTest.setText(this.lb.getUpdate_Test_Button());
        if ("Success".equals(this.testNoteStatus)) {
            this.lblTestNote.setText(this.lb.getUpdate_Label_Connection_Success());
            System.err.println("Success");
        } else if ("Fail".equals(this.testNoteStatus)) {
            this.lblTestNote.setText(this.lb.getUpdate_Label_Connection_Fail());
            System.err.println("fail");
        } else if ("Detecting".equals(this.testNoteStatus)) {
            this.lblTestNote.setText(this.lb.getUpdate_Label_Detect_Connection());
            System.err.println("detecting...");
        } else {
            System.err.println("nothing");
            String strNote = this.lb.getUpdate_Test_Label();
            this.lblTestNote.setName("lblTestNote");
            this.panelConnectConfig.add(this.lblTestNote);
            int iLBLTestNoteWidth = this.getNativeStringWidth(this.lblTestNote, strNote);
            if (iLBLTestNoteWidth > 280) {
                strNote = "<html>" + strNote + "</html>";
            }
            this.lblTestNote.setText(strNote);
        }
        this.rbDisableAutoUpdate.setBounds(10, 11, this.getNativeStringWidth(this.rbDisableAutoUpdate, this.lb.getUpdate_Disable_Auto()) + 130, 23);
        int iRBEnableAutoUpdateWidth = this.getNativeStringWidth(this.rbEnableAutoUpdate, this.lb.getUpdate_Enable_Auto()) + 30;
        this.rbEnableAutoUpdate.setBounds(10, 44, iRBEnableAutoUpdateWidth, 23);
        int iLBLDaysWidth = this.getNativeStringWidth(this.lblDays, this.lb.getUpdate_Enable_Auto_Days());
        this.lblDays.setBounds(30 + iRBEnableAutoUpdateWidth + 80 + 10, 44, iLBLDaysWidth + 70, 23);
        this.cmbAutoCheckDays.setBounds(30 + iRBEnableAutoUpdateWidth, 44, 80, 23);
        int iRBNoProxyWidth = this.getNativeStringWidth(this.rbNoProxy, this.lb.getUpdate_No_Proxy()) + 30;
        this.rbNoProxy.setBounds(10, 5, iRBNoProxyWidth + 50, 23);
        int iRBSelfDefinedProxyWidth = this.getNativeStringWidth(this.rbSelfDefinedProxy, this.lb.getUpdate_Self_Defined_Proxy()) + 30;
        this.rbSelfDefinedProxy.setBounds(10, 35, iRBSelfDefinedProxyWidth + 100, 23);
        int iCBProxySettingWidth = this.getNativeStringWidth(this.cbProxySetting, this.lb.getUpdate_Security_Settings()) + 30;
        this.cbProxySetting.setBounds(10, 95, iCBProxySettingWidth + 50, 15);
    }
}

