/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.onlineupdate.logic;

import com.huawei.mobilePartner.onlineupdate.logic.LogicException;
import com.huawei.mobilePartner.onlineupdate.logic.XMLTool;
import java.util.HashMap;
import java.util.List;

public class UpdateInfo {
    public static final String UPDATEINFO_FILEPATH = "/config/onlineupdate/UpdateInfo.xml";
    public static final String[] componentProperties = new String[]{"name", "main", "sequence", "processname", "displayname", "directory"};
    public static final String componentXpath = "root/components/component";
    public static final String protocolXpath = "root/server/protocol";
    public static final String ipXpath = "root/server/ip";
    public static final String portXpath = "root/server/port";
    public static final String svrDirXpath = "root/server/directory";
    public static final String rootXpath = "root";
    private static UpdateInfo ins = null;
    private List componentList = null;
    private String ip = null;
    private String port = null;
    private String svrDir = null;
    private String protocol = null;

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public List getComponentList() {
        return this.componentList;
    }

    private void setComponentList(List tmp) {
        this.componentList = tmp;
    }

    public String getIP() {
        return this.ip;
    }

    private void setIP(String tmp) {
        this.ip = tmp;
    }

    public String getPort() {
        return this.port;
    }

    private void setPort(String tmp) {
        this.port = tmp;
    }

    public String getSvrDir() {
        return this.svrDir;
    }

    private void setSvrDir(String tmp) {
        this.svrDir = tmp;
    }

    public boolean isMyComponent(String str) {
        int i = 0;
        while (i < this.componentList.size()) {
            HashMap map = (HashMap)this.componentList.get(i);
            if (map.get("name").toString().equals(str)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getComponentSequence(String str) {
        int i = 0;
        while (i < this.componentList.size()) {
            HashMap map = (HashMap)this.componentList.get(i);
            if (map.get("name").toString().equals(str)) {
                return Integer.valueOf(map.get("sequence").toString());
            }
            ++i;
        }
        return -1;
    }

    public static UpdateInfo getUpdateInfo() throws LogicException {
        if (ins == null) {
            ins = new UpdateInfo(String.valueOf(System.getProperty("user.dir")) + UPDATEINFO_FILEPATH);
        }
        return ins;
    }

    public void clear() {
        ins = null;
    }

    private UpdateInfo(String filepath) throws LogicException {
        this.readFromUpdateInfoXml(filepath);
        System.out.println(this.getComponentList().toString());
        System.out.println(this.getProtocol());
        System.out.println(this.getIP());
        System.out.println(this.getPort());
        System.out.println(this.getSvrDir());
    }

    private void readFromUpdateInfoXml(String filepath) throws LogicException {
        XMLTool.setImportExport(true);
        try {
            XMLTool tools = new XMLTool(filepath, rootXpath);
            this.setComponentList(tools.quertyNodeTextValueByPath(componentXpath, componentProperties));
            this.setProtocol(tools.getNodeValue(protocolXpath));
            this.setIP(tools.getNodeValue(ipXpath));
            this.setPort(tools.getNodeValue(portXpath));
            this.setSvrDir(tools.getNodeValue(svrDirXpath));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new LogicException(3);
        }
    }

    public static void main(String[] args) throws LogicException {
        UpdateInfo.getUpdateInfo();
    }
}

