/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.onlineupdate.logic;

import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.onlineupdate.logic.LogicException;
import com.huawei.mobilePartner.onlineupdate.logic.XMLTool;

public class UpdateConfig {
    public static final String UPDATECONFIG_FILEPATH = "/config/onlineupdate/UpdateConfig.xml";
    public static final String rootXpath = "UpdateConfig";
    public static final String AutoCheckXpath = "UpdateConfig/AutoRun/AutoCheck";
    public static final String CycleXpath = "UpdateConfig/AutoRun/Cycle";
    public static final String UpdateDateXpath = "UpdateConfig/AutoRun/UpdateDate";
    public static final String UseProxyXpath = "UpdateConfig/ProxyInfo/UseProxy";
    public static final String AnonymityFlagXpath = "UpdateConfig/ProxyInfo/AnonymityFlag";
    public static final String IPAddressXpath = "UpdateConfig/ProxyInfo/IPAddress";
    public static final String PortXpath = "UpdateConfig/ProxyInfo/Port";
    public static final String UserNameXpath = "UpdateConfig/ProxyInfo/UserName";
    public static final String PasswordXpath = "UpdateConfig/ProxyInfo/Password";
    public static final String SECRET_KEY = "HUAWEITERMINAL";
    private int AutoCheck;
    private int Cycle;
    private String UpdateDate;
    private int UseProxy;
    private int AnonymityFlag;
    private String IPAddress;
    private int Port;
    private String UserName;
    private String Password;
    private static UpdateConfig ins = null;

    public int getAutoCheck() {
        return this.AutoCheck;
    }

    public void setAutoCheck(int autoCheck) {
        this.AutoCheck = autoCheck;
    }

    public int getCycle() {
        return this.Cycle;
    }

    public void setCycle(int cycle) {
        this.Cycle = cycle;
    }

    public String getUpdateDate() {
        return this.UpdateDate;
    }

    public void setUpdateDate(String updateDate) {
        this.UpdateDate = updateDate;
    }

    public int getUseProxy() {
        return this.UseProxy;
    }

    public void setUseProxy(int useProxy) {
        this.UseProxy = useProxy;
    }

    public int getAnonymityFlag() {
        return this.AnonymityFlag;
    }

    public void setAnonymityFlag(int anonymityFlag) {
        this.AnonymityFlag = anonymityFlag;
    }

    public String getIPAddress() {
        return this.IPAddress;
    }

    public void setIPAddress(String address) {
        this.IPAddress = address;
    }

    public int getPort() {
        return this.Port;
    }

    public void setPort(int port) {
        this.Port = port;
    }

    public String getUserName() {
        return this.UserName;
    }

    public void setUserName(String userName) {
        this.UserName = userName;
    }

    public String getPassword() {
        return this.Password;
    }

    public void setPassword(String password) {
        this.Password = password;
    }

    private UpdateConfig() throws LogicException {
        this.readFromUpdateConfigXml(String.valueOf(System.getProperty("user.dir")) + UPDATECONFIG_FILEPATH);
    }

    public static UpdateConfig getUpdateConfig() throws LogicException {
        if (ins == null) {
            ins = new UpdateConfig();
        }
        return ins;
    }

    public static void clear() {
        ins = null;
    }

    private void readFromUpdateConfigXml(String filepath) throws LogicException {
        XMLTool.setImportExport(true);
        try {
            XMLTool tools = new XMLTool(filepath, rootXpath);
            this.setAutoCheck(Integer.valueOf(tools.getNodeValue(AutoCheckXpath)));
            this.setCycle(Integer.valueOf(tools.getNodeValue(CycleXpath)));
            this.setUpdateDate(tools.getNodeValue(UpdateDateXpath));
            this.setUseProxy(Integer.valueOf(tools.getNodeValue(UseProxyXpath)));
            this.setAnonymityFlag(Integer.valueOf(tools.getNodeValue(AnonymityFlagXpath)));
            this.setIPAddress(tools.getNodeValue(IPAddressXpath));
            if ("".equals(tools.getNodeValue(PortXpath))) {
                this.setPort(0);
            } else {
                this.setPort(Integer.valueOf(tools.getNodeValue(PortXpath)));
            }
            this.setUserName(tools.getNodeValue(UserNameXpath));
            String tempPwd = tools.getNodeValue(PasswordXpath);
            String decryptedPwd = "";
            try {
                decryptedPwd = Tools.deCrypto(tempPwd, SECRET_KEY);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.setPassword(decryptedPwd);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new LogicException(9);
        }
    }

    public void printout() {
        System.out.println(this.getAutoCheck());
        System.out.println(this.getCycle());
        System.out.println(this.getUpdateDate());
        System.out.println(this.getUseProxy());
        System.out.println(this.getAnonymityFlag());
        System.out.println(this.getIPAddress());
        System.out.println(this.getPort());
        System.out.println(this.getUserName());
        System.out.println(this.getPassword());
    }

    public static void main(String[] args) throws LogicException {
        UpdateConfig.getUpdateConfig().printout();
    }
}

