/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.onlineupdate.logic;

import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.config.business.LanguageSelect;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.onlineupdate.event.uiEvent;
import com.huawei.mobilePartner.onlineupdate.event.uiEventSource;
import com.huawei.mobilePartner.onlineupdate.logic.DownloadComponentState;
import com.huawei.mobilePartner.onlineupdate.logic.DownloadFileState;
import com.huawei.mobilePartner.onlineupdate.logic.ErrorInformUI;
import com.huawei.mobilePartner.onlineupdate.logic.HttpTransfer;
import com.huawei.mobilePartner.onlineupdate.logic.LogicException;
import com.huawei.mobilePartner.onlineupdate.logic.MD5;
import com.huawei.mobilePartner.onlineupdate.logic.RequestXML;
import com.huawei.mobilePartner.onlineupdate.logic.ResponseXML;
import com.huawei.mobilePartner.onlineupdate.logic.RuleParam;
import com.huawei.mobilePartner.onlineupdate.logic.UpdateConfig;
import com.huawei.mobilePartner.onlineupdate.logic.UpdateDoneXML;
import com.huawei.mobilePartner.onlineupdate.logic.UpdateInfo;
import com.huawei.mobilePartner.onlineupdate.logic.XMLTool;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.commons.httpclient.HttpException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnlineUpdate {
    public static final String classpath = System.getProperty("user.dir");
    public static final String tmpdir = String.valueOf(classpath) + "/~temp";
    public static final String installfilelist = String.valueOf(tmpdir) + "/installfilelist.txt";
    public static final String UPDATECONFIG_FILEPATH = "/config/onlineupdate/UpdateConfig.xml";
    public static final String UpdateConfigRootXpath = "UpdateConfig";
    public static final String UpdateDateXpath = "UpdateConfig/AutoRun/UpdateDate";
    private static final int exist = 0;
    private static final int isnotexist = 1;
    private static final int continuedown = 2;
    private static final int downagain = 3;
    private UpdateConfig insUpdateConfig = null;
    private UpdateInfo insUpdateInfo = null;
    private static OnlineUpdate ins = null;
    private HttpTransfer httpTransfer = null;
    private boolean isSSL = true;
    private boolean isnotSSL = false;
    private List<DownloadComponentState> downloadComponentList = null;

    public static OnlineUpdate getOnlineUpdate() {
        if (ins == null) {
            ins = new OnlineUpdate();
        }
        return ins;
    }

    private OnlineUpdate() {
        this.init();
    }

    private void init() {
        File f = new File(tmpdir);
        if (!f.exists()) {
            f.mkdir();
        }
        try {
            UpdateConfig.clear();
            this.insUpdateConfig = UpdateConfig.getUpdateConfig();
            this.insUpdateInfo = UpdateInfo.getUpdateInfo();
            this.httpTransfer = HttpTransfer.getInstant();
            this.configHttpTransfer();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof LogicException) {
                ErrorInformUI.SendErrorToUI(this, "LogicException", ((LogicException)e).getErrorCode());
            }
            ErrorInformUI.SendErrorToUI(this, "Exception", 0);
        }
        this.downloadComponentList = new ArrayList<DownloadComponentState>();
    }

    public void clear() {
        this.httpTransfer.stopDownloadComponent();
        if (this.httpTransfer != null) {
            HttpTransfer.clear();
            this.httpTransfer = null;
        }
        if (this.insUpdateInfo != null) {
            this.insUpdateInfo.clear();
            this.insUpdateInfo = null;
        }
        this.isSSL = true;
        this.downloadComponentList = null;
        ins = null;
        RuleParam.clear();
    }

    private void configHttpTransfer() throws Exception {
        if (this.httpTransfer == null || this.insUpdateInfo == null) {
            throw new Exception();
        }
        String port = this.insUpdateInfo.getPort();
        String protocol = this.insUpdateInfo.getProtocol();
        if ("https".equals(protocol)) {
            this.httpTransfer.setPort(Integer.parseInt(port), this.isSSL);
        } else if ("http".equals(protocol)) {
            this.httpTransfer.setPort(Integer.parseInt(port), this.isnotSSL);
        } else {
            throw new Exception();
        }
        if (this.insUpdateConfig.getUseProxy() == 1) {
            this.httpTransfer.setAddress(this.insUpdateConfig.getIPAddress());
            this.httpTransfer.setProxyPort(this.insUpdateConfig.getPort());
            if (this.insUpdateConfig.getAnonymityFlag() == 0) {
                this.httpTransfer.setUsername(this.insUpdateConfig.getUserName());
                this.httpTransfer.setPassword(this.insUpdateConfig.getPassword());
            }
        }
    }

    public List<DownloadComponentState> returnDownloadComponentList() {
        return this.downloadComponentList;
    }

    public Vector getDownloadComponentList() {
        if (this.downloadComponentList != null) {
            Vector<String> tmp = new Vector<String>();
            int i = 0;
            while (i < this.downloadComponentList.size()) {
                tmp.add(String.valueOf(this.downloadComponentList.get(i).getComponentname()) + " " + this.downloadComponentList.get(i).getVersion());
                ++i;
            }
            return tmp;
        }
        return null;
    }

    public void setSelectedDownloadComponent(Vector vec) throws Exception {
        if (vec == null) {
            throw new Exception();
        }
        int k = 0;
        while (k < this.downloadComponentList.size()) {
            this.downloadComponentList.get(k).setSelected(false);
            ++k;
        }
        int i = 0;
        while (i < vec.size()) {
            if (!(vec.get(i) instanceof String)) {
                throw new Exception();
            }
            String name = (String)vec.get(i);
            int j = 0;
            while (j < this.downloadComponentList.size()) {
                if (name.equals(String.valueOf(this.downloadComponentList.get(j).getComponentname()) + " " + this.downloadComponentList.get(j).getVersion())) {
                    this.downloadComponentList.get(j).setSelected(true);
                }
                ++j;
            }
            ++i;
        }
    }

    public void writeIntallFilePathToFile() throws IOException, LogicException {
        File f = new File(installfilelist);
        if (f.exists()) {
            f.delete();
        } else {
            f.createNewFile();
        }
        FileOutputStream outstream = new FileOutputStream(f);
        Vector<Object[]> tmp = new Vector<Object[]>();
        int i = 0;
        while (i < this.downloadComponentList.size()) {
            if (this.downloadComponentList.get(i).isSelected()) {
                List<DownloadFileState> fileList = this.downloadComponentList.get(i).getComponentfilelist();
                String savepath = this.downloadComponentList.get(i).getSavpath();
                int sequence = UpdateInfo.getUpdateInfo().getComponentSequence(this.downloadComponentList.get(i).getComponentname());
                Object[] obj = new Object[]{fileList, savepath, sequence};
                if (tmp.size() == 0) {
                    tmp.add(obj);
                } else {
                    int j = 0;
                    while (j < tmp.size()) {
                        Object[] t = (Object[])tmp.get(j);
                        if ((Integer)t[2] > (Integer)obj[2]) {
                            tmp.insertElementAt(obj, j);
                            break;
                        }
                        if (j == tmp.size() - 1) {
                            tmp.add(obj);
                            break;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        Color color = ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1());
        String strColor = "RGB: " + String.valueOf(color.getRed()) + "," + String.valueOf(color.getGreen()) + "," + String.valueOf(color.getBlue()) + "," + String.valueOf(color.getAlpha()) + "\n";
        byte[] content = strColor.getBytes();
        outstream.write(content);
        String language = String.valueOf(LanguageSelect.getRunInfoLanguageType2()) + "\n";
        content = language.getBytes();
        outstream.write(content);
        int k = 0;
        while (k < tmp.size()) {
            Object[] t = (Object[])tmp.get(k);
            List fileList = (List)t[0];
            int i2 = 0;
            while (i2 < fileList.size()) {
                String file = String.valueOf((String)t[1]) + ((DownloadFileState)fileList.get(i2)).getSpath() + "\n";
                byte[] b = file.getBytes();
                outstream.write(b);
                ++i2;
            }
            ++k;
        }
        outstream.close();
    }

    public Vector getDownloadFileList() {
        Vector<String[]> vec = new Vector<String[]>();
        int j = 0;
        while (j < this.downloadComponentList.size()) {
            if (this.downloadComponentList.get(j).isSelected()) {
                int i = 0;
                while (i < this.downloadComponentList.get(j).getComponentfilelist().size()) {
                    String name = this.downloadComponentList.get(j).getComponentfilelist().get(i).getSpath();
                    String size = this.downloadComponentList.get(j).getComponentfilelist().get(i).getFilesize();
                    String[] element = new String[]{name, size};
                    vec.add(element);
                    ++i;
                }
            }
            ++j;
        }
        return vec;
    }

    private String getCheckDataURL() throws LogicException {
        if ("" == this.insUpdateInfo.getSvrDir()) {
            return String.valueOf(UpdateInfo.getUpdateInfo().getProtocol()) + "://" + this.insUpdateInfo.getIP() + "/urlCommand/checkNewVersion.aspx";
        }
        return String.valueOf(UpdateInfo.getUpdateInfo().getProtocol()) + "://" + this.insUpdateInfo.getIP() + "/" + this.insUpdateInfo.getSvrDir() + "/urlCommand/checkNewVersion.aspx";
    }

    private String getUpdateDoneURL() throws LogicException {
        if ("" == this.insUpdateInfo.getSvrDir()) {
            return String.valueOf(UpdateInfo.getUpdateInfo().getProtocol()) + "://" + this.insUpdateInfo.getIP() + "/urlCommand/UpdateDone.aspx";
        }
        return String.valueOf(UpdateInfo.getUpdateInfo().getProtocol()) + "://" + this.insUpdateInfo.getIP() + "/" + this.insUpdateInfo.getSvrDir() + "/urlCommand/UpdateDone.aspx";
    }

    public ResponseXML sendUpdateRequest(RequestXML request) throws Exception {
        String requestXML = request.getRequestXML();
        return new ResponseXML(this.httpTransfer.postXMLRequest(this.getCheckDataURL(), requestXML));
    }

    public void downloadFilelistXml(ResponseXML response) throws Exception {
        if (response == null) {
            throw new LogicException(54);
        }
        String status = response.getStatus();
        if ("-1".equals(status)) {
            throw new LogicException(50);
        }
        if ("1".equals(status)) {
            throw new LogicException(51);
        }
        if ("2".equals(status)) {
            throw new LogicException(52);
        }
        if ("3".equals(status)) {
            throw new LogicException(53);
        }
        if (!"0".equals(status)) {
            throw new LogicException(54);
        }
        List componentList = response.getComponentList();
        File tmp = new File(tmpdir);
        String[] fNameList = tmp.list();
        int index = 0;
        while (index < fNameList.length) {
            boolean flag = true;
            int index2 = 0;
            while (index2 < componentList.size()) {
                HashMap map = (HashMap)componentList.get(index2);
                if (fNameList[index].equals(String.valueOf((String)map.get("name")) + (String)map.get("version"))) {
                    flag = false;
                }
                ++index2;
            }
            if (flag) {
                this.delFileOrDir(new File(String.valueOf(tmpdir) + "/" + fNameList[index]));
            }
            ++index;
        }
        int i = 0;
        while (i < componentList.size()) {
            HashMap map = (HashMap)componentList.get(i);
            File f = new File(String.valueOf(tmpdir) + "/" + map.get("name") + map.get("version") + "/full");
            if (!f.exists()) {
                f.mkdirs();
            }
            String fileListUrl = String.valueOf((String)map.get("url")) + "full/" + "filelist.xml";
            String fileListDst = String.valueOf(f.getAbsolutePath()) + "/filelist.xml";
            this.httpTransfer.downloadFile(fileListUrl, fileListDst);
            if (this.downloadComponentList == null) {
                throw new Exception();
            }
            String name = map.get("name").toString();
            File tmpFileList = new File(fileListDst);
            if (!tmpFileList.exists()) {
                this.delFileOrDir(new File(f.getParent()));
                break;
            }
            DownloadComponentState downloadComponentState = new DownloadComponentState(fileListDst, name, String.valueOf((String)map.get("url")) + "full/", String.valueOf(f.getAbsolutePath()) + "/", map.get("version").toString(), (String)map.get("createtime"), (String)map.get("versionID"));
            String namefromfilelist = downloadComponentState.getComponentnamefromfilelist();
            if (UpdateInfo.getUpdateInfo().isMyComponent(namefromfilelist)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                Date date = sdf.parse(downloadComponentState.getCreatetime());
                boolean flag = true;
                int k = 0;
                while (k < this.downloadComponentList.size()) {
                    if (this.downloadComponentList.get(k).getComponentnamefromfilelist().equals(namefromfilelist)) {
                        flag = false;
                        Date date2 = sdf.parse(this.downloadComponentList.get(k).getCreatetime());
                        if (date.after(date2)) {
                            File tmpF = new File(this.downloadComponentList.get(k).getSavpath());
                            File tmpFile = new File(tmpF.getParent());
                            this.delFileOrDir(tmpFile);
                            this.downloadComponentList.remove(k);
                            this.downloadComponentList.add(k, downloadComponentState);
                            break;
                        }
                        File tmpFile = new File(f.getParent());
                        this.delFileOrDir(tmpFile);
                        break;
                    }
                    ++k;
                }
                if (flag) {
                    this.downloadComponentList.add(downloadComponentState);
                }
            } else {
                File tmpFile = new File(f.getParent());
                this.delFileOrDir(tmpFile);
            }
            ++i;
        }
    }

    public void delFileOrDir(File f) {
        if (f.isFile()) {
            f.delete();
            return;
        }
        File[] fList = f.listFiles();
        int index = 0;
        while (index < fList.length) {
            System.err.println(fList[index].getAbsolutePath());
            if (fList[index].isDirectory()) {
                this.delFileOrDir(fList[index]);
            } else {
                fList[index].delete();
            }
            ++index;
        }
        f.delete();
    }

    public void downloadComponents() throws Exception {
        if (this.downloadComponentList == null) {
            throw new Exception();
        }
        this.httpTransfer.postXMLRequestNoErr(this.getUpdateDoneURL(), new UpdateDoneXML().getRequestXML(1));
        int i = 0;
        while (i < this.downloadComponentList.size()) {
            if (this.downloadComponentList.get(i).isSelected()) {
                this.downloadFileAdvanced(this.downloadComponentList.get(i).getUrl(), this.downloadComponentList.get(i).getComponentfilelist(), this.downloadComponentList.get(i).getSavpath());
            }
            ++i;
        }
        this.httpTransfer.postXMLRequestNoErr(this.getUpdateDoneURL(), new UpdateDoneXML().getRequestXML(2));
    }

    private void downloadFileAdvanced(String url, List<DownloadFileState> fileList, String savePath) throws Exception {
        int i = 0;
        while (i < fileList.size()) {
            File f;
            DownloadFileState downloadFileState = fileList.get(i);
            String downloadurl = String.valueOf(url) + downloadFileState.getSpath();
            String file = String.valueOf(savePath) + downloadFileState.getSpath();
            System.out.println(downloadurl);
            int filestate = this.preCheckIfFileExsitsAdvanced(downloadFileState, savePath);
            if (1 == filestate || 3 == filestate) {
                f = new File(file);
                this.httpTransfer.downloadFileWithProgressUpdateToUI(downloadurl, file, downloadFileState.getSpath());
            } else if (2 == filestate) {
                f = new File(file);
                this.httpTransfer.downloadagain(downloadurl, file, downloadFileState.getSpath());
            } else {
                Vector<Object> vec = new Vector<Object>();
                vec.add(downloadFileState.getSpath());
                vec.add(Long.valueOf(downloadFileState.getFilesize()));
                uiEvent ue = new uiEvent(this, 4, vec);
                uiEventSource.getuiEventSource().activeuiEvent(ue);
            }
            ++i;
        }
    }

    private void downloadFile(String url, List<DownloadFileState> fileList, String savePath) throws Exception {
        int i = 0;
        while (i < fileList.size()) {
            DownloadFileState downloadFileState = fileList.get(i);
            if (!this.preCheckIfFileExsits(downloadFileState, savePath)) {
                String downloadurl = String.valueOf(url) + downloadFileState.getSpath();
                String file = String.valueOf(savePath) + downloadFileState.getSpath();
                System.out.println(downloadurl);
                this.httpTransfer.downloadFileWithProgressUpdateToUI(downloadurl, file, downloadFileState.getSpath());
            } else {
                Vector<Object> vec = new Vector<Object>();
                vec.add(downloadFileState.getSpath());
                vec.add(Long.valueOf(downloadFileState.getFilesize()));
                uiEvent ue = new uiEvent(this, 4, vec);
                uiEventSource.getuiEventSource().activeuiEvent(ue);
            }
            ++i;
        }
    }

    public int preCheckIfFileExsitsAdvanced(DownloadFileState downloadFileState, String savePath) {
        int result = -1;
        String file = String.valueOf(savePath) + downloadFileState.getSpath();
        File f = new File(file);
        if (!f.exists()) {
            result = 1;
            System.out.println(String.valueOf(file) + " !exists()");
        } else {
            String size = String.valueOf(f.length());
            long fullfilelen = Integer.parseInt(downloadFileState.getFilesize());
            if (f.length() > fullfilelen) {
                f.delete();
                System.out.println(String.valueOf(file) + " size error!  " + "local size:" + size + " filelist size:" + downloadFileState.getFilesize());
                result = 3;
            } else if (f.length() == fullfilelen) {
                String md5 = MD5.getMD5(f);
                String fullmd5 = downloadFileState.getFilemd5();
                if (!md5.equalsIgnoreCase(downloadFileState.getFilemd5())) {
                    f.delete();
                    System.out.println(String.valueOf(file) + " md5 error!  " + "local md5:" + md5 + " filelist md5:" + downloadFileState.getFilemd5());
                    result = 3;
                } else {
                    result = 0;
                }
            } else {
                result = 2;
            }
        }
        return result;
    }

    public boolean preCheckIfFileExsits(DownloadFileState downloadFileState, String savePath) {
        boolean result = true;
        String file = String.valueOf(savePath) + downloadFileState.getSpath();
        File f = new File(file);
        if (!f.exists()) {
            result = false;
            System.out.println(String.valueOf(file) + " !exists()");
        } else {
            String md5;
            String size = String.valueOf(f.length());
            if (!size.equals(downloadFileState.getFilesize())) {
                result = false;
                System.out.println(String.valueOf(file) + " size error!  " + "local size:" + size + " filelist size:" + downloadFileState.getFilesize());
            }
            if (!(md5 = MD5.getMD5(f)).equalsIgnoreCase(downloadFileState.getFilemd5())) {
                result = false;
                System.out.println(String.valueOf(file) + " md5 error!  " + "local md5:" + md5 + " filelist md5:" + downloadFileState.getFilemd5());
            }
        }
        return result;
    }

    public Vector checkDownloadComponents() throws Exception {
        Vector<Object[]> vec = new Vector<Object[]>();
        boolean flag = true;
        if (this.downloadComponentList == null) {
            throw new Exception();
        }
        boolean checkresult = true;
        int i = 0;
        while (i < this.downloadComponentList.size()) {
            if (this.downloadComponentList.get(i).isSelected()) {
                checkresult = this.checkDownloadFile(this.downloadComponentList.get(i).getComponentfilelist(), this.downloadComponentList.get(i).getSavpath());
                this.downloadComponentList.get(i).setCorrect(checkresult);
                if (!checkresult) {
                    flag = false;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.downloadComponentList.size()) {
            if (this.downloadComponentList.get(i).isSelected()) {
                List<DownloadFileState> fileList = this.downloadComponentList.get(i).getComponentfilelist();
                int j = 0;
                while (j < fileList.size()) {
                    DownloadFileState downloadFileState = fileList.get(j);
                    Object[] tmp = new Object[]{downloadFileState.getSpath(), downloadFileState.isCorrect()};
                    vec.add(tmp);
                    ++j;
                }
            }
            ++i;
        }
        if (flag) {
            Date date = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            String strDate = sdf.format(date);
            XMLTool.setImportExport(true);
            XMLTool tools = new XMLTool(String.valueOf(System.getProperty("user.dir")) + UPDATECONFIG_FILEPATH, UpdateConfigRootXpath);
            tools.setNodeValue(UpdateDateXpath, strDate);
        }
        return vec;
    }

    private boolean checkDownloadFile(List<DownloadFileState> fileList, String savePath) {
        boolean result = true;
        int i = 0;
        while (i < fileList.size()) {
            DownloadFileState downloadFileState = fileList.get(i);
            String file = String.valueOf(savePath) + downloadFileState.getSpath();
            File f = new File(file);
            if (!f.exists()) {
                result = false;
                System.out.println(String.valueOf(file) + " !exists()");
            } else {
                String size = String.valueOf(f.length());
                if (!size.equals(downloadFileState.getFilesize())) {
                    result = false;
                    System.out.println(String.valueOf(file) + " size error!  " + "local size:" + size + " filelist size:" + downloadFileState.getFilesize());
                } else {
                    String md5 = MD5.getMD5(f);
                    if (!md5.equalsIgnoreCase(downloadFileState.getFilemd5())) {
                        result = false;
                        System.out.println(String.valueOf(file) + " md5 error!  " + "local md5:" + md5 + " filelist md5:" + downloadFileState.getFilemd5());
                    } else {
                        downloadFileState.setCorrect(result);
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public void start() {
        try {
            if (ins == null) {
                throw new Exception();
            }
            ResponseXML response = ins.sendUpdateRequest(new RequestXML());
            if (response == null) {
                throw new Exception();
            }
            ins.downloadFilelistXml(response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            OnlineUpdate insOU = OnlineUpdate.getOnlineUpdate();
            ResponseXML response = insOU.sendUpdateRequest(new RequestXML());
            if (response != null) {
                System.out.println(response.getStatus());
                System.out.println(response.getComponentList().toString());
                insOU.downloadFilelistXml(response);
                insOU.downloadComponents();
                insOU.checkDownloadComponents();
            } else {
                System.out.println("connect to site failed!");
            }
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

