/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.onlineupdate.logic;

import com.huawei.mobilePartner.onlineupdate.event.uiEvent;
import com.huawei.mobilePartner.onlineupdate.event.uiEventSource;
import com.huawei.mobilePartner.onlineupdate.logic.CustomSecureProtocolSocketFactory;
import com.huawei.mobilePartner.onlineupdate.logic.LogicException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class HttpTransfer {
    private HttpClient httpClient = null;
    private static HttpTransfer httpTransfer = null;
    private static int WAIT_TIMEOUT = 20000;
    private HttpMethod hm = null;
    private String address = "";
    private int port = 80;
    private String username = "";
    private String password = "";

    public void setAddress(String address) {
        this.address = address;
    }

    public void setProxyPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static HttpTransfer getInstant() {
        if (httpTransfer == null) {
            httpTransfer = new HttpTransfer();
        }
        return httpTransfer;
    }

    public void stopDownloadComponent() {
        if (this.hm != null) {
            this.hm.abort();
            if (this.hm != null) {
                this.hm.releaseConnection();
                this.hm = null;
            }
        }
        ((MultiThreadedHttpConnectionManager)this.httpClient.getHttpConnectionManager()).deleteClosedConnections();
        ((MultiThreadedHttpConnectionManager)this.httpClient.getHttpConnectionManager()).shutdown();
    }

    public static void clear() {
        httpTransfer = null;
    }

    private HttpTransfer() {
        this.init();
    }

    private void init() {
        this.httpClient = new HttpClient(new MultiThreadedHttpConnectionManager());
        System.err.println("httpClient = new HttpClient(new MultiThreadedHttpConnectionManager());");
        this.httpClient.getParams().setSoTimeout(WAIT_TIMEOUT);
        this.httpClient.setConnectionTimeout(60000);
    }

    public void setPort(int logon_port, int logon_sslport) {
        this.setPort(logon_port, false);
        this.setPort(logon_sslport, true);
    }

    public void setPort(int logon_port, boolean isSSL) {
        if (isSSL) {
            Protocol myhttps = new Protocol("https", (ProtocolSocketFactory)new CustomSecureProtocolSocketFactory(), logon_port);
            Protocol.registerProtocol("https", myhttps);
        } else {
            Protocol http = Protocol.getProtocol("http");
            Protocol myhttp = new Protocol("http", http.getSocketFactory(), logon_port);
            Protocol.registerProtocol("http", myhttp);
        }
    }

    public void downloadagain(String url, String savepath, String filename) throws Exception {
        GetMethod getMethod = null;
        getMethod = new GetMethod(this.convertURL(url));
        this.hm = getMethod;
        getMethod.getParams().setParameter("http.socket.timeout", new Integer(WAIT_TIMEOUT));
        getMethod.getParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler());
        InputStream instream = null;
        FilterOutputStream outstream = null;
        long length = 0L;
        int statusCode = -1;
        try {
            try {
                File f = new File(savepath);
                long filecurentsize = f.length();
                System.out.println("Old size = " + filecurentsize);
                getMethod.setRequestHeader("RANGE", "bytes=" + filecurentsize + "-");
                statusCode = "".equals(this.address) ? this.httpClient.executeMethod(getMethod) : this.httpClient.executeMethod(this.getProxy(this.httpClient), getMethod);
                if (statusCode != 200 && statusCode != 206) {
                    throw new HttpException();
                }
                System.out.println("getMethod.getStatusLine()   " + getMethod.getStatusLine());
                instream = getMethod.getResponseBodyAsStream();
                outstream = new BufferedOutputStream(new FileOutputStream(f, true));
                Header filelength = getMethod.getResponseHeader("Content-Length");
                length = Long.parseLong(filelength.getValue());
                System.out.println("File length: " + length);
                byte[] buffer = new byte[1024];
                int x = 0;
                long downlength = 0L;
                int readsize = instream.read(buffer);
                while (true) {
                    ((BufferedOutputStream)outstream).write(buffer, 0, readsize);
                    Vector<Object> vec = new Vector<Object>();
                    vec.add(filename);
                    vec.add((downlength += (long)readsize) + filecurentsize);
                    uiEvent ue = new uiEvent(this, 4, vec);
                    uiEventSource.getuiEventSource().activeuiEvent(ue);
                    System.out.println("progress: " + String.valueOf(downlength * 100L / length) + "%");
                    if (++x >= 1024) {
                        x = 0;
                        ((BufferedOutputStream)outstream).flush();
                    }
                    if (length == downlength) break;
                    readsize = instream.read(buffer);
                }
                System.out.println(String.valueOf(filename) + "download successly! ");
                instream.close();
                outstream.close();
            }
            catch (Exception e) {
                System.err.println("download  error   " + url);
                e.printStackTrace();
                throw new LogicException(7);
            }
        }
        finally {
            this.hm = null;
            instream.close();
            outstream.close();
        }
    }

    public HostConfiguration getProxy(HttpClient client) {
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.username, this.password);
        client.getState().setProxyCredentials(AuthScope.ANY, creds);
        HostConfiguration hcf = new HostConfiguration();
        hcf.setProxy(this.address, this.port);
        return hcf;
    }

    public void downloadFileWithProgressUpdateToUI(String url, String filename, String filename2) throws Exception {
        GetMethod getMethod = null;
        getMethod = new GetMethod(this.convertURL(url));
        this.hm = getMethod;
        getMethod.getParams().setParameter("http.socket.timeout", new Integer(WAIT_TIMEOUT));
        getMethod.getParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler());
        int statusCode = -1;
        statusCode = "".equals(this.address) ? this.httpClient.executeMethod(getMethod) : this.httpClient.executeMethod(this.getProxy(this.httpClient), getMethod);
        if (statusCode != 200) {
            throw new HttpException();
        }
        InputStream instream = getMethod.getResponseBodyAsStream();
        FileOutputStream outstream = new FileOutputStream(new File(filename));
        long contentlength = getMethod.getResponseContentLength();
        long downlength = 0L;
        byte[] buffer = new byte[4096];
        try {
            try {
                while (true) {
                    int len;
                    if ((len = instream.available()) != -1) {
                        if (len > 4096) {
                            len = 4096;
                        }
                        len = instream.read(buffer);
                        ((OutputStream)outstream).write(buffer, 0, len);
                        Vector<Object> vec = new Vector<Object>();
                        vec.add(filename2);
                        vec.add(downlength += (long)len);
                        uiEvent ue = new uiEvent(this, 4, vec);
                        uiEventSource.getuiEventSource().activeuiEvent(ue);
                        System.out.println("progress: " + String.valueOf(downlength * 100L / contentlength) + "%");
                        if (contentlength == downlength) {
                            break;
                        }
                    }
                    Thread.sleep(1L);
                }
            }
            catch (Exception e) {
                System.err.println("download  error   " + url);
                e.printStackTrace();
                throw new LogicException(7);
            }
        }
        finally {
            this.hm = null;
            ((OutputStream)outstream).close();
            instream.close();
        }
    }

    public void downloadFile(String url, String filename) throws Exception {
        GetMethod getMethod = null;
        getMethod = new GetMethod(this.convertURL(url));
        getMethod.getParams().setParameter("http.socket.timeout", new Integer(WAIT_TIMEOUT));
        getMethod.getParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler());
        int statusCode = -1;
        statusCode = "".equals(this.address) ? this.httpClient.executeMethod(getMethod) : this.httpClient.executeMethod(this.getProxy(this.httpClient), getMethod);
        if (statusCode != 200) {
            if (statusCode == 404) {
                return;
            }
            throw new HttpException();
        }
        InputStream instream = getMethod.getResponseBodyAsStream();
        FileOutputStream outstream = new FileOutputStream(new File(filename));
        long contentlength = getMethod.getResponseContentLength();
        long downlength = 0L;
        byte[] buffer = new byte[4096];
        try {
            try {
                while (true) {
                    int len;
                    if ((len = instream.available()) != -1) {
                        if (len > 4096) {
                            len = 4096;
                        }
                        len = instream.read(buffer);
                        ((OutputStream)outstream).write(buffer, 0, len);
                        System.out.println("progress: " + String.valueOf((downlength += (long)len) * 100L / contentlength) + "%");
                        if (contentlength == downlength) {
                            break;
                        }
                    }
                    Thread.sleep(1L);
                }
            }
            catch (Exception e) {
                System.out.println("download  error" + url);
                e.printStackTrace();
                throw new LogicException(5);
            }
        }
        finally {
            ((OutputStream)outstream).close();
            instream.close();
        }
    }

    private String convertURL(String url) {
        if (url == null) {
            return null;
        }
        return url.trim().replaceAll(" ", "%20");
    }

    public byte[] postMethodRequest(String url, String input, String contentType) throws Exception {
        PostMethod postMethod = null;
        try {
            if (url == null) {
                throw new LogicException(1);
            }
            postMethod = new PostMethod(this.convertURL(url));
            postMethod.getParams().setParameter("http.socket.timeout", new Integer(WAIT_TIMEOUT));
            byte[] bytes = input.getBytes();
            InputStreamRequestEntity entity = new InputStreamRequestEntity(new ByteArrayInputStream(bytes));
            postMethod.setRequestEntity(entity);
            int statusCode = -1;
            statusCode = "".equals(this.address) ? this.httpClient.executeMethod(postMethod) : this.httpClient.executeMethod(this.getProxy(this.httpClient), postMethod);
            if (statusCode == 200) {
                return postMethod.getResponseBody();
            }
            throw new HttpException();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public byte[] postXMLRequest(String url, String input) throws Exception {
        String contentType = "text/xml; charset=UTF-8";
        return this.postMethodRequest(url, input, contentType);
    }

    public void postXMLRequestNoErr(String url, String input) {
        PostMethod postMethod = null;
        try {
            postMethod = new PostMethod(this.convertURL(url));
            postMethod.getParams().setParameter("http.socket.timeout", new Integer(WAIT_TIMEOUT));
            byte[] bytes = input.getBytes();
            InputStreamRequestEntity entity = new InputStreamRequestEntity(new ByteArrayInputStream(bytes));
            postMethod.setRequestEntity(entity);
            int statusCode = -1;
            statusCode = "".equals(this.address) ? this.httpClient.executeMethod(postMethod) : this.httpClient.executeMethod(this.getProxy(this.httpClient), postMethod);
            if (statusCode == 200) {
                postMethod.getResponseBody();
            }
            System.err.println("UpdateDone: " + statusCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

