/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.onlineupdate.logic;

import com.huawei.mobilePartner.onlineupdate.logic.CustomSecureProtocolSocketFactory;
import com.huawei.mobilePartner.onlineupdate.logic.LogicException;
import com.huawei.mobilePartner.onlineupdate.logic.UpdateInfo;
import java.io.IOException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class HttpTest {
    private HttpClient httpClient = new HttpClient(new SimpleHttpConnectionManager());
    private static int WAIT_TIMEOUT = 20000;
    private String svrPort = null;
    private String svrAddr = null;

    public HttpTest() throws Exception {
        this.httpClient.getParams().setSoTimeout(WAIT_TIMEOUT);
        this.httpClient.setConnectionTimeout(60000);
        this.svrAddr = UpdateInfo.getUpdateInfo().getIP();
        this.svrPort = UpdateInfo.getUpdateInfo().getPort();
        String protocol = UpdateInfo.getUpdateInfo().getProtocol();
        if ("https".equals(protocol)) {
            this.setPort(Integer.parseInt(this.svrPort), true);
        } else if ("http".equals(protocol)) {
            this.setPort(Integer.parseInt(this.svrPort), false);
        } else {
            throw new Exception();
        }
    }

    public void setPort(int logon_port, int logon_sslport) {
        this.setPort(logon_port, false);
        this.setPort(logon_sslport, true);
    }

    public void setPort(int logon_port, boolean isSSL) {
        if (isSSL) {
            Protocol myhttps = new Protocol("https", (ProtocolSocketFactory)new CustomSecureProtocolSocketFactory(), logon_port);
            Protocol.registerProtocol("https", myhttps);
        } else {
            Protocol http = Protocol.getProtocol("http");
            Protocol myhttp = new Protocol("http", http.getSocketFactory(), logon_port);
            Protocol.registerProtocol("http", myhttp);
        }
    }

    public HostConfiguration getProxy(HttpClient client, String address, int port, String username, String password) {
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
        client.getState().setProxyCredentials(AuthScope.ANY, creds);
        HostConfiguration hcf = new HostConfiguration();
        hcf.setProxy(address, port);
        return hcf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean testConnection(String ip, String port, String username, String password) {
        if ("".equals(ip) && !"".equals(port)) {
            return false;
        }
        if (!"".equals(ip) && "".equals(port)) {
            return false;
        }
        if ("".equals(username) && !"".equals(password)) {
            return false;
        }
        HttpMethodBase getMethod = null;
        try {
            getMethod = new GetMethod(this.convertURL(String.valueOf(UpdateInfo.getUpdateInfo().getProtocol()) + "://" + this.svrAddr + ":" + this.svrPort));
            getMethod.getParams().setParameter("http.socket.timeout", new Integer(WAIT_TIMEOUT));
            if (!"".equals(ip) && !"".equals(port)) {
                this.httpClient.executeMethod(this.getProxy(this.httpClient, ip, Integer.valueOf(port), username, password), getMethod);
            } else {
                this.httpClient.executeMethod(getMethod);
            }
            if (407 == getMethod.getStatusCode()) {
                System.err.println("UUUUUUUUUUUUUUUUU");
                return false;
            }
            System.err.println(getMethod.getStatusCode());
            return true;
        }
        catch (HttpException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (LogicException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    private String convertURL(String url) {
        if (url == null) {
            return null;
        }
        return url.trim().replaceAll(" ", "%20");
    }

    public static void main(String[] args) throws Exception {
        if (new HttpTest().testConnection("", "", "", "")) {
            System.out.println("Connect sucess");
        }
    }
}

