/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.onlineupdate.assistant;

import com.huawei.mobilePartner.gui.ui.AppFrame;
import com.huawei.mobilePartner.onlineupdate.assistant.OnlineUpdateEntry;
import com.huawei.mobilePartner.onlineupdate.logic.LogicException;
import com.huawei.mobilePartner.onlineupdate.logic.UpdateConfig;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AutoRunAdapter {
    private String currentDate;
    private String referenceDate;
    private int cycleDate;
    private long cycletime;
    private UpdateConfig insUpdateConfig = UpdateConfig.getUpdateConfig();

    private AutoRunAdapter() throws LogicException {
        if (this.isAutoCheck()) {
            this.referenceDate = this.insUpdateConfig.getUpdateDate();
            this.cycleDate = this.insUpdateConfig.getCycle();
            this.cycletime = 86400000L * (long)this.cycleDate;
        }
    }

    private boolean isAutoCheck() {
        return this.insUpdateConfig.getAutoCheck() == 1;
    }

    private boolean checkDate() {
        Date date;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        try {
            date = sdf.parse(this.referenceDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
        long updatetime = date.getTime();
        return System.currentTimeMillis() > updatetime + this.cycletime || System.currentTimeMillis() < updatetime;
    }

    public static void excute() throws LogicException {
        AutoRunAdapter ins = new AutoRunAdapter();
        if (!ins.isAutoCheck()) {
            return;
        }
        if (!ins.checkDate()) {
            return;
        }
        OnlineUpdateEntry.excute(1);
        AppFrame appframe = AppFrame.getAppFrameInit();
        appframe.checkupdate.setEnabled(false);
    }

    public static void main(String[] args) throws LogicException {
        AutoRunAdapter.excute();
    }
}

