/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.ussd;

import com.huawei.mobilePartner.gui.ui.AppFrame;
import com.huawei.mobilePartner.gui.ui.ussd.BalanceDialog;
import com.huawei.mobilePartner.gui.ui.ussd.DownBorder;
import com.huawei.mobilePartner.gui.ui.ussd.TopupDialog;
import com.huawei.mobilePartner.gui.ui.ussd.USSDStaticVariable;
import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class USSDPopupMenuButton
implements ActionListener,
Serializable {
    private JButton button;
    private JPopupMenu popupMenu;
    private AppFrame frame = AppFrame.getAppFrameInit();
    public ImageIcon icon;

    public USSDPopupMenuButton(ImageIcon icon) {
        this.icon = icon;
        JMenuItem topupItem = new JMenuItem(USSDStaticVariable.lb.getUssd_Topup_Menu_Name());
        topupItem.setName(USSDStaticVariable.lb.getUssd_Topup_Menu_Name());
        topupItem.setBackground(Color.WHITE);
        JMenuItem accountItem = new JMenuItem(USSDStaticVariable.lb.getUssd_Account_Menu_Name());
        accountItem.setName(USSDStaticVariable.lb.getUssd_Account_Menu_Name());
        topupItem.addActionListener(this);
        accountItem.addActionListener(this);
        topupItem.setBackground(Color.WHITE);
        accountItem.setBackground(Color.WHITE);
        this.button = new JButton(){

            public void paintComponent(Graphics g) {
                super.setText("");
                super.paintComponent(g);
                FontMetrics fm = g.getFontMetrics();
                int wordHeight = fm.getHeight();
                int y = (this.getHeight() - wordHeight) / 2 + fm.getAscent();
                Image image = USSDPopupMenuButton.this.icon.getImage();
                int iw = USSDPopupMenuButton.this.icon.getIconWidth();
                int ih = USSDPopupMenuButton.this.icon.getIconHeight();
                g.drawImage(image, 0, 0, iw, ih, null, USSDPopupMenuButton.this.button);
                g.drawString(USSDStaticVariable.lb.getUssd().trim(), iw + 5, y);
                g.setColor(Color.BLACK);
                g.fillPolygon(new int[]{this.getWidth() - 12, this.getWidth() - 6, this.getWidth() - 9}, new int[]{this.getHeight() / 2 - 2, this.getHeight() / 2 - 2, this.getHeight() / 2 + 2}, 3);
            }

            public void setUI(ButtonUI ui) {
                if (ui instanceof WindowsButtonUI) {
                    ui = new BasicButtonUI();
                }
                super.setUI(ui);
            }
        };
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.setPreferredSize(new Dimension(100, 40));
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(topupItem);
        this.popupMenu.add(accountItem);
        this.popupMenu.setBackground(Color.WHITE);
        this.popupMenu.setPopupSize(new Dimension(100, 50));
        this.button.addActionListener(this);
    }

    protected void showPopupMenu() {
        if (this.popupMenu == null) {
            return;
        }
        this.popupMenu.show(this.button, 0, this.button.getHeight());
    }

    public JButton getPopupMenuButton() {
        return this.button;
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JButton) {
            this.button.setBorder(new DownBorder());
            this.showPopupMenu();
        }
        if (obj instanceof JMenuItem) {
            try {
                JMenuItem item = (JMenuItem)obj;
                ExecutorService service = Executors.newFixedThreadPool(1);
                if (item.getName().equals(USSDStaticVariable.lb.getUssd_Topup_Menu_Name())) {
                    TopupDialog td = new TopupDialog(this.frame);
                } else {
                    USSDStaticVariable.threadSign = "BalanceDialog";
                    BalanceDialog bd = new BalanceDialog(this.frame);
                    service.submit(bd);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

