/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.ussd;

import com.huawei.mobilePartner.business.ussd.UssdManage;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.data.comm.service.UssdService;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.gui.ui.GetButtonBackground;
import com.huawei.mobilePartner.gui.ui.PinPrompt;
import com.huawei.mobilePartner.gui.ui.ussd.OnLineValuePINPanel;
import com.huawei.mobilePartner.gui.ui.ussd.QueryBalancePanel;
import com.huawei.mobilePartner.gui.ui.ussd.QueryMSISDNPanel;
import com.huawei.mobilePartner.gui.ui.ussd.ValuePINPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class USSDDialog
extends JDialog
implements ActionListener {
    public XMLTool tool;
    public Map panelMap = new HashMap();
    public JSeparator js;
    public JPanel panel;
    public JButton closeButton;
    public JLabel valuePINLabel;
    public LanguageBean lb = CustomizeInit.getLanguageBean();
    public int iStyle;
    public String MSISDNFlag;
    public String balanceFlag;
    private Thread balanceThread;
    private Thread MSISDNThread;
    private Thread valueThread;
    UssdManage ussdManage = new UssdManage();
    UssdService ussdService = new UssdService();

    public USSDDialog(JFrame frame, String strValue, String strTitle) {
        super((Frame)frame, false);
        this.setLocation(frame.getX() + 100, frame.getY() + 120);
        try {
            XMLTool.setImportExport(false);
            this.tool = new XMLTool("config/data/USSDPluginConfig.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getContentPane().setLayout(null);
        int height = this.loadPanel(strValue);
        this.setModal(true);
        this.setTitle(strTitle);
        this.getContentPane().setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.closeButton = new JButton();
        this.closeButton.setText(this.lb.getOperation_3_Close());
        this.panel = new JPanel();
        this.valuePINLabel = new JLabel();
        this.valuePINLabel.setBounds(0, 0, 200, 15);
        this.panel.add(this.valuePINLabel);
        this.panel.setBounds(10, height + 15, 670, 60);
        this.panel.setLayout(null);
        this.closeButton.setBounds(490, 30, 130, 28);
        this.closeButton.addActionListener(this);
        this.closeButton.setActionCommand("close");
        GetButtonBackground.setButtonBackground(this.closeButton);
        this.panel.add(this.closeButton);
        this.panel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        this.add(this.panel);
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            this.setSize(648, height + this.panel.getHeight() + 60);
        } else if (os.indexOf("mac") >= 0) {
            this.setSize(635, height + this.panel.getHeight() + 60);
        } else if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
            this.setSize(648, height + this.panel.getHeight() + 60);
        }
        Tools.showWindowCenter(this);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent arg0) {
                USSDDialog.this.ussdService.finishUssdDialog();
                UssdManage.USSD_RETURN_VALUE = "0";
                if (USSDDialog.this.balanceThread != null && USSDDialog.this.balanceThread.isAlive()) {
                    USSDDialog.this.balanceThread.interrupt();
                }
                if (USSDDialog.this.MSISDNThread != null && USSDDialog.this.MSISDNThread.isAlive()) {
                    USSDDialog.this.MSISDNThread.interrupt();
                }
                if (USSDDialog.this.valueThread != null && USSDDialog.this.valueThread.isAlive()) {
                    USSDDialog.this.valueThread.interrupt();
                }
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        if ("close".equals(e.getActionCommand())) {
            this.dispose();
        } else if ("updateButton".equals(e.getActionCommand())) {
            this.queryBalanceThread();
        } else if ("MSISDNUpdateButton".equals(e.getActionCommand())) {
            this.queryMSISDNThread();
        } else if ("activeButton".equals(e.getActionCommand())) {
            String para = ValuePINPanel.textField.getText();
            ValuePINPanel.activeButton.setEnabled(false);
            GetButtonBackground.setButtonBackground(ValuePINPanel.activeButton);
            this.valuePINThread(para);
        }
    }

    public int loadPanel(String strValue) {
        this.getQueryBalancePanel(strValue);
        this.getValuePINPanel(strValue);
        this.getOnLineValuePINPanel(strValue);
        this.getQueryMSISDNPanel(strValue);
        Set set = this.panelMap.keySet();
        ArrayList list = new ArrayList();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        Collections.sort(list);
        int i = 0;
        while (i < list.size()) {
            JPanel panel = (JPanel)this.panelMap.get(list.get(i));
            panel.setSize(new Dimension(625, 90));
            panel.setBounds(new Rectangle(10, i * panel.getHeight() + 10 + 1, 625, 90));
            panel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
            this.add(panel);
            if (i + 1 != list.size()) {
                this.js = new JSeparator();
                this.js.setBounds(10, i * panel.getHeight() + 10 + 90, 615, 50);
                this.js.setBackground(Color.black);
                this.add(this.js);
            }
            ++i;
        }
        return this.panelMap.size() * 90;
    }

    public void getQueryBalancePanel(String strValue) {
        String[] str = new String[]{"name", "value", "pos"};
        List list = this.tool.quertyNodePropertiesValueByPath("/USSD/" + strValue + "/item[@name=\"Balance\"]", str);
        Map map = (Map)list.get(0);
        this.balanceFlag = map.get("value").toString();
        if ("true".equals(map.get("value").toString())) {
            QueryBalancePanel queryBalancePanel = new QueryBalancePanel();
            queryBalancePanel.initialize();
            this.queryBalanceThread();
            QueryBalancePanel.updateButton.addActionListener(this);
            QueryBalancePanel.updateButton.setActionCommand("updateButton");
            QueryBalancePanel.updateButton.setEnabled(false);
            GetButtonBackground.setButtonBackground(QueryBalancePanel.updateButton);
            String strPlace = map.get("pos").toString();
            Map mapCommand = this.tool.quertyNodeTextValueByPath("/USSD/" + strValue + "/item[@name=\"Balance\"]/command");
            String strCommand = mapCommand.get("command").toString();
            this.panelMap.put(strPlace, queryBalancePanel);
        }
    }

    public void queryBalanceThread() {
        QueryBalancePanel.valueText.setText(this.lb.getUSSD_CODE_WAITTING());
        QueryBalancePanel.updateButton.setEnabled(false);
        GetButtonBackground.setButtonBackground(QueryBalancePanel.updateButton);
        this.balanceThread = new Thread(new Runnable(){

            public void run() {
                String str = USSDDialog.this.ussdManage.sendUssdRequest("Balance", null);
                if ("failed".equals(str) || "".equals(str)) {
                    QueryBalancePanel.valueText.setText(USSDDialog.this.lb.getUSSD_CODE_FAILED());
                    QueryBalancePanel.updateButton.setEnabled(true);
                    GetButtonBackground.setButtonBackground(QueryBalancePanel.updateButton);
                } else {
                    QueryBalancePanel.valueText.setText(str);
                    QueryBalancePanel.updateButton.setEnabled(true);
                    GetButtonBackground.setButtonBackground(QueryBalancePanel.updateButton);
                }
            }
        });
        this.balanceThread.start();
    }

    public void queryMSISDNThread() {
        QueryMSISDNPanel.valueText.setText(this.lb.getUSSD_CODE_WAITTING());
        if (QueryMSISDNPanel.updateButton != null) {
            QueryMSISDNPanel.updateButton.setEnabled(false);
            GetButtonBackground.setButtonBackground(QueryMSISDNPanel.updateButton);
        }
        this.MSISDNThread = new Thread(new Runnable(){

            public void run() {
                String str = USSDDialog.this.ussdManage.sendUssdRequest("MSISDN", null);
                if ("failed".equals(str) || "".equals(str)) {
                    QueryMSISDNPanel.valueText.setText(USSDDialog.this.lb.getUSSD_CODE_FAILED());
                } else {
                    QueryMSISDNPanel.valueText.setText(str);
                }
                if (QueryMSISDNPanel.updateButton != null) {
                    QueryMSISDNPanel.updateButton.setEnabled(true);
                    GetButtonBackground.setButtonBackground(QueryMSISDNPanel.updateButton);
                }
            }
        });
        this.MSISDNThread.start();
    }

    public void valuePINThread(final String para) {
        this.valuePINLabel.setText(this.lb.getUSSD_CODE_WAITTING());
        ValuePINPanel.textField.setEnabled(false);
        this.valueThread = new Thread(new Runnable(){

            public void run() {
                String str = USSDDialog.this.ussdManage.sendUssdRequest("Charge", para);
                if (str.equals(CustomizeInit.getLanguageBean().getUssd_Memu_One_Content()) || str.equals(CustomizeInit.getLanguageBean().getUSSD_Code_Time_Out()) || str.equals(CustomizeInit.getLanguageBean().getUssd_Memu_One_Content())) {
                    ValuePINPanel.textField.setEnabled(true);
                    ValuePINPanel.activeButton.setEnabled(true);
                    GetButtonBackground.setButtonBackground(ValuePINPanel.activeButton);
                    USSDDialog.this.valuePINLabel.setText(str);
                } else {
                    ValuePINPanel.textField.setEnabled(true);
                    ValuePINPanel.activeButton.setEnabled(true);
                    GetButtonBackground.setButtonBackground(ValuePINPanel.activeButton);
                    if (USSDDialog.this.iStyle == 0) {
                        USSDDialog.this.valuePINLabel.setText(str);
                    } else if (USSDDialog.this.iStyle == 1) {
                        USSDDialog.this.valuePINLabel.setText("");
                        PinPrompt.showConfirmDialog(null, str, "", 0);
                    }
                    if ("true".equals(USSDDialog.this.balanceFlag.toLowerCase())) {
                        USSDDialog.this.queryBalanceThread();
                    }
                }
            }
        });
        this.valueThread.start();
    }

    public void getValuePINPanel(String strValue) {
        String[] str = new String[]{"name", "value", "pos"};
        List list = this.tool.quertyNodePropertiesValueByPath("/USSD/" + strValue + "/item[@name=\"Charge\"]", str);
        Map map = (Map)list.get(0);
        if ("true".equals(map.get("value").toString())) {
            String strPlace = map.get("pos").toString();
            Map mapStyle = this.tool.quertyNodeTextValueByPath("/USSD/" + strValue + "/item[@name=\"Charge\"]/ReturnStyle");
            this.iStyle = Integer.parseInt(mapStyle.get("ReturnStyle").toString());
            Map mapLength = this.tool.quertyNodeTextValueByPath("/USSD/" + strValue + "/item[@name=\"Charge\"]/length");
            int iLength = Integer.parseInt(mapLength.get("length").toString());
            mapLength = this.tool.quertyNodeTextValueByPath("/USSD/" + strValue + "/item[@name=\"Charge\"]/minlenth");
            int minlenth = Integer.parseInt(mapLength.get("minlenth").toString());
            ValuePINPanel valuePINPanel = new ValuePINPanel();
            valuePINPanel.init(iLength, minlenth);
            ValuePINPanel.activeButton.addActionListener(this);
            ValuePINPanel.activeButton.setActionCommand("activeButton");
            this.panelMap.put(strPlace, valuePINPanel);
        }
    }

    public void getOnLineValuePINPanel(String strValue) {
        String[] str = new String[]{"name", "value", "pos"};
        List list = this.tool.quertyNodePropertiesValueByPath("/USSD/" + strValue + "/item[@name=\"OnlineCharge\"]", str);
        Map map = (Map)list.get(0);
        if ("true".equals(map.get("value").toString())) {
            String strPlace = map.get("pos").toString();
            Map mapURL = this.tool.quertyNodeTextValueByPath("/USSD/" + strValue + "/item[@name=\"OnlineCharge\"]/URL");
            String strURL = (String)mapURL.get("URL");
            OnLineValuePINPanel onLineValuePINPanel = new OnLineValuePINPanel();
            onLineValuePINPanel.init(strURL);
            this.panelMap.put(strPlace, onLineValuePINPanel);
        }
    }

    public void getQueryMSISDNPanel(String strValue) {
        String[] str = new String[]{"name", "value", "pos"};
        List list = this.tool.quertyNodePropertiesValueByPath("/USSD/" + strValue + "/item[@name=\"MSISDN\"]", str);
        Map map = (Map)list.get(0);
        this.MSISDNFlag = map.get("value").toString();
        if ("true".equals(map.get("value").toString())) {
            String strPlace = map.get("pos").toString();
            Map mapUpdateButton = this.tool.quertyNodeTextValueByPath("/USSD/" + strValue + "/item[@name=\"MSISDN\"]/UpdateButton");
            int iUpdateButton = Integer.parseInt(mapUpdateButton.get("UpdateButton").toString());
            QueryMSISDNPanel queryMSISDNPanel = new QueryMSISDNPanel();
            queryMSISDNPanel.init(iUpdateButton);
            if (iUpdateButton == 1) {
                QueryMSISDNPanel.updateButton.addActionListener(this);
                QueryMSISDNPanel.updateButton.setActionCommand("MSISDNUpdateButton");
                QueryMSISDNPanel.updateButton.setEnabled(false);
                GetButtonBackground.setButtonBackground(QueryMSISDNPanel.updateButton);
            }
            this.queryMSISDNThread();
            this.panelMap.put(strPlace, queryMSISDNPanel);
        }
    }
}

