/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.telbookui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

class TreeLabel
extends JLabel {
    boolean isSelected;
    boolean hasFocus;

    TreeLabel() {
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public void paint(Graphics g) {
        String str = this.getText();
        if (str != null && str.length() > 0) {
            if (this.isSelected) {
                g.setColor(UIManager.getColor("Tree.selectionBackground"));
            } else {
                g.setColor(UIManager.getColor("Tree.textBackground"));
            }
            Dimension d = this.getPreferredSize();
            int imageOffset = 0;
            Icon currentI = this.getIcon();
            if (currentI != null) {
                imageOffset = currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
            }
            g.fillRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
            if (this.hasFocus) {
                g.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                g.drawRect(imageOffset, 0, d.width - 1 - imageOffset, d.height - 1);
            }
        }
        super.paint(g);
    }

    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 3, retDimension.height);
        }
        return retDimension;
    }

    void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    void setFocus(boolean hasFocus) {
        this.hasFocus = hasFocus;
    }
}

