/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.telbookui;

import com.huawei.mobilePartner.business.sms.commserver.ParameterConfigServer;
import com.huawei.mobilePartner.business.telephoneBook.commserver.CommonMethodByTelBook;
import com.huawei.mobilePartner.business.telephoneBook.commserver.SaveTelToDeviceXML;
import com.huawei.mobilePartner.business.telephoneBook.commserver.SaveTelToSimXML;
import com.huawei.mobilePartner.business.telephoneBook.commserver.TelHomeCode;
import com.huawei.mobilePartner.business.telephoneBook.commserver.TeleManageDevice;
import com.huawei.mobilePartner.business.telephoneBook.commserver.TeleManageLocal;
import com.huawei.mobilePartner.business.telephoneBook.commserver.TeleManageSim;
import com.huawei.mobilePartner.common.interfaces.PublicConfig;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.JUTPSOptionDialog;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.config.bean.CustomizeBean;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.data.comm.service.SmsCommService;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.gui.ui.GetButtonBackground;
import com.huawei.mobilePartner.gui.ui.PinPrompt;
import com.huawei.mobilePartner.gui.ui.telbookui.PhoneBookPanel;
import com.huawei.mobilePartner.gui.ui.telbookui.SimCardContactDialog;
import com.huawei.mobilePartner.gui.ui.telbookui.TelNameJTextField;
import com.huawei.mobilePartner.gui.ui.telbookui.TelNameJTextFieldListener;
import com.huawei.mobilePartner.gui.ui.telbookui.TelNumJTextField;
import com.huawei.mobilePartner.gui.ui.telbookui.TelNumJTextFieldListener;
import com.huawei.mobilePartner.gui.ui.telbookui.TelSimCardNameText;
import com.huawei.mobilePartner.gui.ui.telbookui.TelSimCardNameTextListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreePath;

public class SimCardContactPanel
extends JPanel {
    private CustomizeBean cb = CustomizeInit.getCustomizeBean();
    private JButton cancel;
    private SimCardContactDialog dialog;
    private JLabel nameLabel = new JLabel(lb.getOperation_4_Name());
    private TelSimCardNameText nameText = null;
    private JLabel mobileLabel = new JLabel(lb.getOperation_4_MobileNumber());
    private TelNumJTextField mobileText = null;
    private JLabel emaileLabel = new JLabel(lb.getOperation_4_EmailAddress());
    private TelNameJTextField emaileText = null;
    private JLabel officeLabel = new JLabel(lb.getOperation_4_OfficeNumber());
    private TelNumJTextField officeText = null;
    private JButton okButton;
    static LanguageBean lb = CustomizeInit.getLanguageBean();
    private static LogConfig log = Log.getLog(SimCardContactPanel.class);
    SmsCommService smsCommService = SmsCommService.getInstance();
    String text1 = "";
    String id = "";
    private AppFrame frame = null;
    PhoneBookPanel phoneBookPanel;
    TeleManageSim teleManageSim = new TeleManageSim();
    TeleManageDevice teleManageDevice = new TeleManageDevice();

    public SimCardContactPanel(JDialog dialog, AppFrame frame, String id) {
        this.dialog = (SimCardContactDialog)dialog;
        this.frame = frame;
        this.id = id;
        this.phoneBookPanel = frame.phoneBookPanel;
        this.initPanel();
    }

    public SimCardContactPanel() {
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(3, 12, 0, 12));
        this.setBackground(ChangeColor.getColor(this.cb.getNetWorkPanel_1()));
        try {
            this.add((Component)this.getCenterPanel(), "Center");
        }
        catch (Exception e) {
            log.info(e.toString());
        }
        this.add((Component)this.getSouthPanel(), "South");
        this.nameLabel.setFont(Tools.setFont());
        this.mobileLabel.setFont(Tools.setFont());
        this.emaileLabel.setFont(Tools.setFont());
        this.officeLabel.setFont(Tools.setFont());
        this.cancel.setFont(Tools.setFont());
        this.okButton.setFont(Tools.setFont());
        this.okButton.setPreferredSize(this.cancel.getPreferredSize());
    }

    private JPanel getCenterPanel() throws Exception {
        String name = "";
        String mobileNumber = "";
        String emailAddress = "";
        String officeNumber = "";
        ArrayList contactList = TeleManageSim.queryContact(this.id);
        if (contactList != null) {
            int i = 0;
            while (i < contactList.size()) {
                HashMap contactMap = (HashMap)contactList.get(i);
                name = (String)contactMap.get("name");
                mobileNumber = (String)contactMap.get("mobileNumber");
                if (contactMap.get("officeNumber") != null) {
                    officeNumber = (String)contactMap.get("officeNumber");
                }
                ++i;
            }
        }
        this.nameText = new TelSimCardNameText();
        TelHomeCode telHomeCode = new TelHomeCode();
        int codingFormat = TelHomeCode.getStrigLength(name, PublicConfig.simNameMaxLength);
        if (name.length() > codingFormat) {
            name = name.substring(0, codingFormat);
        }
        this.nameText.setText(name);
        this.nameText.setMinimumSize(new Dimension(200, 18));
        this.nameText.setBorder(BorderFactory.createLoweredBevelBorder());
        this.nameText.getDocument().addDocumentListener(new TelSimCardNameTextListener(this.nameText));
        this.nameText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e3) {
                SimCardContactPanel.this.name_KeyListener(e3);
            }

            public void keyTyped(KeyEvent e3) {
            }
        });
        String mobileTextLen = Tools.getConfigValueFromXML("config/data/UICustomize.xml", "utpsdoc/function/item", "MaxPhoneBookNumberLength");
        int length = Integer.parseInt(mobileTextLen);
        this.mobileText = new TelNumJTextField(length);
        if (mobileNumber.length() > length) {
            mobileNumber = mobileNumber.substring(0, length);
        }
        this.mobileText.setText(mobileNumber);
        this.mobileText.setMinimumSize(new Dimension(200, 18));
        this.mobileText.setBorder(BorderFactory.createLoweredBevelBorder());
        this.mobileText.getDocument().addDocumentListener(new TelNumJTextFieldListener(this.mobileText));
        this.mobileText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e3) {
                SimCardContactPanel.this.mobile_KeyListener(e3);
            }

            public void keyTyped(KeyEvent e3) {
                SimCardContactPanel.this.mobile_KeyListener(e3);
            }
        });
        this.officeText = new TelNumJTextField(length);
        if (officeNumber.length() > length) {
            officeNumber = officeNumber.substring(0, length);
        }
        this.officeText.setText(officeNumber);
        this.officeText.setMinimumSize(new Dimension(200, 18));
        this.officeText.setBorder(BorderFactory.createLoweredBevelBorder());
        this.officeText.getDocument().addDocumentListener(new TelNumJTextFieldListener(this.mobileText));
        this.officeText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e3) {
                SimCardContactPanel.this.mobile_KeyListener(e3);
            }

            public void keyTyped(KeyEvent e3) {
                SimCardContactPanel.this.mobile_KeyListener(e3);
            }
        });
        this.emaileText = new TelNameJTextField(64);
        this.emaileText.setVisible(false);
        this.emaileLabel.setVisible(false);
        this.emaileText.setText(emailAddress);
        this.emaileText.setMinimumSize(new Dimension(200, 18));
        this.emaileText.setBorder(BorderFactory.createLoweredBevelBorder());
        this.emaileText.getDocument().addDocumentListener(new TelNameJTextFieldListener(this.emaileText));
        JPanel centerNorthPanel = new JPanel(new GridBagLayout());
        centerNorthPanel.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        JPanel CenterNorthPanelleft = new JPanel(new GridBagLayout());
        CenterNorthPanelleft.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        JPanel CenterNorthPanelright = new JPanel(new GridBagLayout());
        CenterNorthPanelright.setBackground(ChangeColor.getColor(CustomizeInit.getCustomizeBean().getNetWorkPanel_1()));
        CenterNorthPanelleft.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 12.0, 12.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        CenterNorthPanelright.add((Component)this.nameText, new GridBagConstraints(1, 0, 6, 1, 12.0, 12.0, 10, 1, new Insets(2, 2, 2, 12), 0, 0));
        CenterNorthPanelleft.add((Component)this.mobileLabel, new GridBagConstraints(0, 1, 1, 1, 12.0, 12.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        CenterNorthPanelright.add((Component)this.mobileText, new GridBagConstraints(1, 1, 6, 1, 12.0, 12.0, 10, 1, new Insets(2, 2, 2, 12), 0, 0));
        CenterNorthPanelleft.add((Component)this.officeLabel, new GridBagConstraints(0, 2, 1, 1, 12.0, 12.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        CenterNorthPanelright.add((Component)this.officeText, new GridBagConstraints(1, 2, 6, 1, 12.0, 12.0, 10, 1, new Insets(2, 2, 2, 12), 0, 0));
        CenterNorthPanelleft.add((Component)this.emaileLabel, new GridBagConstraints(0, 4, 1, 1, 12.0, 12.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        CenterNorthPanelright.add((Component)this.emaileText, new GridBagConstraints(1, 4, 6, 1, 12.0, 12.0, 10, 1, new Insets(2, 2, 2, 12), 0, 0));
        centerNorthPanel.add((Component)CenterNorthPanelleft, new GridBagConstraints(0, 0, 1, 1, 12.0, 12.0, 10, 1, new Insets(2, 2, 2, 0), 0, 0));
        centerNorthPanel.add((Component)CenterNorthPanelright, new GridBagConstraints(1, 0, 1, 1, 12.0, 12.0, 10, 1, new Insets(2, 0, 2, 2), 0, 0));
        CommonMethodByTelBook commonMethod = new CommonMethodByTelBook();
        String telColumnConfig = CommonMethodByTelBook.getPhonebookMemoryBySM();
        if (telColumnConfig.toLowerCase().indexOf("office") == -1) {
            this.officeLabel.setVisible(false);
            this.officeText.setVisible(false);
        }
        return centerNorthPanel;
    }

    private JPanel getSouthPanel() {
        JPanel southPanel = new JPanel(new FlowLayout(2, 12, 12));
        southPanel.setBackground(ChangeColor.getColor(this.cb.getNetWorkPanel_1()));
        this.okButton = new JButton(lb.getTools_3_OK());
        this.okButton.setEnabled(false);
        GetButtonBackground.setButtonBackground(this.okButton);
        this.okButton.setEnabled(false);
        this.okButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SimCardContactPanel.this.okButton_actionPerformed();
                }
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimCardContactPanel.this.okButton_actionPerformed();
            }
        });
        this.cancel = new JButton(lb.getTools_3_Cancel());
        GetButtonBackground.setButtonBackground(this.cancel);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimCardContactPanel.this.dialog.dispose();
            }
        });
        this.cancel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SimCardContactPanel.this.dialog.dispose();
                }
            }
        });
        Tools.macButton(southPanel, this.okButton, this.cancel);
        return southPanel;
    }

    public void okButton_actionPerformed() {
        log.info("okButton_actionPerformed come in time:" + System.currentTimeMillis());
        TreePath path = this.phoneBookPanel.tree.getSelectionPath();
        String info = path.getLastPathComponent().toString();
        if (info.indexOf("(") > -1) {
            info = info.substring(0, info.indexOf("("));
        }
        if (info.equalsIgnoreCase(lb.getOperation_3_Local()) && !AppFrame.getAppFrameInit().phoneBookPanel.treeSelectLeaf) {
            info = "";
        }
        String name = this.nameText.getText();
        String mobile = this.mobileText.getText();
        String office = this.officeText.getText();
        if (mobile.equalsIgnoreCase("+")) {
            PinPrompt.showConfirmDialog(null, lb.getOperation_failed(), lb.getOperation_1_Connect_Fail(), 0);
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("mobileNumber", mobile);
        map.put("officeNumber", office);
        Object mobileList = null;
        if ("".equals(this.id)) {
            if (!info.equalsIgnoreCase(lb.getOperation_3_Sim())) {
                info.equalsIgnoreCase(lb.getOperation_3_Device());
            }
            boolean hasEqualsContact = TeleManageSim.hasEqualsContact(mobile);
            log.info("hasEqualsContact time: " + System.currentTimeMillis());
            if (hasEqualsContact) {
                Object[] obj = new Object[]{lb.getTools_3_OK(), lb.getTools_3_Cancel()};
                if (JUTPSOptionDialog.showConfirmDialog(this.frame, lb.getPrompt_exists_phone(), lb.getTools_5_ProfileManagement_Delete_Prompt(), 0) == 0) {
                    this.updatexml(map, info, path);
                }
            } else {
                this.updatexml(map, info, path);
            }
        } else {
            map.put("index", this.id);
            this.updatexml(map, info, path);
        }
    }

    public void updatexml(HashMap map, String info, TreePath path) {
        if (info.equalsIgnoreCase(lb.getOperation_3_Sim())) {
            this.updateSimxml(map, path);
        } else if (info.equalsIgnoreCase(lb.getOperation_3_Device())) {
            this.updateDevicexml(map, path);
        }
    }

    public void updateDevicexml(HashMap map, TreePath path) {
        boolean bool = false;
        String[] addId = new String[1];
        if ("".equals(this.id)) {
            try {
                Tools.logToControl("out", "SaveTelToSimXML.savePhone begin");
                bool = SaveTelToDeviceXML.savePhone(map);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String simxmlpath = String.valueOf(ParameterConfigServer.userdata_dir) + "userdata/telbook/DeviceTelBook.xml";
            XMLTool.setImportExport(true);
            try {
                XMLTool comm = new XMLTool(simxmlpath, "root", new String[]{"seqid"}, new String[]{"1"});
                addId[0] = String.valueOf(Integer.parseInt(comm.getNodePropertiesValue("root", "seqid")) + 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            addId[0] = this.id;
            try {
                Tools.logToControl("out", "updatexml.id======" + this.id);
                map.put("id", this.id);
                bool = SaveTelToDeviceXML.editPhone(map);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (bool) {
            this.phoneBookPanel.editContactButton.setEnabled(false);
            this.phoneBookPanel.delContactButton.setEnabled(false);
            this.phoneBookPanel.sendButton.setEnabled(false);
            TeleManageLocal teleManageLocal = new TeleManageLocal();
            teleManageLocal.freshLocalTree(this.phoneBookPanel, path, this.phoneBookPanel.tree);
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("panel", this.phoneBookPanel);
            map1.put("id", addId);
            this.teleManageDevice.freshContact(map1);
            this.phoneBookPanel.updateUI();
            Tools.logToControl("out", "new TreePath(phoneBookPanel.tree.getRoot())======" + new TreePath(this.phoneBookPanel.tree.getModel().getRoot()));
        }
        this.dialog.dispose();
    }

    public void updateSimxml(HashMap map, TreePath path) {
        boolean bool = true;
        PublicConfig.simSelectIdList = new StringBuffer();
        String[] addId = new String[1];
        if ("".equals(this.id)) {
            try {
                bool = SaveTelToSimXML.savePhoneOne(map);
                log.info(" savePhoneOne time:" + System.currentTimeMillis());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            addId[0] = PublicConfig.maxTelHomeIndex;
        } else {
            addId[0] = this.id;
            try {
                map.put("id", this.id);
                bool = SaveTelToSimXML.editPhone(map);
                log.info(" editPhone time:" + System.currentTimeMillis());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (bool) {
            this.phoneBookPanel.editContactButton.setEnabled(false);
            this.phoneBookPanel.delContactButton.setEnabled(false);
            this.phoneBookPanel.sendButton.setEnabled(false);
            TeleManageLocal teleManageLocal = new TeleManageLocal();
            this.phoneBookPanel.isChangeCall = true;
            teleManageLocal.freshLocalTree(this.phoneBookPanel, path, this.phoneBookPanel.tree);
            log.info("fresh freshLocalTree time:" + System.currentTimeMillis());
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("panel", this.phoneBookPanel);
            map1.put("id", addId);
            this.teleManageSim.freshContact(map1);
            this.phoneBookPanel.updateUI();
            log.info("fresh freshContact time:" + System.currentTimeMillis());
        }
        this.dialog.dispose();
    }

    public void name_KeyListener(KeyEvent key) {
        int userLength = this.nameText.getText().length();
        int length = Integer.parseInt(PublicConfig.simNameMaxLength);
        this.setOkButtonEnable();
    }

    public void mobile_KeyListener(KeyEvent key) {
        int userLength = this.mobileText.getText().length();
        int length = Integer.parseInt(PublicConfig.simTelMaxLength);
        this.setOkButtonEnable();
    }

    private void setOkButtonEnable() {
        if (this.nameText.getText().trim().length() + this.mobileText.getText().trim().length() == 0) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
        GetButtonBackground.setButtonBackground(this.okButton);
    }

    public void emaile_KeyListener(KeyEvent key) {
        int userLength = this.emaileText.getText().length();
        if (userLength >= 64 && key.getKeyChar() != '\b') {
            String emaileTxt = this.emaileText.getText().substring(0, 64);
            this.emaileText.setText(emaileTxt);
        }
    }
}

