/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.telbookui;

import com.huawei.mobilePartner.business.sms.commserver.ParameterConfigServer;
import com.huawei.mobilePartner.business.telephoneBook.commserver.CommonMethodByTelBook;
import com.huawei.mobilePartner.business.telephoneBook.commserver.TeleManageDevice;
import com.huawei.mobilePartner.business.telephoneBook.commserver.TeleManageLocal;
import com.huawei.mobilePartner.business.telephoneBook.commserver.TeleManageSim;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.ExcelToXmlUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.config.bean.CustomizeBean;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.data.comm.service.SmsCommService;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.gui.ui.GetButtonBackground;
import com.huawei.mobilePartner.gui.ui.HScrollBarUI;
import com.huawei.mobilePartner.gui.ui.VScrollBarUI;
import com.huawei.mobilePartner.gui.ui.telbookui.ContactPanel;
import com.huawei.mobilePartner.gui.ui.telbookui.DragTelBookTableModel;
import com.huawei.mobilePartner.gui.ui.telbookui.ImportContactDialog;
import com.huawei.mobilePartner.gui.ui.telbookui.ImportContactTransferHandler;
import com.huawei.mobilePartner.gui.ui.telbookui.PhoneBookPanel;
import com.huawei.mobilePartner.gui.ui.telbookui.TelTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreePath;

public class ImportContactPanel
extends JPanel {
    private CustomizeBean cb = CustomizeInit.getCustomizeBean();
    private JButton cancel;
    private ImportContactDialog dialog;
    private JLabel fileNameLabel = new JLabel("");
    private JLabel localLabel;
    private JButton okButton;
    static LanguageBean lb = CustomizeInit.getLanguageBean();
    private static LogConfig log = Log.getLog(ContactPanel.class);
    SmsCommService smsCommService = SmsCommService.getInstance();
    String text1 = "";
    String fileName = "";
    private AppFrame frame = null;
    private JTextArea textArea = new JTextArea();
    PhoneBookPanel phoneBookPanel;
    TeleManageLocal teleManageLocal = new TeleManageLocal();
    TeleManageSim teleManageSim = new TeleManageSim();
    TeleManageDevice teleManageDevice = new TeleManageDevice();
    private CommonMethodByTelBook commonMethod = new CommonMethodByTelBook();
    JTable leftTable = new JTable();
    JTable centerTable = new JTable();

    public ImportContactPanel(JDialog dialog, AppFrame frame, String fileName) {
        this.dialog = (ImportContactDialog)dialog;
        this.frame = frame;
        this.fileName = fileName;
        this.phoneBookPanel = frame.phoneBookPanel;
        this.initPanel();
    }

    public ImportContactPanel() {
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(3, 12, 0, 12));
        this.setBackground(ChangeColor.getColor(this.cb.getPanel_border()));
        this.textArea.setBackground(ChangeColor.getColor(this.cb.getPanel_border()));
        this.textArea.setFocusable(false);
        String prompt = lb.getPrompt_drag();
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textArea.setText(prompt);
        this.add((Component)this.textArea, "North");
        try {
            JPanel centerPanel = this.getCenterPanel();
            this.add((Component)centerPanel, "Center");
        }
        catch (Exception e) {
            log.info(e.toString());
        }
        this.add((Component)this.getSouthPanel(), "South");
        this.leftTable.getTableHeader().setDefaultRenderer(new TelTableCellRenderer());
        this.centerTable.getTableHeader().setDefaultRenderer(new TelTableCellRenderer());
    }

    private JPanel getCenterPanel() throws Exception {
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(3, 12, 0, 12));
        centerPanel.setBackground(ChangeColor.getColor(this.cb.getPanel_border()));
        CommonMethodByTelBook commonMethodByTelBook = new CommonMethodByTelBook();
        DragTelBookTableModel lTableModel = null;
        DragTelBookTableModel cTableModel = null;
        this.leftTable.setDragEnabled(true);
        this.leftTable.setFocusable(false);
        this.leftTable.setSelectionMode(0);
        this.leftTable.setTransferHandler(new ImportContactTransferHandler());
        this.leftTable.getTableHeader().setForeground(Color.BLACK);
        if (!"".equals(this.fileName)) {
            int ind = this.fileName.lastIndexOf("\\");
            if (ind < 0) {
                ind = this.fileName.lastIndexOf("/");
            }
            this.fileNameLabel.setText(this.fileName.substring(ind + 1));
            lTableModel = this.teleManageLocal.getImportLTabModel(this.fileName);
            int columnCount = this.phoneBookPanel.boxTable.getColumnCount();
            String[] colName = new String[columnCount];
            int i = 0;
            while (i < columnCount) {
                colName[i] = this.phoneBookPanel.boxTable.getColumnName(i);
                ++i;
            }
            cTableModel = this.teleManageLocal.getImportCTabModel(colName, this.fileName);
        }
        this.leftTable.setModel(lTableModel);
        this.leftTable.getTableHeader().setBackground(ChangeColor.getColor(this.cb.getAppFrame_createPhoneBookPanel_8()));
        this.leftTable.getTableHeader().setForeground(Color.BLACK);
        this.leftTable.getTableHeader().setBackground(ChangeColor.getColor(this.cb.getAppFrame_createToolPanel_2()));
        this.leftTable.getTableHeader().setFont(Tools.setFont());
        this.leftTable.setAutoResizeMode(0);
        JScrollPane lScrollPane = new JScrollPane(this.leftTable);
        if (!System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            JScrollBar bar3 = lScrollPane.getHorizontalScrollBar();
            JScrollBar bar4 = lScrollPane.getVerticalScrollBar();
            bar3.setUI(new VScrollBarUI());
            bar4.setUI(new HScrollBarUI());
        }
        lScrollPane.setBorder(new LineBorder(ChangeColor.getColor(this.cb.getDefault_border()), 1, true));
        JPanel centerLPanel = new JPanel();
        centerLPanel.setLayout(new BorderLayout());
        centerLPanel.setBackground(ChangeColor.getColor(this.cb.getAppFrame_createPhoneBookPanel_4()));
        centerLPanel.add((Component)this.fileNameLabel, "North");
        centerLPanel.add((Component)lScrollPane, "Center");
        this.centerTable.setModel(cTableModel);
        this.centerTable.setDragEnabled(true);
        this.centerTable.setSelectionMode(0);
        this.centerTable.setTransferHandler(new ImportContactTransferHandler());
        this.centerTable.getTableHeader().setBackground(ChangeColor.getColor(this.cb.getAppFrame_createPhoneBookPanel_8()));
        this.centerTable.getTableHeader().setForeground(Color.BLACK);
        this.centerTable.setAutoResizeMode(0);
        this.centerTable.getTableHeader().setForeground(Color.BLACK);
        this.centerTable.getTableHeader().setBackground(ChangeColor.getColor(this.cb.getAppFrame_createToolPanel_2()));
        this.centerTable.getTableHeader().setFont(Tools.setFont());
        this.centerTable.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (!System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
                    if (e.getKeyCode() == 127) {
                        ImportContactPanel.this.deleteItem();
                    }
                } else if (e.getKeyCode() == 8) {
                    ImportContactPanel.this.deleteItem();
                }
            }

            public void keyReleased(KeyEvent e) {
                int row = ImportContactPanel.this.centerTable.getSelectedRow();
                DragTelBookTableModel model = (DragTelBookTableModel)ImportContactPanel.this.centerTable.getModel();
                String ss = (String)model.getValueAt(row, 1);
                model.setValueAt(ss, row, 1);
                ImportContactPanel.this.centerTable.setModel(model);
                ImportContactPanel.this.centerTable.updateUI();
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane cScrollPane = new JScrollPane(this.centerTable);
        if (!System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            JScrollBar bar5 = cScrollPane.getHorizontalScrollBar();
            JScrollBar bar6 = cScrollPane.getVerticalScrollBar();
            bar5.setUI(new VScrollBarUI());
            bar6.setUI(new HScrollBarUI());
        }
        cScrollPane.setBorder(new LineBorder(ChangeColor.getColor(this.cb.getDefault_border()), 1, true));
        String treeNode = this.phoneBookPanel.tree.getSelectionPath().toString();
        this.localLabel = treeNode.indexOf(lb.getLabel_local()) > -1 ? new JLabel(lb.getLabel_local()) : (treeNode.indexOf(lb.getOperation_3_Device()) > -1 ? new JLabel(lb.getOperation_3_Device()) : new JLabel(lb.getOperation_3_Sim()));
        JPanel centerCPanel = new JPanel();
        centerCPanel.setLayout(new BorderLayout());
        centerCPanel.setBackground(ChangeColor.getColor(this.cb.getAppFrame_createPhoneBookPanel_4()));
        centerCPanel.add((Component)this.localLabel, "North");
        centerCPanel.add((Component)cScrollPane, "Center");
        JSplitPane phoneBookSplitPane = new JSplitPane();
        phoneBookSplitPane.setLeftComponent(centerLPanel);
        phoneBookSplitPane.setDividerSize(4);
        phoneBookSplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        phoneBookSplitPane.setRightComponent(centerCPanel);
        phoneBookSplitPane.setResizeWeight(0.3);
        phoneBookSplitPane.setBackground(new Color(221, 241, 255));
        commonMethodByTelBook.setSplitPaneDividerColor(phoneBookSplitPane, new Color(221, 241, 255));
        centerPanel.add(phoneBookSplitPane);
        return centerPanel;
    }

    private JPanel getSouthPanel() {
        JPanel southPanel = new JPanel(new FlowLayout(2, 12, 12));
        southPanel.setBackground(ChangeColor.getColor(this.cb.getNetWorkPanel_1()));
        this.okButton = new JButton(lb.getTools_3_OK());
        this.okButton.setPreferredSize(new Dimension(110, 29));
        GetButtonBackground.setButtonBackground(this.okButton);
        this.okButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ImportContactPanel.this.okButton_actionPerformed();
                }
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportContactPanel.this.okButton_actionPerformed();
            }
        });
        this.cancel = new JButton(lb.getTools_3_Cancel());
        this.cancel.setPreferredSize(new Dimension(110, 29));
        GetButtonBackground.setButtonBackground(this.cancel);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportContactPanel.this.dialog.dispose();
            }
        });
        this.cancel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ImportContactPanel.this.dialog.dispose();
                }
            }
        });
        Tools.macButton(southPanel, this.okButton, this.cancel);
        return southPanel;
    }

    public void okButton_actionPerformed() {
        String xmlpath = "";
        String strId = "";
        int id = 0;
        TreePath path = this.phoneBookPanel.tree.getSelectionPath();
        String info = path.getLastPathComponent().toString();
        int importRowCount = 0;
        if (info.indexOf("(") > -1) {
            info = info.substring(0, info.lastIndexOf("("));
        }
        String[] strPropertiesName = new String[]{(String)this.centerTable.getValueAt(0, 1), (String)this.centerTable.getValueAt(1, 1), (String)this.centerTable.getValueAt(2, 1), (String)this.centerTable.getValueAt(3, 1), (String)this.centerTable.getValueAt(4, 1), (String)this.centerTable.getValueAt(5, 1)};
        ExcelToXmlUtil excelToXmlUtil = new ExcelToXmlUtil();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("panel", this.phoneBookPanel);
        if (info.equalsIgnoreCase(lb.getOperation_3_Sim()) && !AppFrame.getAppFrameInit().phoneBookPanel.treeSelectLeaf) {
            XMLTool comm;
            this.phoneBookPanel.impaim = "2";
            this.commonMethod.geterrimppar(this.centerTable);
            xmlpath = String.valueOf(ParameterConfigServer.userdata_dir) + "userdata/telbook/SimTelBook.xml";
            try {
                try {
                    XMLTool.setImportExport(true);
                    comm = new XMLTool(xmlpath, "root", new String[]{"seqid"}, new String[]{"1"});
                    String strid = comm.getNodePropertiesValue("root", "seqid");
                    id = Integer.parseInt(strid) + 1;
                    strId = String.valueOf(id);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            finally {
                comm = null;
            }
            this.dialog.dispose();
            XMLTool.setImportExport(false);
            importRowCount = excelToXmlUtil.importCsvDataToSimXml(this.fileName, strPropertiesName);
            String[] impId = new String[importRowCount];
            int i = 0;
            while (i < importRowCount) {
                impId[i] = String.valueOf(id + i);
                ++i;
            }
            TeleManageLocal teleManageLocal = new TeleManageLocal();
            this.phoneBookPanel.isChangeCall = true;
            teleManageLocal.freshLocalTree(this.phoneBookPanel, path, this.phoneBookPanel.tree);
            map1.put("id", impId);
            this.teleManageSim.freshContact(map1);
        } else if (info.equalsIgnoreCase(lb.getOperation_3_Device()) && !AppFrame.getAppFrameInit().phoneBookPanel.treeSelectLeaf) {
            XMLTool comm;
            this.phoneBookPanel.impaim = "3";
            this.commonMethod.geterrimppar(this.centerTable);
            xmlpath = String.valueOf(ParameterConfigServer.userdata_dir) + "userdata/telbook/DeviceTelBook.xml";
            XMLTool.setImportExport(true);
            try {
                try {
                    comm = new XMLTool(xmlpath, "root", new String[]{"seqid"}, new String[]{"1"});
                    String strid = comm.getNodePropertiesValue("root", "seqid");
                    id = Integer.parseInt(strid) + 1;
                    strId = String.valueOf(id);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            finally {
                comm = null;
            }
            this.dialog.dispose();
            XMLTool.setImportExport(false);
            importRowCount = excelToXmlUtil.importCsvDataToDeviceXml(this.fileName, strPropertiesName);
            String[] impId = new String[importRowCount];
            int i = 0;
            while (i < importRowCount) {
                impId[i] = String.valueOf(id + i);
                ++i;
            }
            TeleManageLocal teleManageLocal = new TeleManageLocal();
            this.phoneBookPanel.isChangeCall = true;
            teleManageLocal.freshLocalTree(this.phoneBookPanel, path, this.phoneBookPanel.tree);
            map1.put("id", impId);
            this.teleManageDevice.freshContact(map1);
        } else {
            XMLTool comm;
            this.phoneBookPanel.impaim = "1";
            this.commonMethod.geterrimppar(this.centerTable);
            String group = "";
            if (info.equalsIgnoreCase(lb.getOperation_3_Local()) && !AppFrame.getAppFrameInit().phoneBookPanel.treeSelectLeaf) {
                info = "";
            } else {
                group = this.teleManageLocal.setXmlGroup(info);
            }
            xmlpath = String.valueOf(ParameterConfigServer.userdata_dir) + "userdata/telbook/LocalTelBook.xml";
            XMLTool.setImportExport(true);
            try {
                try {
                    comm = new XMLTool(xmlpath, "root", new String[]{"seqid"}, new String[]{"1"});
                    String strid = comm.getNodePropertiesValue("root", "seqid");
                    id = Integer.parseInt(strid) + 1;
                    strId = String.valueOf(id);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            finally {
                comm = null;
            }
            this.dialog.dispose();
            importRowCount = excelToXmlUtil.importCsvDataToXml(info, this.fileName, strPropertiesName);
            String[] impId = new String[importRowCount];
            int i = 0;
            while (i < importRowCount) {
                impId[i] = String.valueOf(id + i);
                ++i;
            }
            this.phoneBookPanel.isChangeCall = true;
            this.teleManageLocal.freshLocalTree(this.phoneBookPanel, path, this.phoneBookPanel.tree);
            map1.put("id", impId);
            this.teleManageLocal.freshContact(map1);
        }
        this.commonMethod.offerrimp(this.centerTable);
    }

    public void deleteItem() {
        int row = this.centerTable.getSelectedRow();
        if (row >= 0) {
            this.centerTable.setValueAt(null, row, 1);
            this.centerTable.updateUI();
        }
    }
}

