/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.telbookui;

import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.config.bean.CustomizeBean;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.gui.ui.GetButtonBackground;
import com.huawei.mobilePartner.gui.ui.call.CallUILogic;
import com.huawei.mobilePartner.gui.ui.telbookui.CallContactDialog;
import com.huawei.mobilePartner.gui.ui.telbookui.ContactPanel;
import com.huawei.mobilePartner.gui.ui.telbookui.ImportContactTransferHandler;
import com.huawei.mobilePartner.gui.ui.telbookui.PhoneBookPanel;
import com.huawei.mobilePartner.gui.ui.telbookui.TelTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;

public class CallContactPanel
extends JPanel {
    private CustomizeBean cb = CustomizeInit.getCustomizeBean();
    private JButton cancel;
    private CallContactDialog dialog;
    private JButton okButton;
    static LanguageBean lb = CustomizeInit.getLanguageBean();
    private static LogConfig log = Log.getLog(ContactPanel.class);
    private String nodeStr;
    private AppFrame frame = null;
    private PhoneBookPanel phoneBookPanel;
    private JTable centerTable = new JTable();
    HashMap map;

    public CallContactPanel(JDialog dialog, AppFrame frame, HashMap map) {
        this.dialog = (CallContactDialog)dialog;
        this.frame = frame;
        this.map = map;
        this.phoneBookPanel = frame.phoneBookPanel;
        this.initPanel();
    }

    public CallContactPanel() {
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(3, 5, 0, 5));
        this.setBackground(ChangeColor.getColor(this.cb.getPanel_border()));
        try {
            this.add((Component)this.getCenterPanel(), "Center");
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        this.add((Component)this.getSouthPanel(), "South");
        this.centerTable.getTableHeader().setDefaultRenderer(new TelTableCellRenderer());
    }

    private JPanel getCenterPanel() throws Exception {
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(3, 5, 0, 5));
        centerPanel.setBackground(ChangeColor.getColor(this.cb.getPanel_border()));
        DefaultTableModel cTableModel = null;
        cTableModel = this.getCTabModel(this.map);
        JPanel centerLPanel = new JPanel();
        centerLPanel.setLayout(new BorderLayout());
        centerLPanel.setBackground(ChangeColor.getColor(this.cb.getAppFrame_createPhoneBookPanel_4()));
        this.centerTable.setModel(cTableModel);
        this.centerTable.setDragEnabled(true);
        this.centerTable.setSelectionMode(0);
        this.centerTable.setTransferHandler(new ImportContactTransferHandler());
        this.centerTable.getTableHeader().setBackground(ChangeColor.getColor(this.cb.getAppFrame_createPhoneBookPanel_8()));
        this.centerTable.getTableHeader().setForeground(Color.WHITE);
        this.centerTable.getTableHeader().setBackground(ChangeColor.getColor(this.cb.getAppFrame_createToolPanel_2()));
        this.centerTable.getTableHeader().setFont(Tools.setFont());
        this.centerTable.setAutoResizeMode(0);
        this.centerTable.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane cScrollPane = new JScrollPane(this.centerTable);
        centerPanel.add(cScrollPane);
        return centerPanel;
    }

    private JPanel getSouthPanel() {
        JPanel southPanel = new JPanel(new FlowLayout(2, 12, 12));
        southPanel.setBackground(ChangeColor.getColor(this.cb.getNetWorkPanel_1()));
        this.okButton = new JButton(lb.getTools_3_OK());
        GetButtonBackground.setButtonBackground(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CallContactPanel.this.okButton_actionPerformed();
            }
        });
        this.okButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CallContactPanel.this.okButton_actionPerformed();
                }
            }
        });
        this.cancel = new JButton(lb.getTools_3_Cancel());
        GetButtonBackground.setButtonBackground(this.cancel);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CallContactPanel.this.dialog.dispose();
            }
        });
        this.cancel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CallContactPanel.this.dialog.dispose();
                }
            }
        });
        Tools.macButton(southPanel, this.okButton, this.cancel);
        return southPanel;
    }

    public void okButton_actionPerformed() {
        int row = this.centerTable.getSelectedRow();
        String number = (String)this.centerTable.getValueAt(row, 1);
        CallUILogic callUILogic = CallUILogic.getInstance();
        this.dialog.dispose();
        callUILogic.onCallPanel(number);
    }

    public DefaultTableModel getCTabModel(HashMap map) {
        DefaultTableModel retTableModel = new DefaultTableModel();
        try {
            Vector<String> rowData = new Vector<String>();
            rowData.add("Number type");
            rowData.add("Number");
            retTableModel.setColumnIdentifiers(rowData);
            int i = 0;
            while (i < 8) {
                Vector<String> rowDataV = new Vector<String>();
                rowDataV.add("");
                rowDataV.add("");
                retTableModel.addRow(rowDataV);
                ++i;
            }
            String office = (String)map.get("officeNumber");
            String mobile = (String)map.get("mobileNumber");
            String home = (String)map.get("homeNumber");
            if (!Tools.isEmpty(mobile)) {
                retTableModel.setValueAt(lb.getOperation_4_MobileNumber(), 0, 0);
                retTableModel.setValueAt(mobile, 0, 1);
                if (!Tools.isEmpty(office)) {
                    retTableModel.setValueAt(lb.getOperation_4_OfficeNumber(), 1, 0);
                    retTableModel.setValueAt(office, 1, 1);
                    if (!Tools.isEmpty(home)) {
                        retTableModel.setValueAt(lb.getOperation_4_HomeNumber(), 2, 0);
                        retTableModel.setValueAt(home, 2, 1);
                    }
                } else {
                    retTableModel.setValueAt(lb.getOperation_4_HomeNumber(), 1, 0);
                    retTableModel.setValueAt(home, 1, 1);
                }
            } else {
                retTableModel.setValueAt(lb.getOperation_4_OfficeNumber(), 0, 0);
                retTableModel.setValueAt(office, 0, 1);
                retTableModel.setValueAt(lb.getOperation_4_HomeNumber(), 1, 0);
                retTableModel.setValueAt(home, 1, 1);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
        return retTableModel;
    }
}

