/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.statistics;

import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import java.awt.Color;
import java.awt.Dimension;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WeeklyFieldPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int index = 0;
    private JSpinner spinner = new JSpinner();
    private JTextField textField = new JTextField();
    private LanguageBean lb;
    public String[] WEEK_STRING;

    public WeeklyFieldPanel() {
        CustomizeInit.getCustomizeInit();
        this.lb = CustomizeInit.getLanguageBean();
        this.WEEK_STRING = new String[]{this.lb.getTools_operation_2_Sunday(), this.lb.getTools_operation_2_Monday(), this.lb.getTools_operation_2_Tuesday(), this.lb.getTools_operation_2_Wednesday(), this.lb.getTools_operation_2_Thursday(), this.lb.getTools_operation_2_Friday(), this.lb.getTools_operation_2_Saturday()};
        this.spinner.setBounds(100, 0, 16, 20);
        this.textField.setBounds(0, 0, 100, 20);
        this.textField.setEditable(false);
        this.textField.setHorizontalAlignment(4);
        this.textField.setBackground(new Color(255, 255, 255));
        this.spinner.setOpaque(false);
        this.setLayout(null);
        this.add(this.spinner);
        this.add(this.textField);
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                try {
                    WeeklyFieldPanel.this.setText();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void setValue(int index) {
        this.index = index;
        if (this.index < 0 || 7 < this.index) {
            this.index = 0;
        }
        String weekInfo = this.WEEK_STRING[index];
        this.spinner.setValue(index);
        this.textField.setText(weekInfo);
    }

    public Object getValue() {
        block2: {
            try {
                this.spinner.commitEdit();
            }
            catch (ParseException pe) {
                JComponent editor = this.spinner.getEditor();
                if (!(editor instanceof JSpinner.DefaultEditor)) break block2;
                ((JSpinner.DefaultEditor)editor).getTextField().setValue(this.spinner.getValue());
            }
        }
        return this.spinner.getValue();
    }

    public void setComponentEnable(boolean enabled) {
        this.spinner.setEnabled(enabled);
        this.textField.setEnabled(enabled);
    }

    private void setText() {
        int value = 0;
        value = this.spinner.getValue() == null || "".equals(this.spinner.getValue()) ? 0 : Integer.parseInt(this.spinner.getValue().toString());
        if (value < 0) {
            this.spinner.setValue(6);
            this.textField.setText(this.WEEK_STRING[6]);
        } else if (value > 6) {
            this.spinner.setValue(0);
            this.textField.setText(this.WEEK_STRING[0]);
        } else {
            this.textField.setText(this.WEEK_STRING[value]);
        }
    }

    public static void main(String[] ar) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new WeeklyFieldPanel());
        frame.setSize(new Dimension(500, 200));
        frame.setVisible(true);
    }
}

