/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.statistics;

import com.huawei.mobilePartner.business.sms.smsset.CommandButton;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.gui.ui.GetButtonBackground;
import com.huawei.mobilePartner.gui.ui.statistics.AbsoluteConstraints;
import com.huawei.mobilePartner.gui.ui.statistics.AbsoluteLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.BorderUIResource;

public final class DatePicker
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int startX = 10;
    private static final int startY = 60;
    private static final Font smallFont = new Font("Dialog", 0, 10);
    private static final Font largeFont = new Font("Dialog", 0, 12);
    private static final Insets insets = new Insets(2, 2, 2, 2);
    private static final Color highlight = Color.ORANGE;
    private static final Color white = new Color(255, 255, 255);
    private static final Color gray = new Color(204, 204, 204);
    private Component selectedDay = null;
    private GregorianCalendar selectedDate = null;
    private GregorianCalendar originalDate = null;
    private boolean hideOnSelect = true;
    private final CommandButton backButton = new CommandButton();
    private final JLabel monthAndYear = new JLabel();
    private final CommandButton forwardButton = new CommandButton();
    static LanguageBean lb = CustomizeInit.getLanguageBean();
    private final JLabel[] dayHeadings = new JLabel[]{new JLabel(lb.getTools_operation_2_Sunday()), new JLabel(lb.getTools_operation_2_Monday()), new JLabel(lb.getTools_operation_2_Tuesday()), new JLabel(lb.getTools_operation_2_Wednesday()), new JLabel(lb.getTools_operation_2_Thursday()), new JLabel(lb.getTools_operation_2_Friday()), new JLabel(lb.getTools_operation_2_Saturday())};
    private final JLabel[][] daysInMonth = new JLabel[][]{{new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel()}, {new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel()}, {new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel()}, {new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel()}, {new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel()}, {new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel()}};
    private final JLabel todayButton = new JLabel();
    private final CommandButton cancelButton = new CommandButton();

    public DatePicker() {
        this.selectedDate = DatePicker.getToday();
        this.init();
    }

    public DatePicker(Date initialDate) {
        if (initialDate == null) {
            this.selectedDate = DatePicker.getToday();
        } else {
            this.selectedDate = new GregorianCalendar();
            this.selectedDate.setTime(initialDate);
        }
        this.originalDate = new GregorianCalendar(this.selectedDate.get(1), this.selectedDate.get(2), this.selectedDate.get(5));
        this.init();
    }

    public boolean isHideOnSelect() {
        return this.hideOnSelect;
    }

    public void setHideOnSelect(boolean hideOnSelect) {
        if (this.hideOnSelect != hideOnSelect) {
            this.hideOnSelect = hideOnSelect;
            this.initButtons(false);
        }
    }

    public Date getDate() {
        if (this.selectedDate != null) {
            return this.selectedDate.getTime();
        }
        return null;
    }

    private void init() {
        this.setLayout(new AbsoluteLayout());
        this.setMinimumSize(new Dimension(510, 226));
        this.setMaximumSize(this.getMinimumSize());
        this.setPreferredSize(this.getMinimumSize());
        this.setBorder(new BorderUIResource.EtchedBorderUIResource());
        this.backButton.setFont(smallFont);
        this.backButton.setText("<");
        this.backButton.setMargin(insets);
        this.backButton.setDefaultCapable(false);
        this.backButton.setFocusable(false);
        GetButtonBackground.setButtonBackground(this.backButton);
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatePicker.this.onBackClicked(evt);
            }
        });
        this.add((Component)this.backButton, new AbsoluteConstraints(10, 10, 20, 20));
        this.monthAndYear.setFont(largeFont);
        this.monthAndYear.setHorizontalAlignment(0);
        this.monthAndYear.setText(DatePicker.formatDateText(this.selectedDate.getTime()));
        this.monthAndYear.setFocusable(false);
        this.add((Component)this.monthAndYear, new AbsoluteConstraints(150, 10, 200, 20));
        this.forwardButton.setFont(smallFont);
        this.forwardButton.setText(">");
        this.forwardButton.setMargin(insets);
        this.forwardButton.setDefaultCapable(false);
        this.forwardButton.setFocusable(false);
        GetButtonBackground.setButtonBackground(this.forwardButton);
        this.forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatePicker.this.onForwardClicked(evt);
            }
        });
        this.add((Component)this.forwardButton, new AbsoluteConstraints(480, 10, 20, 20));
        int x = 10;
        int ii = 0;
        while (ii < this.dayHeadings.length) {
            this.dayHeadings[ii].setOpaque(true);
            this.dayHeadings[ii].setBackground(Color.LIGHT_GRAY);
            this.dayHeadings[ii].setForeground(Color.WHITE);
            this.dayHeadings[ii].setHorizontalAlignment(0);
            this.add((Component)this.dayHeadings[ii], new AbsoluteConstraints(x, 40, 70, 21));
            x += 70;
            ++ii;
        }
        x = 10;
        int y = 60;
        int ii2 = 0;
        while (ii2 < this.daysInMonth.length) {
            int jj = 0;
            while (jj < this.daysInMonth[ii2].length) {
                this.daysInMonth[ii2][jj].setOpaque(true);
                this.daysInMonth[ii2][jj].setBackground(white);
                this.daysInMonth[ii2][jj].setFont(smallFont);
                this.daysInMonth[ii2][jj].setHorizontalAlignment(0);
                this.daysInMonth[ii2][jj].setText("");
                this.daysInMonth[ii2][jj].addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent evt) {
                        DatePicker.this.onDayClicked(evt);
                    }
                });
                this.add((Component)this.daysInMonth[ii2][jj], new AbsoluteConstraints(x, y, 70, 21));
                x += 70;
                ++jj;
            }
            x = 10;
            y += 20;
            ++ii2;
        }
        this.initButtons(true);
        this.calculateCalendar();
    }

    private void initButtons(boolean firstTime) {
        if (firstTime) {
            Dimension buttonSize = new Dimension(108, 24);
            SimpleDateFormat simple = new SimpleDateFormat("dd-MM-yyyy");
            Calendar calen = Calendar.getInstance();
            String tempTime = "";
            try {
                tempTime = simple.format(calen.getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.todayButton.setText(String.valueOf(lb.getTools_operation_2_Today()) + " : " + tempTime);
            this.todayButton.setMaximumSize(buttonSize);
            this.todayButton.setMinimumSize(buttonSize);
            this.todayButton.setPreferredSize(buttonSize);
            this.todayButton.setBorder(null);
            this.todayButton.setFocusable(false);
            this.todayButton.setHorizontalAlignment(2);
            this.todayButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    DatePicker.this.onToday(evt);
                }
            });
            this.cancelButton.setText(lb.getTools_operation_2_Cancel());
            this.cancelButton.setMargin(insets);
            this.cancelButton.setMaximumSize(buttonSize);
            this.cancelButton.setMinimumSize(buttonSize);
            this.cancelButton.setPreferredSize(buttonSize);
            this.cancelButton.setFocusable(false);
            GetButtonBackground.setButtonBackground(this.cancelButton);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    DatePicker.this.onCancel(evt);
                }
            });
        } else {
            this.remove(this.todayButton);
            this.remove(this.cancelButton);
        }
        if (this.hideOnSelect) {
            this.add((Component)this.todayButton, new AbsoluteConstraints(10, 190, 260, -1));
            this.add((Component)this.cancelButton, new AbsoluteConstraints(400, 190, 100, -1));
        } else {
            this.add((Component)this.todayButton, new AbsoluteConstraints(10, 190, 260, -1));
        }
    }

    private void onToday(MouseEvent evt) {
        this.selectedDate = DatePicker.getToday();
        this.setVisible(!this.hideOnSelect);
        if (this.isVisible()) {
            this.monthAndYear.setText(DatePicker.formatDateText(this.selectedDate.getTime()));
            this.calculateCalendar();
        }
    }

    private void onCancel(ActionEvent evt) {
        this.selectedDate = this.originalDate;
        this.setVisible(!this.hideOnSelect);
    }

    private void onForwardClicked(ActionEvent evt) {
        int day = this.selectedDate.get(5);
        this.selectedDate.set(5, 1);
        this.selectedDate.add(2, 1);
        this.selectedDate.set(5, Math.min(day, DatePicker.calculateDaysInMonth(this.selectedDate)));
        this.monthAndYear.setText(DatePicker.formatDateText(this.selectedDate.getTime()));
        this.calculateCalendar();
    }

    private void onBackClicked(ActionEvent evt) {
        int day = this.selectedDate.get(5);
        this.selectedDate.set(5, 1);
        this.selectedDate.add(2, -1);
        this.selectedDate.set(5, Math.min(day, DatePicker.calculateDaysInMonth(this.selectedDate)));
        this.monthAndYear.setText(DatePicker.formatDateText(this.selectedDate.getTime()));
        this.calculateCalendar();
    }

    private void onDayClicked(MouseEvent evt) {
        JLabel fld = (JLabel)evt.getSource();
        if (!"".equals(fld.getText())) {
            fld.setBackground(highlight);
            this.selectedDay = fld;
            this.selectedDate.set(5, Integer.parseInt(fld.getText()));
            this.setVisible(!this.hideOnSelect);
        }
    }

    private static GregorianCalendar getToday() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return gc;
    }

    private void calculateCalendar() {
        int week;
        int dd;
        if (this.selectedDay != null) {
            this.selectedDay.setBackground(white);
            this.selectedDay = null;
        }
        GregorianCalendar gCalendar = new GregorianCalendar(this.selectedDate.get(1), this.selectedDate.get(2), 1);
        int maxDay = DatePicker.calculateDaysInMonth(gCalendar);
        int selectedDay = Math.min(maxDay, this.selectedDate.get(5));
        int dow = gCalendar.get(7);
        Locale local = Locale.getDefault();
        if (!"en".equalsIgnoreCase(local.getLanguage())) {
            gCalendar.setFirstDayOfWeek(1);
            gCalendar.setMinimalDaysInFirstWeek(1);
            dow = gCalendar.get(7);
            dd = 0;
            while (dd < dow) {
                this.daysInMonth[0][dd].setText("");
                ++dd;
            }
        } else {
            dd = 0;
            while (dd < dow) {
                this.daysInMonth[0][dd].setText("");
                ++dd;
            }
        }
        do {
            if (!"en".equalsIgnoreCase(local.getLanguage())) {
                gCalendar.setFirstDayOfWeek(1);
                gCalendar.setMinimalDaysInFirstWeek(1);
                week = gCalendar.get(4);
                dow = gCalendar.get(7);
            } else {
                week = gCalendar.get(4);
                dow = gCalendar.get(7);
            }
            JLabel fld = this.daysInMonth[week - 1][dow - 1];
            fld.setText(Integer.toString(gCalendar.get(5)));
            if (selectedDay == gCalendar.get(5)) {
                fld.setBackground(highlight);
                this.selectedDay = fld;
            }
            if (gCalendar.get(5) >= maxDay) break;
            gCalendar.add(5, 1);
        } while (gCalendar.get(5) <= maxDay);
        int ww = --week;
        while (ww < this.daysInMonth.length) {
            int dd2 = dow;
            while (dd2 < this.daysInMonth[ww].length) {
                this.daysInMonth[ww][dd2].setText("");
                ++dd2;
            }
            dow = 0;
            ++ww;
        }
        gCalendar.set(5, selectedDay);
        this.selectedDate = gCalendar;
    }

    private static int calculateDaysInMonth(Calendar c) {
        int daysInMonth = 0;
        switch (c.get(2)) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                daysInMonth = 31;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                daysInMonth = 30;
                break;
            }
            case 1: {
                int year = c.get(1);
                daysInMonth = year % 1000 == 0 ? 29 : (year % 100 == 0 ? 28 : (year % 4 == 0 ? 29 : 28));
            }
        }
        return daysInMonth;
    }

    private static String formatDateText(Date dt) {
        DateFormat df = DateFormat.getDateInstance(1);
        StringBuffer mm = new StringBuffer();
        StringBuffer yy = new StringBuffer();
        FieldPosition mmfp = new FieldPosition(2);
        FieldPosition yyfp = new FieldPosition(1);
        df.format(dt, mm, mmfp);
        df.format(dt, yy, yyfp);
        return String.valueOf(mm.toString().substring(mmfp.getBeginIndex(), mmfp.getEndIndex())) + " " + lb.getOperation_2_Monthly() + " " + yy.toString().substring(yyfp.getBeginIndex(), yyfp.getEndIndex()) + " " + lb.getOperation_2_Yearly();
    }
}

