/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.statistics;

import com.huawei.mobilePartner.business.sms.smsset.CommandButton;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.config.bean.CustomizeBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.gui.ui.GetButtonBackground;
import com.huawei.mobilePartner.gui.ui.statistics.DatePicker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class DateFieldPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public final JTextField dateText = new JTextField(12);
    private final CommandButton dropdownButton = new CommandButton();
    private DatePicker dp;
    private JDialog dlg;
    Point origin = new Point();
    CustomizeBean cb = CustomizeInit.getCustomizeBean();
    String path = "";
    XMLTool xmltool = null;

    public DateFieldPanel() {
        XMLTool.setImportExport(true);
        this.xmltool = new XMLTool();
        this.path = String.valueOf(XMLTool.getClassPath()) + "/config/images/";
        this.path = TextUtil.replaceStr1(this.path, "\\/", "/");
        this.path = TextUtil.replaceStr1(this.path, "\\", "/");
        this.init();
    }

    public DateFieldPanel(Date initialDate) {
        this.init();
        this.dateText.setText(DateFieldPanel.dateToString(initialDate));
    }

    public Date getDate() {
        return DateFieldPanel.stringToDate(this.dateText.getText());
    }

    public void setDate(Date date) {
        String strDate = DateFieldPanel.dateToString(date);
        if (strDate == null) {
            strDate = "";
        }
        this.dateText.setText(strDate);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.dateText.setEditable(false);
        this.dateText.setBackground(new Color(255, 255, 255));
        this.add((Component)this.dateText, "Center");
        ImageIcon icon = new ImageIcon(String.valueOf(this.path) + this.cb.getSelectDate());
        this.dropdownButton.setIcon(icon);
        this.dropdownButton.setOpaque(true);
        this.dropdownButton.setMargin(new Insets(0, 0, 0, 0));
        GetButtonBackground.setButtonBackground(this.dropdownButton);
        this.dropdownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DateFieldPanel.this.onButtonClick(evt);
            }
        });
        this.add((Component)this.dropdownButton, "East");
    }

    private void onButtonClick(ActionEvent evt) {
        this.dp = "".equals(this.dateText.getText()) ? new DatePicker() : new DatePicker(DateFieldPanel.stringToDate(this.dateText.getText()));
        this.dp.addComponentListener(new Listener());
        Point p = this.dateText.getLocationOnScreen();
        p.setLocation(p.getX(), p.getY() - 1.0 + this.dateText.getSize().getHeight());
        this.dlg = new JDialog((Frame)new JFrame(), true);
        this.dlg.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                DateFieldPanel.this.origin.x = e.getX();
                DateFieldPanel.this.origin.y = e.getY();
            }
        });
        this.dlg.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                Point p = DateFieldPanel.this.dlg.getLocation();
                DateFieldPanel.this.dlg.setLocation(p.x + e.getX() - DateFieldPanel.this.origin.x, p.y + e.getY() - DateFieldPanel.this.origin.y);
            }
        });
        this.dlg.setLocation(p);
        this.dlg.setResizable(false);
        this.dlg.setUndecorated(true);
        this.dlg.getContentPane().add(this.dp);
        this.dlg.setSize(new Dimension(520, 230));
        this.dlg.setVisible(true);
    }

    private static String dateToString(Date dt) {
        if (dt != null) {
            SimpleDateFormat simple = new SimpleDateFormat("dd-MM-yyyy");
            String date = simple.format(dt);
            return date;
        }
        return null;
    }

    private static Date stringToDate(String s) {
        try {
            SimpleDateFormat simple = new SimpleDateFormat("dd-MM-yyyy");
            Date date = simple.parse(s);
            return date;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setComponentEnable(boolean enabled) {
        this.dateText.setEnabled(enabled);
        this.dropdownButton.setEnabled(enabled);
    }

    public static void main(String[] args) {
        JDialog dlg = new JDialog((Frame)new JFrame(), true);
        DateFieldPanel df = new DateFieldPanel();
        dlg.getContentPane().add(df);
        dlg.setVisible(true);
        System.out.println(df.getDate().toString());
        System.exit(0);
    }

    final class Listener
    extends ComponentAdapter {
        Listener() {
        }

        public void componentHidden(ComponentEvent evt) {
            Date dt = ((DatePicker)evt.getSource()).getDate();
            if (dt != null) {
                DateFieldPanel.this.dateText.setText(DateFieldPanel.dateToString(dt));
            }
            DateFieldPanel.this.dlg.dispose();
        }
    }
}

