/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.smsui;

import com.huawei.mobilePartner.common.util.JPopupMenuTools;
import com.huawei.mobilePartner.common.util.ScrolJPopupMenuTools;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.gui.ui.smsui.SmsContentPanel;
import com.huawei.mobilePartner.gui.ui.smsui.SmsTableTransferHandler;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.MouseInputListener;

public class SmsMouseInputListener
implements MouseInputListener {
    int number = 0;
    private JPopupMenu popup = null;
    private JTable table = null;
    LanguageBean lb = CustomizeInit.getLanguageBean();
    private SmsContentPanel tableSmsContent;
    private SmsContentPanel scrollSmsContent;
    private JScrollPane boxScrollPane;
    private int[] rowIndex = null;
    private int index = 0;

    public SmsMouseInputListener(JPopupMenu popup, JTable table, SmsContentPanel smsContent) {
        this.popup = popup;
        this.table = table;
        this.tableSmsContent = smsContent;
    }

    public SmsMouseInputListener(JPopupMenu popup, JScrollPane boxScrollPane, SmsContentPanel smsContent) {
        this.popup = popup;
        this.boxScrollPane = boxScrollPane;
        this.scrollSmsContent = smsContent;
    }

    public void mouseClicked(MouseEvent e) {
        if (this.table == null) {
            return;
        }
        if ((e.getModifiers() == 4 || e.getModifiers() == 18 && System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) && this.table != null && this.rowIndex != null) {
            if (this.rowIndex.length == 1 || this.rowIndex.length == 0) {
                this.table.addRowSelectionInterval(this.index, this.index);
            } else {
                int i = 0;
                while (i < this.rowIndex.length) {
                    int index = this.rowIndex[i];
                    this.table.addRowSelectionInterval(index, index);
                    ++i;
                }
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getModifiers() == 16 && e.isControlDown()) {
            if (this.table != null) {
                if (this.rowIndex != null) {
                    int i = 0;
                    while (i < this.rowIndex.length) {
                        this.table.addRowSelectionInterval(this.rowIndex[i], this.rowIndex[i]);
                        ++i;
                    }
                }
                Point p = e.getPoint();
                int selRow = this.table.rowAtPoint(p);
                this.table.addRowSelectionInterval(selRow, selRow);
            }
        } else if (this.table != null) {
            this.rowIndex = this.table.getSelectedRows();
        }
        this.processEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        if (this.table != null) {
            this.index = this.table.getSelectedRow();
        }
        if (e.getModifiers() == 4 || e.getModifiers() == 18 && System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            if (this.table != null) {
                Point p = e.getPoint();
                int selRow = this.table.rowAtPoint(p);
                boolean bFlag = false;
                if (this.rowIndex != null) {
                    int i = 0;
                    while (i < this.rowIndex.length) {
                        this.table.addRowSelectionInterval(this.rowIndex[i], this.rowIndex[i]);
                        if (this.rowIndex[i] == selRow) {
                            bFlag = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (!bFlag) {
                    this.table.setRowSelectionInterval(selRow, selRow);
                }
                JPopupMenuTools jPopup = new JPopupMenuTools(this.tableSmsContent);
                JPopupMenu mnuDisplay = jPopup.getPopupMenu();
                mnuDisplay.show(this.table, e.getX(), e.getY());
            }
            if (this.boxScrollPane != null) {
                ScrolJPopupMenuTools jPopup = new ScrolJPopupMenuTools(this.scrollSmsContent);
                JPopupMenu mnuDisplay = jPopup.getPopupMenu();
                mnuDisplay.show(this.boxScrollPane, e.getX(), e.getY());
            }
        }
        SmsTableTransferHandler.treeFlag = false;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    private void processEvent(MouseEvent e) {
        MouseEvent ne;
        int modifiers;
        if (e.getModifiers() == 4 || e.getModifiers() == 5) {
            modifiers = e.getModifiers();
            modifiers -= 4;
            ne = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), modifiers |= 0x10, e.getX(), e.getY(), e.getClickCount(), false);
            if (this.table != null) {
                this.table.dispatchEvent(ne);
            }
            if (this.boxScrollPane != null) {
                this.boxScrollPane.dispatchEvent(ne);
            }
        }
        if (e.getModifiers() == 18 && System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            modifiers = e.getModifiers();
            modifiers -= 18;
            ne = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), modifiers |= 0x10, e.getX(), e.getY(), e.getClickCount(), false);
            if (this.table != null) {
                this.table.dispatchEvent(ne);
            }
            if (this.boxScrollPane != null) {
                this.boxScrollPane.dispatchEvent(ne);
            }
        }
    }
}

