/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.smsui;

import com.huawei.mobilePartner.common.interfaces.SmsConfigInfo;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.gui.ui.smsui.SmsContentPanel;
import com.huawei.mobilePartner.gui.ui.smsui.SmsTableModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableColumnModel;

public class SmsColumnListener
extends MouseAdapter {
    protected SmsContentPanel smsCont;
    private static int selectRow = -1;

    public SmsColumnListener(SmsContentPanel smsCont) {
        this.smsCont = smsCont;
    }

    public void mouseClicked(MouseEvent e) {
        TableColumnModel colModel;
        int columnModelIndex;
        boolean bSel = false;
        if (this.smsCont.boxTable.getSelectedRowCount() > 0) {
            bSel = true;
        }
        if ((columnModelIndex = (colModel = this.smsCont.boxTable.getColumnModel()).getColumnIndexAtX(e.getX())) == 0) {
            this.sortNameRowContent(this.smsCont.rowContent, SmsConfigInfo.sortNameStatus);
        }
        if (columnModelIndex == 1) {
            this.sortContentRowContent(this.smsCont.rowContent, SmsConfigInfo.sortNameStatus);
        }
        if (columnModelIndex == 2) {
            this.sortDateRowContent(this.smsCont.rowContent, SmsConfigInfo.sortDateStatus);
        }
        this.smsCont.tableHeader = this.smsCont.getTableHeader();
        List temp = Tools.getTableWidth(this.smsCont.boxTable);
        SmsTableModel defaultTableModel = new SmsTableModel(this.smsCont.rowContent, this.smsCont.tableHeader);
        this.smsCont.boxTable.setModel(defaultTableModel);
        Tools.setTableWidth(this.smsCont.boxTable, temp);
        if (this.smsCont.smsMouse != null) {
            this.smsCont.boxTable.removeMouseListener(this.smsCont.smsMouse);
            this.smsCont.smsMouse = null;
        }
        Tools.setTableColumn(this.smsCont.rowContent, this.smsCont.boxTable);
        Tools.setSmsButtonAndTextArea(this.smsCont);
        if (bSel && selectRow != -1) {
            this.smsCont.boxTable.setRowSelectionInterval(selectRow, selectRow);
        }
        this.smsCont.boxTable.updateUI();
    }

    public void sortContentRowContent(Vector sumRowContent, String sortStatus) {
        if (SmsConfigInfo.sortNameStatus.equals("ASC")) {
            SmsConfigInfo.sortNameStatus = "DESC";
        } else if (SmsConfigInfo.sortNameStatus.equals("DESC")) {
            SmsConfigInfo.sortNameStatus = "ASC";
        }
        int sumIndex = 0;
        while (sumIndex < sumRowContent.size()) {
            int rowIndex = 0;
            while (rowIndex < sumRowContent.size() - sumIndex - 1) {
                Vector rowVectorOne = (Vector)sumRowContent.get(rowIndex);
                String afDateTime = rowVectorOne.get(1).toString();
                Vector rowVectorTwo = (Vector)sumRowContent.get(rowIndex + 1);
                String deDateTime = rowVectorTwo.get(1).toString();
                if (sortStatus.equals("DESC") && afDateTime.compareTo(deDateTime) > -1) {
                    sumRowContent.remove(rowVectorOne);
                    sumRowContent.add(rowIndex + 1, rowVectorOne);
                }
                if (sortStatus.equals("ASC") && afDateTime.compareTo(deDateTime) < 0) {
                    sumRowContent.remove(rowVectorOne);
                    sumRowContent.add(rowIndex + 1, rowVectorOne);
                }
                ++rowIndex;
            }
            ++sumIndex;
        }
        this.setSortSelectRowIndex(sumRowContent);
    }

    private void setSortSelectRowIndex(Vector sumRowContent) {
        int sumIndex = 0;
        while (sumIndex < sumRowContent.size()) {
            Vector rowVec = (Vector)sumRowContent.get(sumIndex);
            String id = rowVec.get(3).toString();
            if (SmsConfigInfo.smsSortSelectID.trim().equals(id.trim())) {
                selectRow = sumIndex;
                break;
            }
            ++sumIndex;
        }
    }

    public void sortNameRowContent(Vector sumRowContent, String sortStatus) {
        if (SmsConfigInfo.sortNameStatus.equals("ASC")) {
            SmsConfigInfo.sortNameStatus = "DESC";
        } else if (SmsConfigInfo.sortNameStatus.equals("DESC")) {
            SmsConfigInfo.sortNameStatus = "ASC";
        }
        int sumIndex = 0;
        while (sumIndex < sumRowContent.size()) {
            int rowIndex = 0;
            while (rowIndex < sumRowContent.size() - sumIndex - 1) {
                Vector rowVectorOne = (Vector)sumRowContent.get(rowIndex);
                String afDateTime = rowVectorOne.get(0).toString();
                Vector rowVectorTwo = (Vector)sumRowContent.get(rowIndex + 1);
                String deDateTime = rowVectorTwo.get(0).toString();
                if (sortStatus.equals("DESC") && afDateTime.compareTo(deDateTime) > -1) {
                    sumRowContent.remove(rowVectorOne);
                    sumRowContent.add(rowIndex + 1, rowVectorOne);
                }
                if (sortStatus.equals("ASC") && afDateTime.compareTo(deDateTime) < 0) {
                    sumRowContent.remove(rowVectorOne);
                    sumRowContent.add(rowIndex + 1, rowVectorOne);
                }
                ++rowIndex;
            }
            ++sumIndex;
        }
        this.setSortSelectRowIndex(sumRowContent);
    }

    public void sortDateRowContent(Vector sumRowContent, String sortStatus) {
        Date date = new Date();
        Date smsDate = new Date();
        if (SmsConfigInfo.sortDateStatus.equals("ASC")) {
            SmsConfigInfo.sortDateStatus = "DESC";
        } else if (SmsConfigInfo.sortDateStatus.equals("DESC")) {
            SmsConfigInfo.sortDateStatus = "ASC";
        }
        int sumIndex = 0;
        while (sumIndex < sumRowContent.size()) {
            int rowIndex = 0;
            while (rowIndex < sumRowContent.size() - sumIndex - 1) {
                Vector rowVectorOne = (Vector)sumRowContent.get(rowIndex);
                String afDateTime = rowVectorOne.get(2).toString();
                if (afDateTime.indexOf("-") > -1) {
                    date = Tools.stringToDate(afDateTime);
                }
                if (afDateTime.indexOf("/") > -1) {
                    date = Tools.stringToDateK(afDateTime);
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                Vector rowVectorTwo = (Vector)sumRowContent.get(rowIndex + 1);
                String deDateTime = rowVectorTwo.get(2).toString();
                if (deDateTime.indexOf("-") > -1) {
                    smsDate = Tools.stringToDate(deDateTime);
                }
                if (deDateTime.indexOf("/") > -1) {
                    smsDate = Tools.stringToDateK(deDateTime);
                }
                Calendar smsCalendar = Calendar.getInstance();
                smsCalendar.setTime(smsDate);
                if (sortStatus.equals("DESC") && smsCalendar.after(calendar)) {
                    sumRowContent.remove(rowVectorOne);
                    sumRowContent.add(rowIndex + 1, rowVectorOne);
                }
                if (sortStatus.equals("ASC") && calendar.after(smsCalendar)) {
                    sumRowContent.remove(rowVectorOne);
                    sumRowContent.add(rowIndex + 1, rowVectorOne);
                }
                ++rowIndex;
            }
            ++sumIndex;
        }
        this.setSortSelectRowIndex(sumRowContent);
    }
}

