/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.calllog;

import com.huawei.mobilePartner.gui.ui.calllog.UpDownArrow;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.Arrays;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class SortManager
implements TableModelListener {
    static final Icon upIcon = new UpDownArrow(1);
    static final Icon downIcon = new UpDownArrow(0);
    private JTable table;
    private TableModel dataModel;
    private int sortColumn;
    private Row[] rows = null;
    private boolean ascending = true;
    private int[] sortableColumns = null;

    public SortManager(JTable jtable) {
        this.table = jtable;
        int i = 0;
        int length = jtable.getModel().getColumnCount();
        int[] columns = new int[length];
        while (i < length) {
            columns[i] = i;
            ++i;
        }
        this.sortableColumns = columns;
        this.initialize();
    }

    public SortManager(JTable jtable, int i) {
        this.table = jtable;
        this.sortColumn = i;
        this.initialize();
    }

    public SortManager(JTable jtable, int[] ai) {
        this(jtable, ai[0]);
        this.sortableColumns = (int[])ai.clone();
    }

    public void initialize() {
        this.dataModel = this.table.getModel();
        ((AbstractTableModel)this.dataModel).addTableModelListener(this);
        this.addMouseListener(this.table);
        JTableHeader jtableheader = this.table.getTableHeader();
        jtableheader.setDefaultRenderer(this.createHeaderRenderer());
        if (this.table.getRowCount() > 0) {
            this.reinitialize();
        }
    }

    protected TableCellRenderer createHeaderRenderer() {
        SortHeaderRenderer defaultHeaderRenderer = new SortHeaderRenderer();
        defaultHeaderRenderer.setHorizontalAlignment(0);
        defaultHeaderRenderer.setHorizontalTextPosition(2);
        return defaultHeaderRenderer;
    }

    public void reinitialize() {
        this.rows = null;
        if (this.table.getRowCount() > 0) {
            this.rows = new Row[this.table.getRowCount()];
            int i = 0;
            while (i < this.rows.length) {
                this.rows[i] = new Row();
                this.rows[i].index = i;
                ++i;
            }
            if (this.columnIsSortable(this.sortColumn)) {
                this.sort();
            }
        }
    }

    private boolean columnIsSortable(int i) {
        if (this.rows != null) {
            if (this.sortableColumns != null) {
                int j = 0;
                while (j < this.sortableColumns.length) {
                    if (i == this.sortableColumns[j]) {
                        return true;
                    }
                    ++j;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public void addMouseListener(final JTable table) {
        table.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseevent) {
                int i = table.columnAtPoint(mouseevent.getPoint());
                int j = table.convertColumnIndexToModel(i);
                if (!SortManager.this.columnIsSortable(j)) {
                    return;
                }
                if (j == SortManager.this.sortColumn) {
                    SortManager.this.ascending = !SortManager.this.ascending;
                } else {
                    SortManager.this.ascending = true;
                    SortManager.this.sortColumn = j;
                }
                SortManager.this.sort();
            }
        });
    }

    public void sort() {
        if (this.rows == null) {
            return;
        }
        ((AbstractTableModel)this.dataModel).removeTableModelListener(this);
        Arrays.sort(this.rows);
        this.resetData();
        ((AbstractTableModel)this.dataModel).fireTableDataChanged();
        ((AbstractTableModel)this.dataModel).addTableModelListener(this);
        this.table.revalidate();
        this.table.repaint();
    }

    /*
     * Unable to fully structure code
     */
    public void resetData() {
        block8: {
            data = new Vector<Vector>(this.dataModel.getRowCount());
            i = 0;
            while (i < this.dataModel.getRowCount()) {
                j = 0;
                vv = new Vector(this.dataModel.getColumnCount());
                while (j < this.dataModel.getColumnCount()) {
                    vv.add(this.dataModel.getValueAt(i, j));
                    ++j;
                }
                data.add(vv);
                ++i;
            }
            i = 0;
            if (!this.ascending) ** GOTO lbl38
            while (i < this.rows.length) {
                if (this.rows[i].index != i) {
                    j = 0;
                    vv = (Vector)data.get(this.rows[i].index);
                    while (j < this.dataModel.getColumnCount()) {
                        this.dataModel.setValueAt(vv.get(j), i, j);
                        ++j;
                    }
                    this.rows[i].index = i;
                }
                ++i;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                if (this.rows[i].index == i) {
                    j = 0;
                    vv = (Vector)data.get(this.rows[i].index);
                    while (j < this.dataModel.getColumnCount()) {
                        this.dataModel.setValueAt(vv.get(j), this.rows.length - 1 - i, j);
                        ++j;
                    }
                    this.rows[i].index = this.rows.length - 1 - i;
                }
                ++i;
lbl38:
                // 2 sources

                ** while (i < this.rows.length)
            }
        }
    }

    public void tableChanged(TableModelEvent tablemodelevent) {
        this.reinitialize();
    }

    private class SortHeaderRenderer
    extends DefaultTableCellRenderer {
        private SortHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jtable, Object obj, boolean flag, boolean flag1, int i, int j) {
            JTableHeader jtableheader;
            if (jtable != null && (jtableheader = jtable.getTableHeader()) != null) {
                this.setForeground(jtableheader.getForeground());
                this.setBackground(jtableheader.getBackground());
                this.setFont(jtableheader.getFont());
            }
            this.setText(obj != null ? obj.toString() : "");
            int k = jtable.convertColumnIndexToModel(j);
            this.setBorder(BorderFactory.createEtchedBorder(Color.WHITE, null));
            return this;
        }
    }

    private class Row
    implements Comparable {
        public int index;

        private Row() {
        }

        public int compareTo(Object obj) {
            Row row = (Row)obj;
            Collator cnCollator = Collator.getInstance(Locale.getDefault());
            Object obj1 = SortManager.this.dataModel.getValueAt(this.index, SortManager.this.sortColumn);
            Object obj2 = SortManager.this.dataModel.getValueAt(row.index, SortManager.this.sortColumn);
            if (SortManager.this.ascending) {
                if (!(obj1 instanceof Comparable)) {
                    return -1;
                }
                if (!(obj2 instanceof Comparable)) {
                    return 1;
                }
            }
            if (!(obj1 instanceof Comparable)) {
                return 1;
            }
            if (!(obj2 instanceof Comparable)) {
                return -1;
            }
            return cnCollator.compare(obj2, obj1);
        }
    }
}

