/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.calllog;

import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.Tools;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class CustomTableCellRenderer
extends DefaultTableCellRenderer {
    public JLabel label = new JLabel();
    public int imgColumn = -1;
    public ImageIcon[] img = null;
    private LogConfig log = Log.getLog(CustomTableCellRenderer.class);

    public CustomTableCellRenderer(int column, ImageIcon[] icn) {
        this.label.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.label.setFont(Tools.setFont());
        this.imgColumn = column;
        this.img = icn;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.label.setOpaque(true);
        if (hasFocus) {
            this.label.setBackground(table.getSelectionBackground());
        } else if (isSelected) {
            this.label.setBackground(table.getSelectionBackground());
        } else {
            this.label.setBackground(Color.white);
        }
        if (value instanceof String) {
            this.label.setText(value.toString());
            this.setText(value.toString());
        }
        if (this.imgColumn == column) {
            int iType = 0;
            String curRowlogType = (String)table.getModel().getValueAt(row, table.getColumnCount() - 1);
            String curRowLogState = (String)table.getModel().getValueAt(row, table.getColumnCount() - 2);
            if (curRowlogType.equalsIgnoreCase("1") && curRowLogState.equalsIgnoreCase("1")) {
                iType = this.img.length - 1;
            } else {
                try {
                    iType = Integer.parseInt(curRowlogType);
                }
                catch (NumberFormatException nfe) {
                    this.log.info("talbe last column can't convert to number format.");
                }
            }
            if (iType >= this.img.length || iType < 0) {
                iType = 0;
            }
            this.label.setIcon(this.img[iType]);
            return this.label;
        }
        return this;
    }
}

