/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.calllog;

import com.huawei.mobilePartner.business.telephoneBook.commserver.CommonMethodByTelBook;
import com.huawei.mobilePartner.common.interfaces.PublicConfig;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.config.bean.CustomizeBean;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.gui.ui.SendSmsDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CallLogLogic {
    private LogConfig log = Log.getLog(CommonMethodByTelBook.class);
    private LanguageBean lb = CustomizeInit.getLanguageBean();
    private CustomizeBean cb = CustomizeInit.getCustomizeBean();
    private static CallLogLogic calllogInstance = null;

    private CallLogLogic() {
    }

    public static CallLogLogic getCallLogLogicInstance() {
        if (calllogInstance == null) {
            calllogInstance = new CallLogLogic();
        }
        return calllogInstance;
    }

    public void setButtonStyle(JButton btn, ImageIcon activeIcn, ImageIcon rolloverIcn, ImageIcon disableIcn, String tooltip) {
        btn.setIcon(activeIcn);
        btn.setDisabledIcon(disableIcn);
        btn.setRolloverIcon(rolloverIcn);
        btn.setToolTipText(tooltip);
        btn.setActionCommand(tooltip);
        btn.setMaximumSize(new Dimension(29, 28));
        btn.setMinimumSize(new Dimension(29, 28));
        btn.setPreferredSize(new Dimension(29, 28));
        btn.setOpaque(false);
        btn.setBorder(new EmptyBorder(0, 0, 0, 0));
        btn.setContentAreaFilled(false);
        btn.setBackground(ChangeColor.getColor(this.cb.getButtonBackground()));
    }

    public void setSplitPaneDividerColor(JSplitPane splitPane, Color newDividerColor) {
        SplitPaneUI splitUI = splitPane.getUI();
        if (splitUI instanceof BasicSplitPaneUI) {
            BasicSplitPaneDivider div = ((BasicSplitPaneUI)splitUI).getDivider();
            BGBorder newBorder = null;
            BGBorder colorBorder = null;
            private class BGBorder
            implements Border {
                private Color color;
                private final Insets NO_INSETS = new Insets(0, 0, 0, 0);
                Rectangle r = new Rectangle();

                BGBorder(Color color) {
                    this.color = color;
                }

                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    g.setColor(this.color);
                    g.fillRect(x, y, width, height);
                    if (c instanceof Container) {
                        Container cont = (Container)c;
                        int i = 0;
                        int n = cont.getComponentCount();
                        while (i < n) {
                            Component comp = cont.getComponent(i);
                            comp.getBounds(this.r);
                            Graphics tmpg = g.create(this.r.x, this.r.y, this.r.width, this.r.height);
                            comp.paint(tmpg);
                            tmpg.dispose();
                            ++i;
                        }
                    }
                }

                public Insets getBorderInsets(Component c) {
                    return this.NO_INSETS;
                }

                public boolean isBorderOpaque() {
                    return true;
                }
            }
            newBorder = colorBorder = new BGBorder(newDividerColor);
            div.setBorder(newBorder);
        }
    }

    public static void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                CallLogLogic.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public void sendSMS(JTable logTable) {
        AppFrame appFrame = AppFrame.getAppFrameInit();
        int[] selectRow = logTable.getSelectedRows();
        int selRows = logTable.getSelectedRowCount();
        String numbers = "";
        if (selRows >= 1) {
            int i = 0;
            while (i < selectRow.length) {
                numbers = String.valueOf(numbers) + logTable.getValueAt(selectRow[i], logTable.getColumnCount() - 3).toString() + ";";
                ++i;
            }
        } else {
            return;
        }
        appFrame.smsManage_actionPerformed();
        appFrame.clickSmsButton();
        System.out.println("=====" + numbers);
        PublicConfig.simMenuListValue = "10";
        PublicConfig.simSendType = "4";
        SendSmsDialog sendSmsDialog = new SendSmsDialog(AppFrame.getAppFrameInit(), appFrame.smsPanel, numbers, "");
        appFrame.conPanelFlag = false;
        appFrame.statPanelFlag = false;
        appFrame.smsPanelFlag = true;
        appFrame.phoPanelFlag = false;
        appFrame.calllogPanelFlag = false;
        appFrame.callPanelFlag = false;
    }
}

