/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.mobilePartner.gui.ui.calllog;

import com.huawei.mobilePartner.business.telephoneBook.common.commoninterface.PhonebookObserver;
import com.huawei.mobilePartner.business.telephoneBook.common.commoninterface.PhonebookSubject;
import com.huawei.mobilePartner.business.telephoneBook.common.commoninterfaceimpl.PhoneBookData;
import com.huawei.mobilePartner.business.telephoneBook.commserver.CommonMethodByTelBook;
import com.huawei.mobilePartner.common.interfaces.PublicConfig;
import com.huawei.mobilePartner.common.log.Log;
import com.huawei.mobilePartner.common.log.LogConfig;
import com.huawei.mobilePartner.common.util.JUTPSOptionDialog;
import com.huawei.mobilePartner.common.util.TextUtil;
import com.huawei.mobilePartner.common.util.Tools;
import com.huawei.mobilePartner.common.util.XMLTool;
import com.huawei.mobilePartner.config.bean.CustomizeBean;
import com.huawei.mobilePartner.config.bean.LanguageBean;
import com.huawei.mobilePartner.config.business.CustomizeInit;
import com.huawei.mobilePartner.data.comm.service.MutiDeviceService;
import com.huawei.mobilePartner.gui.ui.AppFrame;
import com.huawei.mobilePartner.gui.ui.ChangeColor;
import com.huawei.mobilePartner.gui.ui.HScrollBarUI;
import com.huawei.mobilePartner.gui.ui.VScrollBarUI;
import com.huawei.mobilePartner.gui.ui.call.CallUILogic;
import com.huawei.mobilePartner.gui.ui.calllog.CallLogLogic;
import com.huawei.mobilePartner.gui.ui.calllog.CallLogTabelModel;
import com.huawei.mobilePartner.gui.ui.calllog.CallLogTreeRenderer;
import com.huawei.mobilePartner.gui.ui.calllog.CustomTableCellRenderer;
import com.huawei.mobilePartner.gui.ui.calllog.SortManager;
import com.huawei.mobilePartner.gui.ui.telbookui.ContactDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CallLogContentPanel
extends JPanel
implements TreeSelectionListener,
ListSelectionListener,
ActionListener,
PhonebookObserver {
    private AppFrame frame = null;
    private LogConfig log = null;
    private XMLTool xmltool = null;
    private String path = null;
    private CustomizeBean cb = CustomizeInit.getCustomizeBean();
    private static LanguageBean lb = CustomizeInit.getLanguageBean();
    private final String imgPath = "/config/images/CallLogUIPlugin/";
    public static final String log_allType = "4";
    public static final String log_ansType = "0";
    public static final String log_missType = "1";
    public static final String log_dialType = "2";
    public static final String unreadState = "0";
    public static final String readState = "1";
    public static final String semicolon = " : ";
    private final int blinkDelay = 1000;
    private JSplitPane hSplitPane = new JSplitPane();
    private JSplitPane rvSplitPane = new JSplitPane();
    private static JTree logtree = new JTree();
    private JPopupMenu popLog = new JPopupMenu();
    private JMenuItem itemCall = null;
    private JMenuItem itemSendSMS = null;
    private JMenuItem itemSave = null;
    private JMenuItem itemDelete = null;
    private JMenuItem itemClear = null;
    private ImageIcon openedIcon = null;
    private ImageIcon closedIcon = null;
    private ImageIcon answeredIcon = null;
    private ImageIcon missedIcon = null;
    private ImageIcon dialedIcon = null;
    private ImageIcon readMissedIcon = null;
    private JButton btnCall = new JButton();
    private JButton btnSMS = new JButton();
    private JButton btnSave = new JButton();
    private JButton btnDelete = new JButton();
    private JButton btnClear = new JButton();
    private JScrollPane logtablePane = null;
    private Timer callBlinkTimer = null;
    private boolean blinkFlag = false;
    private JTable tableLog = new JTable();
    private JTextArea logTextArea = new JTextArea();
    private CallLogTabelModel logTableMode = null;
    private DefaultTreeCellRenderer treeRender = null;
    private CallLogLogic calllogInstance = null;
    private CallUILogic calluiInstance = null;
    private PhonebookSubject pbSubjectInstance = PhoneBookData.getInstance();
    private static CallLogContentPanel callpanelInstance = null;
    private CommonMethodByTelBook commonMethodByTelBook = new CommonMethodByTelBook();
    private String[] columnNames = new String[]{lb.getCallLog_logid(), lb.getCallLog_nameornum(), lb.getCallLog_begintime(), lb.getCallLog_durtime(), lb.getCallLog_num(), lb.getCallLog_logstate(), lb.getCallLog_logtype()};
    public Vector vHead = new Vector();
    public Vector<Vector> vLogInfos = new Vector();
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode calllogNode;
    private DefaultMutableTreeNode answeredNode;
    private DefaultMutableTreeNode missedNode;
    private DefaultMutableTreeNode dialedNode;
    private String calllogString = "";

    public static CallLogContentPanel getCallLogPanelInstance() {
        if (callpanelInstance == null) {
            callpanelInstance = new CallLogContentPanel(AppFrame.frame);
        }
        return callpanelInstance;
    }

    public CallLogContentPanel(AppFrame parentFrame) {
        try {
            this.frame = parentFrame;
            this.setName("callLogManage");
            this.xmltool = new XMLTool();
            this.path = String.valueOf(XMLTool.getClassPath()) + "/config/images/CallLogUIPlugin/";
            this.path = TextUtil.replaceStr1(this.path, "\\/", "/");
            this.path = TextUtil.replaceStr1(this.path, "\\", "/");
            this.log = Log.getLog(CallLogContentPanel.class);
            this.calllogInstance = CallLogLogic.getCallLogLogicInstance();
            this.calluiInstance = CallUILogic.getInstance();
            this.vHead.add(lb.getCallLog_logid());
            this.vHead.add(lb.getCallLog_nameornum());
            this.vHead.add(lb.getCallLog_begintime());
            this.vHead.add(lb.getCallLog_durtime());
            this.vHead.add(lb.getCallLog_num());
            this.vHead.add(lb.getCallLog_logstate());
            this.vHead.add(lb.getCallLog_logtype());
            this.callBlinkTimer = new Timer(1000, this);
            if (this.pbSubjectInstance != null) {
                this.pbSubjectInstance.registerObserver(this);
            }
            this.initPanel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initPanel() {
        this.openedIcon = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_open());
        this.closedIcon = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_close());
        this.answeredIcon = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_ans());
        this.missedIcon = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_miss());
        this.dialedIcon = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_dial());
        this.readMissedIcon = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_missread());
        this.setBackground(ChangeColor.getColor(this.cb.getAppFrame_createConnManagePanel_2()));
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setBorder(new MatteBorder(6, 4, 6, 4, ChangeColor.getColor(this.cb.getPanel_border())));
        this.hSplitPane.setBackground(ChangeColor.getColor(this.cb.getAppFrame_createConnManagePanel_2()));
        this.hSplitPane.setDividerSize(4);
        this.hSplitPane.setResizeWeight(0.3);
        this.root = new DefaultMutableTreeNode("root");
        this.calllogNode = new DefaultMutableTreeNode(lb.getCallLog_all());
        this.answeredNode = new DefaultMutableTreeNode(lb.getCallLog_ans());
        this.missedNode = new DefaultMutableTreeNode(lb.getCallLog_miss());
        this.dialedNode = new DefaultMutableTreeNode(lb.getCallLog_dial());
        DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
        treeModel.insertNodeInto(this.calllogNode, this.root, this.root.getChildCount());
        treeModel.insertNodeInto(this.answeredNode, this.calllogNode, this.calllogNode.getChildCount());
        treeModel.insertNodeInto(this.missedNode, this.calllogNode, this.calllogNode.getChildCount());
        treeModel.insertNodeInto(this.dialedNode, this.calllogNode, this.calllogNode.getChildCount());
        logtree.setModel(treeModel);
        logtree.setRootVisible(false);
        TreeNode vroot = (TreeNode)logtree.getModel().getRoot();
        CallLogLogic.expandAll(logtree, new TreePath(vroot), true);
        logtree.addTreeSelectionListener(this);
        CallLogTreeRenderer treeRenderer = new CallLogTreeRenderer(this.openedIcon, this.closedIcon, this.answeredIcon, this.missedIcon, this.dialedIcon, false);
        logtree.setCellRenderer(treeRenderer);
        logtree.putClientProperty("JTree.lineStyle", "None");
        logtree.getSelectionModel().setSelectionMode(1);
        logtree.setDragEnabled(false);
        JScrollPane leftPane = new JScrollPane(logtree);
        leftPane.setViewportView(logtree);
        leftPane.setBorder(new LineBorder(ChangeColor.getColor(this.cb.getDefault_border()), 1, true));
        leftPane.setMinimumSize(new Dimension(100, leftPane.getHeight()));
        leftPane.setMaximumSize(new Dimension(200, leftPane.getHeight()));
        this.hSplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.hSplitPane.setLeftComponent(leftPane);
        this.calllogInstance.setSplitPaneDividerColor(this.hSplitPane, ChangeColor.getColor(this.cb.getSplitPane_Background()));
        this.rvSplitPane.setResizeWeight(0.7);
        this.rvSplitPane.setOrientation(0);
        this.rvSplitPane.setDividerSize(4);
        this.rvSplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.calllogInstance.setSplitPaneDividerColor(this.rvSplitPane, ChangeColor.getColor(this.cb.getSplitPane_Background()));
        JPanel rtopPanel = new JPanel();
        rtopPanel.setLayout(new BorderLayout());
        JPanel btnsPanel = new JPanel();
        btnsPanel.setLayout(new FlowLayout(0, 0, 0));
        btnsPanel.setBackground(ChangeColor.getColor(this.cb.getAppFrame_createPhoneBookPanel_5()));
        ImageIcon activeCall = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_call());
        ImageIcon rolloverCall = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_rolcall());
        ImageIcon disableCall = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_graycall());
        this.calllogInstance.setButtonStyle(this.btnCall, activeCall, rolloverCall, disableCall, lb.getCallLog_call());
        this.btnCall.addActionListener(this);
        ImageIcon activeSMS = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_sms());
        ImageIcon rolloverSMS = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_rolsms());
        ImageIcon disableSMS = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_graysms());
        this.calllogInstance.setButtonStyle(this.btnSMS, activeSMS, rolloverSMS, disableSMS, lb.getCallLog_sms());
        this.btnSMS.addActionListener(this);
        ImageIcon activeSave = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_save());
        ImageIcon rolloverSave = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_rolsave());
        ImageIcon disableSave = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_graysave());
        this.calllogInstance.setButtonStyle(this.btnSave, activeSave, rolloverSave, disableSave, lb.getCallLog_save());
        this.btnSave.addActionListener(this);
        ImageIcon activeDel = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_del());
        ImageIcon rolloverDel = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_roldel());
        ImageIcon disableDel = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_graydel());
        this.calllogInstance.setButtonStyle(this.btnDelete, activeDel, rolloverDel, disableDel, lb.getCallLog_del());
        this.btnDelete.addActionListener(this);
        ImageIcon activeClear = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_clr());
        ImageIcon rolloverClear = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_rolclr());
        ImageIcon disableClear = new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_grayclr());
        this.calllogInstance.setButtonStyle(this.btnClear, activeClear, rolloverClear, disableClear, lb.getCallLog_clr());
        this.btnClear.addActionListener(this);
        btnsPanel.add(this.btnCall);
        btnsPanel.add(this.btnSMS);
        btnsPanel.add(this.btnSave);
        btnsPanel.add(this.btnDelete);
        btnsPanel.add(this.btnClear);
        rtopPanel.add((Component)btnsPanel, "North");
        this.readCallLogFromFile();
        Vector vInfos = this.readCallLog(log_allType);
        this.logTableMode = new CallLogTabelModel(vInfos, this.vHead);
        this.tableLog.setModel(this.logTableMode);
        this.logTableMode.setColumnIdentifiers(this.columnNames);
        String firstSecondColume = this.columnNames[0];
        this.tableLog.getColumn(firstSecondColume).setMaxWidth(0);
        this.tableLog.getColumn(firstSecondColume).setMinWidth(0);
        this.tableLog.getColumn(firstSecondColume).setPreferredWidth(0);
        String numColume = this.columnNames[this.columnNames.length - 3];
        this.tableLog.getColumn(numColume).setMaxWidth(0);
        this.tableLog.getColumn(numColume).setMinWidth(0);
        this.tableLog.getColumn(numColume).setPreferredWidth(0);
        String stateColume = this.columnNames[this.columnNames.length - 2];
        this.tableLog.getColumn(stateColume).setMaxWidth(0);
        this.tableLog.getColumn(stateColume).setMinWidth(0);
        this.tableLog.getColumn(stateColume).setPreferredWidth(0);
        String lastColume = this.columnNames[this.columnNames.length - 1];
        this.tableLog.getColumn(lastColume).setMaxWidth(0);
        this.tableLog.getColumn(lastColume).setMinWidth(0);
        this.tableLog.getColumn(lastColume).setPreferredWidth(0);
        this.tableLog.setBorder(new LineBorder(ChangeColor.getColor(this.cb.getDefault_border()), 0, true));
        this.tableLog.setShowGrid(false);
        this.tableLog.getTableHeader().setBackground(ChangeColor.getColor(this.cb.getTable_header_Background()));
        this.tableLog.getTableHeader().setForeground(ChangeColor.getColor(this.cb.getTable_header_Foreground()));
        this.tableLog.getTableHeader().setReorderingAllowed(false);
        this.tableLog.setSelectionMode(2);
        this.tableLog.setRowSelectionAllowed(true);
        TableColumnModel columnModel = this.tableLog.getColumnModel();
        ImageIcon[] img = new ImageIcon[]{new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_ans()), new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_miss()), new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_dial()), new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_missread())};
        int c = 0;
        while (c < columnModel.getColumnCount()) {
            columnModel.getColumn(c).setCellRenderer(new CustomTableCellRenderer(1, img));
            ++c;
        }
        this.itemCall = new JMenuItem(lb.getCallLog_call());
        this.itemCall.setActionCommand(lb.getCallLog_call());
        this.itemCall.setFont(Tools.setFont());
        this.itemCall.addActionListener(this);
        this.itemSendSMS = new JMenuItem(lb.getCallLog_sms());
        this.itemSendSMS.setActionCommand(lb.getCallLog_sms());
        this.itemSendSMS.setFont(Tools.setFont());
        this.itemSendSMS.addActionListener(this);
        this.itemSave = new JMenuItem(lb.getCallLog_save());
        this.itemSave.setActionCommand(lb.getCallLog_save());
        this.itemSave.setFont(Tools.setFont());
        this.itemSave.addActionListener(this);
        this.itemDelete = new JMenuItem(lb.getCallLog_del());
        this.itemDelete.setActionCommand(lb.getCallLog_del());
        this.itemDelete.setFont(Tools.setFont());
        this.itemDelete.addActionListener(this);
        this.itemClear = new JMenuItem(lb.getCallLog_clr());
        this.itemClear.setActionCommand(lb.getCallLog_clr());
        this.itemClear.setFont(Tools.setFont());
        this.itemClear.addActionListener(this);
        this.popLog.add(this.itemCall);
        this.popLog.add(this.itemSendSMS);
        this.popLog.add(this.itemSave);
        this.popLog.addSeparator();
        this.popLog.add(this.itemDelete);
        this.popLog.add(this.itemClear);
        this.tableLog.setComponentPopupMenu(this.popLog);
        this.tableLog.getSelectionModel().addListSelectionListener(this);
        this.tableLog.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    CallLogContentPanel.this.deleteCallLog();
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.tableLog.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    Point point = e.getPoint();
                    int row = CallLogContentPanel.this.tableLog.rowAtPoint(point);
                    CallLogContentPanel.this.tableLog.setRowSelectionInterval(row, row);
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    int selRows = CallLogContentPanel.this.tableLog.getSelectedRowCount();
                    Point point = e.getPoint();
                    int row = CallLogContentPanel.this.tableLog.rowAtPoint(point);
                    if (selRows == 0) {
                        CallLogContentPanel.this.tableLog.setRowSelectionInterval(row, row);
                    } else {
                        int[] rows = CallLogContentPanel.this.tableLog.getSelectedRows();
                        boolean bFlag = false;
                        int i = 0;
                        while (i < rows.length) {
                            if (rows[i] == row) {
                                bFlag = true;
                                break;
                            }
                            ++i;
                        }
                        if (!bFlag) {
                            CallLogContentPanel.this.tableLog.setRowSelectionInterval(row, row);
                        }
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        SortManager st = new SortManager(this.tableLog, 2);
        boolean blink = this.checkUnreadMissCall();
        if (blink && !this.callBlinkTimer.isRunning()) {
            this.callBlinkTimer.start();
        }
        this.logtablePane = new JScrollPane(this.tableLog);
        this.logtablePane.getViewport().setBackground(Color.WHITE);
        JScrollBar hLogBar = this.logtablePane.getHorizontalScrollBar();
        JScrollBar vLogBar = this.logtablePane.getVerticalScrollBar();
        vLogBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent arg0) {
                CallLogContentPanel.this.logtablePane.revalidate();
            }
        });
        if (!System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            hLogBar.setUI(new VScrollBarUI());
            vLogBar.setUI(new HScrollBarUI());
        }
        this.logtablePane.setVerticalScrollBarPolicy(22);
        this.logtablePane.setViewportView(this.tableLog);
        this.logtablePane.setBorder(new LineBorder(ChangeColor.getColor(this.cb.getDefault_border()), 1, true));
        rtopPanel.add((Component)this.logtablePane, "Center");
        this.rvSplitPane.setTopComponent(rtopPanel);
        this.logTextArea.setEditable(false);
        this.logTextArea.setForeground(Color.black);
        this.logTextArea.setFont(Tools.setFont());
        this.logTextArea.setBackground(Color.WHITE);
        JScrollPane rBottomPane = new JScrollPane(this.logTextArea);
        if (!System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            JScrollBar hBar = rBottomPane.getHorizontalScrollBar();
            JScrollBar vBar = rBottomPane.getVerticalScrollBar();
            vBar.setUI(new VScrollBarUI());
            hBar.setUI(new HScrollBarUI());
        }
        rBottomPane.setVerticalScrollBarPolicy(22);
        rBottomPane.setBorder(new LineBorder(ChangeColor.getColor(this.cb.getDefault_border()), 1, true));
        this.rvSplitPane.setBottomComponent(rBottomPane);
        this.hSplitPane.setRightComponent(this.rvSplitPane);
        this.add((Component)this.hSplitPane, "Center");
        this.refreshButtonState();
        int selRows = this.tableLog.getSelectedRowCount();
        if (selRows == 0) {
            this.btnCall.setEnabled(false);
            this.btnSMS.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnDelete.setEnabled(false);
            this.itemSave.setEnabled(false);
            this.itemDelete.setEnabled(false);
            this.itemCall.setEnabled(false);
            this.itemSendSMS.setEnabled(false);
        }
        if (this.tableLog.getRowCount() <= 0) {
            this.btnClear.setEnabled(false);
            this.itemClear.setEnabled(false);
        } else {
            this.btnClear.setEnabled(true);
            this.itemClear.setEnabled(true);
        }
    }

    public void update(boolean bool) {
        int i = 0;
        while (i < this.tableLog.getRowCount()) {
            String phoneNum = (String)this.tableLog.getValueAt(i, this.tableLog.getColumnCount() - 3);
            String name = this.commonMethodByTelBook.getContactName(phoneNum.trim()).trim();
            if (name == null || "".equals(name)) {
                name = phoneNum;
            }
            this.tableLog.setValueAt(name, i, 1);
            ++i;
        }
        this.tableLog.revalidate();
        this.readCallLogFromFile();
    }

    public void valueChanged(ListSelectionEvent e) {
        int selRows = this.tableLog.getSelectedRowCount();
        int rowCount = this.tableLog.getRowCount();
        String strContent = "";
        String newLine = System.getProperty("line.separator");
        int[] selCurRow = this.tableLog.getSelectedRows();
        if (rowCount == 0) {
            this.btnClear.setEnabled(false);
            this.itemClear.setEnabled(false);
        } else {
            this.btnClear.setEnabled(true);
            this.itemClear.setEnabled(true);
        }
        if (selRows == 0) {
            this.btnCall.setEnabled(false);
            this.btnSMS.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnDelete.setEnabled(false);
            this.itemSave.setEnabled(false);
            this.itemDelete.setEnabled(false);
            this.itemCall.setEnabled(false);
            this.itemSendSMS.setEnabled(false);
        } else if (selRows == 1) {
            strContent = String.valueOf(lb.getCallLog_name()) + semicolon + this.tableLog.getValueAt(selCurRow[0], 1);
            strContent = String.valueOf(strContent) + newLine + lb.getCallLog_num() + semicolon + this.tableLog.getValueAt(selCurRow[0], this.tableLog.getColumnCount() - 3);
            strContent = String.valueOf(strContent) + newLine + lb.getCallLog_begintime() + semicolon + this.tableLog.getValueAt(selCurRow[0], 2);
            strContent = String.valueOf(strContent) + newLine + lb.getCallLog_durtime() + semicolon + this.tableLog.getValueAt(selCurRow[0], 3);
            this.btnSMS.setEnabled(true);
            this.btnSave.setEnabled(true);
            this.btnDelete.setEnabled(true);
            this.btnCall.setEnabled(true);
            this.itemSave.setEnabled(true);
            this.itemDelete.setEnabled(true);
            this.itemCall.setEnabled(true);
            this.itemSendSMS.setEnabled(true);
            String logType = (String)this.tableLog.getValueAt(selCurRow[0], this.tableLog.getColumnCount() - 1);
            String state = (String)this.tableLog.getValueAt(selCurRow[0], this.tableLog.getColumnCount() - 2);
            if ("1".equalsIgnoreCase(logType) && "0".equalsIgnoreCase(state)) {
                String logId = (String)this.tableLog.getValueAt(selCurRow[0], 0);
                this.calluiInstance.updateCallInfo(logId, "1");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int[] selCurRowss = CallLogContentPanel.this.tableLog.getSelectedRows();
                        CallLogContentPanel.this.tableLog.setValueAt("1", selCurRowss[0], CallLogContentPanel.this.tableLog.getColumnCount() - 2);
                    }
                });
                this.tableLog.updateUI();
                this.readCallLogFromFile();
                boolean blink = this.checkUnreadMissCall();
                if (blink) {
                    if (!this.callBlinkTimer.isRunning()) {
                        this.callBlinkTimer.start();
                    }
                } else if (this.callBlinkTimer.isRunning()) {
                    this.callBlinkTimer.stop();
                    this.frame.callBlinkLabel.setVisible(false);
                }
            }
        } else if (selRows > 1) {
            this.btnSave.setEnabled(false);
            this.btnCall.setEnabled(false);
            this.itemSave.setEnabled(false);
            this.itemCall.setEnabled(false);
        }
        this.logTextArea.setText(strContent);
        this.refreshButtonState();
        this.tableLog.revalidate();
        this.logTextArea.revalidate();
        this.rvSplitPane.revalidate();
    }

    public void refreshButtonState() {
        String deviceName = MutiDeviceService.getCurrentDeviceType();
        int selRows = this.tableLog.getSelectedRowCount();
        if (selRows != 0) {
            if (!"".equals(deviceName) && PublicConfig.serviceFlag) {
                if (selRows > 1) {
                    this.btnSave.setEnabled(false);
                    this.btnCall.setEnabled(false);
                    this.itemSave.setEnabled(false);
                    this.itemCall.setEnabled(false);
                } else {
                    this.btnCall.setEnabled(true);
                    this.itemCall.setEnabled(true);
                    this.btnSMS.setEnabled(true);
                    this.itemSendSMS.setEnabled(true);
                }
            } else {
                this.btnCall.setEnabled(false);
                this.itemCall.setEnabled(false);
                this.btnSMS.setEnabled(false);
                this.itemSendSMS.setEnabled(false);
            }
        }
    }

    public boolean checkUnreadMissCall() {
        boolean hasMissCall = false;
        int i = 0;
        while (i < this.vLogInfos.size()) {
            Vector vRowInfo = this.vLogInfos.get(i);
            String strLogType = vRowInfo.get(6).toString();
            String strLogState = vRowInfo.get(5).toString();
            if (strLogType.equalsIgnoreCase("1") && strLogState.equalsIgnoreCase("0")) {
                hasMissCall = true;
                break;
            }
            ++i;
        }
        return hasMissCall;
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)logtree.getLastSelectedPathComponent();
        if (selNode == null) {
            return;
        }
        String strNode = selNode.toString();
        CallLogTreeRenderer treeRender = null;
        String newLine = System.getProperty("line.separator");
        Vector vLogs = new Vector();
        String strLogInfo = null;
        if (strNode.equalsIgnoreCase(lb.getCallLog_all())) {
            treeRender = new CallLogTreeRenderer(this.openedIcon, this.closedIcon, this.answeredIcon, this.missedIcon, this.dialedIcon, true);
            vLogs = this.readCallLog(log_allType);
            strLogInfo = String.valueOf(lb.getCallLog_all()) + newLine + lb.getCallLog_logcount() + semicolon + vLogs.size();
        } else if (strNode.equalsIgnoreCase(lb.getCallLog_ans())) {
            treeRender = new CallLogTreeRenderer(this.openedIcon, this.closedIcon, this.answeredIcon, this.missedIcon, this.dialedIcon, false);
            vLogs = this.readCallLog("0");
            strLogInfo = String.valueOf(lb.getCallLog_ans()) + newLine + lb.getCallLog_logcount() + semicolon + vLogs.size();
        } else if (strNode.equalsIgnoreCase(lb.getCallLog_miss())) {
            treeRender = new CallLogTreeRenderer(this.openedIcon, this.closedIcon, this.answeredIcon, this.missedIcon, this.dialedIcon, false);
            vLogs = this.readCallLog("1");
            strLogInfo = String.valueOf(lb.getCallLog_miss()) + newLine + lb.getCallLog_logcount() + semicolon + vLogs.size();
        } else if (strNode.equalsIgnoreCase(lb.getCallLog_dial())) {
            treeRender = new CallLogTreeRenderer(this.openedIcon, this.closedIcon, this.answeredIcon, this.missedIcon, this.dialedIcon, false);
            vLogs = this.readCallLog(log_dialType);
            strLogInfo = String.valueOf(lb.getCallLog_dial()) + newLine + lb.getCallLog_logcount() + semicolon + vLogs.size();
        } else {
            return;
        }
        this.calllogString = strLogInfo;
        int i = this.logTableMode.getRowCount() - 1;
        while (i >= 0) {
            this.logTableMode.removeRow(i);
            --i;
        }
        int j = 0;
        while (j < vLogs.size()) {
            this.logTableMode.addRow((Vector)vLogs.get(j));
            ++j;
        }
        TableColumnModel columnModel = this.tableLog.getColumnModel();
        ImageIcon[] img = new ImageIcon[]{new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_ans()), new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_miss()), new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_dial()), new ImageIcon(String.valueOf(this.path) + this.cb.getCallLog_missread())};
        int c = 0;
        while (c < columnModel.getColumnCount()) {
            columnModel.getColumn(c).setCellRenderer(new CustomTableCellRenderer(1, img));
            ++c;
        }
        int selRows = this.tableLog.getSelectedRowCount();
        if (selRows == 0) {
            this.btnCall.setEnabled(false);
            this.btnSMS.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnDelete.setEnabled(false);
            this.itemSave.setEnabled(false);
            this.itemDelete.setEnabled(false);
            this.itemCall.setEnabled(false);
            this.itemSendSMS.setEnabled(false);
        }
        if (this.tableLog.getRowCount() <= 0) {
            this.btnClear.setEnabled(false);
            this.itemClear.setEnabled(false);
        } else {
            this.btnClear.setEnabled(true);
            this.itemClear.setEnabled(true);
        }
        this.tableLog.invalidate();
        this.logtablePane.update(this.tableLog.getGraphics());
        this.logTextArea.setText(strLogInfo);
        logtree.setCellRenderer(treeRender);
    }

    private void deleteCallLog() {
        int iRet = JUTPSOptionDialog.showConfirmDialog(this, lb.getPrompt_whetherdelete(), lb.getHelp_1_Prompt(), 2);
        if (iRet == 0) {
            int selRows = this.tableLog.getSelectedRowCount();
            int[] selCurRow = this.tableLog.getSelectedRows();
            int i = selCurRow.length - 1;
            while (i >= 0) {
                String strId = (String)this.tableLog.getValueAt(selCurRow[i], 0);
                this.calluiInstance.deleteLog(strId);
                this.deleteLogFromVector(strId);
                ((DefaultTableModel)this.tableLog.getModel()).removeRow(selCurRow[i]);
                --i;
            }
            this.tableLog.revalidate();
            boolean blink = this.checkUnreadMissCall();
            if (blink) {
                if (!this.callBlinkTimer.isRunning()) {
                    this.callBlinkTimer.start();
                }
            } else if (this.callBlinkTimer.isRunning()) {
                this.callBlinkTimer.stop();
                this.frame.callBlinkLabel.setVisible(false);
            }
        }
    }

    public void deleteLogFromVector(String strId) {
        int iSize = this.vLogInfos.size();
        int i = 0;
        while (i < iSize) {
            Vector vLog = this.vLogInfos.get(i);
            String logId = (String)vLog.get(0);
            if (logId.equalsIgnoreCase(strId)) {
                this.vLogInfos.remove(i);
                break;
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() != null) {
            int iRet;
            if (e.getActionCommand().equalsIgnoreCase(lb.getCallLog_sms())) {
                this.calllogInstance.sendSMS(this.tableLog);
            } else if (e.getActionCommand().equalsIgnoreCase(lb.getCallLog_call())) {
                int selRows = this.tableLog.getSelectedRowCount();
                int[] selCurRow = this.tableLog.getSelectedRows();
                if (selRows == 1) {
                    String number = (String)this.tableLog.getValueAt(selCurRow[0], this.tableLog.getColumnCount() - 3);
                    this.calluiInstance.onCallPanel(number);
                }
            } else if (e.getActionCommand().equalsIgnoreCase(lb.getCallLog_save())) {
                int selRows = this.tableLog.getSelectedRowCount();
                int[] selCurRow = this.tableLog.getSelectedRows();
                if (selRows == 1) {
                    String number = (String)this.tableLog.getValueAt(selCurRow[0], this.tableLog.getColumnCount() - 3);
                    ContactDialog contactDialog = ContactDialog.getInstance(this.frame, "", number);
                }
            } else if (e.getActionCommand().equalsIgnoreCase(lb.getCallLog_del())) {
                int iRet2 = JUTPSOptionDialog.showConfirmDialog(this, lb.getPrompt_whetherdelete(), lb.getHelp_1_Prompt(), 2);
                if (iRet2 == 0) {
                    int selRows = this.tableLog.getSelectedRowCount();
                    int[] selCurRow = this.tableLog.getSelectedRows();
                    int i = selCurRow.length - 1;
                    while (i >= 0) {
                        String strId = (String)this.tableLog.getValueAt(selCurRow[i], 0);
                        this.calluiInstance.deleteLog(strId);
                        this.deleteLogFromVector(strId);
                        ((DefaultTableModel)this.tableLog.getModel()).removeRow(selCurRow[i]);
                        --i;
                    }
                    this.tableLog.revalidate();
                    boolean blink = this.checkUnreadMissCall();
                    if (blink) {
                        if (!this.callBlinkTimer.isRunning()) {
                            this.callBlinkTimer.start();
                        }
                    } else if (this.callBlinkTimer.isRunning()) {
                        this.callBlinkTimer.stop();
                        this.frame.callBlinkLabel.setVisible(false);
                    }
                }
            } else if (e.getActionCommand().equalsIgnoreCase(lb.getCallLog_clr()) && (iRet = JUTPSOptionDialog.showConfirmDialog(this, lb.getClear_CallLog_Prompt(), lb.getHelp_1_Prompt(), 2)) == 0) {
                int j = this.tableLog.getRowCount() - 1;
                while (j >= 0) {
                    String strId = (String)this.tableLog.getValueAt(j, 0);
                    this.calluiInstance.deleteLog(strId);
                    this.deleteLogFromVector(strId);
                    ((DefaultTableModel)this.tableLog.getModel()).removeRow(j);
                    --j;
                }
                this.btnClear.setEnabled(false);
                this.itemClear.setEnabled(false);
                this.tableLog.invalidate();
                boolean blink = this.checkUnreadMissCall();
                if (blink) {
                    if (!this.callBlinkTimer.isRunning()) {
                        this.callBlinkTimer.start();
                    }
                } else if (this.callBlinkTimer.isRunning()) {
                    this.callBlinkTimer.stop();
                    this.frame.callBlinkLabel.setVisible(false);
                }
            }
        }
        if (e.getSource() == this.callBlinkTimer) {
            if (this.blinkFlag) {
                this.blinkFlag = false;
                this.frame.callBlinkLabel.setVisible(true);
            } else {
                this.blinkFlag = true;
                this.frame.callBlinkLabel.setVisible(false);
            }
            this.frame.callBlinkLabel.repaint();
        }
    }

    public void responseForBlink() {
        logtree.setSelectionRow(2);
    }

    public void refreshCallLogInfo(String logType) {
        int j;
        int i;
        Vector vLogs;
        this.readCallLogFromFile();
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)logtree.getLastSelectedPathComponent();
        String selNodeText = "";
        selNodeText = selNode != null ? selNode.toString() : lb.getCallLog_all();
        String log_selType = log_allType;
        log_selType = selNodeText.equalsIgnoreCase(lb.getCallLog_ans()) ? "0" : (selNodeText.equalsIgnoreCase(lb.getCallLog_miss()) ? "1" : (selNodeText.equalsIgnoreCase(lb.getCallLog_dial()) ? log_dialType : log_allType));
        if (logType.equalsIgnoreCase(log_selType)) {
            vLogs = this.readCallLog(logType);
            i = this.logTableMode.getRowCount() - 1;
            while (i >= 0) {
                this.logTableMode.removeRow(i);
                --i;
            }
            j = 0;
            while (j < vLogs.size()) {
                this.logTableMode.addRow((Vector)vLogs.get(j));
                ++j;
            }
            this.btnClear.setEnabled(true);
            this.itemClear.setEnabled(true);
        }
        if (log_selType.equalsIgnoreCase(log_allType)) {
            vLogs = this.readCallLog(log_allType);
            i = this.logTableMode.getRowCount() - 1;
            while (i >= 0) {
                this.logTableMode.removeRow(i);
                --i;
            }
            j = 0;
            while (j < vLogs.size()) {
                this.logTableMode.addRow((Vector)vLogs.get(j));
                ++j;
            }
            this.btnClear.setEnabled(true);
            this.itemClear.setEnabled(true);
        }
        this.tableLog.invalidate();
        boolean blink = this.checkUnreadMissCall();
        if (blink) {
            if (!this.callBlinkTimer.isRunning()) {
                this.callBlinkTimer.start();
            }
        } else if (this.callBlinkTimer.isRunning()) {
            this.callBlinkTimer.stop();
            this.frame.callBlinkLabel.setVisible(false);
        }
    }

    public void callLogChangeLanguage() {
        this.calllogNode.setUserObject("");
        this.answeredNode.setUserObject("");
        this.missedNode.setUserObject("");
        this.dialedNode.setUserObject("");
        this.logTextArea.setText("");
        this.calllogNode.setUserObject(lb.getCallLog_all());
        this.answeredNode.setUserObject(lb.getCallLog_ans());
        this.missedNode.setUserObject(lb.getCallLog_miss());
        this.dialedNode.setUserObject(lb.getCallLog_dial());
        this.logTextArea.setText(this.calllogString);
        this.btnCall.setToolTipText("");
        this.btnSMS.setToolTipText("");
        this.btnSave.setToolTipText("");
        this.btnDelete.setToolTipText("");
        this.btnClear.setToolTipText("");
        this.btnCall.setToolTipText(lb.getCallLog_call());
        this.btnSMS.setToolTipText(lb.getCallLog_sms());
        this.btnSave.setToolTipText(lb.getCallLog_save());
        this.btnDelete.setToolTipText(lb.getCallLog_del());
        this.btnClear.setToolTipText(lb.getCallLog_clr());
        Vector<String> strHead = new Vector<String>();
        if (!strHead.isEmpty()) {
            strHead.removeAllElements();
        }
        strHead.add(lb.getCallLog_logid());
        strHead.add(lb.getCallLog_nameornum());
        strHead.add(lb.getCallLog_begintime());
        strHead.add(lb.getCallLog_durtime());
        strHead.add(lb.getCallLog_num());
        strHead.add(lb.getCallLog_logstate());
        strHead.add(lb.getCallLog_logtype());
        this.logTableMode.setColumnIdentifiers(strHead);
        String firstSecondColume = lb.getCallLog_logid();
        this.tableLog.getColumn(lb.getCallLog_logid()).setMaxWidth(0);
        this.tableLog.getColumn(lb.getCallLog_logid()).setMinWidth(0);
        this.tableLog.getColumn(lb.getCallLog_logid()).setPreferredWidth(0);
        String numColume = lb.getCallLog_num();
        this.tableLog.getColumn(lb.getCallLog_num()).setMaxWidth(0);
        this.tableLog.getColumn(lb.getCallLog_num()).setMinWidth(0);
        this.tableLog.getColumn(lb.getCallLog_num()).setPreferredWidth(0);
        String stateColume = lb.getCallLog_logstate();
        this.tableLog.getColumn(lb.getCallLog_logstate()).setMaxWidth(0);
        this.tableLog.getColumn(lb.getCallLog_logstate()).setMinWidth(0);
        this.tableLog.getColumn(lb.getCallLog_logstate()).setPreferredWidth(0);
        String lastColume = lb.getCallLog_logtype();
        this.tableLog.getColumn(lb.getCallLog_logtype()).setMaxWidth(0);
        this.tableLog.getColumn(lb.getCallLog_logtype()).setMinWidth(0);
        this.tableLog.getColumn(lb.getCallLog_logtype()).setPreferredWidth(0);
        this.itemCall.setText(lb.getCallLog_call());
        this.itemCall.setActionCommand(lb.getCallLog_call());
        this.itemSendSMS.setText(lb.getCallLog_sms());
        this.itemSendSMS.setActionCommand(lb.getCallLog_sms());
        this.itemSave.setText(lb.getCallLog_save());
        this.itemSave.setActionCommand(lb.getCallLog_save());
        this.itemDelete.setText(lb.getCallLog_del());
        this.itemDelete.setActionCommand(lb.getCallLog_del());
        this.itemClear.setText(lb.getCallLog_clr());
        this.itemClear.setActionCommand(lb.getCallLog_clr());
        this.btnCall.setToolTipText(lb.getCallLog_call());
        this.btnCall.setActionCommand(lb.getCallLog_call());
        this.btnSMS.setToolTipText(lb.getCallLog_sms());
        this.btnSMS.setActionCommand(lb.getCallLog_sms());
        this.btnSave.setToolTipText(lb.getCallLog_save());
        this.btnSave.setActionCommand(lb.getCallLog_save());
        this.btnDelete.setToolTipText(lb.getCallLog_del());
        this.btnDelete.setActionCommand(lb.getCallLog_del());
        this.btnClear.setToolTipText(lb.getCallLog_clr());
        this.btnClear.setActionCommand(lb.getCallLog_clr());
    }

    public void readCallLogFromFile() {
        this.vLogInfos.removeAllElements();
        List logList = this.calluiInstance.getCallInfoList();
        int i = 0;
        while (i < logList.size()) {
            Vector<String> rowContent = new Vector<String>();
            HashMap profileMap = (HashMap)logList.get(i);
            String rowType = profileMap.get("type").toString();
            rowContent.add(profileMap.get("id").toString());
            String phoneNum = profileMap.get("number").toString().trim();
            String name = "";
            if (phoneNum == null || "".equals(phoneNum)) {
                name = lb.getCallLog_unknownnum();
            } else {
                name = this.commonMethodByTelBook.getContactName(phoneNum).trim();
                if (name == null || "".equals(name)) {
                    name = phoneNum;
                }
            }
            rowContent.add(name);
            rowContent.add(profileMap.get("startTime").toString());
            rowContent.add(profileMap.get("duration").toString());
            rowContent.add(profileMap.get("number").toString());
            rowContent.add(profileMap.get("state").toString());
            rowContent.add(profileMap.get("type").toString());
            this.vLogInfos.add(rowContent);
            ++i;
        }
    }

    public Vector readCallLog(String logType) {
        Vector<Vector> vTypeLogInfos = new Vector<Vector>();
        if (!this.vLogInfos.isEmpty()) {
            int i = 0;
            while (i < this.vLogInfos.size()) {
                Vector vLogRow = this.vLogInfos.get(i);
                String strLogType = vLogRow.get(6).toString();
                if (logType.equalsIgnoreCase(log_allType)) {
                    vTypeLogInfos.add(vLogRow);
                } else if (strLogType.equalsIgnoreCase(logType)) {
                    vTypeLogInfos.add(vLogRow);
                }
                ++i;
            }
        }
        return vTypeLogInfos;
    }
}

